/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl;

import javax.vecmath.Color4f;
import javax.vecmath.Point4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3d;

class LightSource {
    static final int LIGHT_TYPE_NONE = 0;
    static final int LIGHT_TYPE_POINT = 1;
    static final int LIGHT_TYPE_SPOT = 2;
    static final int LIGHT_TYPE_DIRECTIONAL = 3;
    int stamp;
    int lightType = 0;
    Point4d lightPos;
    Vector3d lightDir;
    float spotExponent = 0.0f;
    float spotCutoff = 180.0f;
    float constantAttenuation = 1.0f;
    float linearAttenuation = 0.0f;
    float quadraticAttenuation = 0.0f;
    Color4f ambientColor = new Color4f(0.0f, 0.0f, 0.0f, 1.0f);
    Color4f diffuseColor = new Color4f(1.0f, 1.0f, 1.0f, 1.0f);
    Color4f specularColor = new Color4f(1.0f, 1.0f, 1.0f, 1.0f);

    LightSource() {
        this.lightPos = new Point4d(0.0, 0.0, 1.0, 0.0);
        this.lightDir = new Vector3d(0.0, 0.0, -1.0);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof LightSource) {
            bl = true;
            LightSource lightSource = (LightSource)object;
            bl &= this.lightType == lightSource.lightType;
            bl &= this.lightPos.equals((Tuple4d)lightSource.lightPos);
            bl &= this.lightDir.equals((Tuple3d)lightSource.lightDir);
            bl &= this.spotExponent == lightSource.spotExponent;
            bl &= this.spotCutoff == lightSource.spotCutoff;
            bl &= this.constantAttenuation == lightSource.constantAttenuation;
            bl &= this.linearAttenuation == lightSource.linearAttenuation;
            bl &= this.quadraticAttenuation == lightSource.quadraticAttenuation;
            bl &= this.ambientColor.equals((Tuple4f)lightSource.ambientColor);
            bl &= this.diffuseColor.equals((Tuple4f)lightSource.diffuseColor);
            bl &= this.specularColor.equals((Tuple4f)lightSource.specularColor);
        }
        return bl;
    }

    public int hashCode() {
        int n = 0;
        int n2 = n << 13;
        n >>>= 19;
        n = n2 | n;
        int n3 = (n ^= this.lightType) << 13;
        n >>>= 19;
        n = n3 | n;
        int n4 = (n ^= this.lightPos.hashCode()) << 13;
        n >>>= 19;
        n = n4 | n;
        int n5 = (n ^= this.lightDir.hashCode()) << 13;
        n >>>= 19;
        n = n5 | n;
        int n6 = (n ^= Float.floatToIntBits(this.spotExponent)) << 13;
        n >>>= 19;
        n = n6 | n;
        int n7 = (n ^= Float.floatToIntBits(this.spotCutoff)) << 13;
        n >>>= 19;
        n = n7 | n;
        int n8 = (n ^= Float.floatToIntBits(this.constantAttenuation)) << 13;
        n >>>= 19;
        n = n8 | n;
        int n9 = (n ^= Float.floatToIntBits(this.linearAttenuation)) << 13;
        n >>>= 19;
        n = n9 | n;
        int n10 = (n ^= Float.floatToIntBits(this.quadraticAttenuation)) << 13;
        n >>>= 19;
        n = n10 | n;
        int n11 = (n ^= this.ambientColor.hashCode()) << 13;
        n >>>= 19;
        n = n11 | n;
        int n12 = (n ^= this.diffuseColor.hashCode()) << 13;
        n >>>= 19;
        n = n12 | n;
        return n ^= this.specularColor.hashCode();
    }
}

