/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.light;

import de.grogra.imp3d.Camera;
import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.light.GLSLLightShader;
import de.grogra.imp3d.glsl.light.LightPos;
import de.grogra.imp3d.glsl.light.LightShaderConfiguration;
import de.grogra.imp3d.glsl.light.RenderToSkyCubePass;
import de.grogra.imp3d.glsl.light.ShadowMapGenerationPass;
import de.grogra.imp3d.glsl.light.shadow.GLSLShadowMap;
import de.grogra.imp3d.glsl.renderpass.FullRenderPass;
import de.grogra.imp3d.glsl.utility.GLSLOpenGLObject;
import de.grogra.imp3d.glsl.utility.GLSLShader;
import de.grogra.imp3d.objects.Sky;
import javax.media.opengl.GL;
import javax.vecmath.Matrix4d;

public class LightingProcessPass
extends FullRenderPass {
    private ShadowMapGenerationPass smgp = new ShadowMapGenerationPass();
    LightShaderConfiguration lsc = new LightShaderConfiguration();
    private RenderToSkyCubePass rtsc = new RenderToSkyCubePass();

    protected int getID() {
        return 2;
    }

    protected void epilogue(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        assert (object instanceof LightPos);
        GL gL = openGLState.getGL();
        LightPos lightPos = (LightPos)object;
        if (lightPos.getLight() instanceof Sky && (!openGLState.BGFound || openGLState.getBGShader() == null)) {
            return;
        }
        gL.glPopAttrib();
        LightingProcessPass.ViewPerspective(openGLState);
        openGLState.disable('\u0001');
        openGLState.setDepthMask(true);
        openGLState.enable('\u0002');
        gL.glActiveTexture(33992);
        gL.glBindTexture(3553, 0);
        boolean bl = !lightPos.getLight().isShadowless() & gLSLDisplay.isOptionShowShadows() & !(lightPos.getLight() instanceof Sky) & lightPos.getLight().getLightType() != 2;
        if (bl) {
            gL.glActiveTexture(33991);
            gL.glBindTexture(34037, 0);
            gL.glMatrixMode(5890);
            gL.glActiveTexture(33986);
            gL.glLoadIdentity();
            gL.glMatrixMode(5888);
        }
        if (lightPos.getLight() instanceof Sky) {
            gL.glActiveTexture(33991);
            gL.glBindTexture(34067, 0);
            gL.glActiveTexture(33990);
            gL.glBindTexture(34067, 0);
        }
        LightingProcessPass.deactivateTextures(gL, 6, 34037);
    }

    protected void prologue(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        Matrix4d matrix4d;
        GLSLOpenGLObject gLSLOpenGLObject;
        boolean bl;
        assert (object instanceof LightPos);
        GL gL = openGLState.getGL();
        LightPos lightPos = (LightPos)object;
        if (lightPos.getLight() instanceof Sky) {
            if (!openGLState.BGFound || openGLState.getBGShader() == null) {
                return;
            }
            this.rtsc.process(gLSLDisplay, openGLState, null);
        }
        if (bl = !lightPos.getLight().isShadowless() & gLSLDisplay.isOptionShowShadows() & !(lightPos.getLight() instanceof Sky) & lightPos.getLight().getLightType() != 2) {
            gLSLOpenGLObject = openGLState.SM_Manager.getDefaultCachedMap(lightPos.getLight());
            ((GLSLShadowMap)gLSLOpenGLObject).create(gL);
            ((GLSLShadowMap)gLSLOpenGLObject).setLightTransf(lightPos);
            this.smgp.process(gLSLDisplay, openGLState, gLSLOpenGLObject);
            matrix4d = new Matrix4d();
            matrix4d.set(openGLState.getInvWorldToView());
            ((GLSLShadowMap)gLSLOpenGLObject).setupTextureMatrices(openGLState, matrix4d, lightPos);
        }
        gL.glPushAttrib(2048);
        gL.glViewport(0, 0, openGLState.width, openGLState.height);
        openGLState.switchFloatRT();
        GLSLDisplay.printDebugInfoN("Render Light to: " + (4 + openGLState.getFloatRT()));
        openGLState.getHDRFBO().drawBuffer(openGLState, openGLState.getFloatRT());
        gLSLOpenGLObject = (GLSLLightShader)openGLState.csc.getCacheEntry(openGLState, gLSLDisplay, this.lsc, lightPos.getLight());
        if (gLSLOpenGLObject == null) {
            GLSLDisplay.printDebugInfoN("! " + lightPos.getLight().toString() + " : not known");
            return;
        }
        LightingProcessPass.ViewOrtho(openGLState);
        openGLState.disable('\u0002');
        openGLState.setDepthMask(false);
        openGLState.getDeferredShadingFBO().bindAllAttachmentsAsTextures(openGLState);
        openGLState.getHDRFBO().bindAttachmentAsTexture(openGLState, openGLState.getFloatRTLast(), 4);
        openGLState.getAlphaFBO().bindAttachmentAsTexture(openGLState, 0, 5);
        openGLState.getDeferredShadingDepthTRT().bindTo(openGLState, 8);
        if (lightPos.getLight() instanceof Sky) {
            matrix4d = new Matrix4d();
            matrix4d.set(openGLState.getWorldToView());
            matrix4d.m30 = 0.0;
            matrix4d.m31 = 0.0;
            matrix4d.m32 = 0.0;
            matrix4d.m03 = 0.0;
            matrix4d.m13 = 0.0;
            matrix4d.m23 = 0.0;
            matrix4d.invert();
            gL.glActiveTexture(33986);
            gL.glMatrixMode(5890);
            openGLState.loadMatrixd(matrix4d);
            gL.glMatrixMode(5888);
            openGLState.skyCube.bindTo(gL, 33990);
            openGLState.skyDiffuseCube.bindTo(gL, 33991);
            GLSLDisplay.printDebugInfoN("Bound Env-Map");
        }
        openGLState.enable('\u0001');
        gL.glStencilFunc(514, 1, 1);
        gL.glStencilOp(7680, 7680, 7680);
        ((GLSLShader)gLSLOpenGLObject).activateShader(openGLState, gLSLDisplay, lightPos);
        GLSLDisplay.printDebugInfoN("Rendering Light with Shader: " + gLSLOpenGLObject);
    }

    protected void render(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        Camera camera = gLSLDisplay.getView3D().getCamera();
        LightingProcessPass.drawPrjQuad(openGLState, camera);
    }

    public void process(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        super.process(gLSLDisplay, openGLState, object);
    }
}

