/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.light.shadow;

import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.light.GLSLPointLight;
import de.grogra.imp3d.glsl.utility.GLSLShader;
import javax.media.opengl.GL;

public class GLSLPointLightShadow
extends GLSLPointLight {
    static final String ShadowFuncPrologue = "float lookup(samplerCube ShadowCube, vec2 offset, vec3 ViewPos, float Epsilon)";
    static final String ShadowFunc = " vec4 Coord = gl_TextureMatrix[2] * vec4(ViewPos + vec3(offset, 0.0) * Epsilon, 1.0);\n float depth = textureCube(ShadowCube, Coord.xyz).r;\n vec3 absCoord = abs(Coord.xyz);\n float max_z = max(absCoord.x, absCoord.y);\n max_z = max(max_z, absCoord.z);\n float zFar = 2000.0; float zNear = 0.01;\n float val = zFar / (zFar-zNear);\n float depth_z = -1.0/max_z * zNear * val + val;\n return (depth_z > depth) ? 0.0: 1.0;";
    protected String shadowCube;

    public String getLightFunction() {
        this.shadowCube = this.config.registerNewUniform(8);
        this.config.registerFunc(ShadowFuncPrologue, ShadowFunc);
        String string = " vec3 normal = getEyeNormal(norm);\n vec3 eye = vec3 (0.0, 0.0, 1.0);\n float mul = 0.0;\n mul += lookup(" + this.shadowCube + ", vec2(0.0), pos, 0.0);\n" + " if(mul > 0.0)" + " PointLight( normal.rgb, " + "eye, " + "pos, " + this.lightPos + ", " + "shininess, " + this.col0 + ", " + this.fade_distance + ", " + this.fade_power + ", " + this.radientPower + ", " + "diff, spec);\n" + " diff *= mul; spec *= mul;";
        return string;
    }

    public void setupShader(GL gL, GLSLDisplay gLSLDisplay, Object object) {
        super.setupShader(gL, gLSLDisplay, object);
        int n = gL.glGetUniformLocation(this.getShaderProgramNumber(), this.shadowCube);
        gL.glUniform1i(n, 7);
    }

    public GLSLShader getInstance() {
        return new GLSLPointLightShadow();
    }

    public boolean canDisplayShadows() {
        return true;
    }
}

