/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.material;

import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.material.GLSLDefaultInput;
import de.grogra.imp3d.glsl.material.MaterialCollection;
import de.grogra.imp3d.glsl.material.channel.GLSLChannelMap;
import de.grogra.imp3d.glsl.material.channel.Result;
import de.grogra.imp3d.glsl.utility.GLSLManagedShader;
import de.grogra.imp3d.glsl.utility.ShaderConfiguration;
import de.grogra.imp3d.shading.RGBAShader;
import de.grogra.ray.physics.Light;
import java.util.Iterator;
import javax.media.opengl.GL;

public class MaterialConfiguration
extends ShaderConfiguration {
    public static final int IT_NORMAL = 0;
    public static final int IT_POSITION = 1;
    public static final int IT_SHININESS = 2;
    public static final int IT_DIFFUSE = 3;
    public static final int IT_SPECULAR = 4;
    public static final int IT_AMBIENT = 5;
    public static final int IT_EMISSIVE = 6;
    public static final int IT_TRANSPERENCY = 7;
    public static final int IT_DIFFUSE_TRANSPERENCY = 8;
    public static final int IT_TRANSPERENCY_SHININESS = 9;
    public static final int IT_PROLOGUE = 10;
    private boolean shaderAntialiasing = false;
    int invFarPlaneLoc = -1;

    public boolean isShaderAntialiasing() {
        return this.shaderAntialiasing;
    }

    String getDerivates() {
        return "vec3 dpdv = normalize(dFdx(pos.xyz) * dFdy(uv.t) - dFdy(pos.xyz) * dFdx(uv.t));\nvec3 dpdu = cross(dpdv, normalize(normal));\ndpdv = cross(normalize(normal), dpdu);\n";
    }

    public String[] completeShader(Result[] resultArray) {
        int n;
        String string = "#version " + this.version + "\n" + "#extension GL_ARB_draw_buffers : enable\n";
        string = string + "uniform float inv_farplane;";
        for (n = 0; n < this.uniform.size(); ++n) {
            string = string + (String)this.uniform.elementAt(n);
        }
        if (this.uniform.size() > 0) {
            string = string + "\n";
        }
        for (n = 0; n < this.sampler.size(); ++n) {
            string = string + (String)this.sampler.elementAt(n);
        }
        if (this.sampler.size() > 0) {
            string = string + "\n";
        }
        for (n = 0; n < this.customSampler.size(); ++n) {
            string = string + (String)this.customSampler.elementAt(n);
        }
        if (this.customSampler.size() > 0) {
            string = string + "\n";
        }
        string = string + "varying vec2 uv;\n";
        string = string + "varying vec3 normal;\n";
        string = string + "varying float depth;\n";
        string = string + "varying vec4 pos;\n";
        string = string + "varying vec3 n_pos;\n";
        string = string + "varying vec3 g_pos;\n\n";
        for (n = 0; n < this.constVar.size(); ++n) {
            string = string + (String)this.constVar.elementAt(n);
        }
        if (this.constVar.size() > 0) {
            string = string + "\n";
        }
        Iterator iterator = this.funcMap.values().iterator();
        while (iterator.hasNext()) {
            string = string + (String)iterator.next();
        }
        if (this.funcMap.size() > 0) {
            string = string + "\n";
        }
        string = string + "float packToFloat(vec2 val) {\n val = clamp(val, 0.0, 1.0);\n val.x = floor(val.x * 127.5) * 0.125;\n vec2 X = vec2(floor(val.x), fract(val.x));\n return (X.y + ( floor(val.y * 127.5) * 0.0009765625) + (1.0)) * exp2(X.x);\n}\n\n";
        string = string + "vec2 encodeNormal(vec3 normal){\n float f = sqrt(8.0*normal.z+8.0);\n return normal.xy / f + 0.5;\n}\n\n";
        string = string + "void main() {\n";
        if (this.getBit((byte)8)) {
            string = string + this.getDerivates() + "\n";
        }
        for (int i = 0; i < this.var.size(); ++i) {
            string = string + " " + (String)this.var.elementAt(i);
        }
        if (this.var.size() > 0) {
            string = string + "\n";
        }
        if (resultArray[10].toString().length() > 0) {
            string = string + resultArray[10] + "\n";
        }
        string = string + " vec3 n_normal = normalize(" + resultArray[0].convert(2) + ");\n";
        string = string + " if(!gl_FrontFacing) n_normal *= -1.0;\n";
        string = string + " vec3 emissive = " + resultArray[6].convert(2) + ";\n";
        string = string + " vec3 diff_transp = " + resultArray[8].convert(2) + ";\n";
        string = string + " gl_FragData[0] = vec4(encodeNormal(n_normal), " + resultArray[2].reduce(0) + ", " + resultArray[9].reduce(0) + ");\n";
        string = string + " gl_FragData[1] = vec4(" + resultArray[3].convert(2) + ",packToFloat(emissive.rg));\n";
        string = string + " gl_FragData[2] = vec4(" + resultArray[4].convert(2) + ", packToFloat(vec2(emissive.b, diff_transp.r)));\n";
        string = string + " gl_FragData[3] = vec4(" + resultArray[7].convert(2) + ",packToFloat(diff_transp.gb));\n";
        string = string + "}";
        String[] stringArray = new String[]{string};
        return stringArray;
    }

    protected boolean perInstance() {
        return this.referenceKey.getClass() == RGBAShader.class;
    }

    protected void setThisToOther(ShaderConfiguration shaderConfiguration) {
        super.setThisToOther(shaderConfiguration);
        assert (shaderConfiguration instanceof MaterialConfiguration);
        this.shaderAntialiasing = ((MaterialConfiguration)shaderConfiguration).shaderAntialiasing;
    }

    public ShaderConfiguration clone() {
        MaterialConfiguration materialConfiguration = new MaterialConfiguration();
        materialConfiguration.setThisToOther(this);
        return materialConfiguration;
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.shaderAntialiasing ? 1231 : 1237);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MaterialConfiguration materialConfiguration = (MaterialConfiguration)object;
        return this.shaderAntialiasing == materialConfiguration.shaderAntialiasing;
    }

    public void set(OpenGLState openGLState, GLSLDisplay gLSLDisplay, Object object) {
        assert (object instanceof Light);
        this.set(object);
        this.shaderAntialiasing = gLSLDisplay.isOptionShaderAntialiasing();
    }

    public GLSLChannelMap getDefaultInputChannel() {
        return new GLSLDefaultInput();
    }

    public GLSLManagedShader getShaderByDefaultCollection(GLSLDisplay gLSLDisplay, Object object) {
        return MaterialCollection.getGLSLManagedObject(object);
    }

    public void setupShader(GL gL, GLSLDisplay gLSLDisplay, int n) {
        super.setupShader(gL, gLSLDisplay, n);
        this.invFarPlaneLoc = gL.glGetUniformLocation(n, "inv_farplane");
    }

    public void setupDynamicUniforms(GL gL, GLSLDisplay gLSLDisplay, int n) {
        super.setupDynamicUniforms(gL, gLSLDisplay, n);
        gL.glUniform1f(this.invFarPlaneLoc, 1.0f / gLSLDisplay.getView3D().getCamera().getZFar());
    }
}

