/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.material.channel;

import de.grogra.imp3d.glsl.material.MaterialConfiguration;
import de.grogra.imp3d.glsl.material.channel.GLSLChannelMap;
import de.grogra.imp3d.glsl.material.channel.GLSLVolumeFunction;
import de.grogra.imp3d.glsl.material.channel.OldNoise;
import de.grogra.imp3d.glsl.material.channel.Result;
import de.grogra.imp3d.shading.Julia;
import de.grogra.math.ChannelMap;

public class GLSLJulia
extends GLSLVolumeFunction {
    static final String juliaFuncSig = "float julia(vec3 pos, vec2 c, float iterations)";
    static final String juliaFunc = "float x = ((pos.x > 0.0) ? pos.x - floor(pos.x) : pos.x + (1.0 + floor(-pos.x)) ) * 4.0 - 2.0;\nfloat y = ((pos.y > 0.0) ? pos.y - floor(pos.y) : pos.y + (1.0 + floor(-pos.y)) ) * 4.0 - 2.0;\nfloat a = x;\nfloat b = y;\nfloat a2 = a * a;\nfloat b2 = b * b;\nfloat dist2;\nfloat i;\nfor (i = 0.0; i < iterations; i+=1.0)\n{\nb = 2.0 * a * b + c.y;\na = a2 - b2 + c.x;\na2 = a * a;\nb2 = b * b;\ndist2 = a2 + b2;\nif (dist2 > 4.0)\n{\nbreak;\n}\n}\nreturn (2.0 * i - iterations) / iterations;\n";

    public Class instanceFor() {
        return Julia.class;
    }

    public Result generateVolumeData(ChannelMap channelMap, MaterialConfiguration materialConfiguration, GLSLChannelMap gLSLChannelMap, int n) {
        assert (channelMap instanceof Julia);
        OldNoise.regLookUpTexture(materialConfiguration);
        Julia julia = (Julia)channelMap;
        int n2 = Math.max(Math.min(julia.getIterations(), 200), 1);
        materialConfiguration.registerFunc(juliaFuncSig, juliaFunc);
        GLSLChannelMap gLSLChannelMap2 = GLSLChannelMap.getGLSLObject(julia.getInput());
        Result result = gLSLChannelMap2 != null ? gLSLChannelMap2.generate(julia.getInput(), materialConfiguration, gLSLChannelMap, 20) : gLSLChannelMap.generate(null, materialConfiguration, null, 20);
        String string = result.convert(2);
        return new Result("julia(" + string + ",vec2(" + julia.getCx() + "," + julia.getCy() + ")," + (float)n2 + ")", 0);
    }
}

