/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.material.channel;

import de.grogra.imp3d.glsl.material.MaterialConfiguration;
import de.grogra.imp3d.glsl.material.channel.GLSLChannelMap;
import de.grogra.imp3d.glsl.material.channel.GLSLChannelMapNode;
import de.grogra.imp3d.glsl.material.channel.Result;
import de.grogra.imp3d.glsl.utility.GLSLQueuedFloatTexture;
import de.grogra.imp3d.glsl.utility.ShaderConfiguration;
import de.grogra.imp3d.shading.SyntheticTexture;
import de.grogra.math.ChannelMap;

public abstract class GLSLSyntheticTexture
extends GLSLChannelMapNode {
    GLSLQueuedFloatTexture data;
    static final String linearBlendSig = "float linBlend(sampler2D s, vec2 uv, vec2 texelSize, vec2 textureSize)";
    static final String linearBlend = "float v00 = texture2D(s, uv).r;\nfloat v10 = texture2D(s, uv + vec2(texelSize.x, 0)).r;\nfloat v01 = texture2D(s, uv + vec2(0, texelSize.y)).r;\nfloat v11 = texture2D(s, uv + texelSize).r;\nvec2 f = fract( uv.xy * textureSize );\nfloat wx0 = mix( v00, v10, f.x );\nfloat wx1 = mix( v01, v11, f.x );\nreturn mix( wx0, wx1, f.y );";
    static final String linearBlendDifSig = "vec2 linBlendDif(sampler2D s, vec2 uv, vec2 texelSize, vec2 textureSize)";
    static final String linearBlendDif = "float v00 = texture2D(s, uv).r;\nfloat v10 = texture2D(s, uv + vec2(texelSize.x, 0)).r;\nfloat v01 = texture2D(s, uv + vec2(0, texelSize.y)).r;\nfloat v11 = texture2D(s, uv + vec2(texelSize.x)).r;\nfloat v20 = texture2D(s, uv + vec2(2.*texelSize.x, 0)).r;\nfloat v02 = texture2D(s, uv + vec2(0, 2.*texelSize.y)).r;\nfloat v21 = texture2D(s, uv + vec2(2.,1.)*texelSize).r;\nfloat v12 = texture2D(s, uv + vec2(1.,2.)*texelSize).r;\nvec2 f = fract( uv.xy * textureSize );\nfloat wx0 = mix( v00, v10, f.x );\nfloat wx1 = mix( v01, v11, f.x );\nv00 = mix( wx0, wx1, f.y );wx0 = mix( v10, v20, f.x );\nwx1 = mix( v11, v21, f.x );\nv10 = mix( wx0, wx1, f.y );wx0 = mix( v01, v11, f.x );\nwx1 = mix( v02, v12, f.x );\nv01 = mix( wx0, wx1, f.y );return (vec2(v10, v01)-v00)*textureSize;";

    String regSyntheticTexture(SyntheticTexture syntheticTexture, ShaderConfiguration shaderConfiguration) {
        this.data = new GLSLQueuedFloatTexture();
        this.data.setData(syntheticTexture.getWidth(), syntheticTexture.getHeight(), syntheticTexture.getFloatData());
        return shaderConfiguration.registerCustomTexture(this.data);
    }

    public Result generate(ChannelMap channelMap, MaterialConfiguration materialConfiguration, GLSLChannelMap gLSLChannelMap, int n) {
        assert (channelMap instanceof SyntheticTexture);
        SyntheticTexture syntheticTexture = (SyntheticTexture)channelMap;
        String string = this.regSyntheticTexture(syntheticTexture, materialConfiguration);
        String string2 = GLSLSyntheticTexture.generateResultWithChannelDefault(syntheticTexture.getInput(), materialConfiguration, gLSLChannelMap, 16).convert(1);
        if (n == 8) {
            materialConfiguration.registerFunc(linearBlendDifSig, linearBlendDif);
            return new Result("linBlendDif(" + string + "," + string2 + ",vec2(" + 1.0 / (double)syntheticTexture.getHeight() + "," + 1.0 / (double)syntheticTexture.getWidth() + "),vec2(" + syntheticTexture.getHeight() + ".," + syntheticTexture.getWidth() + ".))", 1);
        }
        materialConfiguration.registerFunc(linearBlendSig, linearBlend);
        return new Result("linBlend(" + string + "," + string2 + ",vec2(" + 1.0 / (double)syntheticTexture.getHeight() + "," + 1.0 / (double)syntheticTexture.getWidth() + "),vec2(" + syntheticTexture.getHeight() + ".," + syntheticTexture.getWidth() + ".))", 0);
    }
}

