/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.material.channel;

import de.grogra.imp3d.glsl.material.MaterialConfiguration;
import de.grogra.imp3d.glsl.material.channel.GLSLChannelMap;
import de.grogra.imp3d.glsl.material.channel.GLSLVolumeFunction;
import de.grogra.imp3d.glsl.material.channel.Result;
import de.grogra.imp3d.glsl.material.channel.SimplexNoise;
import de.grogra.imp3d.shading.VolumeTurbulence;
import de.grogra.math.ChannelMap;

public class GLSLVolumeTurbulence
extends GLSLVolumeFunction {
    public Result generateVolumeData(ChannelMap channelMap, MaterialConfiguration materialConfiguration, GLSLChannelMap gLSLChannelMap, int n) {
        assert (channelMap instanceof VolumeTurbulence);
        SimplexNoise.registerNoiseFunctions(materialConfiguration);
        VolumeTurbulence volumeTurbulence = (VolumeTurbulence)channelMap;
        float f = volumeTurbulence.getFrequencyRatio();
        float f2 = volumeTurbulence.getNoiseRatio();
        float f3 = volumeTurbulence.getSize();
        int n2 = Math.max(Math.min(volumeTurbulence.getOctaves(), 6), 1);
        GLSLChannelMap gLSLChannelMap2 = GLSLChannelMap.getGLSLObject(volumeTurbulence.getInput());
        Result result = gLSLChannelMap2 != null ? gLSLChannelMap2.generate(volumeTurbulence.getInput(), materialConfiguration, gLSLChannelMap, 20) : gLSLChannelMap.generate(null, materialConfiguration, null, 20);
        String string = result.convert(2);
        float f4 = 1.0f;
        if (Math.abs(f2) > 1.0f) {
            f4 = (float)((double)f4 / Math.pow(Math.abs(f2), n2 - 1));
        }
        String string2 = SimplexNoise.registerTurbWithUnroll(materialConfiguration, n2);
        return new Result(f4 + "*" + string2 + "(" + f3 + "*" + string + ", " + f + ", " + f2 + ")", 0);
    }

    public Class instanceFor() {
        return VolumeTurbulence.class;
    }
}

