/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.material.channel;

import de.grogra.imp3d.glsl.utility.ShaderConfiguration;
import de.grogra.vecmath.Math2;
import java.awt.image.BufferedImage;

public class OldNoise {
    static final String fadeSig = "vec3 fade(vec3 t)";
    static final String fade = "return t * t * t * (t * (t * 6.0 - 15.0) + 10.0);";
    static final String noise3dSig = "float inoise(vec3 p)";
    static final String noise3d = "vec3 intp = floor(p);vec3 P = mod(intp, 256.0);p -= intp;vec3 f = fade(p);float A  = perm(P.x) + P.y;float AA = perm(A) + P.z;float AB = perm(A + 1.0) + P.z;float B  = perm(P.x + 1.0) + P.y;float BA = perm(B) + P.z;float BB = perm(B + 1.0) + P.z;return mix(mix(mix(grad(perm(AA), p),grad(perm(BA), p + vec3(-1.0,  0.0, 0.0)), f.x),mix(grad(perm(AB), p + vec3( 0.0, -1.0, 0.0)),grad(perm(BB), p + vec3(-1.0, -1.0, 0.0)), f.x),f.y),mix(mix(grad(perm(AA + 1.0), p + vec3( 0.0,  0.0, -1.0)),grad(perm(BA + 1.0), p + vec3(-1.0,  0.0, -1.0)), f.x),mix(grad(perm(AB + 1.0), p + vec3( 0.0, -1.0, -1.0)),grad(perm(BB + 1.0), p + vec3(-1.0, -1.0, -1.0)), f.x),f.y),f.z);";
    static final String turb3dSig = "float turbulence(vec3 f, int octaves, float lambda, float omega)";
    static final String turb3d = "float v = inoise (f);float l = lambda, o = omega;for (int i = octaves-1; i > 0; --i){v += o * inoise (f * l);if (i > 1){l *= lambda;o *= omega;}}return v;";
    static BufferedImage permImage;
    static BufferedImage gradImage;
    static String permSampler;
    static String gradSampler;
    static boolean init;
    static int PermutationTexture;
    static int GradientTexture;

    public static BufferedImage generatePermutationTexture() {
        BufferedImage bufferedImage = new BufferedImage(256, 1, 2);
        for (char c = '\u0000'; c < '\u0100'; c = (char)(c + '\u0001')) {
            bufferedImage.setRGB(c, 0, 0xFF000000 | Math2.random((char)c) << 16);
        }
        return bufferedImage;
    }

    public static BufferedImage generateGradientTexture() {
        int[] nArray = new int[]{0, 127, 255};
        int[] nArray2 = new int[]{1, 1, 0, -1, 1, 0, 1, -1, 0, -1, -1, 0, 1, 0, 1, -1, 0, 1, 1, 0, -1, -1, 0, -1, 0, 1, 1, 0, -1, 1, 0, 1, -1, 0, -1, -1, 1, 1, 0, 0, -1, 1, -1, 1, 0, 0, -1, -1};
        BufferedImage bufferedImage = new BufferedImage(16, 1, 2);
        for (int n = 0; n < 16; n = (int)((char)(n + 1))) {
            bufferedImage.setRGB(n, 0, 0xFF000000 | nArray[nArray2[3 * n] + 1] << 16 | nArray[nArray2[3 * n + 1] + 1] << 8 | nArray[nArray2[3 * n + 2] + 1]);
        }
        return bufferedImage;
    }

    static void regLookUpTexture(ShaderConfiguration shaderConfiguration) {
        if (!init) {
            permImage = OldNoise.generatePermutationTexture();
            gradImage = OldNoise.generateGradientTexture();
            init = true;
        }
        permSampler = shaderConfiguration.registerTexture(permImage);
        gradSampler = shaderConfiguration.registerTexture(gradImage);
    }

    public static void registerNoiseFunctions(ShaderConfiguration shaderConfiguration) {
        OldNoise.regLookUpTexture(shaderConfiguration);
        shaderConfiguration.registerFunc("float perm(float x)", "return texture2D(" + permSampler + ", vec2(x / 256.0 + 1.0/256.0, 0.5)).r * 256.0;");
        shaderConfiguration.registerFunc("float grad(float x, vec3 p)", "return dot((texture2D(" + gradSampler + ", vec2(x / 256.0 + 1.0/256.0, 0.5)).rgb * 2.0 - 1.0), p);");
        shaderConfiguration.registerFunc(fadeSig, fade);
        shaderConfiguration.registerFunc(noise3dSig, noise3d);
        shaderConfiguration.registerFunc(turb3dSig, turb3d);
    }

    static {
        init = false;
        PermutationTexture = 0;
        GradientTexture = 0;
    }
}

