/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.renderable;

import de.grogra.graph.GraphState;
import de.grogra.imp.objects.Attributes;
import de.grogra.imp3d.RenderState;
import de.grogra.imp3d.Renderable;
import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.renderable.GLSLAxis;
import de.grogra.imp3d.glsl.renderable.GLSLRenderable;
import de.grogra.imp3d.objects.Box;
import javax.media.opengl.GL;
import javax.vecmath.Matrix4d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLSLBox
extends GLSLAxis {
    protected float width = 1.0f;
    protected float height = 1.0f;
    private Matrix4d t = null;
    private Matrix4d scale = new Matrix4d();

    @Override
    public Class<?> instanceFor() {
        return Box.class;
    }

    @Override
    protected void updateInstanceDirect(Renderable renderable) {
        super.updateInstanceDirect(renderable);
        assert (renderable instanceof Box);
        Box box = (Box)renderable;
        this.width = box.getWidth();
        this.height = box.getHeight();
    }

    @Override
    public void updateInstanceIndirect(Object object, boolean bl, GraphState graphState) {
        this.width = (float)graphState.getDouble(object, bl, Attributes.WIDTH);
        this.height = (float)graphState.getDouble(object, bl, Attributes.HEIGHT);
        this.length = (float)graphState.getDouble(object, bl, Attributes.LENGTH);
    }

    @Override
    protected void updateInstanceByInstancing(Renderable renderable, GraphState graphState) {
        super.updateInstanceByInstancing(renderable, graphState);
        assert (renderable instanceof Box);
        Box box = (Box)renderable;
        this.width = (float)graphState.checkDouble((Object)renderable, true, Attributes.WIDTH, (double)box.getWidth());
        this.height = (float)graphState.checkDouble((Object)renderable, true, Attributes.HEIGHT, (double)box.getHeight());
    }

    @Override
    public void draw(OpenGLState openGLState, RenderState renderState) {
        renderState.drawBox(this.width * 0.5f, this.height * 0.5f, this.length, null, -1, null);
    }

    @Override
    public void drawAlt(OpenGLState openGLState, GLSLDisplay gLSLDisplay) {
        this.drawSetup(openGLState, gLSLDisplay);
    }

    private void drawSetup(OpenGLState openGLState, GLSLDisplay gLSLDisplay) {
        this.t = gLSLDisplay.getTransformation(null);
        GL gL = openGLState.getGL();
        gL.glPushMatrix();
        gL.glLoadMatrixd(openGLState.toGLMatrix4(this.t), 0);
        this.scale.setIdentity();
        this.scale.m00 = this.width;
        this.scale.m11 = this.height;
        this.scale.m22 = this.length;
        gL.glMultMatrixd(openGLState.toGLMatrix4(this.scale), 0);
        openGLState.VBO_Manager.getVBO(0, openGLState).draw(openGLState);
        gL.glPopMatrix();
    }

    @Override
    public GLSLRenderable getInstance() {
        return new GLSLBox();
    }
}

