/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.renderable;

import de.grogra.graph.GraphState;
import de.grogra.imp.objects.FontAdapter;
import de.grogra.imp3d.RenderState;
import de.grogra.imp3d.Renderable;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.renderable.GLSLBitCache;
import de.grogra.imp3d.objects.TextLabelBase;
import java.awt.Font;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;

public abstract class GLSLTextLabelBase
extends GLSLBitCache {
    protected static final int TOP_MASK = 4096;
    protected static final int BOTTOM_MASK = 8192;
    protected static final int VERTICAL_MASK = 12288;
    protected static final int LEFT_MASK = 16384;
    protected static final int RIGHT_MASK = 32768;
    protected static final int HORIZONTAL_MASK = 49152;
    protected static final int OUTLINED_MASK = 16;
    protected static final int FILLED_MASK = 32;
    public static final int USED_BITS = 6;
    protected Color3f color = new Color3f(1.0f, 1.0f, 1.0f);
    protected Color3f fillColor = new Color3f(0.0f, 0.0f, 1.0f);
    protected Font font = null;
    protected String caption = null;

    public void setAlignment(int n, int n2) {
        this.setHorizontalAlignment(n);
        this.setVerticalAlignment(n2);
    }

    public void setHorizontalAlignment(int n) {
        this.BITMASK &= 0xFFFF3FFF;
        if (n == 1) {
            this.BITMASK |= 0x4000;
        } else if (n == 2) {
            this.BITMASK |= 0x8000;
        }
    }

    public int getHorizontalAlignment() {
        switch (this.BITMASK & 0xC000) {
            case 16384: {
                return 1;
            }
            case 32768: {
                return 2;
            }
        }
        return 0;
    }

    public void setVerticalAlignment(int n) {
        this.BITMASK &= 0xFFFFCFFF;
        if (n == 1) {
            this.BITMASK |= 0x1000;
        } else if (n == 2) {
            this.BITMASK |= 0x2000;
        }
    }

    public int getVerticalAlignment() {
        switch (this.BITMASK & 0x3000) {
            case 4096: {
                return 1;
            }
            case 8192: {
                return 2;
            }
        }
        return 0;
    }

    public void updateInstanceIndirect(Object object, boolean bl, GraphState graphState) {
    }

    protected void updateInstanceByInstancing(Renderable renderable, GraphState graphState) {
        assert (renderable instanceof TextLabelBase);
        TextLabelBase textLabelBase = (TextLabelBase)renderable;
    }

    protected void updateInstanceDirect(Renderable renderable) {
        assert (renderable instanceof TextLabelBase);
        TextLabelBase textLabelBase = (TextLabelBase)renderable;
        this.font = FontAdapter.getFont((FontAdapter)textLabelBase.getFont());
        this.getHorizontalAlignment();
        this.getVerticalAlignment();
        this.color = textLabelBase.getColor();
        this.fillColor = textLabelBase.getFillColor();
        this.setBool(32, textLabelBase.isFilled());
        this.setBool(16, textLabelBase.isOutlined());
    }

    public void draw(OpenGLState openGLState, RenderState renderState) {
        TextLabelBase.draw(this.caption, this.font, this.getHorizontalAlignment(), this.getVerticalAlignment(), (Tuple3f)this.color, (Tuple3f)this.fillColor, this.getBool(32), this.getBool(16), renderState);
    }
}

