/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.io;

import de.grogra.graph.impl.Node;
import de.grogra.imp3d.objects.Patch;
import de.grogra.math.VertexGrid;
import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.XMLReaderBase;
import de.grogra.util.MimeType;
import de.grogra.util.Utils;
import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLPatchReader
extends XMLReaderBase {
    public static final MimeType MIME_TYPE = new MimeType("text/x-grogra-tuple3table+xml", null);
    public static final IOFlavor FLAVOR = IOFlavor.valueOf(Node.class);
    private int depth;
    private int rowCount;
    private int index;
    private VertexGrid grid;
    private float[] floatArray = new float[3];

    public XMLPatchReader(FilterItem filterItem, FilterSource filterSource) {
        super(filterItem, filterSource);
        this.setFlavor(FLAVOR);
    }

    protected Object getObjectImpl() throws IOException {
        return new Patch(this.grid);
    }

    public void startDocument() {
        this.depth = 0;
        this.rowCount = 0;
        this.index = 0;
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.depth == 1) {
            ++this.rowCount;
        }
        ++this.depth;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        --this.depth;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.depth == 3) {
            try {
                String string = new String(cArray, n, n2);
                if (Utils.parseFloatArray((String)string, (float[])this.floatArray, (String)" ,") != 3) {
                    throw new SAXParseException("Illegal string for triple: " + string, this.loc);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXParseException(null, this.loc, numberFormatException);
            }
        }
    }
}

