/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.objects;

import de.grogra.graph.Cache;
import de.grogra.graph.GraphState;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.GlobalTransformation;
import de.grogra.imp3d.objects.NURBSCurve;
import de.grogra.imp3d.objects.Sequence;
import de.grogra.math.BSpline;
import de.grogra.math.BSplineCurve;
import de.grogra.math.BSplineCurveList;
import de.grogra.math.Pool;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import de.grogra.vecmath.Matrix34d;
import java.util.ArrayList;
import javax.vecmath.Matrix4d;

public class CurveSequence
extends Sequence
implements BSplineCurveList {
    public static final Type $TYPE = new Type(CurveSequence.class);

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public CurveSequence() {
    }

    public CurveSequence(String string) {
        this.name = string;
    }

    public boolean dependsOnContext() {
        return true;
    }

    public void writeStamp(Cache.Entry entry, GraphState graphState) {
        super.writeStamp(entry, graphState);
        Object[] objectArray = (Object[])this.getCache(graphState);
        int n = objectArray.length;
        entry.write(n);
        GraphState.ObjectContext objectContext = graphState.getObjectContext();
        while ((n -= 3) >= 0) {
            graphState.setObjectContext((GraphState.ObjectContext)objectArray[n + 1]);
            ((BSplineCurve)objectArray[n]).writeStamp(entry, graphState);
            entry.write((float[])objectArray[n + 2]);
        }
        graphState.setObjectContext(objectContext);
    }

    protected void visitNode(Object object, Object object2, ArrayList arrayList, GraphState graphState) {
        if (object2 instanceof NURBSCurve) {
            arrayList.add(graphState.createObjectState(object, true));
            arrayList.add(graphState.getObject(object, true, null, Attributes.CURVE));
            arrayList.add(GlobalTransformation.get(object, true, graphState, false));
        }
    }

    protected Object calculateCache(Matrix4d matrix4d, ArrayList arrayList, GraphState graphState, Object object) {
        int n = arrayList.size();
        Object[] objectArray = new Object[n];
        int n2 = -1;
        Matrix4d matrix4d2 = Pool.get((GraphState)graphState).m4d1;
        while (n > 0) {
            ((Matrix34d)arrayList.get(--n)).get(matrix4d2);
            matrix4d2.mul(matrix4d, matrix4d2);
            objectArray[++n2] = (BSplineCurve)arrayList.get(--n);
            objectArray[++n2] = (GraphState.ObjectContext)arrayList.get(--n);
            objectArray[++n2] = new float[]{(float)matrix4d2.m00, (float)matrix4d2.m01, (float)matrix4d2.m02, (float)matrix4d2.m03, (float)matrix4d2.m10, (float)matrix4d2.m11, (float)matrix4d2.m12, (float)matrix4d2.m13, (float)matrix4d2.m20, (float)matrix4d2.m21, (float)matrix4d2.m22, (float)matrix4d2.m23};
        }
        return objectArray;
    }

    public int getSize(GraphState graphState) {
        Object[] objectArray = (Object[])this.getCache(graphState);
        return objectArray.length / 3;
    }

    public int getVertex(float[] fArray, int n, int n2, GraphState graphState) {
        Object[] objectArray = (Object[])this.getCache(graphState);
        BSplineCurve bSplineCurve = (BSplineCurve)objectArray[n *= 3];
        GraphState.ObjectContext objectContext = graphState.getObjectContext();
        graphState.setObjectContext((GraphState.ObjectContext)objectArray[n + 1]);
        int n3 = bSplineCurve.getVertex(fArray, n2, graphState);
        float f = bSplineCurve.isRational(graphState) ? fArray[--n3] : 1.0f;
        float f2 = fArray[0];
        float f3 = n3 > 1 ? fArray[1] : 0.0f;
        float f4 = n3 > 2 ? fArray[2] : 0.0f;
        float[] fArray2 = (float[])objectArray[n + 2];
        graphState.setObjectContext(objectContext);
        return BSpline.set((float[])fArray, (float)(fArray2[0] * f2 + fArray2[1] * f3 + fArray2[2] * f4 + fArray2[3] * f), (float)(fArray2[4] * f2 + fArray2[5] * f3 + fArray2[6] * f4 + fArray2[7] * f), (float)(fArray2[8] * f2 + fArray2[9] * f3 + fArray2[10] * f4 + fArray2[11] * f), (float)f);
    }

    public float getKnot(int n, int n2, GraphState graphState) {
        Object[] objectArray = (Object[])this.getCache(graphState);
        GraphState.ObjectContext objectContext = graphState.getObjectContext();
        graphState.setObjectContext((GraphState.ObjectContext)objectArray[(n *= 3) + 1]);
        float f = ((BSplineCurve)objectArray[n]).getKnot(0, n2, graphState);
        graphState.setObjectContext(objectContext);
        return f;
    }

    public int getSize(int n, GraphState graphState) {
        Object[] objectArray = (Object[])this.getCache(graphState);
        GraphState.ObjectContext objectContext = graphState.getObjectContext();
        graphState.setObjectContext((GraphState.ObjectContext)objectArray[(n *= 3) + 1]);
        int n2 = ((BSplineCurve)objectArray[n]).getSize(graphState);
        graphState.setObjectContext(objectContext);
        return n2;
    }

    public int getDimension(int n, GraphState graphState) {
        return 4;
    }

    public int getDegree(int n, GraphState graphState) {
        Object[] objectArray = (Object[])this.getCache(graphState);
        GraphState.ObjectContext objectContext = graphState.getObjectContext();
        graphState.setObjectContext((GraphState.ObjectContext)objectArray[(n *= 3) + 1]);
        int n2 = ((BSplineCurve)objectArray[n]).getDegree(graphState);
        graphState.setObjectContext(objectContext);
        return n2;
    }

    public boolean isRational(int n, GraphState graphState) {
        Object[] objectArray = (Object[])this.getCache(graphState);
        GraphState.ObjectContext objectContext = graphState.getObjectContext();
        graphState.setObjectContext((GraphState.ObjectContext)objectArray[(n *= 3) + 1]);
        boolean bl = ((BSplineCurve)objectArray[n]).isRational(graphState);
        graphState.setObjectContext(objectContext);
        return bl;
    }

    public boolean areCurvesCompatible(GraphState graphState) {
        return false;
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends Sequence.Type {
        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(CurveSequence curveSequence, SCOType sCOType) {
            super(curveSequence, sCOType);
        }

        Type(Class clazz) {
            super(clazz, (SCOType)Sequence.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        public Object newInstance() {
            return new CurveSequence();
        }
    }
}

