/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.objects;

import de.grogra.graph.Attribute;
import de.grogra.graph.ContextDependent;
import de.grogra.graph.GraphState;
import de.grogra.graph.impl.Node;
import de.grogra.imp.PickList;
import de.grogra.imp3d.Pickable;
import de.grogra.imp3d.PolygonArray;
import de.grogra.imp3d.Polygonizable;
import de.grogra.imp3d.Polygonization;
import de.grogra.imp3d.RenderState;
import de.grogra.imp3d.Renderable;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.PolygonMesh;
import de.grogra.imp3d.objects.Polygons;
import de.grogra.imp3d.objects.ShadedNull;
import de.grogra.persistence.ManageableType;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Type;
import de.grogra.xl.util.DoubleList;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class MeshNode
extends ShadedNull
implements Pickable,
Polygonizable,
Renderable {
    protected Polygons polygons;
    protected int visibleSides = 2;
    public static final Node.NType $TYPE = new Node.NType((Node)new MeshNode());
    public static final Node.NType.Field polygons$FIELD = new _Field("polygons", 0x200004, (Type)ClassAdapter.wrap(Polygons.class), null, 0);
    public static final Node.NType.Field visibleSides$FIELD;

    public MeshNode() {
        this((Polygons)null);
    }

    public MeshNode(Polygons polygons) {
        this.polygons = polygons;
        this.setLayer(1);
    }

    public ContextDependent getPolygonizableSource(GraphState graphState) {
        return this.polygons;
    }

    public void pick(Object object, boolean bl, Point3d point3d, Vector3d vector3d, Matrix4d matrix4d, PickList pickList) {
        TriangleRayTest triangleRayTest = new TriangleRayTest(point3d, vector3d, matrix4d);
        triangleRayTest.setPolygons((PolygonMesh)this.polygons);
        DoubleList doubleList = triangleRayTest.intersectionTest();
        for (int i = 0; i < doubleList.size; ++i) {
            pickList.add(doubleList.get(i));
        }
    }

    public Polygonization getPolygonization() {
        final class Poly
        implements Polygonization {
            final int visibleSides;

            Poly() {
                this.visibleSides = MeshNode.this.visibleSides;
            }

            public void polygonize(ContextDependent contextDependent, GraphState graphState, PolygonArray polygonArray, int n, float f) {
                MeshNode.this.polygonizeImpl(contextDependent, graphState, polygonArray, n, f);
            }

            public boolean equals(Object object) {
                if (!(object instanceof Poly)) {
                    return false;
                }
                Poly poly = (Poly)object;
                return poly.visibleSides == this.visibleSides;
            }

            public int hashCode() {
                return this.visibleSides;
            }
        }
        return new Poly();
    }

    void polygonizeImpl(ContextDependent contextDependent, GraphState graphState, PolygonArray polygonArray, int n, float f) {
        if (this.polygons == null) {
            polygonArray.init(3);
        } else {
            this.polygons.polygonize(contextDependent, graphState, polygonArray, n, f);
            polygonArray.visibleSides = this.visibleSides;
        }
    }

    public void draw(Object object, boolean bl, RenderState renderState) {
        renderState.drawPolygons(this, object, bl, null, -1, null);
    }

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new MeshNode();
    }

    public int getVisibleSides() {
        return this.visibleSides;
    }

    public void setVisibleSides(int n) {
        this.visibleSides = n;
    }

    public Polygons getPolygons() {
        return this.polygons;
    }

    public void setPolygons(Polygons polygons) {
        polygons$FIELD.setObject((Object)this, (Object)polygons);
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)polygons$FIELD);
        visibleSides$FIELD = new _Field("visibleSides", 0x200004, Type.INT, null, 1);
        $TYPE.addManagedField((ManageableType.Field)visibleSides$FIELD);
        $TYPE.declareFieldAttribute(polygons$FIELD, (Attribute)Attributes.POLYGONS);
        $TYPE.declareFieldAttribute(visibleSides$FIELD, (Attribute)Attributes.VISIBLE_SIDES);
        $TYPE.addIdentityAccessor(Attributes.SHAPE);
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        public void setInt(Object object, int n) {
            switch (this.id) {
                case 1: {
                    ((MeshNode)object).visibleSides = n;
                    return;
                }
            }
            super.setInt(object, n);
        }

        public int getInt(Object object) {
            switch (this.id) {
                case 1: {
                    return ((MeshNode)object).getVisibleSides();
                }
            }
            return super.getInt(object);
        }

        protected void setObjectImpl(Object object, Object object2) {
            switch (this.id) {
                case 0: {
                    ((MeshNode)object).polygons = (Polygons)object2;
                    return;
                }
            }
            super.setObjectImpl(object, object2);
        }

        public Object getObject(Object object) {
            switch (this.id) {
                case 0: {
                    return ((MeshNode)object).getPolygons();
                }
            }
            return super.getObject(object);
        }
    }

    private class TriangleRayTest {
        private Point3d origin;
        private Vector3d direction;
        private PolygonMesh polygons;

        public TriangleRayTest(Point3d point3d, Vector3d vector3d, Matrix4d matrix4d) {
            this.origin = new Point3d(point3d);
            this.direction = new Vector3d(vector3d);
        }

        public void setPolygons(PolygonMesh polygonMesh) {
            this.polygons = polygonMesh;
        }

        public DoubleList intersectionTest() {
            DoubleList doubleList = new DoubleList();
            float f = 1.0E-5f;
            float[] fArray = this.polygons.getVertexData();
            int[] nArray = this.polygons.getIndexData();
            for (int i = 0; i <= nArray.length - 3; i += 3) {
                double d;
                Vector3d vector3d;
                double d2;
                double d3;
                Point3d point3d = new Point3d((double)fArray[nArray[i + 0] * 3], (double)fArray[nArray[i + 0] * 3 + 1], (double)fArray[nArray[i + 0] * 3 + 2]);
                Point3d point3d2 = new Point3d((double)fArray[nArray[i + 1] * 3], (double)fArray[nArray[i + 1] * 3 + 1], (double)fArray[nArray[i + 1] * 3 + 2]);
                Point3d point3d3 = new Point3d((double)fArray[nArray[i + 2] * 3], (double)fArray[nArray[i + 2] * 3 + 1], (double)fArray[nArray[i + 2] * 3 + 2]);
                Point3d point3d4 = new Point3d(point3d2.x - point3d.x, point3d2.y - point3d.y, point3d2.z - point3d.z);
                Point3d point3d5 = new Point3d(point3d3.x - point3d.x, point3d3.y - point3d.y, point3d3.z - point3d.z);
                Vector3d vector3d2 = new Vector3d(this.direction);
                vector3d2.cross(vector3d2, new Vector3d(point3d5.x, point3d5.y, point3d5.z));
                double d4 = point3d4.x * vector3d2.x + point3d4.y * vector3d2.y + point3d4.z * vector3d2.z;
                if (Math.abs(d4) < (double)f || (d3 = (d2 = 1.0 / d4) * (vector3d = new Vector3d(this.origin.x - point3d.x, this.origin.y - point3d.y, this.origin.z - point3d.z)).dot(vector3d2)) < 0.0 || d3 > 1.0) continue;
                Vector3d vector3d3 = new Vector3d(vector3d);
                vector3d3.cross(vector3d3, new Vector3d(point3d4.x, point3d4.y, point3d4.z));
                double d5 = d2 * this.direction.dot(vector3d3);
                if (d5 < 0.0 || d3 + d5 > 1.0 || (d = d2 * new Vector3d(point3d5.x, point3d5.y, point3d5.z).dot(vector3d3)) < 0.0) continue;
                doubleList.add(d);
            }
            return doubleList;
        }
    }
}

