/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.objects;

import de.grogra.imp3d.PolygonArray;
import de.grogra.imp3d.objects.NURBSSubdivisionHelper;
import de.grogra.math.BSpline;
import de.grogra.math.Pool;
import de.grogra.xl.util.FloatList;
import de.grogra.xl.util.IntList;

public class NURBSPolygonizer
extends NURBSSubdivisionHelper
implements BSpline.BezierPatchVisitor {
    int vSize;
    private final IntList patchCornerIndices = new IntList();
    private final Pool pool;
    private final boolean normals;
    private final boolean uv;
    private boolean uvPermuted;
    private int left;
    private int right;
    private int dir;
    private int uDegree;
    private int vDegree;
    private int patchSize;
    private int uRowSize;
    private boolean rightPart;
    private final PolygonArray out;
    private final IntList vertexIndices;
    private final IntList tmpData = new IntList();
    private float uMin;
    private float uMax;
    private float vMin;
    private float vMax;
    private static final int IPV = 6;

    public NURBSPolygonizer(PolygonArray polygonArray, boolean bl, Pool pool, int n) {
        super(polygonArray.vertices, bl);
        this.vertexIndices = polygonArray.polygons;
        this.out = polygonArray;
        this.uv = (n & 2) != 0;
        this.normals = (n & 1) != 0;
        polygonArray.edgeCount = 4;
        polygonArray.planar = false;
        polygonArray.closed = false;
        this.pool = pool;
    }

    private int getIndex(int n, int n2) {
        return this.patchCornerIndices.elements[n == 0 ? n2 << 1 : (n == 1 ? (n2 << 1) + 1 : n * this.vSize + n2)];
    }

    public void visit(int n, int n2, float[] fArray, int n3, int n4, int n5, float f, float f2, float f3, float f4, boolean bl) {
        int n6;
        int n7;
        int n8;
        this.dimension = n3;
        this.uDegree = n4;
        this.vDegree = n5;
        this.uvPermuted = bl;
        int n9 = this.uRowSize = n3 * (n4 + 1);
        this.patchSize = this.uRowSize * (n5 + 1);
        if (bl) {
            this.uMin = f3;
            this.uMax = f4;
            this.vMin = f;
            this.vMax = f2;
        } else {
            this.uMin = f;
            this.uMax = f2;
            this.vMin = f3;
            this.vMax = f4;
        }
        if (n == 0) {
            this.vSize = n2 + 2;
        }
        if (n == 0 && n2 == 0) {
            n8 = this.addVertex(fArray, 0);
            this.patchCornerIndices.add(n8);
        } else {
            n8 = this.getIndex(n, n2);
        }
        if (n2 == 0) {
            n7 = this.addVertex(fArray, n9 - n3);
            this.patchCornerIndices.add(n7);
        } else {
            n7 = this.getIndex(n + 1, n2);
        }
        if (n == 0) {
            n6 = this.addVertex(fArray, n9 * n5);
            this.patchCornerIndices.add(n6);
        } else {
            n6 = this.getIndex(n, n2 + 1);
        }
        int n10 = this.addVertex(fArray, this.patchSize - n3);
        this.patchCornerIndices.add(n10);
        FloatList floatList = this.pool.fv;
        float[] fArray2 = this.pool.getFloatArray(0, Math.max(16, n3 * (n4 * n5 + Math.max(n4, n5))));
        this.rightPart = true;
        floatList.setSize(n9);
        this.dir = 0;
        this.degree = n4;
        if (n2 == 0) {
            this.left = n8;
            this.right = n7;
            FloatList.arraycopy((float[])fArray, (int)0, (float[])floatList.elements, (int)0, (int)n9);
            this.subdivideCurve(floatList, fArray2, 0, 0);
        }
        this.left = n6;
        this.right = n10;
        FloatList.arraycopy((float[])fArray, (int)(n9 * n5), (float[])floatList.elements, (int)0, (int)n9);
        this.subdivideCurve(floatList, fArray2, 0, 0);
        floatList.setSize(n3 * (n5 + 1));
        this.dir = 1;
        this.degree = n5;
        if (n == 0) {
            this.left = n8;
            this.right = n6;
            NURBSPolygonizer.copy(fArray, 0, n9, floatList.elements, 0, n3, n5 + 1);
            this.subdivideCurve(floatList, fArray2, 0, 0);
        }
        this.left = n7;
        this.right = n10;
        NURBSPolygonizer.copy(fArray, n9 - n3, n9, floatList.elements, 0, n3, n5 + 1);
        this.subdivideCurve(floatList, fArray2, 0, 0);
        floatList.clear();
        floatList.addAll(fArray, 0, this.patchSize);
        this.subdividePatch(floatList, n8, n7, n6, n10, 0, true, true, fArray2, true, 0, 0, false, 1, f, f2, f3, f4);
    }

    protected void subdivideCurve(FloatList floatList, float[] fArray, int n, int n2) {
        int n3 = this.left;
        int n4 = this.right;
        boolean bl = this.rightPart;
        if (n > 0) {
            this.right = this.addVertex(floatList.elements, floatList.size - this.dimension);
            this.tmpData.set((bl ? n3 : n4) * 6 + (this.dir << 1) + (bl ? 1 : 0), this.right);
            this.rightPart = false;
        } else if (n < 0) {
            this.left = this.tmpData.get((bl ? n3 : n4) * 6 + (this.dir << 1) + (bl ? 1 : 0));
            this.rightPart = true;
        }
        super.subdivideCurve(floatList, fArray, n, n2);
        this.left = n3;
        this.right = n4;
        this.rightPart = bl;
    }

    private void copyVertex(float[] fArray, int n, float[] fArray2, int n2, boolean bl) {
        int n3 = this.dimension;
        if (this.rational) {
            if (bl) {
                float f = 1.0f / fArray[n + n3 - 1];
                fArray2[n2] = fArray[n] * f;
                fArray2[n2 + 1] = n3 > 2 ? fArray[n + 1] * f : 0.0f;
                fArray2[n2 + 2] = n3 > 3 ? fArray[n + 2] * f : 0.0f;
            } else {
                fArray2[n2] = fArray[n];
                fArray2[n2 + 1] = n3 > 2 ? fArray[n + 1] : 0.0f;
                fArray2[n2 + 2] = n3 > 3 ? fArray[n + 2] : 0.0f;
                fArray2[n2 + 3] = fArray[n + n3 - 1];
            }
        } else {
            fArray2[n2] = fArray[n];
            fArray2[n2 + 1] = n3 > 1 ? fArray[n + 1] : 0.0f;
            fArray2[n2 + 2] = n3 > 2 ? fArray[n + 2] : 0.0f;
        }
    }

    private boolean isFlat(float[] fArray, int n, int n2, float[] fArray2) {
        int n3;
        this.degree = this.uDegree + this.vDegree >> 1;
        int n4 = this.dimension;
        int n5 = this.uDegree * n4;
        int n6 = n5 + n4;
        int n7 = this.vDegree * n6;
        this.copyVertex(fArray, n, fArray2, 0, true);
        this.copyVertex(fArray, n + n5, fArray2, 4, true);
        this.copyVertex(fArray, n + n5 + n7, fArray2, 8, true);
        this.copyVertex(fArray, n + n7, fArray2, 12, true);
        float f = fArray2[0] - fArray2[4];
        float f2 = f * f;
        f = fArray2[1] - fArray2[5];
        float f3 = f2 + f * f;
        f = fArray2[2] - fArray2[6];
        float f4 = f3 + f * f;
        f = fArray2[4] - fArray2[8];
        float f5 = f * f;
        f = fArray2[5] - fArray2[9];
        float f6 = f5 + f * f;
        f = fArray2[6] - fArray2[10];
        float f7 = f6 + f * f;
        f = fArray2[8] - fArray2[12];
        float f8 = f * f;
        f = fArray2[9] - fArray2[13];
        float f9 = f8 + f * f;
        f = fArray2[10] - fArray2[14];
        float f10 = f9 + f * f;
        f = fArray2[12] - fArray2[0];
        float f11 = f * f;
        f = fArray2[13] - fArray2[1];
        float f12 = f11 + f * f;
        f = fArray2[14] - fArray2[2];
        float f13 = f12 + f * f;
        int n8 = f4 > f7 ? (f4 > f10 ? (f4 > f13 ? 0 : 12) : (f10 > f13 ? 8 : 12)) : (f7 > f10 ? (f7 > f13 ? 4 : 12) : (n3 = f10 > f13 ? 8 : 12));
        f13 = n3 == 0 ? f4 : (n3 == 4 ? f7 : (n3 == 8 ? f10 : f13));
        f4 = fArray2[n3];
        f7 = fArray2[n3 + 1];
        f10 = fArray2[n3 + 2];
        n3 = n3 + 4 & 0xF;
        float f14 = fArray2[n3] - f4;
        float f15 = fArray2[n3 + 1] - f7;
        float f16 = fArray2[n3 + 2] - f10;
        n3 = n3 + 4 & 0xF;
        float f17 = fArray2[n3] - f4;
        float f18 = fArray2[n3 + 1] - f7;
        float f19 = fArray2[n3 + 2] - f10;
        float f20 = f18 * f16 - f19 * f15;
        float f21 = f19 * f14 - f17 * f16;
        float f22 = f17 * f15 - f18 * f14;
        n3 = n3 + 4 & 0xF;
        f17 = fArray2[n3] - f4;
        f18 = fArray2[n3 + 1] - f7;
        f19 = fArray2[n3 + 2] - f10;
        float f23 = f18 * f16 - f19 * f15;
        float f24 = f19 * f14 - f17 * f16;
        float f25 = f17 * f15 - f18 * f14;
        float f26 = f20 * f20 + f21 * f21 + f22 * f22;
        f = f23 * f23 + f24 * f24 + f25 * f25;
        if (f > f26 ? !this.isFlat((f = (fArray2[n3 = n3 - 4 & 0xF] - f4) * (f20 = f23) + (fArray2[n3 + 1] - f7) * (f21 = f24) + (fArray2[n3 + 2] - f10) * (f22 = f25)) * f * (f26 = 1.0f / f), f13, n2) : !this.isFlat((f = f17 * f20 + f18 * f21 + f19 * f22) * f * (f26 = 1.0f / f26), f13, n2)) {
            return false;
        }
        for (int i = n5 - n4; i > 0; i -= n4) {
            for (int j = n7 - n6 + i; j > 0; j -= n6) {
                this.copyVertex(fArray, n + j, fArray2, 0, true);
                f = (fArray2[0] - f4) * f20 + (fArray2[1] - f7) * f21 + (fArray2[2] - f10) * f22;
                if (this.isFlat(f * f * f26, f13, n2)) continue;
                return false;
            }
        }
        return true;
    }

    private void pushVertex(int n, float[] fArray, int n2, int n3, int n4, float[] fArray2, float f, float f2) {
        this.vertexIndices.push(n);
        if (this.uv) {
            this.out.uv.set(2 * n, f);
            this.out.uv.set(2 * n + 1, f2);
        }
        if (this.normals) {
            int n5 = n * 6 + 5;
            int n6 = this.tmpData.elements[n5];
            this.tmpData.elements[n5] = n6 + 1;
            int n7 = n6;
            if (n7 == 0 || f == this.uMin || f == this.uMax || f2 == this.vMin || f2 == this.vMax) {
                byte by;
                byte by2;
                byte by3;
                float f3;
                float f4;
                float f5;
                float f6;
                float f7;
                float f8;
                this.copyVertex(fArray, n2, fArray2, 0, false);
                this.copyVertex(fArray, n2 + n3, fArray2, 4, false);
                this.copyVertex(fArray, n2 + n4, fArray2, 8, false);
                if (this.rational) {
                    f = fArray2[3];
                    f2 = -fArray2[7];
                    f8 = f * fArray2[4] + f2 * fArray2[0];
                    f7 = f * fArray2[5] + f2 * fArray2[1];
                    f6 = f * fArray2[6] + f2 * fArray2[2];
                    f2 = -fArray2[11];
                    f5 = f * fArray2[8] + f2 * fArray2[0];
                    f4 = f * fArray2[9] + f2 * fArray2[1];
                    f3 = f * fArray2[10] + f2 * fArray2[2];
                } else {
                    f8 = fArray2[4] - fArray2[0];
                    f7 = fArray2[5] - fArray2[1];
                    f6 = fArray2[6] - fArray2[2];
                    f5 = fArray2[8] - fArray2[0];
                    f4 = fArray2[9] - fArray2[1];
                    f3 = fArray2[10] - fArray2[2];
                }
                int n8 = n * 3;
                byte[] byArray = this.out.normals.elements;
                if (n7 > 0) {
                    by3 = byArray[n8];
                    by2 = byArray[n8 + 1];
                    by = byArray[n8 + 2];
                } else {
                    by3 = 0;
                    by2 = 0;
                    by = 0;
                }
                this.out.setNormal(n, f7 * f3 - f6 * f4, f6 * f5 - f8 * f3, f8 * f4 - f7 * f5);
                if (n7 > 0 && Math.abs(byArray[n8] - by3) + Math.abs(byArray[n8 + 1] - by2) + Math.abs(byArray[n8 + 2] - by) > 3) {
                    this.out.setNormal(n, n7 * by3 + byArray[n8], n7 * by2 + byArray[n8 + 1], n7 * by + byArray[n8 + 2]);
                }
            }
        }
    }

    private void subdividePatch(FloatList floatList, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, float[] fArray, boolean bl3, int n6, int n7, boolean bl4, int n8, float f, float f2, float f3, float f4) {
        IntList intList = this.tmpData;
        int n9 = (bl ? n : n2) * 6 + (n5 << 1) + (bl ? 1 : 0);
        int n10 = intList.get(n9);
        int n11 = (bl ? n3 : n4) * 6 + (n5 << 1) + (bl ? 1 : 0);
        int n12 = intList.get(n11);
        int n13 = floatList.size;
        if (!(bl4 || n10 != 0 && intList.get(n10 * 6 + 4) == 0 || n12 != 0 && intList.get(n12 * 6 + 4) == 0)) {
            if (!bl3 && (1 << n6 > (n5 == 0 ? this.uDegree : this.vDegree) + 1 << 1 && 1 << n7 > (n5 == 0 ? this.vDegree : this.uDegree) + 1 << 1 || this.isFlat(floatList.elements, n13 - this.patchSize, n6 + n7 >> 1, fArray))) {
                int n14;
                int n15;
                int n16;
                int n17;
                if (n5 == 0 == this.uvPermuted) {
                    n10 = n2;
                    n2 = n3;
                    n3 = n10;
                    float f5 = f;
                    f = f3;
                    f3 = f5;
                    f5 = f2;
                    f2 = f4;
                    f4 = f5;
                }
                n13 -= this.patchSize;
                if (this.uvPermuted) {
                    n17 = this.patchSize - this.uRowSize;
                    n16 = this.uRowSize - this.dimension;
                    n15 = this.uRowSize;
                    n14 = this.dimension;
                } else {
                    n17 = this.uRowSize - this.dimension;
                    n16 = this.patchSize - this.uRowSize;
                    n15 = this.dimension;
                    n14 = this.uRowSize;
                }
                this.pushVertex(n, floatList.elements, n13, n15, n14, fArray, f, f3);
                this.pushVertex(n2, floatList.elements, n13 + n17, n14, -n15, fArray, f2, f3);
                this.pushVertex(n4, floatList.elements, n13 + n17 + n16, -n15, -n14, fArray, f2, f4);
                this.pushVertex(n3, floatList.elements, n13 + n16, -n14, n15, fArray, f, f4);
                return;
            }
            if (bl3 || n5 == n8) {
                this.subdividePatch(floatList, n, n3, n2, n4, n5 ^ 1, bl2, bl, fArray, false, n7, n6, !bl3, n8, f3, f4, f, f2);
                return;
            }
        }
        if (n5 == 0) {
            NURBSPolygonizer.subdivide((FloatList)floatList, (int)this.dimension, (int)this.uDegree, (int)this.dimension, (int)(this.vDegree + 1), (int)this.uRowSize, (float[])fArray);
        } else {
            NURBSPolygonizer.subdivide((FloatList)floatList, (int)this.dimension, (int)this.vDegree, (int)this.uRowSize, (int)(this.uDegree + 1), (int)this.dimension, (float[])fArray);
        }
        n13 = floatList.size;
        if (n10 == 0) {
            n10 = this.addInterpolated(n9, n, n2, floatList.elements, n13 - 2 * this.patchSize);
        }
        if (n12 == 0) {
            n12 = this.addInterpolated(n11, n3, n4, floatList.elements, n13 - this.dimension);
        }
        if (n5 == 0) {
            floatList.setSize(n13 + this.dimension * (this.vDegree + 1));
            this.dir = 1;
            this.degree = this.vDegree;
            NURBSPolygonizer.copy(floatList.elements, n13 - 2 * this.patchSize, this.uRowSize, floatList.elements, n13, this.dimension, this.vDegree + 1);
        } else {
            floatList.setSize(n13 + this.dimension * (this.uDegree + 1));
            this.dir = 0;
            this.degree = this.uDegree;
            FloatList.arraycopy((float[])floatList.elements, (int)(n13 - 2 * this.patchSize), (float[])floatList.elements, (int)n13, (int)this.uRowSize);
        }
        this.left = n10;
        this.right = n12;
        this.rightPart = bl2;
        this.subdivideCurve(floatList, fArray, 0, n7);
        floatList.setSize(n13);
        this.subdividePatch(floatList, n, n3, n10, n12, n5 ^ 1, bl2, false, fArray, true, n7, n6 + 1, false, n5, f3, f4, f, (f + f2) * 0.5f);
        floatList.setSize(floatList.size - this.patchSize);
        this.subdividePatch(floatList, n10, n12, n2, n4, n5 ^ 1, bl2, true, fArray, true, n7, n6 + 1, false, n5, f3, f4, (f + f2) * 0.5f, f2);
    }

    private int addInterpolated(int n, int n2, int n3, float[] fArray, int n4) {
        n4 = this.addVertex(fArray, n4);
        this.tmpData.set(n, n4);
        this.tmpData.set(n4 * 6 + 4, 1);
        n2 *= 3;
        n3 *= 3;
        n = n4 * 3;
        fArray = this.out.vertices.elements;
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 2; i >= 0; --i) {
            float f3 = fArray[n2 + i];
            float f4 = fArray[n + i] - f3;
            f3 = fArray[n3 + i] - f3;
            f += f4 * f3;
            f2 += f3 * f3;
        }
        float f5 = f >= 0.0f ? f : -f;
        if (f5 < 100000.0f * f2) {
            f /= f2;
            f2 = 1.0f - f;
            fArray[n] = f2 * fArray[n2] + f * fArray[n3];
            fArray[n + 1] = f2 * fArray[n2 + 1] + f * fArray[n3 + 1];
            fArray[n + 2] = f2 * fArray[n2 + 2] + f * fArray[n3 + 2];
        } else {
            fArray[n] = fArray[n2];
            fArray[n + 1] = fArray[n2 + 1];
            fArray[n + 2] = fArray[n2 + 2];
        }
        return n4;
    }

    int addVertex(float[] fArray, int n) {
        n = super.addVertex(fArray, n);
        int n2 = n * 6;
        int n3 = 5;
        this.tmpData.set(n2 + n3, 0);
        int[] nArray = this.tmpData.elements;
        while (--n3 >= 0) {
            nArray[n2 + n3] = 0;
        }
        return n;
    }

    protected void visitFlat(float[] fArray, int n) {
    }

    private static void copy(float[] fArray, int n, int n2, float[] fArray2, int n3, int n4, int n5) {
        while (--n5 >= 0) {
            FloatList.arraycopy((float[])fArray, (int)n, (float[])fArray2, (int)n3, (int)n4);
            n += n2;
            n3 += n4;
        }
    }
}

