/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.objects;

import de.grogra.graph.Attribute;
import de.grogra.graph.ContextDependent;
import de.grogra.graph.GraphState;
import de.grogra.graph.impl.Node;
import de.grogra.imp.PickList;
import de.grogra.imp3d.Pickable;
import de.grogra.imp3d.PolygonArray;
import de.grogra.imp3d.Polygonizable;
import de.grogra.imp3d.Polygonization;
import de.grogra.imp3d.RenderState;
import de.grogra.imp3d.Renderable;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.CurveSequence;
import de.grogra.imp3d.objects.NURBSPolygonizer;
import de.grogra.imp3d.objects.ShadedNull;
import de.grogra.imp3d.objects.Sphere;
import de.grogra.imp3d.objects.SweepSequence;
import de.grogra.imp3d.objects.VertexSequence;
import de.grogra.math.BSpline;
import de.grogra.math.BSplineCurve;
import de.grogra.math.BSplineCurveList;
import de.grogra.math.BSplineSurface;
import de.grogra.math.Circle;
import de.grogra.math.Pool;
import de.grogra.math.ProfileSweep;
import de.grogra.math.SkinnedSurface;
import de.grogra.math.Sweep;
import de.grogra.persistence.ManageableType;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Type;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class NURBSSurface
extends ShadedNull
implements Renderable,
Polygonizable,
Pickable {
    public static final byte SKIN = 0;
    public static final byte SWEEP = 1;
    protected BSplineSurface surface;
    protected float flatness = 1.0f;
    protected int visibleSides = 2;
    public static final Node.NType $TYPE = new Node.NType((Node)new NURBSSurface());
    public static final Node.NType.Field surface$FIELD = new _Field("surface", 0x200004, (Type)ClassAdapter.wrap(BSplineSurface.class), null, 0);
    public static final Node.NType.Field flatness$FIELD;
    public static final Node.NType.Field visibleSides$FIELD;

    public NURBSSurface(BSplineSurface bSplineSurface) {
        this.surface = bSplineSurface;
        this.setLayer(1);
    }

    public NURBSSurface() {
        this((BSplineSurface)null);
    }

    public NURBSSurface(BSplineCurveList bSplineCurveList) {
        this((BSplineSurface)new SkinnedSurface(bSplineCurveList));
    }

    public NURBSSurface(BSplineCurve bSplineCurve) {
        this(bSplineCurve, null, false);
    }

    public NURBSSurface(BSplineCurve bSplineCurve, boolean bl) {
        this(bSplineCurve, null, bl);
    }

    public NURBSSurface(BSplineCurve bSplineCurve, String string) {
        this(bSplineCurve, string, false);
    }

    public NURBSSurface(BSplineCurve bSplineCurve, String string, boolean bl) {
        this((BSplineCurveList)new ProfileSweep(bSplineCurve, (BSplineCurve)new VertexSequence(string)));
        this.setUseRail(bl);
    }

    public NURBSSurface(float f) {
        this((BSplineCurve)new Circle(f), null);
    }

    public NURBSSurface(float f, String string) {
        this((BSplineCurve)new Circle(f), string);
    }

    public NURBSSurface(byte by) {
        switch (by) {
            case 0: {
                this.setSurface((BSplineSurface)new SkinnedSurface((BSplineCurveList)new CurveSequence()));
                break;
            }
            case 1: {
                this.setSurface((BSplineSurface)new SkinnedSurface((BSplineCurveList)new SweepSequence(null, false)));
            }
        }
    }

    public NURBSSurface(byte by, String string, boolean bl) {
        switch (by) {
            case 0: {
                this.setSurface((BSplineSurface)new SkinnedSurface((BSplineCurveList)new CurveSequence(string)));
                break;
            }
            case 1: {
                this.setSurface((BSplineSurface)new SkinnedSurface((BSplineCurveList)new SweepSequence(string, bl)));
            }
        }
    }

    public void setUseRail(boolean bl) {
        BSplineCurveList bSplineCurveList;
        BSplineSurface bSplineSurface = this.getSurface();
        if (bSplineSurface instanceof SkinnedSurface && (bSplineCurveList = ((SkinnedSurface)bSplineSurface).getProfiles()) instanceof Sweep) {
            ((Sweep)bSplineCurveList).setUseRail(bl);
        }
    }

    public void setHermite(boolean bl) {
        BSplineCurveList bSplineCurveList;
        BSplineSurface bSplineSurface = this.getSurface();
        if (bSplineSurface instanceof SkinnedSurface && (bSplineCurveList = ((SkinnedSurface)bSplineSurface).getProfiles()) instanceof SweepSequence) {
            ((SweepSequence)bSplineCurveList).setHermite(bl);
        }
    }

    public void setTangentLength(float f) {
        BSplineCurveList bSplineCurveList;
        BSplineSurface bSplineSurface = this.getSurface();
        if (bSplineSurface instanceof SkinnedSurface && (bSplineCurveList = ((SkinnedSurface)bSplineSurface).getProfiles()) instanceof SweepSequence) {
            ((SweepSequence)bSplineCurveList).setTangentLength(f);
        }
    }

    public ContextDependent getPolygonizableSource(GraphState graphState) {
        return graphState.getObjectContext().getObject() == this ? (graphState.getInstancingPathIndex() <= 0 ? this.surface : (BSplineSurface)graphState.checkObject((Object)this, true, Attributes.SURFACE, (Object)this.surface)) : (BSplineSurface)graphState.getObject(graphState.getObjectContext().getObject(), graphState.getObjectContext().isNode(), Attributes.SURFACE);
    }

    public Polygonization getPolygonization() {
        final class Poly
        implements Polygonization {
            final float flatness;
            final int visibleSides;

            Poly() {
                this.flatness = NURBSSurface.this.flatness;
                this.visibleSides = NURBSSurface.this.visibleSides;
            }

            public void polygonize(ContextDependent contextDependent, GraphState graphState, PolygonArray polygonArray, int n, float f) {
                NURBSSurface.this.polygonizeImpl(contextDependent, graphState, polygonArray, n, f);
            }

            public boolean equals(Object object) {
                if (!(object instanceof Poly)) {
                    return false;
                }
                Poly poly = (Poly)object;
                return poly.flatness == this.flatness && poly.visibleSides == this.visibleSides;
            }

            public int hashCode() {
                return Float.floatToIntBits(this.flatness) ^ this.visibleSides;
            }
        }
        return new Poly();
    }

    void polygonizeImpl(ContextDependent contextDependent, GraphState graphState, PolygonArray polygonArray, int n, float f) {
        int n2;
        float f2;
        if (graphState.getObjectContext().getObject() == this) {
            if (graphState.getInstancingPathIndex() <= 0) {
                f2 = this.flatness;
                n2 = this.visibleSides;
            } else {
                f2 = graphState.checkFloat((Object)this, true, Attributes.FLATNESS, this.flatness);
                n2 = graphState.checkInt((Object)this, true, Attributes.VISIBLE_SIDES, this.visibleSides);
            }
        } else {
            f2 = graphState.getFloatDefault(graphState.getObjectContext().getObject(), graphState.getObjectContext().isNode(), Attributes.FLATNESS, this.flatness);
            n2 = graphState.getIntDefault(graphState.getObjectContext().getObject(), graphState.getObjectContext().isNode(), Attributes.VISIBLE_SIDES, this.visibleSides);
        }
        BSplineSurface bSplineSurface = (BSplineSurface)contextDependent;
        if (BSpline.isValid((BSplineSurface)bSplineSurface, (GraphState)graphState)) {
            polygonArray.init(3);
            NURBSPolygonizer nURBSPolygonizer = new NURBSPolygonizer(polygonArray, bSplineSurface.isRational(graphState), Pool.get((GraphState)graphState), n);
            nURBSPolygonizer.setFlatness(3.0E-4f * f * f2);
            BSpline.decompose((BSpline.BezierPatchVisitor)nURBSPolygonizer, (BSplineSurface)bSplineSurface, (boolean)true, (GraphState)graphState, null);
        } else {
            polygonArray.init(3);
        }
        polygonArray.visibleSides = n2;
    }

    public void draw(Object object, boolean bl, RenderState renderState) {
        renderState.drawPolygons(this, object, bl, null, -1, null);
    }

    public void pick(Object object, boolean bl, Point3d point3d, Vector3d vector3d, Matrix4d matrix4d, PickList pickList) {
        Sphere.pick(1.0f, point3d, vector3d, pickList);
    }

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new NURBSSurface();
    }

    public int getVisibleSides() {
        return this.visibleSides;
    }

    public void setVisibleSides(int n) {
        this.visibleSides = n;
    }

    public float getFlatness() {
        return this.flatness;
    }

    public void setFlatness(float f) {
        this.flatness = f;
    }

    public BSplineSurface getSurface() {
        return this.surface;
    }

    public void setSurface(BSplineSurface bSplineSurface) {
        surface$FIELD.setObject((Object)this, (Object)bSplineSurface);
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)surface$FIELD);
        flatness$FIELD = new _Field("flatness", 0x200004, Type.FLOAT, null, 1);
        $TYPE.addManagedField((ManageableType.Field)flatness$FIELD);
        visibleSides$FIELD = new _Field("visibleSides", 0x200004, Type.INT, null, 2);
        $TYPE.addManagedField((ManageableType.Field)visibleSides$FIELD);
        $TYPE.declareFieldAttribute(surface$FIELD, (Attribute)Attributes.SURFACE);
        $TYPE.declareFieldAttribute(flatness$FIELD, (Attribute)Attributes.FLATNESS);
        $TYPE.declareFieldAttribute(visibleSides$FIELD, (Attribute)Attributes.VISIBLE_SIDES);
        $TYPE.addIdentityAccessor(Attributes.SHAPE);
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        public void setInt(Object object, int n) {
            switch (this.id) {
                case 2: {
                    ((NURBSSurface)object).visibleSides = n;
                    return;
                }
            }
            super.setInt(object, n);
        }

        public int getInt(Object object) {
            switch (this.id) {
                case 2: {
                    return ((NURBSSurface)object).getVisibleSides();
                }
            }
            return super.getInt(object);
        }

        public void setFloat(Object object, float f) {
            switch (this.id) {
                case 1: {
                    ((NURBSSurface)object).flatness = f;
                    return;
                }
            }
            super.setFloat(object, f);
        }

        public float getFloat(Object object) {
            switch (this.id) {
                case 1: {
                    return ((NURBSSurface)object).getFlatness();
                }
            }
            return super.getFloat(object);
        }

        protected void setObjectImpl(Object object, Object object2) {
            switch (this.id) {
                case 0: {
                    ((NURBSSurface)object).surface = (BSplineSurface)object2;
                    return;
                }
            }
            super.setObjectImpl(object, object2);
        }

        public Object getObject(Object object) {
            switch (this.id) {
                case 0: {
                    return ((NURBSSurface)object).getSurface();
                }
            }
            return super.getObject(object);
        }
    }
}

