/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.objects;

import de.grogra.graph.BooleanAttribute;
import de.grogra.graph.ByteAttribute;
import de.grogra.graph.CharAttribute;
import de.grogra.graph.DoubleAttribute;
import de.grogra.graph.EdgePattern;
import de.grogra.graph.FloatAttribute;
import de.grogra.graph.GraphState;
import de.grogra.graph.GraphUtils;
import de.grogra.graph.IntAttribute;
import de.grogra.graph.LongAttribute;
import de.grogra.graph.ObjectAttribute;
import de.grogra.graph.Path;
import de.grogra.graph.ShortAttribute;
import de.grogra.imp.View;
import de.grogra.imp3d.View3D;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.Transformation;
import de.grogra.vecmath.Math2;
import de.grogra.xl.util.ObjectList;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;

public abstract class SceneTree
implements de.grogra.graph.Visitor,
TreeModel {
    protected GraphState state;
    private final EdgePattern pattern;
    private View view;
    private final Matrix4d identity = new Matrix4d();
    private final Matrix4d out = new Matrix4d();
    private final Matrix4d pre = new Matrix4d();
    private final Matrix4d tmp = new Matrix4d();
    private boolean preEqOut;
    private boolean simplifyHierarchy;
    private InnerNode root;
    private InnerNode parent = this.root = this.createInnerNode();
    private final ObjectList<Node> stack = new ObjectList(32);
    private Node cursor;
    private Leaf nextLeaf;
    private Object nextNode;
    private boolean nextAsNode;
    private long nextPathId;
    private Visitor visitor;

    public SceneTree(GraphState graphState, EdgePattern edgePattern) {
        this.state = graphState;
        this.pattern = edgePattern;
        this.identity.setIdentity();
        this.pre.setIdentity();
        this.out.setIdentity();
    }

    public SceneTree(View3D view3D) {
        this(view3D.getWorkbenchGraphState(), view3D.getGraph().getTreePattern());
        this.view = view3D;
    }

    public GraphState getGraphState() {
        return this.state;
    }

    protected void init(Leaf leaf) {
        leaf.state = this.state;
    }

    public Node createTree(boolean bl) {
        return this.createTree(bl, false);
    }

    public Node createTree(boolean bl, boolean bl2) {
        this.simplifyHierarchy = bl;
        this.state.getGraph().accept(null, (de.grogra.graph.Visitor)this, null);
        this.stack.clear();
        this.stack.push((Object)this.root);
        while (!this.stack.isEmpty()) {
            Node node = (Node)this.stack.pop();
            if (!(node instanceof InnerNode)) continue;
            InnerNode innerNode = (InnerNode)node;
            int n = this.stack.size();
            node = innerNode.children;
            while (node != null) {
                this.stack.push((Object)node);
                node = node.next;
            }
            innerNode.children = null;
            for (int i = n; i < this.stack.size(); ++i) {
                Node node2 = (Node)this.stack.get(i);
                if (bl2 && node2 instanceof Leaf && !this.view.isInVisibleLayer(((Leaf)node2).object, true, this.state)) continue;
                node2.next = innerNode.children;
                innerNode.children = node2;
            }
        }
        return this.root;
    }

    public Object getRoot() {
        return this.root;
    }

    public Object visitEnter(Path path, boolean bl) {
        if (bl) {
            return this.visitEnter(path.getObject(-1), true, path.getObjectId(-1), path);
        }
        if (!GraphUtils.matchesTerminalEdge((EdgePattern)this.pattern, (Path)path)) {
            return STOP;
        }
        return this.visitEnter(path.getObject(-2), false, path.getObjectId(-2), path);
    }

    Object visitEnter(Object object, boolean bl, long l, Path path) {
        int n;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        if (this.visitor != null) {
            if (l == this.nextPathId && bl == this.nextAsNode) {
                this.visitor.visit(this.nextLeaf);
                this.findNext();
            }
            return null;
        }
        Transformation transformation = object == null ? null : (Transformation)this.state.getObjectDefault(object, bl, Attributes.TRANSFORMATION, null);
        boolean bl6 = bl5 = object != null && this.acceptLeaf(object, bl);
        if (transformation == null) {
            bl4 = true;
            bl3 = true;
            bl2 = true;
            this.preEqOut = true;
        } else {
            transformation.preTransform(object, bl, this.identity, this.pre, this.state);
            transformation.postTransform(object, bl, this.pre, this.out, this.identity, this.state);
            this.preEqOut = this.pre.epsilonEquals(this.out, 0.0);
            if (bl5) {
                bl4 = this.identity.epsilonEquals(this.pre, 0.0);
                bl3 = this.preEqOut;
                bl2 = bl4 && bl3 || !bl4 && !bl3 && this.identity.epsilonEquals(this.out, 0.0);
            } else {
                bl4 = true;
                bl3 = bl2 = this.identity.epsilonEquals(this.out, 0.0);
            }
        }
        InnerNode innerNode = null;
        if (bl5) {
            Leaf leaf = this.createLeaf(object, bl, l);
            if (bl4 && this.simplifyHierarchy) {
                innerNode = this.parent;
            } else {
                innerNode = this.createInnerNode();
                if (!bl4) {
                    innerNode.set(this.pre);
                }
                this.parent.add(innerNode);
            }
            innerNode.add(leaf);
        }
        int n2 = n = object == null ? -1 : this.state.getIntDefault(object, bl, Attributes.CSG_OPERATION, -1);
        if (this.simplifyHierarchy && n == -1) {
            if (bl2) {
                return null;
            }
            if (bl3) {
                assert (bl5 && !bl4);
                InnerNode innerNode2 = this.parent;
                this.parent = innerNode;
                return innerNode2;
            }
        }
        InnerNode innerNode3 = this.createInnerNode();
        if (bl5 && !this.simplifyHierarchy) {
            if (!bl3) {
                if (bl4) {
                    innerNode3.set(this.out);
                } else {
                    Math2.invertAffine((Matrix4d)this.pre, (Matrix4d)this.tmp);
                    Math2.mulAffine((Matrix4d)this.tmp, (Matrix4d)this.tmp, (Matrix4d)this.out);
                    innerNode3.set(this.tmp);
                }
            }
            innerNode.add(innerNode3);
        } else {
            if (!bl2) {
                innerNode3.set(this.out);
            }
            this.parent.add(innerNode3);
        }
        innerNode3.flags = n & 7 | 8;
        InnerNode innerNode4 = this.parent;
        this.parent = innerNode3;
        return innerNode4;
    }

    public boolean visitLeave(Object object, Path path, boolean bl) {
        if (bl) {
            if (this.visitor != null) {
                return this.nextNode != null;
            }
            if (object != null) {
                this.parent.simplify();
                InnerNode innerNode = (InnerNode)object;
                Node node = innerNode.children;
                while (node != this.parent) {
                    if (node instanceof InnerNode && ((InnerNode)node).children == this.parent) {
                        ((InnerNode)node).simplify();
                        break;
                    }
                    node = node.next;
                }
                this.parent = (InnerNode)object;
            }
        } else {
            return object == STOP ? this.visitor == null || this.nextNode != null : this.visitLeave(object, path, true);
        }
        return true;
    }

    public Object visitInstanceEnter() {
        if (this.visitor != null || this.preEqOut) {
            return null;
        }
        InnerNode innerNode = this.createInnerNode();
        Math2.invertAffine((Matrix4d)this.out, (Matrix4d)this.tmp);
        Math2.mulAffine((Matrix4d)this.tmp, (Matrix4d)this.tmp, (Matrix4d)this.pre);
        innerNode.set(this.tmp);
        this.parent.add(innerNode);
        InnerNode innerNode2 = this.parent;
        this.parent = innerNode;
        return innerNode2;
    }

    public boolean visitInstanceLeave(Object object) {
        if (this.visitor != null) {
            return this.nextNode != null;
        }
        if (object != null) {
            this.parent.simplify();
            this.parent = (InnerNode)object;
        }
        return true;
    }

    private void findNext() {
        Node node = this.cursor;
        while (true) {
            if (node == null) {
                if (this.stack.isEmpty()) {
                    this.nextNode = null;
                    this.cursor = null;
                    return;
                }
                node = (Node)this.stack.pop();
                this.visitor.visitLeave((InnerNode)node);
                node = node.next;
                continue;
            }
            if (node instanceof InnerNode) {
                this.visitor.visitEnter((InnerNode)node);
                this.stack.push((Object)node);
                node = ((InnerNode)node).children;
                continue;
            }
            if (node instanceof Leaf) break;
        }
        this.nextLeaf = (Leaf)node;
        this.nextNode = this.nextLeaf.object;
        this.nextAsNode = this.nextLeaf.asNode;
        this.nextPathId = this.nextLeaf.pathId;
        this.cursor = node.next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(Visitor visitor) {
        this.visitor = visitor;
        try {
            this.cursor = this.root;
            this.findNext();
            if (this.nextNode != null) {
                this.state.getGraph().accept(null, (de.grogra.graph.Visitor)this, null);
            }
        }
        finally {
            this.visitor = null;
        }
    }

    public boolean isLeaf(Object object) {
        return object instanceof Leaf;
    }

    public Object getChild(Object object, int n) {
        Node node = ((InnerNode)object).children;
        while (--n >= 0) {
            node = node.next;
        }
        return node;
    }

    public int getChildCount(Object object) {
        Node node = ((InnerNode)object).children;
        int n = 0;
        while (node != null) {
            ++n;
            node = node.next;
        }
        return n;
    }

    public int getIndexOfChild(Object object, Object object2) {
        Node node = ((InnerNode)object).children;
        if (node == null) {
            return -1;
        }
        int n = 0;
        while (node != object2) {
            ++n;
            node = node.next;
            if (node != null) continue;
            return -1;
        }
        return n;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        throw new UnsupportedOperationException();
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        throw new UnsupportedOperationException();
    }

    protected InnerNode createInnerNode() {
        return new InnerNode();
    }

    protected abstract boolean acceptLeaf(Object var1, boolean var2);

    protected abstract Leaf createLeaf(Object var1, boolean var2, long var3);

    public static interface Visitor {
        public void visitEnter(InnerNode var1);

        public void visitLeave(InnerNode var1);

        public void visit(Leaf var1);
    }

    public static class InnerNode
    extends Node {
        public Node children;
        public static final int CSG_MASK = 7;
        public static final int IS_GROUP = 8;
        public static final int HAS_MORE_THAN_ONE_CHILD = 16;
        public int flags = 7;
        public float m00 = 1.0f;
        public float m01;
        public float m02;
        public float m03;
        public float m10;
        public float m11 = 1.0f;
        public float m12;
        public float m13;
        public float m20;
        public float m21;
        public float m22 = 1.0f;
        public float m23;

        public final void accept(Visitor visitor) {
            visitor.visitEnter(this);
            Node node = this.children;
            while (node != null) {
                node.accept(visitor);
                node = node.next;
            }
            visitor.visitLeave(this);
        }

        public void set(Matrix4d matrix4d) {
            this.m00 = (float)matrix4d.m00;
            this.m01 = (float)matrix4d.m01;
            this.m02 = (float)matrix4d.m02;
            this.m03 = (float)matrix4d.m03;
            this.m10 = (float)matrix4d.m10;
            this.m11 = (float)matrix4d.m11;
            this.m12 = (float)matrix4d.m12;
            this.m13 = (float)matrix4d.m13;
            this.m20 = (float)matrix4d.m20;
            this.m21 = (float)matrix4d.m21;
            this.m22 = (float)matrix4d.m22;
            this.m23 = (float)matrix4d.m23;
        }

        public void get(Matrix4d matrix4d) {
            matrix4d.m00 = this.m00;
            matrix4d.m01 = this.m01;
            matrix4d.m02 = this.m02;
            matrix4d.m03 = this.m03;
            matrix4d.m10 = this.m10;
            matrix4d.m11 = this.m11;
            matrix4d.m12 = this.m12;
            matrix4d.m13 = this.m13;
            matrix4d.m20 = this.m20;
            matrix4d.m21 = this.m21;
            matrix4d.m22 = this.m22;
            matrix4d.m23 = this.m23;
            matrix4d.m30 = 0.0;
            matrix4d.m31 = 0.0;
            matrix4d.m32 = 0.0;
            matrix4d.m33 = 1.0;
        }

        public void transform(Matrix4d matrix4d, Matrix4d matrix4d2) {
            double d = matrix4d.m00;
            double d2 = this.m03;
            double d3 = matrix4d.m01;
            double d4 = this.m13;
            double d5 = matrix4d.m02;
            double d6 = this.m23;
            matrix4d2.m03 = d * d2 + d3 * d4 + d5 * d6 + matrix4d.m03;
            double d7 = matrix4d.m10;
            double d8 = matrix4d.m11;
            double d9 = matrix4d.m12;
            matrix4d2.m13 = d7 * d2 + d8 * d4 + d9 * d6 + matrix4d.m13;
            double d10 = matrix4d.m20;
            double d11 = matrix4d.m21;
            double d12 = matrix4d.m22;
            matrix4d2.m23 = d10 * d2 + d11 * d4 + d12 * d6 + matrix4d.m23;
            d2 = this.m00;
            d4 = this.m10;
            d6 = this.m20;
            matrix4d2.m00 = d * d2 + d3 * d4 + d5 * d6;
            matrix4d2.m10 = d7 * d2 + d8 * d4 + d9 * d6;
            matrix4d2.m20 = d10 * d2 + d11 * d4 + d12 * d6;
            d2 = this.m01;
            d4 = this.m11;
            d6 = this.m21;
            matrix4d2.m01 = d * d2 + d3 * d4 + d5 * d6;
            matrix4d2.m11 = d7 * d2 + d8 * d4 + d9 * d6;
            matrix4d2.m21 = d10 * d2 + d11 * d4 + d12 * d6;
            d2 = this.m02;
            d4 = this.m12;
            d6 = this.m22;
            matrix4d2.m02 = d * d2 + d3 * d4 + d5 * d6;
            matrix4d2.m12 = d7 * d2 + d8 * d4 + d9 * d6;
            matrix4d2.m22 = d10 * d2 + d11 * d4 + d12 * d6;
        }

        public void transformVector(Tuple3f tuple3f) {
            float f = tuple3f.x;
            float f2 = tuple3f.y;
            float f3 = tuple3f.z;
            tuple3f.x = this.m00 * f + this.m01 * f2 + this.m02 * f3;
            tuple3f.y = this.m10 * f + this.m11 * f2 + this.m12 * f3;
            tuple3f.z = this.m20 * f + this.m21 * f2 + this.m22 * f3;
        }

        public void transformVector(Tuple3d tuple3d) {
            double d = tuple3d.x;
            double d2 = tuple3d.y;
            double d3 = tuple3d.z;
            tuple3d.x = (double)this.m00 * d + (double)this.m01 * d2 + (double)this.m02 * d3;
            tuple3d.y = (double)this.m10 * d + (double)this.m11 * d2 + (double)this.m12 * d3;
            tuple3d.z = (double)this.m20 * d + (double)this.m21 * d2 + (double)this.m22 * d3;
        }

        public void transformPoint(Tuple3f tuple3f) {
            float f = tuple3f.x;
            float f2 = tuple3f.y;
            float f3 = tuple3f.z;
            tuple3f.x = this.m00 * f + this.m01 * f2 + this.m02 * f3 + this.m03;
            tuple3f.y = this.m10 * f + this.m11 * f2 + this.m12 * f3 + this.m13;
            tuple3f.z = this.m20 * f + this.m21 * f2 + this.m22 * f3 + this.m23;
        }

        public void transformPoint(Tuple3d tuple3d) {
            double d = tuple3d.x;
            double d2 = tuple3d.y;
            double d3 = tuple3d.z;
            tuple3d.x = (double)this.m00 * d + (double)this.m01 * d2 + (double)this.m02 * d3 + (double)this.m03;
            tuple3d.y = (double)this.m10 * d + (double)this.m11 * d2 + (double)this.m12 * d3 + (double)this.m13;
            tuple3d.z = (double)this.m20 * d + (double)this.m21 * d2 + (double)this.m22 * d3 + (double)this.m23;
        }

        void add(Node node) {
            node.next = this.children;
            this.children = node;
        }

        void simplify() {
            Node node = null;
            Node node2 = this.children;
            while (node2 != null) {
                if (node2.hasContent()) {
                    node = node2;
                } else if (node == null) {
                    this.children = node2.next;
                } else {
                    node.next = node2.next;
                }
                node2 = node2.next;
            }
            node = this.children;
            if (node != null) {
                if (node.next != null) {
                    if ((this.flags & 8) != 0) {
                        this.flags |= 0x10;
                    }
                } else if (node instanceof InnerNode && !((InnerNode)node).isSpecial()) {
                    node2 = (InnerNode)node;
                    this.children = ((InnerNode)node2).children;
                    this.flags |= ((InnerNode)node2).flags & 0x18;
                    float f = this.m00;
                    float f2 = ((InnerNode)node2).m03;
                    float f3 = this.m01;
                    float f4 = ((InnerNode)node2).m13;
                    float f5 = this.m02;
                    float f6 = ((InnerNode)node2).m23;
                    this.m03 = f * f2 + f3 * f4 + f5 * f6 + this.m03;
                    float f7 = this.m10;
                    float f8 = this.m11;
                    float f9 = this.m12;
                    this.m13 = f7 * f2 + f8 * f4 + f9 * f6 + this.m13;
                    float f10 = this.m20;
                    float f11 = this.m21;
                    float f12 = this.m22;
                    this.m23 = f10 * f2 + f11 * f4 + f12 * f6 + this.m23;
                    f2 = ((InnerNode)node2).m00;
                    f4 = ((InnerNode)node2).m10;
                    f6 = ((InnerNode)node2).m20;
                    this.m00 = f * f2 + f3 * f4 + f5 * f6;
                    this.m10 = f7 * f2 + f8 * f4 + f9 * f6;
                    this.m20 = f10 * f2 + f11 * f4 + f12 * f6;
                    f2 = ((InnerNode)node2).m01;
                    f4 = ((InnerNode)node2).m11;
                    f6 = ((InnerNode)node2).m21;
                    this.m01 = f * f2 + f3 * f4 + f5 * f6;
                    this.m11 = f7 * f2 + f8 * f4 + f9 * f6;
                    this.m21 = f10 * f2 + f11 * f4 + f12 * f6;
                    f2 = ((InnerNode)node2).m02;
                    f4 = ((InnerNode)node2).m12;
                    f6 = ((InnerNode)node2).m22;
                    this.m02 = f * f2 + f3 * f4 + f5 * f6;
                    this.m12 = f7 * f2 + f8 * f4 + f9 * f6;
                    this.m22 = f10 * f2 + f11 * f4 + f12 * f6;
                }
            }
        }

        boolean hasContent() {
            return this.children != null;
        }

        protected boolean isSpecial() {
            return (this.flags & 7) != 7;
        }

        public boolean isProperGroup() {
            return (this.flags & 0x18) == 24;
        }

        public String toString() {
            return "InnerNode[" + this.flags + ']';
        }
    }

    public static class Leaf
    extends Node {
        public final Object object;
        public final boolean asNode;
        public final long pathId;
        GraphState state;

        public Leaf(Object object, boolean bl, long l) {
            this.object = object;
            this.asNode = bl;
            this.pathId = l;
        }

        public final void accept(Visitor visitor) {
            visitor.visit(this);
        }

        boolean hasContent() {
            return true;
        }

        public String toString() {
            return super.toString() + '[' + this.object + ']';
        }

        public boolean getBoolean(BooleanAttribute booleanAttribute) {
            return this.state.getBoolean(this.object, this.asNode, booleanAttribute);
        }

        public byte getByte(ByteAttribute byteAttribute) {
            return this.state.getByte(this.object, this.asNode, byteAttribute);
        }

        public short getShort(ShortAttribute shortAttribute) {
            return this.state.getShort(this.object, this.asNode, shortAttribute);
        }

        public char getChar(CharAttribute charAttribute) {
            return this.state.getChar(this.object, this.asNode, charAttribute);
        }

        public int getInt(IntAttribute intAttribute) {
            return this.state.getInt(this.object, this.asNode, intAttribute);
        }

        public long getLong(LongAttribute longAttribute) {
            return this.state.getLong(this.object, this.asNode, longAttribute);
        }

        public float getFloat(FloatAttribute floatAttribute) {
            return this.state.getFloat(this.object, this.asNode, floatAttribute);
        }

        public double getDouble(DoubleAttribute doubleAttribute) {
            return this.state.getDouble(this.object, this.asNode, doubleAttribute);
        }

        public Object getObject(ObjectAttribute objectAttribute) {
            return this.state.getObject(this.object, this.asNode, objectAttribute);
        }

        public Object getObject(Object object, ObjectAttribute objectAttribute) {
            return this.state.getObject(this.object, this.asNode, object, objectAttribute);
        }
    }

    public static abstract class Node {
        public Node next;

        public abstract void accept(Visitor var1);

        abstract boolean hasContent();
    }
}

