/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.objects;

import de.grogra.graph.GraphState;
import de.grogra.graph.impl.Node;
import de.grogra.imp.PickList;
import de.grogra.imp3d.Pickable;
import de.grogra.imp3d.RenderState;
import de.grogra.imp3d.Renderable;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.ShadedNull;
import de.grogra.imp3d.objects.Sphere;
import de.grogra.imp3d.ray.RTSky;
import de.grogra.imp3d.ray.Raytraceable;
import de.grogra.imp3d.ray.RaytracerLeaf;
import de.grogra.imp3d.shading.Light;
import de.grogra.imp3d.shading.LightVisitor;
import de.grogra.imp3d.shading.RGBAShader;
import de.grogra.imp3d.shading.Shader;
import de.grogra.persistence.ManageableType;
import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayList;
import de.grogra.reflect.Type;
import de.grogra.util.Quantity;
import de.grogra.vecmath.Math2;
import java.util.Random;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class Sky
extends ShadedNull
implements Pickable,
Renderable,
Raytraceable,
Light {
    float powerDensity = 50.0f;
    public static final Node.NType $TYPE = new Node.NType((Node)new Sky());
    public static final Node.NType.Field powerDensity$FIELD = new _Field("powerDensity", 0x200000, Type.FLOAT, null, 0);

    public int getFlags() {
        return this.getShader() != null ? this.getShader().getFlags() | 4 : 68;
    }

    public int getAverageColor() {
        return -1;
    }

    public boolean isShadowless() {
        return false;
    }

    public boolean isIgnoredWhenHit() {
        return false;
    }

    public double getTotalPower(Environment environment) {
        Shader shader = this.getShader();
        if (shader instanceof Light) {
            return ((Light)((Object)shader)).getTotalPower(environment);
        }
        if (shader == null) {
            shader = RGBAShader.WHITE;
        }
        RGBAShader rGBAShader = new RGBAShader(shader.getAverageColor());
        return environment.boundsRadius * environment.boundsRadius * 2.0 * Math.PI * (double)this.powerDensity * (double)(rGBAShader.x + rGBAShader.y + rGBAShader.z);
    }

    public double computeExitance(Environment environment, Spectrum spectrum) {
        Shader shader = this.getShader();
        if (shader instanceof Light) {
            return ((Light)((Object)shader)).computeExitance(environment, spectrum);
        }
        spectrum.setIdentity();
        spectrum.scale((double)(this.powerDensity * 0.33333334f));
        return 1.0 / (environment.boundsRadius * environment.boundsRadius * Math.PI);
    }

    public float computeBSDF(Environment environment, Vector3f vector3f, Spectrum spectrum, Vector3f vector3f2, boolean bl, Spectrum spectrum2) {
        Shader shader = this.getShader();
        if (shader == null) {
            shader = RGBAShader.WHITE;
        }
        float f = shader.computeBSDF(environment, environment.normal, spectrum, vector3f2, bl, spectrum2);
        if (shader instanceof Light) {
            return f;
        }
        spectrum2.scale(0.25);
        return Math2.M_1_2PI / 2.0f;
    }

    public int getLightType() {
        return this.getShader() instanceof Light ? 4 : 0;
    }

    public void generateRandomOrigins(Environment environment, RayList rayList, Random random) {
        Shader shader = this.getShader();
        if (shader instanceof Light) {
            ((Light)((Object)shader)).generateRandomOrigins(environment, rayList, random);
            return;
        }
        throw new UnsupportedOperationException();
    }

    public void generateRandomRays(Environment environment, Vector3f vector3f, Spectrum spectrum, RayList rayList, boolean bl, Random random) {
        Shader shader = this.getShader();
        if (shader instanceof Light) {
            ((Light)((Object)shader)).generateRandomRays(environment, vector3f, spectrum, rayList, bl, random);
            return;
        }
        throw new UnsupportedOperationException();
    }

    public double completeRay(Environment environment, Point3d point3d, Ray ray) {
        throw new UnsupportedOperationException();
    }

    private static void initType() {
        $TYPE.addIdentityAccessor(Attributes.SHAPE);
        $TYPE.addIdentityAccessor(Attributes.LIGHT);
    }

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new Sky();
    }

    public float getPowerDensity() {
        return this.powerDensity;
    }

    public void setPowerDensity(float f) {
        this.powerDensity = f;
    }

    public void pick(Object object, boolean bl, Point3d point3d, Vector3d vector3d, Matrix4d matrix4d, PickList pickList) {
        Sphere.pick(0.2f, point3d, vector3d, pickList);
    }

    public void draw(Object object, boolean bl, RenderState renderState) {
        renderState.drawSphere(0.2f, null, -1, null);
    }

    public RaytracerLeaf createRaytracerLeaf(Object object, boolean bl, long l, GraphState graphState) {
        return new RTSky(object, bl, l);
    }

    public void accept(LightVisitor lightVisitor) {
        lightVisitor.visit(this);
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)powerDensity$FIELD);
        powerDensity$FIELD.setQuantity(Quantity.POWER_PER_AREA);
        Sky.initType();
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        public void setFloat(Object object, float f) {
            switch (this.id) {
                case 0: {
                    ((Sky)object).powerDensity = f;
                    return;
                }
            }
            super.setFloat(object, f);
        }

        public float getFloat(Object object) {
            switch (this.id) {
                case 0: {
                    return ((Sky)object).getPowerDensity();
                }
            }
            return super.getFloat(object);
        }
    }
}

