/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.objects;

import de.grogra.graph.Cache;
import de.grogra.graph.GraphState;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.NURBSCurve;
import de.grogra.imp3d.objects.Sequence;
import de.grogra.math.BSpline;
import de.grogra.math.BSplineCurve;
import de.grogra.math.Pool;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import de.grogra.util.Int2ObjectMap;
import de.grogra.vecmath.Math2;
import de.grogra.vecmath.Matrix34d;
import java.util.ArrayList;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4f;

public class VertexSequence
extends Sequence
implements BSplineCurve {
    boolean hermite = true;
    float tangentLength = 1.2f;
    boolean periodic = false;
    public static final Type $TYPE = new Type(VertexSequence.class);
    public static final SCOType.Field hermite$FIELD = Type._addManagedField($TYPE, "hermite", 0x200000, de.grogra.reflect.Type.BOOLEAN, null, 2);
    public static final SCOType.Field tangentLength$FIELD = Type._addManagedField($TYPE, "tangentLength", 0x200000, de.grogra.reflect.Type.FLOAT, null, 3);
    public static final SCOType.Field periodic$FIELD = Type._addManagedField($TYPE, "periodic", 0x200000, de.grogra.reflect.Type.BOOLEAN, null, 4);

    public VertexSequence() {
    }

    public VertexSequence(String string) {
        this.name = string;
    }

    public boolean dependsOnContext() {
        return true;
    }

    public void writeStamp(Cache.Entry entry, GraphState graphState) {
        super.writeStamp(entry, graphState);
        entry.write((float[])this.getCache(graphState));
    }

    public int getSize(GraphState graphState) {
        return this.getSize0(graphState) + (this.periodic ? this.getDegree(graphState) : 0);
    }

    private int getSize0(GraphState graphState) {
        return ((float[])this.getCache(graphState)).length / 7;
    }

    public int getDegree(GraphState graphState) {
        return Math.min(3, this.getSize0(graphState) - 1);
    }

    boolean collectCurves() {
        return false;
    }

    protected void visitNode(Object object, Object object2, ArrayList arrayList, GraphState graphState) {
        if (object2 instanceof Vertex) {
            Matrix34d matrix34d = ((Vertex)object2).getVertexTransformation(object, graphState);
            if (matrix34d != null) {
                arrayList.add(matrix34d);
            }
        } else if (object instanceof Vertex) {
            Matrix34d matrix34d = ((Vertex)object).getVertexTransformation(object, graphState);
            if (matrix34d != null) {
                arrayList.add(matrix34d);
            }
        } else if (this.collectCurves() && object2 instanceof NURBSCurve) {
            BSplineCurve bSplineCurve = (BSplineCurve)graphState.getObject(object, true, null, Attributes.CURVE);
            GraphState.ObjectContext objectContext = graphState.createObjectState(object, true);
            GraphState.ObjectContext objectContext2 = graphState.getObjectContext();
            graphState.setObjectContext(objectContext);
            if (BSpline.isValid((BSplineCurve)bSplineCurve, (GraphState)graphState)) {
                arrayList.add(objectContext);
                arrayList.add(bSplineCurve);
                arrayList.add(this);
            }
            graphState.setObjectContext(objectContext2);
        }
    }

    protected Object calculateCache(Matrix4d matrix4d, ArrayList arrayList, GraphState graphState, Object object) {
        Object object2;
        int n;
        int n2 = arrayList.size();
        int n3 = 0;
        int n4 = 0;
        Pool pool = Pool.get((GraphState)graphState);
        Point3d point3d = pool.p3d0;
        Point3d point3d2 = pool.p3d1;
        Point3d point3d3 = pool.p3d2;
        Point3d point3d4 = pool.p3d3;
        Point4f point4f = pool.p4f0;
        Point4f point4f2 = pool.p4f1;
        Point4f point4f3 = pool.p4f2;
        Vector3d vector3d = pool.v3d3;
        Vector3d vector3d2 = pool.w3d0;
        Vector3d vector3d3 = pool.w3d1;
        Vector3d vector3d4 = pool.w3d2;
        Vector4f vector4f = pool.v4f0;
        Vector4f vector4f2 = pool.v4f1;
        Vector4f vector4f3 = pool.v4f2;
        Vector4f vector4f4 = pool.v4f3;
        float f = 0.0f;
        float f2 = 0.0f;
        for (n = n2 - 1; n >= 0; --n) {
            if (arrayList.get(n) != this) {
                object2 = (Matrix34d)arrayList.get(n);
                point3d.set(object2.m03, object2.m13, object2.m23);
                Math2.transformPoint((Matrix4d)matrix4d, (Tuple3d)point3d);
                point3d3.set(object2.m00, object2.m10, object2.m20);
                Math2.transformVector((Matrix4d)matrix4d, (Tuple3d)point3d3);
                if (n3 == 0) {
                    point3d2.set((Tuple3d)point3d);
                    point3d4.set((Tuple3d)point3d3);
                } else {
                    f = Math.max(f, (float)point3d.distanceSquared(point3d2));
                    f2 = Math.max(f2, (float)point3d3.distanceSquared(point3d4));
                }
                ++n3;
                continue;
            }
            n -= 2;
            ++n4;
        }
        int n5 = n = this.hermite && n3 > 2 ? 1 : 0;
        if (this.collectCurves() && n4 == 0 || n3 <= 1) {
            n3 = 0;
        } else if (n != 0) {
            n3 = 3 * n3 - 2;
            f *= 1.0E-6f;
            f2 *= 1.0E-6f;
        }
        object2 = new float[n3 * 7];
        if (n3 > 0) {
            float f3;
            n4 = -1;
            n3 = n != 0 ? -3 : -1;
            Int2ObjectMap int2ObjectMap = (Int2ObjectMap)object;
            for (int i = n2 - 1; i >= 0; --i) {
                if (arrayList.get(i) != this) {
                    Matrix34d matrix34d = (Matrix34d)arrayList.get(i);
                    point3d.set(matrix34d.m03, matrix34d.m13, matrix34d.m23);
                    Math2.transformPoint((Matrix4d)matrix4d, (Tuple3d)point3d);
                    vector3d.set(matrix34d.m00, matrix34d.m10, matrix34d.m20);
                    Math2.transformVector((Matrix4d)matrix4d, (Tuple3d)vector3d);
                    point4f.set((float)vector3d.x, (float)vector3d.y, (float)vector3d.z, (float)vector3d.length());
                    if (n != 0) {
                        Point3d point3d5 = point3d;
                        point3d = point3d2;
                        point3d2 = point3d3;
                        point3d3 = point3d5;
                        Point4f point4f4 = point4f;
                        point4f = point4f2;
                        point4f2 = point4f3;
                        point4f3 = point4f4;
                        if ((n3 += 3) <= 3) continue;
                        vector3d3.sub((Tuple3d)point3d3, (Tuple3d)point3d);
                        double d = vector3d3.lengthSquared();
                        d = d > (double)f ? 0.1111111111111111 / d : 0.0;
                        vector3d2.sub((Tuple3d)point3d2, (Tuple3d)point3d);
                        vector3d4.scaleAdd((double)(-this.tangentLength) * Math.sqrt(d * vector3d2.lengthSquared()), (Tuple3d)vector3d3, (Tuple3d)point3d2);
                        vector4f3.sub((Tuple4f)point4f3, (Tuple4f)point4f);
                        double d2 = vector4f3.lengthSquared();
                        d2 = d2 > (double)f2 ? 0.1111111111111111 / d2 : 0.0;
                        vector4f2.sub((Tuple4f)point4f2, (Tuple4f)point4f);
                        f3 = vector4f2.w;
                        vector4f2.w = 0.0f;
                        vector4f4.scaleAdd(-this.tangentLength * (float)Math.sqrt(d2 * (double)vector4f2.lengthSquared()), (Tuple4f)vector4f3, (Tuple4f)point4f2);
                        vector4f2.w = f3;
                        vector4f4.w = -this.tangentLength * (float)Math.sqrt(d2) * Math.abs(f3) * vector4f3.w + point4f2.w;
                        if (n3 == 6) {
                            float f4;
                            float f5;
                            object2[++n4] = (Matrix34d)((float)point3d.x);
                            object2[++n4] = (Matrix34d)((float)point3d.y);
                            object2[++n4] = (Matrix34d)((float)point3d.z);
                            object2[++n4] = (Matrix34d)point4f.x;
                            object2[++n4] = (Matrix34d)point4f.y;
                            object2[++n4] = (Matrix34d)point4f.z;
                            object2[++n4] = (Matrix34d)point4f.w;
                            f3 = (float)vector3d2.lengthSquared();
                            if (f5 > f) {
                                vector3d.sub((Tuple3d)vector3d4, (Tuple3d)point3d2);
                                vector3d.scaleAdd(-2.0 * vector3d.dot(vector3d2) / (double)f3, (Tuple3d)vector3d2, (Tuple3d)vector3d);
                                object2[++n4] = (Matrix34d)((float)vector3d.x + (float)point3d.x);
                                object2[++n4] = (Matrix34d)((float)vector3d.y + (float)point3d.y);
                                object2[++n4] = (Matrix34d)((float)vector3d.z + (float)point3d.z);
                            } else {
                                object2[++n4] = (Matrix34d)((float)point3d.x);
                                object2[++n4] = (Matrix34d)((float)point3d.y);
                                object2[++n4] = (Matrix34d)((float)point3d.z);
                            }
                            f3 = vector4f2.lengthSquared();
                            if (f4 > f2) {
                                vector4f.sub((Tuple4f)vector4f4, (Tuple4f)point4f2);
                                vector4f.scaleAdd(-2.0f * vector4f.dot(vector4f2) / f3, (Tuple4f)vector4f2, (Tuple4f)vector4f);
                                object2[++n4] = (Matrix34d)(vector4f.x + point4f.x);
                                object2[++n4] = (Matrix34d)(vector4f.y + point4f.y);
                                object2[++n4] = (Matrix34d)(vector4f.z + point4f.z);
                                object2[++n4] = (Matrix34d)(vector4f.w + point4f.w);
                            } else {
                                object2[++n4] = (Matrix34d)point4f.x;
                                object2[++n4] = (Matrix34d)point4f.y;
                                object2[++n4] = (Matrix34d)point4f.z;
                                object2[++n4] = (Matrix34d)point4f.w;
                            }
                        }
                        object2[++n4] = (Matrix34d)((float)vector3d4.x);
                        object2[++n4] = (Matrix34d)((float)vector3d4.y);
                        object2[++n4] = (Matrix34d)((float)vector3d4.z);
                        object2[++n4] = (Matrix34d)vector4f4.x;
                        object2[++n4] = (Matrix34d)vector4f4.y;
                        object2[++n4] = (Matrix34d)vector4f4.z;
                        object2[++n4] = (Matrix34d)vector4f4.w;
                        object2[++n4] = (Matrix34d)((float)point3d2.x);
                        object2[++n4] = (Matrix34d)((float)point3d2.y);
                        object2[++n4] = (Matrix34d)((float)point3d2.z);
                        object2[++n4] = (Matrix34d)point4f2.x;
                        object2[++n4] = (Matrix34d)point4f2.y;
                        object2[++n4] = (Matrix34d)point4f2.z;
                        object2[++n4] = (Matrix34d)point4f2.w;
                        vector3d2.sub((Tuple3d)point3d3, (Tuple3d)point3d2);
                        vector3d4.scaleAdd((double)this.tangentLength * Math.sqrt(d * vector3d2.lengthSquared()), (Tuple3d)vector3d3, (Tuple3d)point3d2);
                        object2[++n4] = (Matrix34d)((float)vector3d4.x);
                        object2[++n4] = (Matrix34d)((float)vector3d4.y);
                        object2[++n4] = (Matrix34d)((float)vector3d4.z);
                        vector4f2.sub((Tuple4f)point4f3, (Tuple4f)point4f2);
                        f3 = vector4f2.w;
                        vector4f2.w = 0.0f;
                        vector4f4.scaleAdd(this.tangentLength * (float)Math.sqrt(d2 * (double)vector4f2.lengthSquared()), (Tuple4f)vector4f3, (Tuple4f)point4f2);
                        vector4f2.w = f3;
                        vector4f4.w = this.tangentLength * (float)Math.sqrt(d2) * Math.abs(f3) * vector4f3.w + point4f2.w;
                        object2[++n4] = (Matrix34d)vector4f4.x;
                        object2[++n4] = (Matrix34d)vector4f4.y;
                        object2[++n4] = (Matrix34d)vector4f4.z;
                        object2[++n4] = (Matrix34d)vector4f4.w;
                        continue;
                    }
                    object2[++n4] = (Matrix34d)((float)point3d.x);
                    object2[++n4] = (Matrix34d)((float)point3d.y);
                    object2[++n4] = (Matrix34d)((float)point3d.z);
                    object2[++n4] = (Matrix34d)point4f.x;
                    object2[++n4] = (Matrix34d)point4f.y;
                    object2[++n4] = (Matrix34d)point4f.z;
                    object2[++n4] = (Matrix34d)point4f.w;
                    ++n3;
                    continue;
                }
                int2ObjectMap.put(n3, (Object)(i -= 2));
            }
            if (n != 0) {
                float f6;
                float f7;
                f3 = (float)vector3d2.lengthSquared();
                if (f7 > f) {
                    vector3d.sub((Tuple3d)vector3d4, (Tuple3d)point3d2);
                    vector3d.scaleAdd(-2.0 * vector3d.dot(vector3d2) / (double)f3, (Tuple3d)vector3d2, (Tuple3d)vector3d);
                    object2[++n4] = (Matrix34d)((float)vector3d.x + (float)point3d3.x);
                    object2[++n4] = (Matrix34d)((float)vector3d.y + (float)point3d3.y);
                    object2[++n4] = (Matrix34d)((float)vector3d.z + (float)point3d3.z);
                } else {
                    object2[++n4] = (Matrix34d)((float)point3d3.x);
                    object2[++n4] = (Matrix34d)((float)point3d3.y);
                    object2[++n4] = (Matrix34d)((float)point3d3.z);
                }
                f3 = vector4f2.lengthSquared();
                if (f6 > f2) {
                    vector4f.sub((Tuple4f)vector4f4, (Tuple4f)point4f2);
                    vector4f.scaleAdd(-2.0f * vector4f.dot(vector4f2) / f3, (Tuple4f)vector4f2, (Tuple4f)vector4f);
                    object2[++n4] = (Matrix34d)(vector4f.x + point4f3.x);
                    object2[++n4] = (Matrix34d)(vector4f.y + point4f3.y);
                    object2[++n4] = (Matrix34d)(vector4f.z + point4f3.z);
                    object2[++n4] = (Matrix34d)(vector4f.w + point4f3.w);
                } else {
                    object2[++n4] = (Matrix34d)point4f3.x;
                    object2[++n4] = (Matrix34d)point4f3.y;
                    object2[++n4] = (Matrix34d)point4f3.z;
                    object2[++n4] = (Matrix34d)point4f3.w;
                }
                object2[++n4] = (Matrix34d)((float)point3d3.x);
                object2[++n4] = (Matrix34d)((float)point3d3.y);
                object2[++n4] = (Matrix34d)((float)point3d3.z);
                object2[++n4] = (Matrix34d)point4f3.x;
                object2[++n4] = (Matrix34d)point4f3.y;
                object2[++n4] = (Matrix34d)point4f3.z;
                object2[++n4] = (Matrix34d)point4f3.w;
            }
            if (this.collectCurves()) {
                int2ObjectMap.put(Integer.MAX_VALUE, (Object)arrayList.toArray());
            }
        }
        return object2;
    }

    public int getDimension(GraphState graphState) {
        return 7;
    }

    public boolean isRational(GraphState graphState) {
        return false;
    }

    public float getKnot(int n, int n2, GraphState graphState) {
        int n3 = this.getSize0(graphState);
        return BSpline.getDefaultKnot((int)n3, (int)this.getDegree(graphState), (boolean)this.periodic, (this.hermite && n3 > 2 ? 1 : 0) != 0, (int)n2);
    }

    public int getVertex(float[] fArray, int n, GraphState graphState) {
        float[] fArray2 = (float[])this.getCache(graphState);
        if ((n *= 7) >= fArray2.length) {
            n -= fArray2.length;
        }
        return BSpline.set((float[])fArray, (float)fArray2[n], (float)fArray2[n + 1], (float)fArray2[n + 2], (float)fArray2[n + 3], (float)fArray2[n + 4], (float)fArray2[n + 5], (float)fArray2[n + 6]);
    }

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public boolean isHermite() {
        return this.hermite;
    }

    public void setHermite(boolean bl) {
        this.hermite = bl;
    }

    public boolean isPeriodic() {
        return this.periodic;
    }

    public void setPeriodic(boolean bl) {
        this.periodic = bl;
    }

    public float getTangentLength() {
        return this.tangentLength;
    }

    public void setTangentLength(float f) {
        this.tangentLength = f;
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends Sequence.Type {
        private static final int SUPER_FIELD_COUNT = 2;
        protected static final int FIELD_COUNT = 5;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(VertexSequence vertexSequence, SCOType sCOType) {
            super(vertexSequence, sCOType);
        }

        Type(Class clazz) {
            super(clazz, (SCOType)Sequence.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setBoolean(Object object, int n, boolean bl) {
            switch (n) {
                case 2: {
                    ((VertexSequence)((Object)object)).hermite = bl;
                    return;
                }
                case 4: {
                    ((VertexSequence)((Object)object)).periodic = bl;
                    return;
                }
            }
            super.setBoolean(object, n, bl);
        }

        protected boolean getBoolean(Object object, int n) {
            switch (n) {
                case 2: {
                    return ((VertexSequence)((Object)object)).isHermite();
                }
                case 4: {
                    return ((VertexSequence)((Object)object)).isPeriodic();
                }
            }
            return super.getBoolean(object, n);
        }

        protected void setFloat(Object object, int n, float f) {
            switch (n) {
                case 3: {
                    ((VertexSequence)((Object)object)).tangentLength = f;
                    return;
                }
            }
            super.setFloat(object, n, f);
        }

        protected float getFloat(Object object, int n) {
            switch (n) {
                case 3: {
                    return ((VertexSequence)((Object)object)).getTangentLength();
                }
            }
            return super.getFloat(object, n);
        }

        public Object newInstance() {
            return new VertexSequence();
        }
    }

    public static interface Vertex {
        public Matrix34d getVertexTransformation(Object var1, GraphState var2);
    }
}

