/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.ray;

import de.grogra.imp3d.ray.RaytracerLeaf;
import de.grogra.ray.RTObject;
import de.grogra.ray.debug3d.ExportableToVRML;
import de.grogra.ray.intersection.BoundingBox;
import de.grogra.ray.intersection.BoundingVolume;
import de.grogra.ray.intersection.IntersectionDescription;
import de.grogra.ray.intersection.Intersections;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayContext;
import java.io.BufferedWriter;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class RTBox
extends RaytracerLeaf
implements RTObject,
ExportableToVRML {
    public final Intersections.BoxInput m_boxInput = new Intersections.BoxInput();
    public final Intersections.BoxLocalVariables m_boxLocalVariables = new Intersections.BoxLocalVariables();
    public final Intersections.ObjectOutput m_boxOutput = new Intersections.ObjectOutput();
    private BoundingBox m_boundingVolume = null;

    public RTBox(Object object, boolean bl, long l, float f, float f2, float f3) {
        super(object, bl, l);
        this.m_boxInput.expansion_x = f;
        this.m_boxInput.expansion_y = f2;
        this.m_boxInput.expansion_z = f3;
        this.m_boxInput.expansion_x *= 0.5f;
        this.m_boxInput.expansion_y *= 0.5f;
        this.m_boxInput.expansion_z *= 0.5f;
    }

    public boolean isConvex() {
        return true;
    }

    public boolean isShadeable() {
        return true;
    }

    public boolean isSolid() {
        return true;
    }

    public void setTransformation(Matrix4f matrix4f) {
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, this.m_boxInput.expansion_z);
        matrix4f.transform(vector3f);
        matrix4f.m03 += vector3f.x;
        matrix4f.m13 += vector3f.y;
        matrix4f.m23 += vector3f.z;
        super.setTransformation(matrix4f);
        this.m_boxInput.transformation.set(matrix4f);
        this.m_boxInput.invers_transformation.invert(matrix4f);
        this.m_boxInput.top_normal.set(0.0f, 0.0f, 1.0f);
        this.m_boxInput.front_normal.set(0.0f, -1.0f, 0.0f);
        this.m_boxInput.right_normal.set(1.0f, 0.0f, 0.0f);
        matrix4f.transform(this.m_boxInput.top_normal);
        matrix4f.transform(this.m_boxInput.front_normal);
        matrix4f.transform(this.m_boxInput.right_normal);
        this.setShader(this.shader);
        if (this.interior != null) {
            this.setMedium(this.interior);
        }
        this.m_boundingVolume = null;
    }

    public float getDistance(Ray ray, RayContext rayContext) {
        this.m_boxInput.ray.setRay(ray);
        this.m_boxInput.minIndex = this.getUserData().isInside ? 1 : 0;
        Intersections.getBox_T((Intersections.BoxInput)this.m_boxInput, (Intersections.ObjectOutput)this.m_boxOutput, (Intersections.BoxLocalVariables)this.m_boxLocalVariables);
        if (!this.m_boxOutput.hasIntersection) {
            return Float.NaN;
        }
        return this.m_boxOutput.t;
    }

    public void getIntersectionDescription(IntersectionDescription intersectionDescription) {
        Intersections.getBox_IntersectionDescription((Intersections.BoxInput)this.m_boxInput, (int)this.shader.getFlags(), (IntersectionDescription)intersectionDescription, (Intersections.BoxLocalVariables)this.m_boxLocalVariables);
        intersectionDescription.setRTObject((RTObject)this);
    }

    public BoundingVolume getBoundingVolume() {
        if (this.m_boundingVolume == null) {
            Point3f[] point3fArray = new Point3f[8];
            Vector3f vector3f = new Vector3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
            Vector3f vector3f2 = new Vector3f(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
            float f = this.m_boxInput.expansion_x + 0.01f;
            float f2 = this.m_boxInput.expansion_y + 0.01f;
            float f3 = this.m_boxInput.expansion_z + 0.01f;
            point3fArray[0] = new Point3f(f, f2, f3);
            point3fArray[1] = new Point3f(-f, f2, f3);
            point3fArray[2] = new Point3f(-f, -f2, f3);
            point3fArray[3] = new Point3f(f, -f2, f3);
            point3fArray[4] = new Point3f(f, f2, -f3);
            point3fArray[5] = new Point3f(-f, f2, -f3);
            point3fArray[6] = new Point3f(-f, -f2, -f3);
            point3fArray[7] = new Point3f(f, -f2, -f3);
            for (int i = 0; i < 8; ++i) {
                this.m_boxInput.transformation.transform(point3fArray[i]);
                if (point3fArray[i].x < vector3f.x) {
                    vector3f.x = point3fArray[i].x;
                }
                if (point3fArray[i].y < vector3f.y) {
                    vector3f.y = point3fArray[i].y;
                }
                if (point3fArray[i].z < vector3f.z) {
                    vector3f.z = point3fArray[i].z;
                }
                if (point3fArray[i].x > vector3f2.x) {
                    vector3f2.x = point3fArray[i].x;
                }
                if (point3fArray[i].y > vector3f2.y) {
                    vector3f2.y = point3fArray[i].y;
                }
                if (!(point3fArray[i].z > vector3f2.z)) continue;
                vector3f2.z = point3fArray[i].z;
            }
            this.m_boundingVolume = new BoundingBox(vector3f, vector3f2);
        }
        return this.m_boundingVolume;
    }

    public void exportToVRML(BufferedWriter bufferedWriter) {
        try {
            bufferedWriter.write("  Transform {");
            bufferedWriter.newLine();
            bufferedWriter.write("    children [");
            bufferedWriter.newLine();
            bufferedWriter.write("      Shape {");
            bufferedWriter.newLine();
            bufferedWriter.write("        appearance Appearance {");
            bufferedWriter.newLine();
            bufferedWriter.write("          material Material {");
            bufferedWriter.newLine();
            bufferedWriter.write("            transparency 0.5");
            bufferedWriter.newLine();
            bufferedWriter.write("          }");
            bufferedWriter.newLine();
            bufferedWriter.write("        }");
            bufferedWriter.newLine();
            bufferedWriter.write("        geometry Box {");
            bufferedWriter.newLine();
            bufferedWriter.write("          size " + this.m_boxInput.expansion_x * 2.0f + " " + this.m_boxInput.expansion_y * 2.0f + " " + this.m_boxInput.expansion_z * 2.0f);
            bufferedWriter.newLine();
            bufferedWriter.write("        }");
            bufferedWriter.newLine();
            bufferedWriter.write("      }");
            bufferedWriter.newLine();
            bufferedWriter.write("    ]");
            bufferedWriter.newLine();
            bufferedWriter.write("    translation " + (this.m_boxInput.transformation.m03 + 0.0f * this.m_boxInput.expansion_x) + " " + (this.m_boxInput.transformation.m13 - 0.0f * this.m_boxInput.expansion_y) + " " + (this.m_boxInput.transformation.m23 + 0.0f * this.m_boxInput.expansion_z));
            bufferedWriter.newLine();
            bufferedWriter.write("  }");
            bufferedWriter.newLine();
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }
}

