/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.shading;

import de.grogra.graph.impl.Node;
import de.grogra.imp3d.shading.ChannelMapNodeVisitor;
import de.grogra.imp3d.shading.SyntheticTexture;
import de.grogra.persistence.ManageableType;
import de.grogra.reflect.Type;
import java.util.Random;

public class Carpenter
extends SyntheticTexture {
    float color = 0.5f;
    float noise = 1.0f;
    float roughness = 1.0f;
    long seed = 0L;
    private static final Random rnd = new Random();
    public static final Node.NType $TYPE = new Node.NType((Node)new Carpenter());
    public static final Node.NType.Field color$FIELD = new _Field("color", 0x200000, Type.FLOAT, null, 0);
    public static final Node.NType.Field noise$FIELD;
    public static final Node.NType.Field roughness$FIELD;
    public static final Node.NType.Field seed$FIELD;

    protected void calculateImageData() {
        rnd.setSeed(0L);
        this.setPixel(0, 0, this.color);
        int n = 0;
        int n2 = 0;
        int n3 = n + this.width;
        int n4 = n2 + this.height;
        this.carpenter(n, n2, n3, n4, this.noise);
    }

    private float rand(float f) {
        return f * (2.0f * rnd.nextFloat() - 1.0f);
    }

    private void carpenter(int n, int n2, int n3, int n4, float f) {
        int n5 = n3 - n;
        for (int i = n4 - n2; n5 >= 2 || i >= 2; n5 /= 2, i /= 2) {
            int n6;
            int n7;
            for (n7 = n; n5 > 0 && n7 < n3; n7 += n5) {
                for (n6 = n2; i > 0 && n6 < n4; n6 += i) {
                    this.diamondStep(n7, n6, n7 + n5, n6 + i, f);
                }
            }
            for (n7 = n; n5 > 0 && n7 < n3; n7 += n5) {
                for (n6 = n2; i > 0 && n6 < n4; n6 += i) {
                    this.squareStep(n7 - n5 / 2, n6, n7 + n5 / 2, n6 + i, f);
                    this.squareStep(n7, n6 - i / 2, n7 + n5, n6 + i / 2, f);
                }
            }
            f = (float)((double)f * Math.pow(2.0, -this.roughness));
        }
    }

    private void diamondStep(int n, int n2, int n3, int n4, float f) {
        int n5 = n3 - n;
        int n6 = n4 - n2;
        if (n5 < 2 || n6 < 2) {
            return;
        }
        int n7 = (n + n3) / 2;
        int n8 = (n2 + n4) / 2;
        float f2 = this.getPixel(n, n2);
        float f3 = this.getPixel(n3, n2);
        float f4 = this.getPixel(n, n4);
        float f5 = this.getPixel(n3, n4);
        float f6 = (f2 + f3 + f4 + f5) / 4.0f;
        this.setPixel(n7, n8, f6 += this.rand(f));
    }

    private void squareStep(int n, int n2, int n3, int n4, float f) {
        int n5 = (n + n3) / 2;
        int n6 = (n2 + n4) / 2;
        float f2 = this.getPixel(n, n6);
        float f3 = this.getPixel(n3, n6);
        float f4 = this.getPixel(n5, n2);
        float f5 = this.getPixel(n5, n4);
        float f6 = (f2 + f3 + f4 + f5) / 4.0f;
        this.setPixel(n5, n6, f6 += this.rand(f));
    }

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new Carpenter();
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long l) {
        this.seed = l;
    }

    public float getColor() {
        return this.color;
    }

    public void setColor(float f) {
        this.color = f;
    }

    public float getNoise() {
        return this.noise;
    }

    public void setNoise(float f) {
        this.noise = f;
    }

    public float getRoughness() {
        return this.roughness;
    }

    public void setRoughness(float f) {
        this.roughness = f;
    }

    public void accept(ChannelMapNodeVisitor channelMapNodeVisitor) {
        channelMapNodeVisitor.visit(this);
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)color$FIELD);
        noise$FIELD = new _Field("noise", 0x200000, Type.FLOAT, null, 1);
        $TYPE.addManagedField((ManageableType.Field)noise$FIELD);
        roughness$FIELD = new _Field("roughness", 0x200000, Type.FLOAT, null, 2);
        $TYPE.addManagedField((ManageableType.Field)roughness$FIELD);
        seed$FIELD = new _Field("seed", 0x200000, Type.LONG, null, 3);
        $TYPE.addManagedField((ManageableType.Field)seed$FIELD);
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        public void setLong(Object object, long l) {
            switch (this.id) {
                case 3: {
                    ((Carpenter)((Object)object)).seed = l;
                    return;
                }
            }
            super.setLong(object, l);
        }

        public long getLong(Object object) {
            switch (this.id) {
                case 3: {
                    return ((Carpenter)((Object)object)).getSeed();
                }
            }
            return super.getLong(object);
        }

        public void setFloat(Object object, float f) {
            switch (this.id) {
                case 0: {
                    ((Carpenter)((Object)object)).color = f;
                    return;
                }
                case 1: {
                    ((Carpenter)((Object)object)).noise = f;
                    return;
                }
                case 2: {
                    ((Carpenter)((Object)object)).roughness = f;
                    return;
                }
            }
            super.setFloat(object, f);
        }

        public float getFloat(Object object) {
            switch (this.id) {
                case 0: {
                    return ((Carpenter)((Object)object)).getColor();
                }
                case 1: {
                    return ((Carpenter)((Object)object)).getNoise();
                }
                case 2: {
                    return ((Carpenter)((Object)object)).getRoughness();
                }
            }
            return super.getFloat(object);
        }
    }
}

