/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.shading;

import de.grogra.graph.impl.Node;
import de.grogra.imp3d.shading.ColorMapNode;
import de.grogra.imp3d.shading.Shader;
import de.grogra.math.ChannelData;
import de.grogra.math.ChannelMap;
import de.grogra.math.ChannelMapInput;
import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.physics.Spectrum3f;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayList;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public abstract class Material
extends ColorMapNode
implements Shader {
    public static final Node.NType $TYPE = new Node.NType(Material.class);

    protected void renderLine(BufferedImage bufferedImage, int n, int n2, boolean bl, Map map) {
        Environment environment = (Environment)map.get("env");
        RayList rayList = (RayList)map.get("rays");
        if (environment == null) {
            environment = new Environment(null, (Spectrum)new Spectrum3f(), 0);
            map.put("env", environment);
            rayList = new RayList(environment.tmpSpectrum0);
            map.put("rays", rayList);
            ChannelMapInput channelMapInput = new ChannelMapInput();
            environment.userObjectOwner = this;
            environment.userObject = channelMapInput;
            ChannelData channelData = channelMapInput.getUserData((ChannelMap)this, null);
            ChannelData channelData2 = channelData.createSink((ChannelMap)this);
            channelData2.setProperty("ignoreInput", (Object)(!bl ? 1 : 0));
        }
        Material.renderLine(this, environment, rayList, bufferedImage, n, n2);
    }

    ChannelData getSource(Environment environment) {
        if (!(environment.userObject instanceof ChannelMapInput)) {
            environment.userObjectOwner = this;
            environment.userObject = new ChannelMapInput();
        }
        ChannelData channelData = ((ChannelMapInput)environment.userObject).getUserData((ChannelMap)this, null);
        ChannelData channelData2 = channelData.createSink((ChannelMap)this);
        channelData.setFloat(28, environment.iorRatio);
        channelData.setTuple3f(20, (Tuple3f)environment.localPoint);
        channelData.setTuple3f(4, (Tuple3f)environment.normal);
        channelData.setTuple2f(16, (Tuple2f)environment.uv);
        channelData.setTuple3f(8, (Tuple3f)environment.dpdu);
        channelData.setTuple3f(12, (Tuple3f)environment.dpdv);
        channelData.setTuple3f(0, (Tuple3f)environment.point);
        return channelData;
    }

    public static void renderLine(Shader shader, Environment environment, RayList rayList, BufferedImage bufferedImage, int n, int n2) {
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        vector3f3.set(-10.0f, 3.0f, 3.0f);
        vector3f3.normalize();
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        rayList.setSize(2);
        Spectrum spectrum = rayList.rays[0].spectrum.newInstance();
        spectrum.setIdentity();
        Point3d point3d = new Point3d();
        for (int i = 0; i < n3; ++i) {
            vector3f.set(0.0f, 0.0f, 0.0f);
            for (int j = 0; j < n; ++j) {
                float f = -1.1f * (float)(2 * (n * i + j) - n3 * n) / (float)(n3 * n);
                for (int k = 0; k < n; ++k) {
                    float f2;
                    float f3 = -1.1f * (float)(2 * (n * n2 + k) - n4 * n) / (float)(n4 * n);
                    float f4 = 1.0f - f * f - f3 * f3;
                    float f5 = f2 = ((int)Math.floor((f + f3) * 4.0f) & 2) == 0 ? 0.8f : 0.5f;
                    if (f4 >= 0.0f) {
                        float f6;
                        float f7;
                        float f8;
                        f4 = f4 <= 0.0f ? 0.0f : -((float)Math.sqrt(f4));
                        vector3f2.set(f4, f, f3);
                        environment.localPoint.set((Tuple3f)vector3f2);
                        environment.point.set((Tuple3f)vector3f2);
                        environment.normal.set((Tuple3f)vector3f2);
                        float f9 = vector3f3.dot(vector3f2) >= 0.0f ? 1.0f : 0.0f;
                        float f10 = 1.0f - f3 * f3;
                        if ((double)f10 < 1.0E-8) {
                            f10 = 0.0f;
                            f8 = 0.0f;
                            f7 = 1.0f;
                            f6 = 0.0f;
                        } else {
                            f10 = (float)Math.sqrt(f10);
                            f8 = (float)Math.atan2(f, f4);
                            f7 = f4 / f10;
                            f6 = f / f10;
                        }
                        f8 = (float)((double)f8 / (Math.PI * 2));
                        if (f8 < 0.0f) {
                            f8 += 1.0f;
                        }
                        float f11 = (float)(Math.acos(-f3) / Math.PI);
                        environment.uv.set(f8, f11);
                        environment.dpdu.set((float)Math.PI * -2 * f6 * f10, (float)Math.PI * 2 * f7 * f10, 0.0f);
                        environment.dpdv.set((float)(-Math.PI) * f7 * f3, (float)(-Math.PI) * f6 * f3, (float)Math.PI * f10);
                        environment.iorRatio = 1.0f;
                        Ray ray = rayList.rays[0];
                        ray.direction.set((Tuple3f)vector3f3);
                        ray.spectrum.setIdentity();
                        ray.spectrum.scale((double)f9);
                        ray = rayList.rays[1];
                        ray.direction.set(1.0f, 0.0f, 0.0f);
                        ray.spectrum.setIdentity();
                        ray.spectrum.scale((double)f2);
                        vector3f2.set(-1.0f, 0.0f, 0.0f);
                        shader.shade(environment, rayList, vector3f2, spectrum, (Tuple3d)point3d);
                        vector3f2.set((Tuple3d)point3d);
                        vector3f.add((Tuple3f)vector3f2);
                        continue;
                    }
                    vector3f2.set(f2, f2, f2);
                    vector3f.add((Tuple3f)vector3f2);
                }
            }
            vector3f.clamp(0.0f, (float)(n * n));
            vector3f.scale(255.99f / (float)(n * n));
            bufferedImage.setRGB(i, n2, -16777216 + ((int)vector3f.x << 16) + ((int)vector3f.y << 8) + (int)vector3f.z);
        }
    }

    static {
        $TYPE.validate();
    }
}

