/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.shading;

import de.grogra.icon.Icon;
import de.grogra.icon.IconSource;
import de.grogra.imp3d.shading.Shader;
import de.grogra.imp3d.shading.ShaderVisitor;
import de.grogra.math.Tuple4fType;
import de.grogra.persistence.Manageable;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.PersistenceField;
import de.grogra.persistence.PersistenceInput;
import de.grogra.persistence.PersistenceOutput;
import de.grogra.persistence.Shareable;
import de.grogra.persistence.SharedObjectProvider;
import de.grogra.persistence.SharedObjectReference;
import de.grogra.persistence.Transaction;
import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayList;
import de.grogra.ray2.tracing.PixelwiseRenderer;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Type;
import de.grogra.vecmath.Math2;
import de.grogra.xl.util.ObjectList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Random;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public final class RGBAShader
extends Color4f
implements Shader,
Shareable,
Manageable,
IconSource,
Icon {
    private static final int[] EGA;
    public static final RGBAShader BLACK;
    public static final RGBAShader BLUE;
    public static final RGBAShader CYAN;
    public static final RGBAShader DARK_GRAY;
    public static final RGBAShader GRAY;
    public static final RGBAShader GREEN;
    public static final RGBAShader LIGHT_GRAY;
    public static final RGBAShader MAGENTA;
    public static final RGBAShader ORANGE;
    public static final RGBAShader PINK;
    public static final RGBAShader RED;
    public static final RGBAShader YELLOW;
    public static final RGBAShader WHITE;
    public static final RGBAShader EGA_0;
    public static final RGBAShader EGA_1;
    public static final RGBAShader EGA_2;
    public static final RGBAShader EGA_3;
    public static final RGBAShader EGA_4;
    public static final RGBAShader EGA_5;
    public static final RGBAShader EGA_6;
    public static final RGBAShader EGA_7;
    public static final RGBAShader EGA_8;
    public static final RGBAShader EGA_9;
    public static final RGBAShader EGA_10;
    public static final RGBAShader EGA_11;
    public static final RGBAShader EGA_12;
    public static final RGBAShader EGA_13;
    public static final RGBAShader EGA_14;
    public static final RGBAShader EGA_15;
    static final RGBAShader[] STANDARD;
    public static final ManageableType $TYPE;
    SharedObjectProvider sop;
    final int index;
    private transient ObjectList refs = null;
    private transient int stamp = 0;

    public static final int getEGAColorIndex(float f, float f2, float f3) {
        float f4 = Float.MAX_VALUE;
        f *= 255.0f;
        f2 *= 255.0f;
        f3 *= 255.0f;
        int n = -1;
        for (int i = 0; i < 16; ++i) {
            int n2 = EGA[i];
            float f5 = (float)((n2 & 0xFF0000) >> 16) - f;
            float f6 = f5 * f5;
            f5 = (float)((n2 & 0xFF00) >> 8) - f2;
            float f7 = f6 + f5 * f5;
            f5 = (float)(n2 & 0xFF) - f3;
            float f8 = f7 + f5 * f5;
            if (!(f8 < f4)) continue;
            f4 = f8;
            n = i;
        }
        return n;
    }

    public static final int getEGAColorIndex(Color3f color3f) {
        return RGBAShader.getEGAColorIndex(color3f.x, color3f.y, color3f.z);
    }

    public static final int getEGAColorIndex(Color4f color4f) {
        return RGBAShader.getEGAColorIndex(color4f.x, color4f.y, color4f.z);
    }

    static Color4f getColor4f(Shader shader) {
        int n = shader.getAverageColor();
        Color4f color4f = new Color4f((float)(n >> 16 & 0xFF), (float)(n >> 8 & 0xFF), (float)(n & 0xFF), (float)(n >>> 24));
        color4f.scale(0.003921569f);
        return color4f;
    }

    public static final RGBAShader forEGAColor(int n) {
        return STANDARD[n & 0xF];
    }

    public RGBAShader(float f, float f2, float f3, float f4) {
        super(f, f2, f3, f4);
        this.index = -1;
    }

    public RGBAShader(float f, float f2, float f3) {
        this(f, f2, f3, 1.0f);
    }

    public RGBAShader() {
        this(0.5f, 0.5f, 0.5f, 1.0f);
    }

    public RGBAShader(Shader shader) {
        this(RGBAShader.getColor4f(shader));
    }

    public RGBAShader(Color4f color4f) {
        this(color4f.x, color4f.y, color4f.z, color4f.w);
    }

    public RGBAShader(int n) {
        this(n, -1);
    }

    private RGBAShader(int n, int n2) {
        super((float)(n >> 16 & 0xFF), (float)(n >> 8 & 0xFF), (float)(n & 0xFF), (float)(n >> 24 & 0xFF));
        this.scale(0.003921569f);
        this.index = n2;
    }

    public void scale(double d, Tuple3d tuple3d) {
        this.x = (float)(d * tuple3d.x);
        this.y = (float)(d * tuple3d.y);
        this.z = (float)(d * tuple3d.z);
    }

    public Object clone() {
        return this.index >= 0 ? this : new RGBAShader(this);
    }

    public boolean isPredefined() {
        return this.index >= 0;
    }

    private static int f2i(float f) {
        int n = Math.round(f * 255.0f);
        return n < 0 ? 0 : (n > 255 ? 255 : n);
    }

    public int getAverageColor() {
        return (RGBAShader.f2i(this.x) << 16) + (RGBAShader.f2i(this.y) << 8) + RGBAShader.f2i(this.z) + (RGBAShader.f2i(this.w) << 24);
    }

    public int getFlags() {
        return this.w < 1.0f ? 36 : 4;
    }

    public void initProvider(SharedObjectProvider sharedObjectProvider) {
        if (this.index >= 0) {
            return;
        }
        if (this.sop != null) {
            throw new IllegalStateException();
        }
        this.sop = sharedObjectProvider;
    }

    public SharedObjectProvider getProvider() {
        return this.sop;
    }

    public synchronized void addReference(SharedObjectReference sharedObjectReference) {
        if (this.index >= 0) {
            return;
        }
        if (this.refs == null) {
            this.refs = new ObjectList(4, false);
        }
        this.refs.add((Object)sharedObjectReference);
    }

    public synchronized void removeReference(SharedObjectReference sharedObjectReference) {
        if (this.refs != null) {
            this.refs.remove((Object)sharedObjectReference);
        }
    }

    public synchronized void appendReferencesTo(List list) {
        if (this.refs != null) {
            list.addAll(this.refs);
        }
    }

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public void fieldModified(PersistenceField persistenceField, int[] nArray, Transaction transaction) {
        ++this.stamp;
        if (transaction != null && this.sop != null && this.index < 0) {
            transaction.fireSharedObjectModified((Shareable)this);
        }
    }

    public int getStamp() {
        return this.stamp;
    }

    public Manageable manageableReadResolve() {
        return this;
    }

    public Object manageableWriteReplace() {
        return this;
    }

    public Icon getIcon(Dimension dimension, int n) {
        return this;
    }

    public Dimension getPreferredIconSize(boolean bl) {
        return null;
    }

    public void paintIcon(Component component, Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawRect(n, n2, n3 - 1, n4 - 1);
        graphics2D.setColor(new Color(this.getAverageColor()));
        graphics2D.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        graphics2D.setColor(color);
    }

    public IconSource getIconSource() {
        return this;
    }

    public void prepareIcon() {
    }

    public boolean isMutable() {
        return this.index < 0;
    }

    public Image getImage() {
        return null;
    }

    public Image getImage(int n, int n2) {
        return null;
    }

    public URL getImageSource() {
        return null;
    }

    public Rectangle getIconBounds() {
        return null;
    }

    public void shade(Environment environment, RayList rayList, Vector3f vector3f, Spectrum spectrum, Tuple3d tuple3d) {
        Ray[] rayArray = rayList.rays;
        Vector3f vector3f2 = environment.userVector;
        Vector3f vector3f3 = environment.userVector2;
        vector3f3.set(0.0f, 0.0f, 0.0f);
        for (int i = rayList.getSize() - 1; i >= 0; --i) {
            rayArray[i].spectrum.get((Tuple3f)vector3f2);
            float f = rayArray[i].direction.dot(environment.normal);
            if (vector3f.dot(environment.normal) >= 0.0f == f >= 0.0f) {
                f = this.w * Math.abs(f);
                vector3f3.x += vector3f2.x * this.x * f;
                vector3f3.y += vector3f2.y * this.y * f;
                vector3f3.z += vector3f2.z * this.z * f;
                continue;
            }
            f = 1.0f - this.w;
            vector3f3.x += vector3f2.x * f;
            vector3f3.y += vector3f2.y * f;
            vector3f3.z += vector3f2.z * f;
        }
        environment.tmpSpectrum0.set((Tuple3f)vector3f3);
        environment.tmpSpectrum0.dot(spectrum, tuple3d);
    }

    public void computeMaxRays(Environment environment, Vector3f vector3f, Spectrum spectrum, Ray ray, Tuple3f tuple3f, Ray ray2, Tuple3f tuple3f2) {
        float f = Math2.fresnel((Vector3f)environment.normal, (Vector3f)vector3f, (float)environment.iorRatio, (Vector3f)ray.direction, (Vector3f)ray2.direction);
        if (environment.normal.dot(vector3f) < 0.0f) {
            ray.direction.negate((Tuple3f)environment.normal);
        } else {
            ray.direction.set((Tuple3f)environment.normal);
        }
        Vector3f vector3f2 = environment.userVector;
        vector3f2.x = this.w * this.x;
        vector3f2.y = this.w * this.y;
        vector3f2.z = this.w * this.z;
        ray.spectrum.set(spectrum);
        ray.spectrum.mul((Tuple3f)vector3f2);
        tuple3f.x = 0.7337006f;
        tuple3f.y = 0.7337006f;
        tuple3f.z = 0.7337006f;
        vector3f2.y = vector3f2.z = (f = (1.0f - this.w) * (1.0f - f));
        vector3f2.x = vector3f2.z;
        ray2.spectrum.set(spectrum);
        ray2.spectrum.mul((Tuple3f)vector3f2);
        tuple3f2.x = 0.0f;
        tuple3f2.y = 0.0f;
        tuple3f2.z = 0.0f;
    }

    public void generateRandomRays(Environment environment, Vector3f vector3f, Spectrum spectrum, RayList rayList, boolean bl, Random random) {
        boolean bl2;
        Vector3f vector3f2 = environment.userVector;
        Vector3f vector3f3 = environment.userVector2;
        Vector3f vector3f4 = environment.userVector3;
        float f = Math2.fresnel((Vector3f)environment.normal, (Vector3f)vector3f, (float)environment.iorRatio, (Vector3f)vector3f2, (Vector3f)vector3f3);
        float f2 = environment.iorRatio;
        if (environment.normal.dot(vector3f) < 0.0f) {
            vector3f2.negate((Tuple3f)environment.normal);
        } else {
            f2 = 1.0f / f2;
            vector3f2.set((Tuple3f)environment.normal);
        }
        float f3 = (1.0f - this.w) * (1.0f - f);
        if (!bl) {
            f3 *= f2 * f2;
        }
        vector3f4.x = this.x;
        vector3f4.y = this.y;
        vector3f4.z = this.z;
        float f4 = this.x + this.y + this.z;
        float f5 = f3;
        float f6 = f4 + f5;
        boolean bl3 = bl2 = f6 < 1.0E-7f;
        if (!bl2) {
            f6 = 1.0f / f6;
            f5 *= f6;
            vector3f4.scale(1.0f / (f4 *= f6));
        }
        Matrix3f matrix3f = null;
        for (int i = rayList.getSize() - 1; i >= 0; --i) {
            Vector3f vector3f5 = rayList.rays[i].direction;
            rayList.rays[i].valid = true;
            float f7 = (float)(2 * (random.nextInt() >>> 8) + 1) * 2.9802322E-8f;
            if (bl2) {
                rayList.rays[i].spectrum.setZero();
                rayList.rays[i].direction.set(1.0f, 0.0f, 0.0f);
                rayList.rays[i].directionDensity = 1.0E10f;
                rayList.rays[i].valid = false;
                continue;
            }
            if (f7 <= f5) {
                vector3f5.set((Tuple3f)vector3f3);
                float f8 = f3 / f5;
                rayList.rays[i].spectrum.set(spectrum);
                rayList.rays[i].spectrum.scale((double)f8);
                rayList.rays[i].directionDensity = 1.0E10f;
                rayList.rays[i].reflected = false;
                continue;
            }
            Matrix3f matrix3f2 = matrix3f;
            if (matrix3f2 == null) {
                matrix3f2 = matrix3f = environment.userMatrix;
                Math2.getOrthogonalBasis((Tuple3f)vector3f2, (Matrix3f)matrix3f, (boolean)true);
            }
            int n = random.nextInt();
            f7 = (float)(2 * (n >>> 16) + 1) * 7.6293945E-6f;
            float f9 = (float)Math.sqrt(f7);
            float f10 = (float)Math.sqrt(1.0f - f7);
            char c = (char)n;
            vector3f5.set(Math2.ccos((char)c) * f10, Math2.csin((char)c) * f10, f9);
            matrix3f2.transform((Tuple3f)vector3f5);
            rayList.rays[i].directionDensity = f4 * f9 * Math2.M_1_PI;
            rayList.rays[i].spectrum.set(spectrum);
            rayList.rays[i].spectrum.mul((Tuple3f)vector3f4);
            rayList.rays[i].reflected = true;
        }
    }

    public float computeBSDF(Environment environment, Vector3f vector3f, Spectrum spectrum, Vector3f vector3f2, boolean bl, Spectrum spectrum2) {
        float f;
        float f2;
        float f3 = vector3f2.dot(environment.normal);
        if (vector3f.dot(environment.normal) > 0.0f != f3 > 0.0f) {
            if (PixelwiseRenderer.DEBUG_SUBPIXEL) {
                System.err.println("RGBA is ZEro!!!");
            }
            spectrum2.setZero();
            return 0.0f;
        }
        float f4 = Math2.fresnel((Vector3f)environment.normal, (Vector3f)vector3f2, (float)environment.iorRatio, (Vector3f)environment.userVector, (Vector3f)environment.userVector2);
        float f5 = environment.iorRatio;
        if (f3 < 0.0f) {
            f3 = -f3;
        } else {
            f5 = 1.0f / f5;
        }
        float f6 = (1.0f - this.w) * (1.0f - f4);
        if (!bl) {
            f6 *= f5 * f5;
        }
        f = (f2 = (f = this.x + this.y + this.z) + f6) < 1.0E-7f ? 1.0f : (f /= f2);
        float f7 = Math2.M_1_PI * f3;
        Vector3f vector3f3 = environment.userVector;
        vector3f3.x = f7 * this.x;
        vector3f3.y = f7 * this.y;
        vector3f3.z = f7 * this.z;
        spectrum2.set(spectrum);
        spectrum2.mul((Tuple3f)vector3f3);
        return f * f7;
    }

    public boolean isTransparent() {
        return false;
    }

    public void accept(ShaderVisitor shaderVisitor) {
        shaderVisitor.visit(this);
    }

    static {
        int n;
        EGA = new int[]{-16777216, -16777046, -16733696, -16733526, -5636096, -5635926, -5614336, -5592406, -11184811, -11184641, -11141291, -11141121, -43691, -43521, -171, -1};
        $TYPE = new ManageableType((Type)ClassAdapter.wrap(RGBAShader.class), (ManageableType)Tuple4fType.$TYPE, true){

            protected Object readObject(PersistenceInput persistenceInput, Object object, boolean bl) throws IOException {
                return persistenceInput.readBoolean() ? STANDARD[persistenceInput.readByte() % STANDARD.length] : super.readObject(persistenceInput, !(object instanceof RGBAShader) || ((RGBAShader)object).index >= 0 ? new RGBAShader() : object, bl);
            }

            protected void write(Object object, PersistenceOutput persistenceOutput, boolean bl) throws IOException {
                RGBAShader rGBAShader = (RGBAShader)object;
                if (rGBAShader.index >= 0) {
                    persistenceOutput.writeBoolean(true);
                    persistenceOutput.writeByte(rGBAShader.index);
                } else {
                    persistenceOutput.writeBoolean(false);
                    super.write(object, persistenceOutput, bl);
                }
            }

            public Object getRepresentative() {
                return null;
            }

            public Object newInstance() {
                return new RGBAShader();
            }
        }.validate();
        Color[] colorArray = new Color[]{Color.BLACK, Color.BLUE, Color.CYAN, Color.DARK_GRAY, Color.GRAY, Color.GREEN, Color.LIGHT_GRAY, Color.MAGENTA, Color.ORANGE, Color.PINK, Color.RED, Color.YELLOW, Color.WHITE};
        STANDARD = new RGBAShader[EGA.length + colorArray.length];
        int n2 = 0;
        for (n = 0; n < EGA.length; ++n) {
            RGBAShader.STANDARD[n2] = new RGBAShader(EGA[n], n2++);
        }
        for (n = 0; n < colorArray.length; ++n) {
            RGBAShader.STANDARD[n2] = new RGBAShader(colorArray[n].getRGB(), n2++);
        }
        n2 = -1;
        EGA_0 = STANDARD[++n2];
        EGA_1 = STANDARD[++n2];
        EGA_2 = STANDARD[++n2];
        EGA_3 = STANDARD[++n2];
        EGA_4 = STANDARD[++n2];
        EGA_5 = STANDARD[++n2];
        EGA_6 = STANDARD[++n2];
        EGA_7 = STANDARD[++n2];
        EGA_8 = STANDARD[++n2];
        EGA_9 = STANDARD[++n2];
        EGA_10 = STANDARD[++n2];
        EGA_11 = STANDARD[++n2];
        EGA_12 = STANDARD[++n2];
        EGA_13 = STANDARD[++n2];
        EGA_14 = STANDARD[++n2];
        EGA_15 = STANDARD[++n2];
        BLACK = STANDARD[++n2];
        BLUE = STANDARD[++n2];
        CYAN = STANDARD[++n2];
        DARK_GRAY = STANDARD[++n2];
        GRAY = STANDARD[++n2];
        GREEN = STANDARD[++n2];
        LIGHT_GRAY = STANDARD[++n2];
        MAGENTA = STANDARD[++n2];
        ORANGE = STANDARD[++n2];
        PINK = STANDARD[++n2];
        RED = STANDARD[++n2];
        YELLOW = STANDARD[++n2];
        WHITE = STANDARD[++n2];
    }
}

