/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.exchangegraph;

import de.grogra.ext.exchangegraph.IOContext;
import de.grogra.ext.exchangegraph.nodes.XEGUnknown;
import de.grogra.ext.exchangegraph.xmlbeans.Edge;
import de.grogra.ext.exchangegraph.xmlbeans.Graph;
import de.grogra.ext.exchangegraph.xmlbeans.GraphDocument;
import de.grogra.ext.exchangegraph.xmlbeans.Node;
import de.grogra.ext.exchangegraph.xmlbeans.Property;
import de.grogra.grammar.RecognitionException;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.ReaderSource;
import de.grogra.pf.io.ReaderSourceImpl;
import de.grogra.pf.registry.Registry;
import de.grogra.reflect.Type;
import de.grogra.rgg.model.CompilationFilter;
import de.grogra.rgg.model.RGGFilter;
import de.grogra.rgg.model.XLFilter;
import de.grogra.util.MimeType;
import de.grogra.xl.util.BidirectionalHashMap;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XEGImport {
    private de.grogra.graph.impl.Node rootNode;
    private Reader graphReader;
    private IOContext ctx;
    private String xlCode;
    private String modelName;
    private Type<?>[] compiledTypes;

    public XEGImport(Reader reader, de.grogra.graph.impl.Node node, IOContext iOContext, String string, String string2) {
        this.rootNode = node;
        this.graphReader = reader;
        this.ctx = iOContext;
        this.xlCode = string;
        this.modelName = string2;
    }

    public void doImport() throws IOException {
        Object object;
        this.rootNode.setName("XEGRoot");
        GraphDocument graphDocument = null;
        try {
            object = new XmlOptions();
            object.setLoadLineNumbers();
            graphDocument = GraphDocument.Factory.parse((Reader)this.graphReader, (XmlOptions)object);
        }
        catch (XmlException xmlException) {
            throw new IOException("XEG parsing error: " + xmlException.getCause().getMessage());
        }
        object = new ArrayList();
        XmlOptions xmlOptions = new XmlOptions();
        xmlOptions.setErrorListener((Collection)object);
        boolean bl = graphDocument.validate(xmlOptions);
        if (!bl) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("XEG document not valid!");
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                XmlError xmlError = (XmlError)((ArrayList)object).get(i);
                stringBuffer.append("\n");
                stringBuffer.append("Message: " + xmlError.getMessage());
                stringBuffer.append("Location: line " + xmlError.getLine() + "; " + xmlError.getCursorLocation().xmlText() + "\n");
            }
            throw new IOException(stringBuffer.toString());
        }
        this.copyGraph(graphDocument);
    }

    private void copyGraph(GraphDocument graphDocument) throws IOException {
        Graph graph = graphDocument.getGraph();
        HashMap<String, Type> hashMap = this.createGroimpNodeTypes(graph);
        BidirectionalHashMap<Long, de.grogra.graph.impl.Node> bidirectionalHashMap = this.ctx.getNodeMap();
        BidirectionalHashMap<Long, de.grogra.graph.impl.Edge> bidirectionalHashMap2 = this.ctx.getEdgeMap();
        for (Node node : graph.getNodeList()) {
            long l = node.getId();
            String string = node.isSetType() ? node.getType() : "node";
            de.grogra.graph.impl.Node node2 = this.createGroimpNode(string, node, hashMap);
            bidirectionalHashMap.put((Object)l, (Object)node2);
        }
        long l = graph.getRootArray(0).getRootId();
        bidirectionalHashMap.put((Object)l, (Object)this.rootNode);
        for (Edge edge : graph.getEdgeList()) {
            long l2 = edge.getSrcId();
            long l3 = edge.getDestId();
            de.grogra.graph.impl.Node node = (de.grogra.graph.impl.Node)bidirectionalHashMap.get((Object)l2);
            de.grogra.graph.impl.Node node3 = (de.grogra.graph.impl.Node)bidirectionalHashMap.get((Object)l3);
            int n = this.getEdgeBit(edge.getType().toLowerCase());
            de.grogra.graph.impl.Edge edge2 = node.getOrCreateEdgeTo(node3);
            edge2.addEdgeBits(n, null);
            bidirectionalHashMap2.put((Object)edge.getId(), (Object)edge2);
        }
    }

    private HashMap<String, Type> createGroimpNodeTypes(Graph graph) {
        Object object;
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("import de.grogra.imp3d.objects.*;");
        for (CompilationFilter compilationFilter : graph.getTypeList()) {
            if (IOContext.importNodeTypes.containsKey(compilationFilter.getName())) continue;
            stringBuffer.append("public class ");
            stringBuffer.append(compilationFilter.getName());
            stringBuffer.append(" extends ");
            string = compilationFilter.getExtends().getName();
            stringBuffer.append(IOContext.importNodeTypes.containsKey(string) ? IOContext.importNodeTypes.get(string) : string);
            stringBuffer.append("{");
            for (CompilationFilter compilationFilter2 : compilationFilter.getPropertyList()) {
                stringBuffer.append(compilationFilter2.getType() + " " + compilationFilter2.getName() + ";");
            }
            stringBuffer.append("};");
        }
        try {
            CompilationFilter compilationFilter;
            object = new XLFilter(null, (ReaderSource)new ReaderSourceImpl((Reader)new StringReader(stringBuffer.toString()), "XEGNodeTypes", MimeType.TEXT_PLAIN, Registry.current(), null));
            compilationFilter = new CompilationFilter(null, (FilterSource)object);
            if (this.xlCode != null) {
                string = new RGGFilter(null, (ReaderSource)new ReaderSourceImpl((Reader)new StringReader(this.xlCode), this.modelName, MimeType.TEXT_PLAIN, Registry.current(), null));
                compilationFilter.addResource((FilterSource)string);
            }
            this.compiledTypes = compilationFilter.compile(null, null);
        }
        catch (IOException iOException) {
            if (iOException.getCause() instanceof RecognitionException) {
                System.err.println(((RecognitionException)iOException.getCause()).getDetailedMessage(false));
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getCause());
        }
        object = new HashMap();
        for (CompilationFilter compilationFilter2 : this.compiledTypes) {
            String string2 = compilationFilter2.getName();
            if (this.modelName != null && string2.startsWith(this.modelName) && string2.length() > this.modelName.length()) {
                string2 = string2.substring(this.modelName.length() + 1, string2.length());
            }
            ((HashMap)object).put(string2, compilationFilter2);
        }
        return object;
    }

    private de.grogra.graph.impl.Node createGroimpNode(String string, Node node, HashMap<String, Type> hashMap) throws IOException {
        de.grogra.graph.impl.Node node2 = null;
        try {
            node2 = IOContext.importNodeTypes.containsKey(string) ? (de.grogra.graph.impl.Node)Class.forName(IOContext.importNodeTypes.get(string)).newInstance() : (de.grogra.graph.impl.Node)hashMap.get(string).newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        List list = node.getPropertyList();
        ArrayList arrayList = new ArrayList(list.size());
        Class<?> clazz = node2.getClass();
        try {
            do {
                if (!IOContext.xegNodeTypes.containsKey(clazz)) continue;
                Class clazz2 = IOContext.xegNodeTypes.get(clazz);
                Method method = clazz2.getMethod("handleImportProperties", de.grogra.graph.impl.Node.class, List.class, List.class);
                method.invoke(null, node2, list, arrayList);
                for (Property property : arrayList) {
                    list.remove(property);
                }
                arrayList.clear();
            } while ((clazz = clazz.getSuperclass()) != Object.class);
            XEGUnknown.handleImportProperties(node2, list);
        }
        catch (Exception exception) {
            throw new IOException("Couldn't create GroIMP node: " + exception.getMessage());
        }
        if (node.isSetName() && !node.getName().trim().equals("")) {
            node2.setName(node.getName());
        }
        return node2;
    }

    private int getEdgeBit(String string) {
        BidirectionalHashMap<Integer, String> bidirectionalHashMap = this.ctx.getEdgeTypes();
        if ("successor".equals(string)) {
            return 256;
        }
        if ("branch".equals(string)) {
            return 512;
        }
        if (bidirectionalHashMap.containsValue((Object)string)) {
            return (Integer)bidirectionalHashMap.getKey((Object)string);
        }
        int n = bidirectionalHashMap.size();
        bidirectionalHashMap.put((Object)n, (Object)string);
        return 131072 << n;
    }

    public de.grogra.graph.impl.Node getRootNode() {
        return this.rootNode;
    }

    public Type<?>[] getCompiledTypes() {
        return this.compiledTypes;
    }
}

