/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.vecmath;

import de.grogra.vecmath.geom.Volume;
import javax.vecmath.Point2d;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Point4d;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4d;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4d;
import javax.vecmath.Vector4f;

public final class VecmathOperators {
    private VecmathOperators() {
    }

    public static boolean operator$in(Tuple3d tuple3d, Volume volume) {
        return volume != null && volume.contains(tuple3d, false);
    }

    public static Vector2f operator$mul(Tuple2f tuple2f, float f) {
        Vector2f vector2f = new Vector2f();
        vector2f.scale(f, tuple2f);
        return vector2f;
    }

    public static Point2f operator$mul(Point2f point2f, float f) {
        Point2f point2f2 = new Point2f();
        point2f2.scale(f, point2f);
        return point2f2;
    }

    public static Vector2f operator$div(Tuple2f tuple2f, float f) {
        Vector2f vector2f = new Vector2f();
        vector2f.scale(1.0f / f, tuple2f);
        return vector2f;
    }

    public static Point2f operator$div(Point2f point2f, float f) {
        Point2f point2f2 = new Point2f();
        point2f2.scale(1.0f / f, point2f);
        return point2f2;
    }

    public static Vector2f operator$mul(float f, Tuple2f tuple2f) {
        Vector2f vector2f = new Vector2f();
        vector2f.scale(f, tuple2f);
        return vector2f;
    }

    public static Point2f operator$mul(float f, Point2f point2f) {
        Point2f point2f2 = new Point2f();
        point2f2.scale(f, point2f);
        return point2f2;
    }

    public static Vector2f operator$neg(Tuple2f tuple2f) {
        Vector2f vector2f = new Vector2f();
        vector2f.negate(tuple2f);
        return vector2f;
    }

    public static Point2f operator$neg(Point2f point2f) {
        Point2f point2f2 = new Point2f();
        point2f2.negate(point2f);
        return point2f2;
    }

    public static Vector2f operator$mulAssign(Vector2f vector2f, float f) {
        vector2f.scale(f);
        return vector2f;
    }

    public static Point2f operator$mulAssign(Point2f point2f, float f) {
        point2f.scale(f);
        return point2f;
    }

    public static Vector2d operator$mul(Tuple2d tuple2d, double d) {
        Vector2d vector2d = new Vector2d();
        vector2d.scale(d, tuple2d);
        return vector2d;
    }

    public static Point2d operator$mul(Point2d point2d, double d) {
        Point2d point2d2 = new Point2d();
        point2d2.scale(d, point2d);
        return point2d2;
    }

    public static Vector2d operator$div(Tuple2d tuple2d, double d) {
        Vector2d vector2d = new Vector2d();
        vector2d.scale(1.0 / d, tuple2d);
        return vector2d;
    }

    public static Point2d operator$div(Point2d point2d, double d) {
        Point2d point2d2 = new Point2d();
        point2d2.scale(1.0 / d, point2d);
        return point2d2;
    }

    public static Vector2d operator$mul(double d, Tuple2d tuple2d) {
        Vector2d vector2d = new Vector2d();
        vector2d.scale(d, tuple2d);
        return vector2d;
    }

    public static Point2d operator$mul(double d, Point2d point2d) {
        Point2d point2d2 = new Point2d();
        point2d2.scale(d, point2d);
        return point2d2;
    }

    public static Vector2d operator$neg(Tuple2d tuple2d) {
        Vector2d vector2d = new Vector2d();
        vector2d.negate(tuple2d);
        return vector2d;
    }

    public static Point2d operator$neg(Point2d point2d) {
        Point2d point2d2 = new Point2d();
        point2d2.negate(point2d);
        return point2d2;
    }

    public static Vector2d operator$mulAssign(Vector2d vector2d, double d) {
        vector2d.scale(d);
        return vector2d;
    }

    public static Point2d operator$mulAssign(Point2d point2d, double d) {
        point2d.scale(d);
        return point2d;
    }

    public static Point2f operator$add(Point2f point2f, Tuple2f tuple2f) {
        return new Point2f(point2f.x + tuple2f.x, point2f.y + tuple2f.y);
    }

    public static Point2f operator$add(Tuple2f tuple2f, Point2f point2f) {
        return new Point2f(tuple2f.x + point2f.x, tuple2f.y + point2f.y);
    }

    public static Point2f operator$add(Point2f point2f, Point2f point2f2) {
        return new Point2f(point2f.x + point2f2.x, point2f.y + point2f2.y);
    }

    public static Vector2f operator$add(Vector2f vector2f, Vector2f vector2f2) {
        return new Vector2f(vector2f.x + vector2f2.x, vector2f.y + vector2f2.y);
    }

    public static Point2f operator$addAssign(Point2f point2f, Tuple2f tuple2f) {
        point2f.set(point2f.x + tuple2f.x, point2f.y + tuple2f.y);
        return point2f;
    }

    public static Vector2f operator$addAssign(Vector2f vector2f, Vector2f vector2f2) {
        vector2f.set(vector2f.x + vector2f2.x, vector2f.y + vector2f2.y);
        return vector2f;
    }

    public static Point2d operator$add(Point2f point2f, Tuple2d tuple2d) {
        return new Point2d((double)point2f.x + tuple2d.x, (double)point2f.y + tuple2d.y);
    }

    public static Point2d operator$add(Tuple2f tuple2f, Point2d point2d) {
        return new Point2d((double)tuple2f.x + point2d.x, (double)tuple2f.y + point2d.y);
    }

    public static Point2d operator$add(Point2f point2f, Point2d point2d) {
        return new Point2d((double)point2f.x + point2d.x, (double)point2f.y + point2d.y);
    }

    public static Vector2d operator$add(Vector2f vector2f, Vector2d vector2d) {
        return new Vector2d((double)vector2f.x + vector2d.x, (double)vector2f.y + vector2d.y);
    }

    public static Point2d operator$add(Point2d point2d, Tuple2f tuple2f) {
        return new Point2d(point2d.x + (double)tuple2f.x, point2d.y + (double)tuple2f.y);
    }

    public static Point2d operator$add(Tuple2d tuple2d, Point2f point2f) {
        return new Point2d(tuple2d.x + (double)point2f.x, tuple2d.y + (double)point2f.y);
    }

    public static Point2d operator$add(Point2d point2d, Point2f point2f) {
        return new Point2d(point2d.x + (double)point2f.x, point2d.y + (double)point2f.y);
    }

    public static Vector2d operator$add(Vector2d vector2d, Vector2f vector2f) {
        return new Vector2d(vector2d.x + (double)vector2f.x, vector2d.y + (double)vector2f.y);
    }

    public static Point2d operator$addAssign(Point2d point2d, Tuple2f tuple2f) {
        point2d.set(point2d.x + (double)tuple2f.x, point2d.y + (double)tuple2f.y);
        return point2d;
    }

    public static Vector2d operator$addAssign(Vector2d vector2d, Vector2f vector2f) {
        vector2d.set(vector2d.x + (double)vector2f.x, vector2d.y + (double)vector2f.y);
        return vector2d;
    }

    public static Point2d operator$add(Point2d point2d, Tuple2d tuple2d) {
        return new Point2d(point2d.x + tuple2d.x, point2d.y + tuple2d.y);
    }

    public static Point2d operator$add(Tuple2d tuple2d, Point2d point2d) {
        return new Point2d(tuple2d.x + point2d.x, tuple2d.y + point2d.y);
    }

    public static Point2d operator$add(Point2d point2d, Point2d point2d2) {
        return new Point2d(point2d.x + point2d2.x, point2d.y + point2d2.y);
    }

    public static Vector2d operator$add(Vector2d vector2d, Vector2d vector2d2) {
        return new Vector2d(vector2d.x + vector2d2.x, vector2d.y + vector2d2.y);
    }

    public static Point2d operator$addAssign(Point2d point2d, Tuple2d tuple2d) {
        point2d.set(point2d.x + tuple2d.x, point2d.y + tuple2d.y);
        return point2d;
    }

    public static Vector2d operator$addAssign(Vector2d vector2d, Vector2d vector2d2) {
        vector2d.set(vector2d.x + vector2d2.x, vector2d.y + vector2d2.y);
        return vector2d;
    }

    public static Point2f operator$sub(Point2f point2f, Tuple2f tuple2f) {
        return new Point2f(point2f.x - tuple2f.x, point2f.y - tuple2f.y);
    }

    public static Point2f operator$sub(Tuple2f tuple2f, Point2f point2f) {
        return new Point2f(tuple2f.x - point2f.x, tuple2f.y - point2f.y);
    }

    public static Vector2f operator$sub(Point2f point2f, Point2f point2f2) {
        return new Vector2f(point2f.x - point2f2.x, point2f.y - point2f2.y);
    }

    public static Vector2f operator$sub(Vector2f vector2f, Vector2f vector2f2) {
        return new Vector2f(vector2f.x - vector2f2.x, vector2f.y - vector2f2.y);
    }

    public static Point2f operator$subAssign(Point2f point2f, Tuple2f tuple2f) {
        point2f.set(point2f.x - tuple2f.x, point2f.y - tuple2f.y);
        return point2f;
    }

    public static Vector2f operator$subAssign(Vector2f vector2f, Vector2f vector2f2) {
        vector2f.set(vector2f.x - vector2f2.x, vector2f.y - vector2f2.y);
        return vector2f;
    }

    public static Point2d operator$sub(Point2f point2f, Tuple2d tuple2d) {
        return new Point2d((double)point2f.x - tuple2d.x, (double)point2f.y - tuple2d.y);
    }

    public static Point2d operator$sub(Tuple2f tuple2f, Point2d point2d) {
        return new Point2d((double)tuple2f.x - point2d.x, (double)tuple2f.y - point2d.y);
    }

    public static Vector2d operator$sub(Point2f point2f, Point2d point2d) {
        return new Vector2d((double)point2f.x - point2d.x, (double)point2f.y - point2d.y);
    }

    public static Vector2d operator$sub(Vector2f vector2f, Vector2d vector2d) {
        return new Vector2d((double)vector2f.x - vector2d.x, (double)vector2f.y - vector2d.y);
    }

    public static Point2d operator$sub(Point2d point2d, Tuple2f tuple2f) {
        return new Point2d(point2d.x - (double)tuple2f.x, point2d.y - (double)tuple2f.y);
    }

    public static Point2d operator$sub(Tuple2d tuple2d, Point2f point2f) {
        return new Point2d(tuple2d.x - (double)point2f.x, tuple2d.y - (double)point2f.y);
    }

    public static Vector2d operator$sub(Point2d point2d, Point2f point2f) {
        return new Vector2d(point2d.x - (double)point2f.x, point2d.y - (double)point2f.y);
    }

    public static Vector2d operator$sub(Vector2d vector2d, Vector2f vector2f) {
        return new Vector2d(vector2d.x - (double)vector2f.x, vector2d.y - (double)vector2f.y);
    }

    public static Point2d operator$subAssign(Point2d point2d, Tuple2f tuple2f) {
        point2d.set(point2d.x - (double)tuple2f.x, point2d.y - (double)tuple2f.y);
        return point2d;
    }

    public static Vector2d operator$subAssign(Vector2d vector2d, Vector2f vector2f) {
        vector2d.set(vector2d.x - (double)vector2f.x, vector2d.y - (double)vector2f.y);
        return vector2d;
    }

    public static Point2d operator$sub(Point2d point2d, Tuple2d tuple2d) {
        return new Point2d(point2d.x - tuple2d.x, point2d.y - tuple2d.y);
    }

    public static Point2d operator$sub(Tuple2d tuple2d, Point2d point2d) {
        return new Point2d(tuple2d.x - point2d.x, tuple2d.y - point2d.y);
    }

    public static Vector2d operator$sub(Point2d point2d, Point2d point2d2) {
        return new Vector2d(point2d.x - point2d2.x, point2d.y - point2d2.y);
    }

    public static Vector2d operator$sub(Vector2d vector2d, Vector2d vector2d2) {
        return new Vector2d(vector2d.x - vector2d2.x, vector2d.y - vector2d2.y);
    }

    public static Point2d operator$subAssign(Point2d point2d, Tuple2d tuple2d) {
        point2d.set(point2d.x - tuple2d.x, point2d.y - tuple2d.y);
        return point2d;
    }

    public static Vector2d operator$subAssign(Vector2d vector2d, Vector2d vector2d2) {
        vector2d.set(vector2d.x - vector2d2.x, vector2d.y - vector2d2.y);
        return vector2d;
    }

    public static Vector3f operator$mul(Tuple3f tuple3f, float f) {
        Vector3f vector3f = new Vector3f();
        vector3f.scale(f, tuple3f);
        return vector3f;
    }

    public static Point3f operator$mul(Point3f point3f, float f) {
        Point3f point3f2 = new Point3f();
        point3f2.scale(f, point3f);
        return point3f2;
    }

    public static Vector3f operator$div(Tuple3f tuple3f, float f) {
        Vector3f vector3f = new Vector3f();
        vector3f.scale(1.0f / f, tuple3f);
        return vector3f;
    }

    public static Point3f operator$div(Point3f point3f, float f) {
        Point3f point3f2 = new Point3f();
        point3f2.scale(1.0f / f, point3f);
        return point3f2;
    }

    public static Vector3f operator$mul(float f, Tuple3f tuple3f) {
        Vector3f vector3f = new Vector3f();
        vector3f.scale(f, tuple3f);
        return vector3f;
    }

    public static Point3f operator$mul(float f, Point3f point3f) {
        Point3f point3f2 = new Point3f();
        point3f2.scale(f, point3f);
        return point3f2;
    }

    public static Vector3f operator$neg(Tuple3f tuple3f) {
        Vector3f vector3f = new Vector3f();
        vector3f.negate(tuple3f);
        return vector3f;
    }

    public static Point3f operator$neg(Point3f point3f) {
        Point3f point3f2 = new Point3f();
        point3f2.negate(point3f);
        return point3f2;
    }

    public static Vector3f operator$mulAssign(Vector3f vector3f, float f) {
        vector3f.scale(f);
        return vector3f;
    }

    public static Point3f operator$mulAssign(Point3f point3f, float f) {
        point3f.scale(f);
        return point3f;
    }

    public static Vector3d operator$mul(Tuple3d tuple3d, double d) {
        Vector3d vector3d = new Vector3d();
        vector3d.scale(d, tuple3d);
        return vector3d;
    }

    public static Point3d operator$mul(Point3d point3d, double d) {
        Point3d point3d2 = new Point3d();
        point3d2.scale(d, point3d);
        return point3d2;
    }

    public static Vector3d operator$div(Tuple3d tuple3d, double d) {
        Vector3d vector3d = new Vector3d();
        vector3d.scale(1.0 / d, tuple3d);
        return vector3d;
    }

    public static Point3d operator$div(Point3d point3d, double d) {
        Point3d point3d2 = new Point3d();
        point3d2.scale(1.0 / d, point3d);
        return point3d2;
    }

    public static Vector3d operator$mul(double d, Tuple3d tuple3d) {
        Vector3d vector3d = new Vector3d();
        vector3d.scale(d, tuple3d);
        return vector3d;
    }

    public static Point3d operator$mul(double d, Point3d point3d) {
        Point3d point3d2 = new Point3d();
        point3d2.scale(d, point3d);
        return point3d2;
    }

    public static Vector3d operator$neg(Tuple3d tuple3d) {
        Vector3d vector3d = new Vector3d();
        vector3d.negate(tuple3d);
        return vector3d;
    }

    public static Point3d operator$neg(Point3d point3d) {
        Point3d point3d2 = new Point3d();
        point3d2.negate(point3d);
        return point3d2;
    }

    public static Vector3d operator$mulAssign(Vector3d vector3d, double d) {
        vector3d.scale(d);
        return vector3d;
    }

    public static Point3d operator$mulAssign(Point3d point3d, double d) {
        point3d.scale(d);
        return point3d;
    }

    public static Point3f operator$add(Point3f point3f, Tuple3f tuple3f) {
        return new Point3f(point3f.x + tuple3f.x, point3f.y + tuple3f.y, point3f.z + tuple3f.z);
    }

    public static Point3f operator$add(Tuple3f tuple3f, Point3f point3f) {
        return new Point3f(tuple3f.x + point3f.x, tuple3f.y + point3f.y, tuple3f.z + point3f.z);
    }

    public static Point3f operator$add(Point3f point3f, Point3f point3f2) {
        return new Point3f(point3f.x + point3f2.x, point3f.y + point3f2.y, point3f.z + point3f2.z);
    }

    public static Vector3f operator$add(Vector3f vector3f, Vector3f vector3f2) {
        return new Vector3f(vector3f.x + vector3f2.x, vector3f.y + vector3f2.y, vector3f.z + vector3f2.z);
    }

    public static Point3f operator$addAssign(Point3f point3f, Tuple3f tuple3f) {
        point3f.set(point3f.x + tuple3f.x, point3f.y + tuple3f.y, point3f.z + tuple3f.z);
        return point3f;
    }

    public static Vector3f operator$addAssign(Vector3f vector3f, Vector3f vector3f2) {
        vector3f.set(vector3f.x + vector3f2.x, vector3f.y + vector3f2.y, vector3f.z + vector3f2.z);
        return vector3f;
    }

    public static Point3d operator$add(Point3f point3f, Tuple3d tuple3d) {
        return new Point3d((double)point3f.x + tuple3d.x, (double)point3f.y + tuple3d.y, (double)point3f.z + tuple3d.z);
    }

    public static Point3d operator$add(Tuple3f tuple3f, Point3d point3d) {
        return new Point3d((double)tuple3f.x + point3d.x, (double)tuple3f.y + point3d.y, (double)tuple3f.z + point3d.z);
    }

    public static Point3d operator$add(Point3f point3f, Point3d point3d) {
        return new Point3d((double)point3f.x + point3d.x, (double)point3f.y + point3d.y, (double)point3f.z + point3d.z);
    }

    public static Vector3d operator$add(Vector3f vector3f, Vector3d vector3d) {
        return new Vector3d((double)vector3f.x + vector3d.x, (double)vector3f.y + vector3d.y, (double)vector3f.z + vector3d.z);
    }

    public static Point3d operator$add(Point3d point3d, Tuple3f tuple3f) {
        return new Point3d(point3d.x + (double)tuple3f.x, point3d.y + (double)tuple3f.y, point3d.z + (double)tuple3f.z);
    }

    public static Point3d operator$add(Tuple3d tuple3d, Point3f point3f) {
        return new Point3d(tuple3d.x + (double)point3f.x, tuple3d.y + (double)point3f.y, tuple3d.z + (double)point3f.z);
    }

    public static Point3d operator$add(Point3d point3d, Point3f point3f) {
        return new Point3d(point3d.x + (double)point3f.x, point3d.y + (double)point3f.y, point3d.z + (double)point3f.z);
    }

    public static Vector3d operator$add(Vector3d vector3d, Vector3f vector3f) {
        return new Vector3d(vector3d.x + (double)vector3f.x, vector3d.y + (double)vector3f.y, vector3d.z + (double)vector3f.z);
    }

    public static Point3d operator$addAssign(Point3d point3d, Tuple3f tuple3f) {
        point3d.set(point3d.x + (double)tuple3f.x, point3d.y + (double)tuple3f.y, point3d.z + (double)tuple3f.z);
        return point3d;
    }

    public static Vector3d operator$addAssign(Vector3d vector3d, Vector3f vector3f) {
        vector3d.set(vector3d.x + (double)vector3f.x, vector3d.y + (double)vector3f.y, vector3d.z + (double)vector3f.z);
        return vector3d;
    }

    public static Point3d operator$add(Point3d point3d, Tuple3d tuple3d) {
        return new Point3d(point3d.x + tuple3d.x, point3d.y + tuple3d.y, point3d.z + tuple3d.z);
    }

    public static Point3d operator$add(Tuple3d tuple3d, Point3d point3d) {
        return new Point3d(tuple3d.x + point3d.x, tuple3d.y + point3d.y, tuple3d.z + point3d.z);
    }

    public static Point3d operator$add(Point3d point3d, Point3d point3d2) {
        return new Point3d(point3d.x + point3d2.x, point3d.y + point3d2.y, point3d.z + point3d2.z);
    }

    public static Vector3d operator$add(Vector3d vector3d, Vector3d vector3d2) {
        return new Vector3d(vector3d.x + vector3d2.x, vector3d.y + vector3d2.y, vector3d.z + vector3d2.z);
    }

    public static Point3d operator$addAssign(Point3d point3d, Tuple3d tuple3d) {
        point3d.set(point3d.x + tuple3d.x, point3d.y + tuple3d.y, point3d.z + tuple3d.z);
        return point3d;
    }

    public static Vector3d operator$addAssign(Vector3d vector3d, Vector3d vector3d2) {
        vector3d.set(vector3d.x + vector3d2.x, vector3d.y + vector3d2.y, vector3d.z + vector3d2.z);
        return vector3d;
    }

    public static Point3f operator$sub(Point3f point3f, Tuple3f tuple3f) {
        return new Point3f(point3f.x - tuple3f.x, point3f.y - tuple3f.y, point3f.z - tuple3f.z);
    }

    public static Point3f operator$sub(Tuple3f tuple3f, Point3f point3f) {
        return new Point3f(tuple3f.x - point3f.x, tuple3f.y - point3f.y, tuple3f.z - point3f.z);
    }

    public static Vector3f operator$sub(Point3f point3f, Point3f point3f2) {
        return new Vector3f(point3f.x - point3f2.x, point3f.y - point3f2.y, point3f.z - point3f2.z);
    }

    public static Vector3f operator$sub(Vector3f vector3f, Vector3f vector3f2) {
        return new Vector3f(vector3f.x - vector3f2.x, vector3f.y - vector3f2.y, vector3f.z - vector3f2.z);
    }

    public static Point3f operator$subAssign(Point3f point3f, Tuple3f tuple3f) {
        point3f.set(point3f.x - tuple3f.x, point3f.y - tuple3f.y, point3f.z - tuple3f.z);
        return point3f;
    }

    public static Vector3f operator$subAssign(Vector3f vector3f, Vector3f vector3f2) {
        vector3f.set(vector3f.x - vector3f2.x, vector3f.y - vector3f2.y, vector3f.z - vector3f2.z);
        return vector3f;
    }

    public static Point3d operator$sub(Point3f point3f, Tuple3d tuple3d) {
        return new Point3d((double)point3f.x - tuple3d.x, (double)point3f.y - tuple3d.y, (double)point3f.z - tuple3d.z);
    }

    public static Point3d operator$sub(Tuple3f tuple3f, Point3d point3d) {
        return new Point3d((double)tuple3f.x - point3d.x, (double)tuple3f.y - point3d.y, (double)tuple3f.z - point3d.z);
    }

    public static Vector3d operator$sub(Point3f point3f, Point3d point3d) {
        return new Vector3d((double)point3f.x - point3d.x, (double)point3f.y - point3d.y, (double)point3f.z - point3d.z);
    }

    public static Vector3d operator$sub(Vector3f vector3f, Vector3d vector3d) {
        return new Vector3d((double)vector3f.x - vector3d.x, (double)vector3f.y - vector3d.y, (double)vector3f.z - vector3d.z);
    }

    public static Point3d operator$sub(Point3d point3d, Tuple3f tuple3f) {
        return new Point3d(point3d.x - (double)tuple3f.x, point3d.y - (double)tuple3f.y, point3d.z - (double)tuple3f.z);
    }

    public static Point3d operator$sub(Tuple3d tuple3d, Point3f point3f) {
        return new Point3d(tuple3d.x - (double)point3f.x, tuple3d.y - (double)point3f.y, tuple3d.z - (double)point3f.z);
    }

    public static Vector3d operator$sub(Point3d point3d, Point3f point3f) {
        return new Vector3d(point3d.x - (double)point3f.x, point3d.y - (double)point3f.y, point3d.z - (double)point3f.z);
    }

    public static Vector3d operator$sub(Vector3d vector3d, Vector3f vector3f) {
        return new Vector3d(vector3d.x - (double)vector3f.x, vector3d.y - (double)vector3f.y, vector3d.z - (double)vector3f.z);
    }

    public static Point3d operator$subAssign(Point3d point3d, Tuple3f tuple3f) {
        point3d.set(point3d.x - (double)tuple3f.x, point3d.y - (double)tuple3f.y, point3d.z - (double)tuple3f.z);
        return point3d;
    }

    public static Vector3d operator$subAssign(Vector3d vector3d, Vector3f vector3f) {
        vector3d.set(vector3d.x - (double)vector3f.x, vector3d.y - (double)vector3f.y, vector3d.z - (double)vector3f.z);
        return vector3d;
    }

    public static Point3d operator$sub(Point3d point3d, Tuple3d tuple3d) {
        return new Point3d(point3d.x - tuple3d.x, point3d.y - tuple3d.y, point3d.z - tuple3d.z);
    }

    public static Point3d operator$sub(Tuple3d tuple3d, Point3d point3d) {
        return new Point3d(tuple3d.x - point3d.x, tuple3d.y - point3d.y, tuple3d.z - point3d.z);
    }

    public static Vector3d operator$sub(Point3d point3d, Point3d point3d2) {
        return new Vector3d(point3d.x - point3d2.x, point3d.y - point3d2.y, point3d.z - point3d2.z);
    }

    public static Vector3d operator$sub(Vector3d vector3d, Vector3d vector3d2) {
        return new Vector3d(vector3d.x - vector3d2.x, vector3d.y - vector3d2.y, vector3d.z - vector3d2.z);
    }

    public static Point3d operator$subAssign(Point3d point3d, Tuple3d tuple3d) {
        point3d.set(point3d.x - tuple3d.x, point3d.y - tuple3d.y, point3d.z - tuple3d.z);
        return point3d;
    }

    public static Vector3d operator$subAssign(Vector3d vector3d, Vector3d vector3d2) {
        vector3d.set(vector3d.x - vector3d2.x, vector3d.y - vector3d2.y, vector3d.z - vector3d2.z);
        return vector3d;
    }

    public static Vector4f operator$mul(Tuple4f tuple4f, float f) {
        Vector4f vector4f = new Vector4f();
        vector4f.scale(f, tuple4f);
        return vector4f;
    }

    public static Point4f operator$mul(Point4f point4f, float f) {
        Point4f point4f2 = new Point4f();
        point4f2.scale(f, point4f);
        return point4f2;
    }

    public static Vector4f operator$div(Tuple4f tuple4f, float f) {
        Vector4f vector4f = new Vector4f();
        vector4f.scale(1.0f / f, tuple4f);
        return vector4f;
    }

    public static Point4f operator$div(Point4f point4f, float f) {
        Point4f point4f2 = new Point4f();
        point4f2.scale(1.0f / f, point4f);
        return point4f2;
    }

    public static Vector4f operator$mul(float f, Tuple4f tuple4f) {
        Vector4f vector4f = new Vector4f();
        vector4f.scale(f, tuple4f);
        return vector4f;
    }

    public static Point4f operator$mul(float f, Point4f point4f) {
        Point4f point4f2 = new Point4f();
        point4f2.scale(f, point4f);
        return point4f2;
    }

    public static Vector4f operator$neg(Tuple4f tuple4f) {
        Vector4f vector4f = new Vector4f();
        vector4f.negate(tuple4f);
        return vector4f;
    }

    public static Point4f operator$neg(Point4f point4f) {
        Point4f point4f2 = new Point4f();
        point4f2.negate(point4f);
        return point4f2;
    }

    public static Vector4f operator$mulAssign(Vector4f vector4f, float f) {
        vector4f.scale(f);
        return vector4f;
    }

    public static Point4f operator$mulAssign(Point4f point4f, float f) {
        point4f.scale(f);
        return point4f;
    }

    public static Vector4d operator$mul(Tuple4d tuple4d, double d) {
        Vector4d vector4d = new Vector4d();
        vector4d.scale(d, tuple4d);
        return vector4d;
    }

    public static Point4d operator$mul(Point4d point4d, double d) {
        Point4d point4d2 = new Point4d();
        point4d2.scale(d, point4d);
        return point4d2;
    }

    public static Vector4d operator$div(Tuple4d tuple4d, double d) {
        Vector4d vector4d = new Vector4d();
        vector4d.scale(1.0 / d, tuple4d);
        return vector4d;
    }

    public static Point4d operator$div(Point4d point4d, double d) {
        Point4d point4d2 = new Point4d();
        point4d2.scale(1.0 / d, point4d);
        return point4d2;
    }

    public static Vector4d operator$mul(double d, Tuple4d tuple4d) {
        Vector4d vector4d = new Vector4d();
        vector4d.scale(d, tuple4d);
        return vector4d;
    }

    public static Point4d operator$mul(double d, Point4d point4d) {
        Point4d point4d2 = new Point4d();
        point4d2.scale(d, point4d);
        return point4d2;
    }

    public static Vector4d operator$neg(Tuple4d tuple4d) {
        Vector4d vector4d = new Vector4d();
        vector4d.negate(tuple4d);
        return vector4d;
    }

    public static Point4d operator$neg(Point4d point4d) {
        Point4d point4d2 = new Point4d();
        point4d2.negate(point4d);
        return point4d2;
    }

    public static Vector4d operator$mulAssign(Vector4d vector4d, double d) {
        vector4d.scale(d);
        return vector4d;
    }

    public static Point4d operator$mulAssign(Point4d point4d, double d) {
        point4d.scale(d);
        return point4d;
    }

    public static Point4f operator$add(Point4f point4f, Tuple4f tuple4f) {
        return new Point4f(point4f.x + tuple4f.x, point4f.y + tuple4f.y, point4f.z + tuple4f.z, point4f.w + tuple4f.w);
    }

    public static Point4f operator$add(Tuple4f tuple4f, Point4f point4f) {
        return new Point4f(tuple4f.x + point4f.x, tuple4f.y + point4f.y, tuple4f.z + point4f.z, tuple4f.w + point4f.w);
    }

    public static Point4f operator$add(Point4f point4f, Point4f point4f2) {
        return new Point4f(point4f.x + point4f2.x, point4f.y + point4f2.y, point4f.z + point4f2.z, point4f.w + point4f2.w);
    }

    public static Vector4f operator$add(Vector4f vector4f, Vector4f vector4f2) {
        return new Vector4f(vector4f.x + vector4f2.x, vector4f.y + vector4f2.y, vector4f.z + vector4f2.z, vector4f.w + vector4f2.w);
    }

    public static Point4f operator$addAssign(Point4f point4f, Tuple4f tuple4f) {
        point4f.set(point4f.x + tuple4f.x, point4f.y + tuple4f.y, point4f.z + tuple4f.z, point4f.w + tuple4f.w);
        return point4f;
    }

    public static Vector4f operator$addAssign(Vector4f vector4f, Vector4f vector4f2) {
        vector4f.set(vector4f.x + vector4f2.x, vector4f.y + vector4f2.y, vector4f.z + vector4f2.z, vector4f.w + vector4f2.w);
        return vector4f;
    }

    public static Point4d operator$add(Point4f point4f, Tuple4d tuple4d) {
        return new Point4d((double)point4f.x + tuple4d.x, (double)point4f.y + tuple4d.y, (double)point4f.z + tuple4d.z, (double)point4f.w + tuple4d.w);
    }

    public static Point4d operator$add(Tuple4f tuple4f, Point4d point4d) {
        return new Point4d((double)tuple4f.x + point4d.x, (double)tuple4f.y + point4d.y, (double)tuple4f.z + point4d.z, (double)tuple4f.w + point4d.w);
    }

    public static Point4d operator$add(Point4f point4f, Point4d point4d) {
        return new Point4d((double)point4f.x + point4d.x, (double)point4f.y + point4d.y, (double)point4f.z + point4d.z, (double)point4f.w + point4d.w);
    }

    public static Vector4d operator$add(Vector4f vector4f, Vector4d vector4d) {
        return new Vector4d((double)vector4f.x + vector4d.x, (double)vector4f.y + vector4d.y, (double)vector4f.z + vector4d.z, (double)vector4f.w + vector4d.w);
    }

    public static Point4d operator$add(Point4d point4d, Tuple4f tuple4f) {
        return new Point4d(point4d.x + (double)tuple4f.x, point4d.y + (double)tuple4f.y, point4d.z + (double)tuple4f.z, point4d.w + (double)tuple4f.w);
    }

    public static Point4d operator$add(Tuple4d tuple4d, Point4f point4f) {
        return new Point4d(tuple4d.x + (double)point4f.x, tuple4d.y + (double)point4f.y, tuple4d.z + (double)point4f.z, tuple4d.w + (double)point4f.w);
    }

    public static Point4d operator$add(Point4d point4d, Point4f point4f) {
        return new Point4d(point4d.x + (double)point4f.x, point4d.y + (double)point4f.y, point4d.z + (double)point4f.z, point4d.w + (double)point4f.w);
    }

    public static Vector4d operator$add(Vector4d vector4d, Vector4f vector4f) {
        return new Vector4d(vector4d.x + (double)vector4f.x, vector4d.y + (double)vector4f.y, vector4d.z + (double)vector4f.z, vector4d.w + (double)vector4f.w);
    }

    public static Point4d operator$addAssign(Point4d point4d, Tuple4f tuple4f) {
        point4d.set(point4d.x + (double)tuple4f.x, point4d.y + (double)tuple4f.y, point4d.z + (double)tuple4f.z, point4d.w + (double)tuple4f.w);
        return point4d;
    }

    public static Vector4d operator$addAssign(Vector4d vector4d, Vector4f vector4f) {
        vector4d.set(vector4d.x + (double)vector4f.x, vector4d.y + (double)vector4f.y, vector4d.z + (double)vector4f.z, vector4d.w + (double)vector4f.w);
        return vector4d;
    }

    public static Point4d operator$add(Point4d point4d, Tuple4d tuple4d) {
        return new Point4d(point4d.x + tuple4d.x, point4d.y + tuple4d.y, point4d.z + tuple4d.z, point4d.w + tuple4d.w);
    }

    public static Point4d operator$add(Tuple4d tuple4d, Point4d point4d) {
        return new Point4d(tuple4d.x + point4d.x, tuple4d.y + point4d.y, tuple4d.z + point4d.z, tuple4d.w + point4d.w);
    }

    public static Point4d operator$add(Point4d point4d, Point4d point4d2) {
        return new Point4d(point4d.x + point4d2.x, point4d.y + point4d2.y, point4d.z + point4d2.z, point4d.w + point4d2.w);
    }

    public static Vector4d operator$add(Vector4d vector4d, Vector4d vector4d2) {
        return new Vector4d(vector4d.x + vector4d2.x, vector4d.y + vector4d2.y, vector4d.z + vector4d2.z, vector4d.w + vector4d2.w);
    }

    public static Point4d operator$addAssign(Point4d point4d, Tuple4d tuple4d) {
        point4d.set(point4d.x + tuple4d.x, point4d.y + tuple4d.y, point4d.z + tuple4d.z, point4d.w + tuple4d.w);
        return point4d;
    }

    public static Vector4d operator$addAssign(Vector4d vector4d, Vector4d vector4d2) {
        vector4d.set(vector4d.x + vector4d2.x, vector4d.y + vector4d2.y, vector4d.z + vector4d2.z, vector4d.w + vector4d2.w);
        return vector4d;
    }

    public static Point4f operator$sub(Point4f point4f, Tuple4f tuple4f) {
        return new Point4f(point4f.x - tuple4f.x, point4f.y - tuple4f.y, point4f.z - tuple4f.z, point4f.w - tuple4f.w);
    }

    public static Point4f operator$sub(Tuple4f tuple4f, Point4f point4f) {
        return new Point4f(tuple4f.x - point4f.x, tuple4f.y - point4f.y, tuple4f.z - point4f.z, tuple4f.w - point4f.w);
    }

    public static Vector4f operator$sub(Point4f point4f, Point4f point4f2) {
        return new Vector4f(point4f.x - point4f2.x, point4f.y - point4f2.y, point4f.z - point4f2.z, point4f.w - point4f2.w);
    }

    public static Vector4f operator$sub(Vector4f vector4f, Vector4f vector4f2) {
        return new Vector4f(vector4f.x - vector4f2.x, vector4f.y - vector4f2.y, vector4f.z - vector4f2.z, vector4f.w - vector4f2.w);
    }

    public static Point4f operator$subAssign(Point4f point4f, Tuple4f tuple4f) {
        point4f.set(point4f.x - tuple4f.x, point4f.y - tuple4f.y, point4f.z - tuple4f.z, point4f.w - tuple4f.w);
        return point4f;
    }

    public static Vector4f operator$subAssign(Vector4f vector4f, Vector4f vector4f2) {
        vector4f.set(vector4f.x - vector4f2.x, vector4f.y - vector4f2.y, vector4f.z - vector4f2.z, vector4f.w - vector4f2.w);
        return vector4f;
    }

    public static Point4d operator$sub(Point4f point4f, Tuple4d tuple4d) {
        return new Point4d((double)point4f.x - tuple4d.x, (double)point4f.y - tuple4d.y, (double)point4f.z - tuple4d.z, (double)point4f.w - tuple4d.w);
    }

    public static Point4d operator$sub(Tuple4f tuple4f, Point4d point4d) {
        return new Point4d((double)tuple4f.x - point4d.x, (double)tuple4f.y - point4d.y, (double)tuple4f.z - point4d.z, (double)tuple4f.w - point4d.w);
    }

    public static Vector4d operator$sub(Point4f point4f, Point4d point4d) {
        return new Vector4d((double)point4f.x - point4d.x, (double)point4f.y - point4d.y, (double)point4f.z - point4d.z, (double)point4f.w - point4d.w);
    }

    public static Vector4d operator$sub(Vector4f vector4f, Vector4d vector4d) {
        return new Vector4d((double)vector4f.x - vector4d.x, (double)vector4f.y - vector4d.y, (double)vector4f.z - vector4d.z, (double)vector4f.w - vector4d.w);
    }

    public static Point4d operator$sub(Point4d point4d, Tuple4f tuple4f) {
        return new Point4d(point4d.x - (double)tuple4f.x, point4d.y - (double)tuple4f.y, point4d.z - (double)tuple4f.z, point4d.w - (double)tuple4f.w);
    }

    public static Point4d operator$sub(Tuple4d tuple4d, Point4f point4f) {
        return new Point4d(tuple4d.x - (double)point4f.x, tuple4d.y - (double)point4f.y, tuple4d.z - (double)point4f.z, tuple4d.w - (double)point4f.w);
    }

    public static Vector4d operator$sub(Point4d point4d, Point4f point4f) {
        return new Vector4d(point4d.x - (double)point4f.x, point4d.y - (double)point4f.y, point4d.z - (double)point4f.z, point4d.w - (double)point4f.w);
    }

    public static Vector4d operator$sub(Vector4d vector4d, Vector4f vector4f) {
        return new Vector4d(vector4d.x - (double)vector4f.x, vector4d.y - (double)vector4f.y, vector4d.z - (double)vector4f.z, vector4d.w - (double)vector4f.w);
    }

    public static Point4d operator$subAssign(Point4d point4d, Tuple4f tuple4f) {
        point4d.set(point4d.x - (double)tuple4f.x, point4d.y - (double)tuple4f.y, point4d.z - (double)tuple4f.z, point4d.w - (double)tuple4f.w);
        return point4d;
    }

    public static Vector4d operator$subAssign(Vector4d vector4d, Vector4f vector4f) {
        vector4d.set(vector4d.x - (double)vector4f.x, vector4d.y - (double)vector4f.y, vector4d.z - (double)vector4f.z, vector4d.w - (double)vector4f.w);
        return vector4d;
    }

    public static Point4d operator$sub(Point4d point4d, Tuple4d tuple4d) {
        return new Point4d(point4d.x - tuple4d.x, point4d.y - tuple4d.y, point4d.z - tuple4d.z, point4d.w - tuple4d.w);
    }

    public static Point4d operator$sub(Tuple4d tuple4d, Point4d point4d) {
        return new Point4d(tuple4d.x - point4d.x, tuple4d.y - point4d.y, tuple4d.z - point4d.z, tuple4d.w - point4d.w);
    }

    public static Vector4d operator$sub(Point4d point4d, Point4d point4d2) {
        return new Vector4d(point4d.x - point4d2.x, point4d.y - point4d2.y, point4d.z - point4d2.z, point4d.w - point4d2.w);
    }

    public static Vector4d operator$sub(Vector4d vector4d, Vector4d vector4d2) {
        return new Vector4d(vector4d.x - vector4d2.x, vector4d.y - vector4d2.y, vector4d.z - vector4d2.z, vector4d.w - vector4d2.w);
    }

    public static Point4d operator$subAssign(Point4d point4d, Tuple4d tuple4d) {
        point4d.set(point4d.x - tuple4d.x, point4d.y - tuple4d.y, point4d.z - tuple4d.z, point4d.w - tuple4d.w);
        return point4d;
    }

    public static Vector4d operator$subAssign(Vector4d vector4d, Vector4d vector4d2) {
        vector4d.set(vector4d.x - vector4d2.x, vector4d.y - vector4d2.y, vector4d.z - vector4d2.z, vector4d.w - vector4d2.w);
        return vector4d;
    }
}

