/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.vecmath.geom;

import de.grogra.vecmath.geom.BoundingBox;
import de.grogra.vecmath.geom.Intersection;
import de.grogra.vecmath.geom.IntersectionList;
import de.grogra.vecmath.geom.Line;
import de.grogra.vecmath.geom.Variables;
import de.grogra.vecmath.geom.Volume;
import de.grogra.vecmath.geom.VolumeBase;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;

public class CSGComplement
extends VolumeBase {
    public Volume volume;

    public CSGComplement(Volume volume) {
        this.volume = volume;
    }

    public boolean contains(Tuple3d tuple3d, boolean bl) {
        return !this.volume.contains(tuple3d, !bl);
    }

    public boolean computeIntersections(Line line, int n, IntersectionList intersectionList, Intersection intersection, Intersection intersection2) {
        int n2 = intersectionList.size;
        boolean bl = this.volume.computeIntersections(line, n, intersectionList, intersection, intersection2);
        while (n2 < intersectionList.size) {
            Intersection intersection3 = intersectionList.elements[n2++];
            switch (intersection3.type) {
                case 1: {
                    intersection3.type = -1;
                    intersection3.negateNormal();
                    break;
                }
                case -1: {
                    intersection3.type = 1;
                    intersection3.negateNormal();
                }
            }
        }
        return !bl;
    }

    public Volume operator$com() {
        return this.volume;
    }

    public void getExtent(Tuple3d tuple3d, Tuple3d tuple3d2, Variables variables) {
        tuple3d.set(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        tuple3d2.set(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public boolean boxContainsBoundary(BoundingBox boundingBox, Tuple3d tuple3d, double d, Variables variables) {
        return this.volume.boxContainsBoundary(boundingBox, tuple3d, d, variables);
    }

    public void computeNormal(Intersection intersection, Vector3d vector3d) {
        throw new UnsupportedOperationException();
    }

    public void computeUV(Intersection intersection, Vector2d vector2d) {
        throw new UnsupportedOperationException();
    }

    public void computeTangents(Intersection intersection, Vector3d vector3d, Vector3d vector3d2) {
        throw new UnsupportedOperationException();
    }
}

