/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.vecmath.geom;

import de.grogra.vecmath.geom.FrustumBase;
import de.grogra.vecmath.geom.Intersection;
import de.grogra.vecmath.geom.IntersectionList;
import de.grogra.vecmath.geom.Line;
import de.grogra.vecmath.geom.Variables;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;

public class Cone
extends FrustumBase {
    public double base;
    public boolean baseOpen;
    public boolean rotateUV;

    public double getTop() {
        return 0.0;
    }

    public double getBase() {
        return this.base;
    }

    public boolean isUVRotated() {
        return this.rotateUV;
    }

    public boolean isBaseOpen() {
        return this.baseOpen;
    }

    public boolean isTopOpen() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int intersectEdge(Line line, double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        if (d6 == 0.0) {
            if (d3 > this.base) {
                return 0;
            }
            if (d3 < this.getTop()) {
                return 0;
            }
            d11 = Double.NEGATIVE_INFINITY;
            d10 = Double.POSITIVE_INFINITY;
        } else {
            d11 = (this.base - d3) / d6;
            d10 = (this.getTop() - d3) / d6;
            if (d10 < d11) {
                d9 = d11;
                d11 = d10;
                d10 = d9;
            }
        }
        d9 = d4 * d4 + d5 * d5 - d6 * d6;
        double d12 = d * d4 + d2 * d5 - d3 * d6;
        double d13 = d * d + d2 * d2 - d3 * d3;
        if (d9 == 0.0) {
            if (d12 == 0.0) {
                if (d13 != 0.0) return 0;
                d8 = Double.NEGATIVE_INFINITY;
                d7 = Double.POSITIVE_INFINITY;
            } else {
                d8 = d7 = d13 / (-2.0 * d12);
            }
        } else {
            double d14 = d12 * d12 - d9 * d13;
            if (d14 < 0.0) {
                return 0;
            }
            double d15 = d14 = d14 <= 0.0 ? 0.0 : Math.sqrt(d14);
            if (d9 > 0.0) {
                d8 = -(d14 + d12) / d9;
                d7 = (d14 - d12) / d9;
            } else if (d6 > 0.0) {
                d8 = -(d14 + d12) / d9;
                d7 = Double.POSITIVE_INFINITY;
            } else {
                d8 = Double.NEGATIVE_INFINITY;
                d7 = (d14 - d12) / d9;
            }
        }
        if (d8 > d11) {
            d11 = d8;
        }
        if (d7 < d10) {
            d10 = d7;
        }
        int n = 2;
        if (line.start > d11) {
            d11 = line.start;
            --n;
        }
        if (line.end < d10) {
            d10 = line.end;
            --n;
        }
        if (d11 > d10) {
            return 0;
        }
        line.start = d11;
        line.end = d10;
        if (n != 0) return 2;
        return 1;
    }

    public boolean computeIntersections(Line line, int n, IntersectionList intersectionList, Intersection intersection, Intersection intersection2) {
        double d;
        int n2;
        int n3;
        double d2;
        double d3;
        if (intersection != null && intersection2 != null && intersection.volume == this && intersection2.volume == this) {
            return true;
        }
        Vector3d vector3d = intersectionList.tmpVector0;
        Point3d point3d = intersectionList.tmpPoint0;
        this.transformVector(line.direction, vector3d);
        this.transformPoint(line.origin, point3d);
        if (vector3d.z == 0.0) {
            if (point3d.z > this.base) {
                return false;
            }
            if (point3d.z < this.getTop()) {
                return false;
            }
            d3 = Double.NEGATIVE_INFINITY;
            d2 = Double.POSITIVE_INFINITY;
            n3 = -1;
            n2 = -1;
        } else {
            d3 = (this.base - point3d.z) / vector3d.z;
            d2 = (this.getTop() - point3d.z) / vector3d.z;
            if (d2 < d3) {
                d = d3;
                d3 = d2;
                d2 = d;
                n3 = this.isTopOpen() ? -1 : 1;
                n2 = this.baseOpen ? -1 : 0;
            } else {
                n3 = this.baseOpen ? -1 : 0;
                n2 = this.isTopOpen() ? -1 : 1;
            }
        }
        d = vector3d.x * vector3d.x + vector3d.y * vector3d.y - vector3d.z * vector3d.z;
        double d4 = point3d.x * vector3d.x + point3d.y * vector3d.y - point3d.z * vector3d.z;
        double d5 = point3d.x * point3d.x + point3d.y * point3d.y - point3d.z * point3d.z;
        if (d == 0.0) {
            if (d4 == 0.0) {
                return false;
            }
            double d6 = d5 / (-2.0 * d4);
            if (vector3d.z > 0.0) {
                if (d6 > d3) {
                    d3 = d6;
                    n3 = 2;
                }
            } else if (d6 < d2) {
                d2 = d6;
                n2 = 2;
            }
        } else {
            double d7 = d4 * d4 - d * d5;
            if (d7 <= 0.0) {
                if (d >= 0.0) {
                    return false;
                }
                d7 = 0.0;
            } else {
                d7 = Math.sqrt(d7);
            }
            if (d > 0.0) {
                double d8 = -(d7 + d4) / d;
                if (d8 > d3) {
                    d3 = d8;
                    n3 = 2;
                }
                if ((d8 = (d7 - d4) / d) < d2) {
                    d2 = d8;
                    n2 = 2;
                }
            } else if (vector3d.z > 0.0) {
                double d9 = -(d7 + d4) / d;
                if (d9 > d3) {
                    d3 = d9;
                    n3 = 2;
                }
            } else {
                double d10 = (d7 - d4) / d;
                if (d10 < d2) {
                    d2 = d10;
                    n2 = 2;
                }
            }
        }
        if (d2 < d3) {
            return false;
        }
        return this.addConvexIntersections(d3, n3, d2, n2, !this.baseOpen && !this.isTopOpen(), line, n, intersectionList, intersection, intersection2);
    }

    public boolean contains(Tuple3d tuple3d, boolean bl) {
        if (this.baseOpen || this.isTopOpen()) {
            return false;
        }
        double d = tuple3d.x - this.t0;
        double d2 = tuple3d.y - this.t1;
        double d3 = tuple3d.z - this.t2;
        double d4 = this.m20 * d + this.m21 * d2 + this.m22 * d3;
        if (bl ? d4 <= this.getTop() || d4 >= this.base : d4 < this.getTop() || d4 > this.base) {
            return false;
        }
        double d5 = this.m00 * d + this.m01 * d2 + this.m02 * d3;
        double d6 = this.m10 * d + this.m11 * d2 + this.m12 * d3;
        return bl ? d5 * d5 + d6 * d6 < d4 * d4 : d5 * d5 + d6 * d6 <= d4 * d4;
    }

    public void getExtent(Tuple3d tuple3d, Tuple3d tuple3d2, Variables variables) {
        double d = this.getTop();
        if (d == 0.0) {
            this.getDiscExtent(this.base, this.base, tuple3d, tuple3d2);
            if (this.t0 < tuple3d.x) {
                tuple3d.x = this.t0;
            } else if (this.t0 > tuple3d2.x) {
                tuple3d2.x = this.t0;
            }
            if (this.t1 < tuple3d.y) {
                tuple3d.y = this.t1;
            } else if (this.t1 > tuple3d2.y) {
                tuple3d2.y = this.t1;
            }
            if (this.t2 < tuple3d.z) {
                tuple3d.z = this.t2;
            } else if (this.t2 > tuple3d2.z) {
                tuple3d2.z = this.t2;
            }
        } else {
            this.getDiscsExtent(d, d, this.base, this.base, tuple3d, tuple3d2);
        }
    }

    boolean containsLocalPoint(Tuple3d tuple3d) {
        return tuple3d.z >= this.getTop() && tuple3d.z <= this.base && tuple3d.x * tuple3d.x + tuple3d.y * tuple3d.y - tuple3d.z * tuple3d.z <= 0.0;
    }

    double getBaseRadiusSquared() {
        return this.base * this.base;
    }

    double getTopRadiusSquared() {
        return this.getTop() * this.getTop();
    }

    boolean intersectsBoundingSphere(Vector3d vector3d, double d) {
        double d2 = d + 1.000001 * this.base;
        vector3d.z -= this.base;
        return vector3d.lengthSquared() <= d2 * d2;
    }

    public void computeNormal(Intersection intersection, Vector3d vector3d) {
        switch (intersection.face) {
            case 0: {
                vector3d.set(0.0, 0.0, 1.0);
                break;
            }
            case 1: {
                vector3d.set(0.0, 0.0, -1.0);
                break;
            }
            case 2: {
                this.transformPoint(intersection.getPoint(), vector3d);
                vector3d.z = -vector3d.z;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.transformTranspose(vector3d, vector3d);
        vector3d.normalize();
    }

    public void computeUV(Intersection intersection, Vector2d vector2d) {
        Vector3d vector3d = intersection.tmpVector0;
        this.transformPoint(intersection.getPoint(), vector3d);
        switch (intersection.face) {
            case 0: {
                vector2d.x = 0.5 * (vector3d.x / this.base + 1.0);
                vector2d.y = 0.5 * (vector3d.y / this.base - 1.0);
                break;
            }
            case 1: {
                vector2d.x = 0.5 * (vector3d.x / this.getTop() + 1.0);
                vector2d.y = 0.5 * (1.0 - vector3d.y / this.getTop());
                break;
            }
            case 2: {
                vector2d.x = (Math.atan2(vector3d.y, -vector3d.x) + Math.PI) * 0.15915494309189535;
                vector2d.y = (vector3d.z - this.getTop()) / (this.base - this.getTop());
                if (this.rotateUV) {
                    vector2d.x = 1.0 - vector2d.x;
                } else {
                    vector2d.y = 1.0 - vector2d.y;
                }
                vector2d.y *= (double)this.scaleV;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void computeTangents(Intersection intersection, Vector3d vector3d, Vector3d vector3d2) {
        Vector3d vector3d3 = intersection.tmpVector0;
        this.transformPoint(intersection.getPoint(), vector3d3);
        switch (intersection.face) {
            case 0: {
                vector3d.set(2.0 * this.base, 0.0, 0.0);
                vector3d2.set(0.0, 2.0 * this.base, 0.0);
                break;
            }
            case 1: {
                vector3d.set(2.0 * this.getTop(), 0.0, 0.0);
                vector3d2.set(0.0, -2.0 * this.getTop(), 0.0);
                break;
            }
            case 2: {
                vector3d.set(Math.PI * -2 * vector3d3.y * vector3d3.z, Math.PI * 2 * vector3d3.x * vector3d3.z, 0.0);
                vector3d2.set(0.0, 0.0, (this.base - this.getTop()) / (double)this.scaleV);
                (this.rotateUV ? vector3d : vector3d2).negate();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        Matrix3d matrix3d = this.getObjectToWorldRotationScale();
        matrix3d.transform(vector3d);
        matrix3d.transform(vector3d2);
    }
}

