/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.vecmath.geom;

import de.grogra.vecmath.Math2;
import de.grogra.vecmath.geom.BoundingBox;
import de.grogra.vecmath.geom.Line;
import de.grogra.vecmath.geom.TransformableVolume;
import de.grogra.vecmath.geom.Variables;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public abstract class FrustumBase
extends TransformableVolume {
    public static final int BASE = 0;
    public static final int TOP = 1;
    public static final int LATERAL = 2;
    public float scaleV = 1.0f;
    static final int EMPTY = 0;
    static final int CONTAINED = 1;
    static final int INTERSECTED = 2;

    abstract double getTop();

    abstract double getBase();

    public boolean intersect(Line line) {
        Vector3d vector3d = new Vector3d();
        this.transformVector(line.direction, vector3d);
        double d = vector3d.x;
        double d2 = vector3d.y;
        double d3 = vector3d.z;
        this.transformPoint(line.origin, vector3d);
        return this.intersectEdge(line, vector3d.x, vector3d.y, vector3d.z, d, d2, d3) != 0;
    }

    abstract int intersectEdge(Line var1, double var2, double var4, double var6, double var8, double var10, double var12);

    abstract boolean containsLocalPoint(Tuple3d var1);

    abstract double getBaseRadiusSquared();

    abstract double getTopRadiusSquared();

    abstract boolean intersectsBoundingSphere(Vector3d var1, double var2);

    public boolean boxContainsBoundary(BoundingBox boundingBox, Tuple3d tuple3d, double d, Variables variables) {
        Point3d point3d = boundingBox.min;
        Point3d point3d2 = boundingBox.max;
        Vector3d vector3d = variables.tmpVector0;
        Vector3d vector3d2 = variables.tmpVector1;
        Vector3d vector3d3 = variables.tmpVector2;
        Point3d point3d3 = variables.tmpPoint0;
        this.transformPoint(tuple3d, vector3d3);
        if (!this.intersectsBoundingSphere(vector3d3, d * this.getFrobeniusNorm())) {
            return false;
        }
        Line line = variables.tmpLine;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i <= 1; ++i) {
            vector3d.x = i == 0 ? point3d.x : point3d2.x;
            for (int j = 0; j <= 1; ++j) {
                vector3d.y = j == 0 ? point3d.y : point3d2.y;
                for (int k = 0; k <= 1; ++k) {
                    double d2;
                    vector3d.z = k == 0 ? point3d.z : point3d2.z;
                    this.transformPoint(vector3d, vector3d2);
                    if (this.containsLocalPoint(vector3d2)) {
                        if (bl2) {
                            return true;
                        }
                        bl = true;
                    } else {
                        if (bl) {
                            return true;
                        }
                        bl2 = true;
                    }
                    if (i == 0) {
                        d2 = point3d2.x - point3d.x;
                        line.start = 0.0;
                        line.end = 1.0;
                        if (this.intersectEdge(line, vector3d2.x, vector3d2.y, vector3d2.z, d2 * this.m00, d2 * this.m10, d2 * this.m20) == 2) {
                            return true;
                        }
                    }
                    if (j == 0) {
                        d2 = point3d2.y - point3d.y;
                        line.start = 0.0;
                        line.end = 1.0;
                        if (this.intersectEdge(line, vector3d2.x, vector3d2.y, vector3d2.z, d2 * this.m01, d2 * this.m11, d2 * this.m21) == 2) {
                            return true;
                        }
                    }
                    if (k != 0) continue;
                    d2 = point3d2.z - point3d.z;
                    line.start = 0.0;
                    line.end = 1.0;
                    if (this.intersectEdge(line, vector3d2.x, vector3d2.y, vector3d2.z, d2 * this.m02, d2 * this.m12, d2 * this.m22) != 2) continue;
                    return true;
                }
            }
        }
        if (!bl2) {
            return false;
        }
        Matrix3d matrix3d = this.getObjectToWorldRotationScale();
        double d3 = 0.5 * (this.getBase() + this.getTop());
        vector3d.set(matrix3d.m02 * d3 + this.t0, matrix3d.m12 * d3 + this.t1, matrix3d.m22 * d3 + this.t2);
        if (Math2.lessThanOrEqual(point3d, vector3d) && Math2.lessThanOrEqual(vector3d, point3d2)) {
            return true;
        }
        for (int i = -1; i <= 1; i += 2) {
            this.transformPoint(i < 0 ? point3d : point3d2, vector3d);
            for (int j = 0; j <= 2; ++j) {
                vector3d2.set(j == 0 ? (double)i : 0.0, j == 1 ? (double)i : 0.0, j == 2 ? (double)i : 0.0);
                Math2.transformTranspose(matrix3d, vector3d2);
                double d4 = vector3d2.dot(vector3d);
                if (vector3d2.z != 0.0 && (d3 = d4 / vector3d2.z) >= this.getTop() && d3 <= this.getBase()) {
                    point3d3.x = matrix3d.m02 * d3 + this.t0;
                    point3d3.y = matrix3d.m12 * d3 + this.t1;
                    point3d3.z = matrix3d.m22 * d3 + this.t2;
                    if (boundingBox.contains((Tuple3d)point3d3, j)) {
                        return true;
                    }
                }
                vector3d3.x = -vector3d2.y;
                vector3d3.y = vector3d2.x;
                vector3d3.z = 0.0;
                boolean bl3 = Math.abs(vector3d2.x) > Math.abs(vector3d2.y);
                for (int k = 0; k < 2; ++k) {
                    double d5;
                    double d6;
                    double d7 = d6 = k == 0 ? this.getBaseRadiusSquared() : this.getTopRadiusSquared();
                    if (d6 == 0.0) continue;
                    double d8 = d5 = k == 0 ? this.getBase() : this.getTop();
                    if (bl3) {
                        point3d3.x = (d4 - d5 * vector3d2.z) / vector3d2.x;
                        point3d3.y = 0.0;
                    } else {
                        point3d3.y = (d4 - d5 * vector3d2.z) / vector3d2.y;
                        point3d3.x = 0.0;
                    }
                    point3d3.z = d5;
                    double d9 = vector3d3.x * vector3d3.x + vector3d3.y * vector3d3.y;
                    double d10 = vector3d3.x * point3d3.x + vector3d3.y * point3d3.y;
                    double d11 = point3d3.x * point3d3.x + point3d3.y * point3d3.y - d6;
                    d3 = d10 * d10 - d9 * d11;
                    if (!(d3 >= 0.0)) continue;
                    point3d3.scaleAdd(-d10 / d9, vector3d3, point3d3);
                    matrix3d.transform(point3d3);
                    point3d3.x += this.t0;
                    point3d3.y += this.t1;
                    point3d3.z += this.t2;
                    if (!boundingBox.contains((Tuple3d)point3d3, j)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

