/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.vecmath.geom;

import de.grogra.vecmath.Math2;
import de.grogra.vecmath.geom.VolumeBase;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;

public abstract class TransformableVolume
extends VolumeBase {
    protected double m00;
    protected double m01;
    protected double m02;
    protected double m10;
    protected double m11;
    protected double m12;
    protected double m20;
    protected double m21;
    protected double m22;
    protected double t0;
    protected double t1;
    protected double t2;
    private Matrix3d objectToWorld;
    private double frobenius = -1.0;

    public void setTransformation(Matrix3d matrix3d, Tuple3d tuple3d) {
        this.m00 = matrix3d.m00;
        this.m01 = matrix3d.m01;
        this.m02 = matrix3d.m02;
        this.m10 = matrix3d.m10;
        this.m11 = matrix3d.m11;
        this.m12 = matrix3d.m12;
        this.m20 = matrix3d.m20;
        this.m21 = matrix3d.m21;
        this.m22 = matrix3d.m22;
        this.t0 = tuple3d.x;
        this.t1 = tuple3d.y;
        this.t2 = tuple3d.z;
        this.invalidate();
    }

    public void getTransformation(Matrix3d matrix3d, Tuple3d tuple3d) {
        matrix3d.m00 = this.m00;
        matrix3d.m01 = this.m01;
        matrix3d.m02 = this.m02;
        matrix3d.m10 = this.m10;
        matrix3d.m11 = this.m11;
        matrix3d.m12 = this.m12;
        matrix3d.m20 = this.m20;
        matrix3d.m21 = this.m21;
        matrix3d.m22 = this.m22;
        tuple3d.x = this.t0;
        tuple3d.y = this.t1;
        tuple3d.z = this.t2;
    }

    public void setTransformation(Tuple3d tuple3d, Tuple3d tuple3d2) {
        Matrix3d matrix3d = new Matrix3d();
        Math2.getOrthogonalBasis(tuple3d2, matrix3d, true);
        this.m00 = matrix3d.m00;
        this.m10 = matrix3d.m01;
        this.m20 = matrix3d.m02;
        this.m01 = matrix3d.m10;
        this.m11 = matrix3d.m11;
        this.m21 = matrix3d.m12;
        this.m02 = matrix3d.m20;
        this.m12 = matrix3d.m21;
        this.m22 = matrix3d.m22;
        this.t0 = tuple3d.x;
        this.t1 = tuple3d.y;
        this.t2 = tuple3d.z;
        this.invalidate();
    }

    public void scale(double d, double d2, double d3) {
        this.m00 *= d;
        this.m10 *= d2;
        this.m20 *= d3;
        this.m01 *= d;
        this.m11 *= d2;
        this.m21 *= d3;
        this.m02 *= d;
        this.m12 *= d2;
        this.m22 *= d3;
        this.invalidate();
    }

    public void translate(double d, double d2, double d3) {
        this.t0 += d;
        this.t1 += d2;
        this.t2 += d3;
        this.invalidate();
    }

    public void transformVector(Tuple3d tuple3d, Tuple3d tuple3d2) {
        double d = tuple3d.x;
        double d2 = tuple3d.y;
        double d3 = tuple3d.z;
        tuple3d2.x = this.m00 * d + this.m01 * d2 + this.m02 * d3;
        tuple3d2.y = this.m10 * d + this.m11 * d2 + this.m12 * d3;
        tuple3d2.z = this.m20 * d + this.m21 * d2 + this.m22 * d3;
    }

    public void transformPoint(Tuple3d tuple3d, Tuple3d tuple3d2) {
        double d = tuple3d.x - this.t0;
        double d2 = tuple3d.y - this.t1;
        double d3 = tuple3d.z - this.t2;
        tuple3d2.x = this.m00 * d + this.m01 * d2 + this.m02 * d3;
        tuple3d2.y = this.m10 * d + this.m11 * d2 + this.m12 * d3;
        tuple3d2.z = this.m20 * d + this.m21 * d2 + this.m22 * d3;
    }

    public void invTransformPoint(Tuple3d tuple3d, Tuple3d tuple3d2) {
        this.getObjectToWorldRotationScale().transform(tuple3d, tuple3d2);
        tuple3d2.x += this.t0;
        tuple3d2.y += this.t1;
        tuple3d2.z += this.t2;
    }

    public void transformTranspose(Tuple3d tuple3d, Tuple3d tuple3d2) {
        double d = tuple3d.x;
        double d2 = tuple3d.y;
        double d3 = tuple3d.z;
        tuple3d2.x = this.m00 * d + this.m10 * d2 + this.m20 * d3;
        tuple3d2.y = this.m01 * d + this.m11 * d2 + this.m21 * d3;
        tuple3d2.z = this.m02 * d + this.m12 * d2 + this.m22 * d3;
    }

    public Matrix3d getObjectToWorldRotationScale() {
        if (this.objectToWorld == null) {
            this.objectToWorld = new Matrix3d();
        } else if (this.objectToWorld.m00 == this.objectToWorld.m00) {
            return this.objectToWorld;
        }
        this.objectToWorld.m00 = this.m00;
        this.objectToWorld.m10 = this.m10;
        this.objectToWorld.m20 = this.m20;
        this.objectToWorld.m01 = this.m01;
        this.objectToWorld.m11 = this.m11;
        this.objectToWorld.m21 = this.m21;
        this.objectToWorld.m02 = this.m02;
        this.objectToWorld.m12 = this.m12;
        this.objectToWorld.m22 = this.m22;
        this.objectToWorld.invert();
        return this.objectToWorld;
    }

    public double getFrobeniusNorm() {
        if (this.frobenius < 0.0) {
            this.frobenius = Math.sqrt(this.m00 * this.m00 + this.m10 * this.m10 + this.m20 * this.m20 + this.m01 * this.m01 + this.m11 * this.m11 + this.m21 * this.m21 + this.m02 * this.m02 + this.m12 * this.m12 + this.m22 * this.m22);
        }
        return this.frobenius;
    }

    public void invalidate() {
        if (this.objectToWorld != null) {
            this.objectToWorld.m00 = Double.NaN;
        }
        this.frobenius = -1.0;
    }

    public void getDiscExtent(double d, double d2, Tuple3d tuple3d, Tuple3d tuple3d2) {
        Matrix3d matrix3d = this.getObjectToWorldRotationScale();
        double d3 = d2 * Math.sqrt(matrix3d.m00 * matrix3d.m00 + matrix3d.m01 * matrix3d.m01);
        tuple3d.x = matrix3d.m02 * d - d3 + this.t0;
        tuple3d2.x = matrix3d.m02 * d + d3 + this.t0;
        d3 = d2 * Math.sqrt(matrix3d.m10 * matrix3d.m10 + matrix3d.m11 * matrix3d.m11);
        tuple3d.y = matrix3d.m12 * d - d3 + this.t1;
        tuple3d2.y = matrix3d.m12 * d + d3 + this.t1;
        d3 = d2 * Math.sqrt(matrix3d.m20 * matrix3d.m20 + matrix3d.m21 * matrix3d.m21);
        tuple3d.z = matrix3d.m22 * d - d3 + this.t2;
        tuple3d2.z = matrix3d.m22 * d + d3 + this.t2;
    }

    public void getDiscsExtent(double d, double d2, double d3, double d4, Tuple3d tuple3d, Tuple3d tuple3d2) {
        Matrix3d matrix3d = this.getObjectToWorldRotationScale();
        double d5 = Math.sqrt(matrix3d.m00 * matrix3d.m00 + matrix3d.m01 * matrix3d.m01);
        tuple3d.x = Math.min(matrix3d.m02 * d - d5 * d2, matrix3d.m02 * d3 - d5 * d4) + this.t0;
        tuple3d2.x = Math.max(matrix3d.m02 * d + d5 * d2, matrix3d.m02 * d3 + d5 * d4) + this.t0;
        d5 = Math.sqrt(matrix3d.m10 * matrix3d.m10 + matrix3d.m11 * matrix3d.m11);
        tuple3d.y = Math.min(matrix3d.m12 * d - d5 * d2, matrix3d.m12 * d3 - d5 * d4) + this.t1;
        tuple3d2.y = Math.max(matrix3d.m12 * d + d5 * d2, matrix3d.m12 * d3 + d5 * d4) + this.t1;
        d5 = Math.sqrt(matrix3d.m20 * matrix3d.m20 + matrix3d.m21 * matrix3d.m21);
        tuple3d.z = Math.min(matrix3d.m22 * d - d5 * d2, matrix3d.m22 * d3 - d5 * d4) + this.t2;
        tuple3d2.z = Math.max(matrix3d.m22 * d + d5 * d2, matrix3d.m22 * d3 + d5 * d4) + this.t2;
    }
}

