/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4d;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Matrix4f
implements Serializable,
Cloneable {
    public float m00;
    public float m01;
    public float m02;
    public float m03;
    public float m10;
    public float m11;
    public float m12;
    public float m13;
    public float m20;
    public float m21;
    public float m22;
    public float m23;
    public float m30;
    public float m31;
    public float m32;
    public float m33;

    public Matrix4f(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.set(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
    }

    public Matrix4f(float[] fArray) {
        this.set(fArray);
    }

    public Matrix4f(Quat4f quat4f, Vector3f vector3f, float f) {
        this.set(quat4f, vector3f, f);
    }

    public Matrix4f(Matrix4d matrix4d) {
        this.set(matrix4d);
    }

    public Matrix4f(Matrix4f matrix4f) {
        this.set(matrix4f);
    }

    public Matrix4f(Matrix3f matrix3f, Vector3f vector3f, float f) {
        this.set(matrix3f);
        this.mulRotationScale(f);
        this.setTranslation(vector3f);
        this.m33 = 1.0f;
    }

    public Matrix4f() {
        this.setZero();
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        return "[" + string + "  [" + this.m00 + "\t" + this.m01 + "\t" + this.m02 + "\t" + this.m03 + "]" + string + "  [" + this.m10 + "\t" + this.m11 + "\t" + this.m12 + "\t" + this.m13 + "]" + string + "  [" + this.m20 + "\t" + this.m21 + "\t" + this.m22 + "\t" + this.m23 + "]" + string + "  [" + this.m30 + "\t" + this.m31 + "\t" + this.m32 + "\t" + this.m33 + "] ]";
    }

    public final void setIdentity() {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setElement(int n, int n2, float f) {
        if (n == 0) {
            if (n2 == 0) {
                this.m00 = f;
                return;
            } else if (n2 == 1) {
                this.m01 = f;
                return;
            } else if (n2 == 2) {
                this.m02 = f;
                return;
            } else {
                if (n2 != 3) throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n2);
                this.m03 = f;
            }
            return;
        } else if (n == 1) {
            if (n2 == 0) {
                this.m10 = f;
                return;
            } else if (n2 == 1) {
                this.m11 = f;
                return;
            } else if (n2 == 2) {
                this.m12 = f;
                return;
            } else {
                if (n2 != 3) throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n2);
                this.m13 = f;
            }
            return;
        } else if (n == 2) {
            if (n2 == 0) {
                this.m20 = f;
                return;
            } else if (n2 == 1) {
                this.m21 = f;
                return;
            } else if (n2 == 2) {
                this.m22 = f;
                return;
            } else {
                if (n2 != 3) throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n2);
                this.m23 = f;
            }
            return;
        } else {
            if (n != 3) throw new ArrayIndexOutOfBoundsException("row must be 0 to 2 and is " + n);
            if (n2 == 0) {
                this.m30 = f;
                return;
            } else if (n2 == 1) {
                this.m31 = f;
                return;
            } else if (n2 == 2) {
                this.m32 = f;
                return;
            } else {
                if (n2 != 3) throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n2);
                this.m33 = f;
            }
        }
    }

    public final float getElement(int n, int n2) {
        if (n == 0) {
            if (n2 == 0) {
                return this.m00;
            }
            if (n2 == 1) {
                return this.m01;
            }
            if (n2 == 2) {
                return this.m02;
            }
            if (n2 == 3) {
                return this.m03;
            }
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n2);
        }
        if (n == 1) {
            if (n2 == 0) {
                return this.m10;
            }
            if (n2 == 1) {
                return this.m11;
            }
            if (n2 == 2) {
                return this.m12;
            }
            if (n2 == 3) {
                return this.m13;
            }
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n2);
        }
        if (n == 2) {
            if (n2 == 0) {
                return this.m20;
            }
            if (n2 == 1) {
                return this.m21;
            }
            if (n2 == 2) {
                return this.m22;
            }
            if (n2 == 3) {
                return this.m23;
            }
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n2);
        }
        if (n == 3) {
            if (n2 == 0) {
                return this.m30;
            }
            if (n2 == 1) {
                return this.m31;
            }
            if (n2 == 2) {
                return this.m32;
            }
            if (n2 == 3) {
                return this.m33;
            }
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n2);
        }
        throw new ArrayIndexOutOfBoundsException("row must be 0 to 3 and is " + n);
    }

    public final void setScale(float f) {
        this.SVD(null, this);
        this.mulRotationScale(f);
    }

    public final List<Float> getElements() {
        ArrayList<Float> arrayList = new ArrayList<Float>(16);
        arrayList.add(Float.valueOf(this.m00));
        arrayList.add(Float.valueOf(this.m01));
        arrayList.add(Float.valueOf(this.m02));
        arrayList.add(Float.valueOf(this.m03));
        arrayList.add(Float.valueOf(this.m10));
        arrayList.add(Float.valueOf(this.m11));
        arrayList.add(Float.valueOf(this.m12));
        arrayList.add(Float.valueOf(this.m13));
        arrayList.add(Float.valueOf(this.m20));
        arrayList.add(Float.valueOf(this.m21));
        arrayList.add(Float.valueOf(this.m22));
        arrayList.add(Float.valueOf(this.m23));
        arrayList.add(Float.valueOf(this.m30));
        arrayList.add(Float.valueOf(this.m31));
        arrayList.add(Float.valueOf(this.m32));
        arrayList.add(Float.valueOf(this.m33));
        return arrayList;
    }

    public final void get(Matrix3d matrix3d) {
        this.SVD(matrix3d);
    }

    public final void get(Matrix3f matrix3f) {
        this.SVD(matrix3f, null);
    }

    public final float get(Matrix3f matrix3f, Vector3f vector3f) {
        this.get(vector3f);
        return this.SVD(matrix3f, null);
    }

    public final void get(Quat4f quat4f) {
        quat4f.set(this);
        quat4f.normalize();
    }

    public final void get(Vector3f vector3f) {
        vector3f.x = this.m03;
        vector3f.y = this.m13;
        vector3f.z = this.m23;
    }

    public final void getRotationScale(Matrix3f matrix3f) {
        matrix3f.m00 = this.m00;
        matrix3f.m01 = this.m01;
        matrix3f.m02 = this.m02;
        matrix3f.m10 = this.m10;
        matrix3f.m11 = this.m11;
        matrix3f.m12 = this.m12;
        matrix3f.m20 = this.m20;
        matrix3f.m21 = this.m21;
        matrix3f.m22 = this.m22;
    }

    public final float getScale() {
        return this.SVD(null);
    }

    public final void setRotationScale(Matrix3f matrix3f) {
        this.m00 = matrix3f.m00;
        this.m01 = matrix3f.m01;
        this.m02 = matrix3f.m02;
        this.m10 = matrix3f.m10;
        this.m11 = matrix3f.m11;
        this.m12 = matrix3f.m12;
        this.m20 = matrix3f.m20;
        this.m21 = matrix3f.m21;
        this.m22 = matrix3f.m22;
    }

    public final void setRow(int n, float f, float f2, float f3, float f4) {
        if (n == 0) {
            this.m00 = f;
            this.m01 = f2;
            this.m02 = f3;
            this.m03 = f4;
        } else if (n == 1) {
            this.m10 = f;
            this.m11 = f2;
            this.m12 = f3;
            this.m13 = f4;
        } else if (n == 2) {
            this.m20 = f;
            this.m21 = f2;
            this.m22 = f3;
            this.m23 = f4;
        } else if (n == 3) {
            this.m30 = f;
            this.m31 = f2;
            this.m32 = f3;
            this.m33 = f4;
        } else {
            throw new ArrayIndexOutOfBoundsException("row must be 0 to 3 and is " + n);
        }
    }

    public final void setRow(int n, Vector4f vector4f) {
        if (n == 0) {
            this.m00 = vector4f.x;
            this.m01 = vector4f.y;
            this.m02 = vector4f.z;
            this.m03 = vector4f.w;
        } else if (n == 1) {
            this.m10 = vector4f.x;
            this.m11 = vector4f.y;
            this.m12 = vector4f.z;
            this.m13 = vector4f.w;
        } else if (n == 2) {
            this.m20 = vector4f.x;
            this.m21 = vector4f.y;
            this.m22 = vector4f.z;
            this.m23 = vector4f.w;
        } else if (n == 3) {
            this.m30 = vector4f.x;
            this.m31 = vector4f.y;
            this.m32 = vector4f.z;
            this.m33 = vector4f.w;
        } else {
            throw new ArrayIndexOutOfBoundsException("row must be 0 to 3 and is " + n);
        }
    }

    public final void setRow(int n, float[] fArray) {
        if (n == 0) {
            this.m00 = fArray[0];
            this.m01 = fArray[1];
            this.m02 = fArray[2];
            this.m03 = fArray[3];
        } else if (n == 1) {
            this.m10 = fArray[0];
            this.m11 = fArray[1];
            this.m12 = fArray[2];
            this.m13 = fArray[3];
        } else if (n == 2) {
            this.m20 = fArray[0];
            this.m21 = fArray[1];
            this.m22 = fArray[2];
            this.m23 = fArray[3];
        } else if (n == 3) {
            this.m30 = fArray[0];
            this.m31 = fArray[1];
            this.m32 = fArray[2];
            this.m33 = fArray[3];
        } else {
            throw new ArrayIndexOutOfBoundsException("row must be 0 to 3 and is " + n);
        }
    }

    public final void getRow(int n, Vector4f vector4f) {
        if (n == 0) {
            vector4f.x = this.m00;
            vector4f.y = this.m01;
            vector4f.z = this.m02;
            vector4f.w = this.m03;
        } else if (n == 1) {
            vector4f.x = this.m10;
            vector4f.y = this.m11;
            vector4f.z = this.m12;
            vector4f.w = this.m13;
        } else if (n == 2) {
            vector4f.x = this.m20;
            vector4f.y = this.m21;
            vector4f.z = this.m22;
            vector4f.w = this.m23;
        } else if (n == 3) {
            vector4f.x = this.m30;
            vector4f.y = this.m31;
            vector4f.z = this.m32;
            vector4f.w = this.m33;
        } else {
            throw new ArrayIndexOutOfBoundsException("row must be 0 to 3 and is " + n);
        }
    }

    public final void getRow(int n, float[] fArray) {
        if (n == 0) {
            fArray[0] = this.m00;
            fArray[1] = this.m01;
            fArray[2] = this.m02;
            fArray[3] = this.m03;
        } else if (n == 1) {
            fArray[0] = this.m10;
            fArray[1] = this.m11;
            fArray[2] = this.m12;
            fArray[3] = this.m13;
        } else if (n == 2) {
            fArray[0] = this.m20;
            fArray[1] = this.m21;
            fArray[2] = this.m22;
            fArray[3] = this.m23;
        } else if (n == 3) {
            fArray[0] = this.m30;
            fArray[1] = this.m31;
            fArray[2] = this.m32;
            fArray[3] = this.m33;
        } else {
            throw new ArrayIndexOutOfBoundsException("row must be 0 to 3 and is " + n);
        }
    }

    public final void setColumn(int n, float f, float f2, float f3, float f4) {
        if (n == 0) {
            this.m00 = f;
            this.m10 = f2;
            this.m20 = f3;
            this.m30 = f4;
        } else if (n == 1) {
            this.m01 = f;
            this.m11 = f2;
            this.m21 = f3;
            this.m31 = f4;
        } else if (n == 2) {
            this.m02 = f;
            this.m12 = f2;
            this.m22 = f3;
            this.m32 = f4;
        } else if (n == 3) {
            this.m03 = f;
            this.m13 = f2;
            this.m23 = f3;
            this.m33 = f4;
        } else {
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n);
        }
    }

    public final void setColumn(int n, Vector4f vector4f) {
        if (n == 0) {
            this.m00 = vector4f.x;
            this.m10 = vector4f.y;
            this.m20 = vector4f.z;
            this.m30 = vector4f.w;
        } else if (n == 1) {
            this.m01 = vector4f.x;
            this.m11 = vector4f.y;
            this.m21 = vector4f.z;
            this.m31 = vector4f.w;
        } else if (n == 2) {
            this.m02 = vector4f.x;
            this.m12 = vector4f.y;
            this.m22 = vector4f.z;
            this.m32 = vector4f.w;
        } else if (n == 3) {
            this.m03 = vector4f.x;
            this.m13 = vector4f.y;
            this.m23 = vector4f.z;
            this.m33 = vector4f.w;
        } else {
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n);
        }
    }

    public final void setColumn(int n, float[] fArray) {
        if (n == 0) {
            this.m00 = fArray[0];
            this.m10 = fArray[1];
            this.m20 = fArray[2];
            this.m30 = fArray[3];
        } else if (n == 1) {
            this.m01 = fArray[0];
            this.m11 = fArray[1];
            this.m21 = fArray[2];
            this.m31 = fArray[3];
        } else if (n == 2) {
            this.m02 = fArray[0];
            this.m12 = fArray[1];
            this.m22 = fArray[2];
            this.m32 = fArray[3];
        } else if (n == 3) {
            this.m03 = fArray[0];
            this.m13 = fArray[1];
            this.m23 = fArray[2];
            this.m33 = fArray[3];
        } else {
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n);
        }
    }

    public final void getColumn(int n, Vector4f vector4f) {
        if (n == 0) {
            vector4f.x = this.m00;
            vector4f.y = this.m10;
            vector4f.z = this.m20;
            vector4f.w = this.m30;
        } else if (n == 1) {
            vector4f.x = this.m01;
            vector4f.y = this.m11;
            vector4f.z = this.m21;
            vector4f.w = this.m31;
        } else if (n == 2) {
            vector4f.x = this.m02;
            vector4f.y = this.m12;
            vector4f.z = this.m22;
            vector4f.w = this.m32;
        } else if (n == 3) {
            vector4f.x = this.m03;
            vector4f.y = this.m13;
            vector4f.z = this.m23;
            vector4f.w = this.m33;
        } else {
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n);
        }
    }

    public final void getColumn(int n, float[] fArray) {
        if (n == 0) {
            fArray[0] = this.m00;
            fArray[1] = this.m10;
            fArray[2] = this.m20;
            fArray[3] = this.m30;
        } else if (n == 1) {
            fArray[0] = this.m01;
            fArray[1] = this.m11;
            fArray[2] = this.m21;
            fArray[3] = this.m31;
        } else if (n == 2) {
            fArray[0] = this.m02;
            fArray[1] = this.m12;
            fArray[2] = this.m22;
            fArray[3] = this.m32;
        } else if (n == 3) {
            fArray[0] = this.m03;
            fArray[1] = this.m13;
            fArray[2] = this.m23;
            fArray[3] = this.m33;
        } else {
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n);
        }
    }

    public final void add(float f) {
        this.m00 += f;
        this.m01 += f;
        this.m02 += f;
        this.m03 += f;
        this.m10 += f;
        this.m11 += f;
        this.m12 += f;
        this.m13 += f;
        this.m20 += f;
        this.m21 += f;
        this.m22 += f;
        this.m23 += f;
        this.m30 += f;
        this.m31 += f;
        this.m32 += f;
        this.m33 += f;
    }

    public final void add(float f, Matrix4f matrix4f) {
        this.set(matrix4f);
        this.add(f);
    }

    public final void add(Matrix4f matrix4f, Matrix4f matrix4f2) {
        this.set(matrix4f);
        this.add(matrix4f2);
    }

    public final void add(Matrix4f matrix4f) {
        this.m00 += matrix4f.m00;
        this.m01 += matrix4f.m01;
        this.m02 += matrix4f.m02;
        this.m03 += matrix4f.m03;
        this.m10 += matrix4f.m10;
        this.m11 += matrix4f.m11;
        this.m12 += matrix4f.m12;
        this.m13 += matrix4f.m13;
        this.m20 += matrix4f.m20;
        this.m21 += matrix4f.m21;
        this.m22 += matrix4f.m22;
        this.m23 += matrix4f.m23;
        this.m30 += matrix4f.m30;
        this.m31 += matrix4f.m31;
        this.m32 += matrix4f.m32;
        this.m33 += matrix4f.m33;
    }

    public final void sub(Matrix4f matrix4f, Matrix4f matrix4f2) {
        this.set(matrix4f.m00 - matrix4f2.m00, matrix4f.m01 - matrix4f2.m01, matrix4f.m02 - matrix4f2.m02, matrix4f.m03 - matrix4f2.m03, matrix4f.m10 - matrix4f2.m10, matrix4f.m11 - matrix4f2.m11, matrix4f.m12 - matrix4f2.m12, matrix4f.m13 - matrix4f2.m13, matrix4f.m20 - matrix4f2.m20, matrix4f.m21 - matrix4f2.m21, matrix4f.m22 - matrix4f2.m22, matrix4f.m23 - matrix4f2.m23, matrix4f.m30 - matrix4f2.m30, matrix4f.m31 - matrix4f2.m31, matrix4f.m32 - matrix4f2.m32, matrix4f.m33 - matrix4f2.m33);
    }

    public final void sub(Matrix4f matrix4f) {
        this.m00 -= matrix4f.m00;
        this.m01 -= matrix4f.m01;
        this.m02 -= matrix4f.m02;
        this.m03 -= matrix4f.m03;
        this.m10 -= matrix4f.m10;
        this.m11 -= matrix4f.m11;
        this.m12 -= matrix4f.m12;
        this.m13 -= matrix4f.m13;
        this.m20 -= matrix4f.m20;
        this.m21 -= matrix4f.m21;
        this.m22 -= matrix4f.m22;
        this.m23 -= matrix4f.m23;
        this.m30 -= matrix4f.m30;
        this.m31 -= matrix4f.m31;
        this.m32 -= matrix4f.m32;
        this.m33 -= matrix4f.m33;
    }

    public final void transpose() {
        float f = this.m01;
        this.m01 = this.m10;
        this.m10 = f;
        f = this.m02;
        this.m02 = this.m20;
        this.m20 = f;
        f = this.m03;
        this.m03 = this.m30;
        this.m30 = f;
        f = this.m12;
        this.m12 = this.m21;
        this.m21 = f;
        f = this.m13;
        this.m13 = this.m31;
        this.m31 = f;
        f = this.m23;
        this.m23 = this.m32;
        this.m32 = f;
    }

    public final void transpose(Matrix4f matrix4f) {
        this.set(matrix4f);
        this.transpose();
    }

    public final void set(Quat4f quat4f) {
        this.setFromQuat(quat4f.x, quat4f.y, quat4f.z, quat4f.w);
    }

    public final void set(AxisAngle4f axisAngle4f) {
        this.setFromAxisAngle(axisAngle4f.x, axisAngle4f.y, axisAngle4f.z, axisAngle4f.angle);
    }

    public final void set(Quat4d quat4d) {
        this.setFromQuat(quat4d.x, quat4d.y, quat4d.z, quat4d.w);
    }

    public final void set(AxisAngle4d axisAngle4d) {
        this.setFromAxisAngle(axisAngle4d.x, axisAngle4d.y, axisAngle4d.z, axisAngle4d.angle);
    }

    public final void set(Quat4d quat4d, Vector3d vector3d, double d) {
        this.set(quat4d);
        this.mulRotationScale((float)d);
        this.m03 = (float)vector3d.x;
        this.m13 = (float)vector3d.y;
        this.m23 = (float)vector3d.z;
    }

    public final void set(Quat4f quat4f, Vector3f vector3f, float f) {
        this.set(quat4f);
        this.mulRotationScale(f);
        this.m03 = vector3f.x;
        this.m13 = vector3f.y;
        this.m23 = vector3f.z;
    }

    public final void set(Matrix4d matrix4d) {
        this.m00 = (float)matrix4d.m00;
        this.m01 = (float)matrix4d.m01;
        this.m02 = (float)matrix4d.m02;
        this.m03 = (float)matrix4d.m03;
        this.m10 = (float)matrix4d.m10;
        this.m11 = (float)matrix4d.m11;
        this.m12 = (float)matrix4d.m12;
        this.m13 = (float)matrix4d.m13;
        this.m20 = (float)matrix4d.m20;
        this.m21 = (float)matrix4d.m21;
        this.m22 = (float)matrix4d.m22;
        this.m23 = (float)matrix4d.m23;
        this.m30 = (float)matrix4d.m30;
        this.m31 = (float)matrix4d.m31;
        this.m32 = (float)matrix4d.m32;
        this.m33 = (float)matrix4d.m33;
    }

    public final void set(Matrix4f matrix4f) {
        this.m00 = matrix4f.m00;
        this.m01 = matrix4f.m01;
        this.m02 = matrix4f.m02;
        this.m03 = matrix4f.m03;
        this.m10 = matrix4f.m10;
        this.m11 = matrix4f.m11;
        this.m12 = matrix4f.m12;
        this.m13 = matrix4f.m13;
        this.m20 = matrix4f.m20;
        this.m21 = matrix4f.m21;
        this.m22 = matrix4f.m22;
        this.m23 = matrix4f.m23;
        this.m30 = matrix4f.m30;
        this.m31 = matrix4f.m31;
        this.m32 = matrix4f.m32;
        this.m33 = matrix4f.m33;
    }

    public final void invert(Matrix4f matrix4f) {
        this.set(matrix4f);
        this.invert();
    }

    public final void invert() {
        float f = this.determinant();
        if ((double)f == 0.0) {
            return;
        }
        f = 1.0f / f;
        this.set(this.m11 * (this.m22 * this.m33 - this.m23 * this.m32) + this.m12 * (this.m23 * this.m31 - this.m21 * this.m33) + this.m13 * (this.m21 * this.m32 - this.m22 * this.m31), this.m21 * (this.m02 * this.m33 - this.m03 * this.m32) + this.m22 * (this.m03 * this.m31 - this.m01 * this.m33) + this.m23 * (this.m01 * this.m32 - this.m02 * this.m31), this.m31 * (this.m02 * this.m13 - this.m03 * this.m12) + this.m32 * (this.m03 * this.m11 - this.m01 * this.m13) + this.m33 * (this.m01 * this.m12 - this.m02 * this.m11), this.m01 * (this.m13 * this.m22 - this.m12 * this.m23) + this.m02 * (this.m11 * this.m23 - this.m13 * this.m21) + this.m03 * (this.m12 * this.m21 - this.m11 * this.m22), this.m12 * (this.m20 * this.m33 - this.m23 * this.m30) + this.m13 * (this.m22 * this.m30 - this.m20 * this.m32) + this.m10 * (this.m23 * this.m32 - this.m22 * this.m33), this.m22 * (this.m00 * this.m33 - this.m03 * this.m30) + this.m23 * (this.m02 * this.m30 - this.m00 * this.m32) + this.m20 * (this.m03 * this.m32 - this.m02 * this.m33), this.m32 * (this.m00 * this.m13 - this.m03 * this.m10) + this.m33 * (this.m02 * this.m10 - this.m00 * this.m12) + this.m30 * (this.m03 * this.m12 - this.m02 * this.m13), this.m02 * (this.m13 * this.m20 - this.m10 * this.m23) + this.m03 * (this.m10 * this.m22 - this.m12 * this.m20) + this.m00 * (this.m12 * this.m23 - this.m13 * this.m22), this.m13 * (this.m20 * this.m31 - this.m21 * this.m30) + this.m10 * (this.m21 * this.m33 - this.m23 * this.m31) + this.m11 * (this.m23 * this.m30 - this.m20 * this.m33), this.m23 * (this.m00 * this.m31 - this.m01 * this.m30) + this.m20 * (this.m01 * this.m33 - this.m03 * this.m31) + this.m21 * (this.m03 * this.m30 - this.m00 * this.m33), this.m33 * (this.m00 * this.m11 - this.m01 * this.m10) + this.m30 * (this.m01 * this.m13 - this.m03 * this.m11) + this.m31 * (this.m03 * this.m10 - this.m00 * this.m13), this.m03 * (this.m11 * this.m20 - this.m10 * this.m21) + this.m00 * (this.m13 * this.m21 - this.m11 * this.m23) + this.m01 * (this.m10 * this.m23 - this.m13 * this.m20), this.m10 * (this.m22 * this.m31 - this.m21 * this.m32) + this.m11 * (this.m20 * this.m32 - this.m22 * this.m30) + this.m12 * (this.m21 * this.m30 - this.m20 * this.m31), this.m20 * (this.m02 * this.m31 - this.m01 * this.m32) + this.m21 * (this.m00 * this.m32 - this.m02 * this.m30) + this.m22 * (this.m01 * this.m30 - this.m00 * this.m31), this.m30 * (this.m02 * this.m11 - this.m01 * this.m12) + this.m31 * (this.m00 * this.m12 - this.m02 * this.m10) + this.m32 * (this.m01 * this.m10 - this.m00 * this.m11), this.m00 * (this.m11 * this.m22 - this.m12 * this.m21) + this.m01 * (this.m12 * this.m20 - this.m10 * this.m22) + this.m02 * (this.m10 * this.m21 - this.m11 * this.m20));
        this.mul(f);
    }

    public final float determinant() {
        return (this.m00 * this.m11 - this.m01 * this.m10) * (this.m22 * this.m33 - this.m23 * this.m32) - (this.m00 * this.m12 - this.m02 * this.m10) * (this.m21 * this.m33 - this.m23 * this.m31) + (this.m00 * this.m13 - this.m03 * this.m10) * (this.m21 * this.m32 - this.m22 * this.m31) + (this.m01 * this.m12 - this.m02 * this.m11) * (this.m20 * this.m33 - this.m23 * this.m30) - (this.m01 * this.m13 - this.m03 * this.m11) * (this.m20 * this.m32 - this.m22 * this.m30) + (this.m02 * this.m13 - this.m03 * this.m12) * (this.m20 * this.m31 - this.m21 * this.m30);
    }

    public final void set(Matrix3f matrix3f) {
        this.m00 = matrix3f.m00;
        this.m01 = matrix3f.m01;
        this.m02 = matrix3f.m02;
        this.m03 = 0.0f;
        this.m10 = matrix3f.m10;
        this.m11 = matrix3f.m11;
        this.m12 = matrix3f.m12;
        this.m13 = 0.0f;
        this.m20 = matrix3f.m20;
        this.m21 = matrix3f.m21;
        this.m22 = matrix3f.m22;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void set(Matrix3d matrix3d) {
        this.m00 = (float)matrix3d.m00;
        this.m01 = (float)matrix3d.m01;
        this.m02 = (float)matrix3d.m02;
        this.m03 = 0.0f;
        this.m10 = (float)matrix3d.m10;
        this.m11 = (float)matrix3d.m11;
        this.m12 = (float)matrix3d.m12;
        this.m13 = 0.0f;
        this.m20 = (float)matrix3d.m20;
        this.m21 = (float)matrix3d.m21;
        this.m22 = (float)matrix3d.m22;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void set(float f) {
        this.m00 = f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = f;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void set(float[] fArray) {
        this.m00 = fArray[0];
        this.m01 = fArray[1];
        this.m02 = fArray[2];
        this.m03 = fArray[3];
        this.m10 = fArray[4];
        this.m11 = fArray[5];
        this.m12 = fArray[6];
        this.m13 = fArray[7];
        this.m20 = fArray[8];
        this.m21 = fArray[9];
        this.m22 = fArray[10];
        this.m23 = fArray[11];
        this.m30 = fArray[12];
        this.m31 = fArray[13];
        this.m32 = fArray[14];
        this.m33 = fArray[15];
    }

    public final void set(Float[] floatArray) {
        this.m00 = floatArray[0].floatValue();
        this.m01 = floatArray[1].floatValue();
        this.m02 = floatArray[2].floatValue();
        this.m03 = floatArray[3].floatValue();
        this.m10 = floatArray[4].floatValue();
        this.m11 = floatArray[5].floatValue();
        this.m12 = floatArray[6].floatValue();
        this.m13 = floatArray[7].floatValue();
        this.m20 = floatArray[8].floatValue();
        this.m21 = floatArray[9].floatValue();
        this.m22 = floatArray[10].floatValue();
        this.m23 = floatArray[11].floatValue();
        this.m30 = floatArray[12].floatValue();
        this.m31 = floatArray[13].floatValue();
        this.m32 = floatArray[14].floatValue();
        this.m33 = floatArray[15].floatValue();
    }

    public final void set(Vector3f vector3f) {
        this.setIdentity();
        this.setTranslation(vector3f);
    }

    public final void set(float f, Vector3f vector3f) {
        this.set(f);
        this.setTranslation(vector3f);
    }

    public final void set(Vector3f vector3f, float f) {
        this.m00 = f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = f * vector3f.x;
        this.m10 = 0.0f;
        this.m11 = f;
        this.m12 = 0.0f;
        this.m13 = f * vector3f.y;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = f;
        this.m23 = f * vector3f.z;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void set(Matrix3f matrix3f, Vector3f vector3f, float f) {
        this.setRotationScale(matrix3f);
        this.mulRotationScale(f);
        this.setTranslation(vector3f);
        this.m33 = 1.0f;
    }

    public final void set(Matrix3d matrix3d, Vector3d vector3d, double d) {
        this.setRotationScale(matrix3d);
        this.mulRotationScale((float)d);
        this.setTranslation(vector3d);
        this.m33 = 1.0f;
    }

    public void setTranslation(Vector3f vector3f) {
        this.m03 = vector3f.x;
        this.m13 = vector3f.y;
        this.m23 = vector3f.z;
    }

    public final void rotX(float f) {
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = f2;
        this.m12 = -f3;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = f3;
        this.m22 = f2;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void rotY(float f) {
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        this.m00 = f2;
        this.m01 = 0.0f;
        this.m02 = f3;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = -f3;
        this.m21 = 0.0f;
        this.m22 = f2;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void rotZ(float f) {
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        this.m00 = f2;
        this.m01 = -f3;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = f3;
        this.m11 = f2;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void mul(float f) {
        this.m00 *= f;
        this.m01 *= f;
        this.m02 *= f;
        this.m03 *= f;
        this.m10 *= f;
        this.m11 *= f;
        this.m12 *= f;
        this.m13 *= f;
        this.m20 *= f;
        this.m21 *= f;
        this.m22 *= f;
        this.m23 *= f;
        this.m30 *= f;
        this.m31 *= f;
        this.m32 *= f;
        this.m33 *= f;
    }

    public final void mul(float f, Matrix4f matrix4f) {
        this.set(matrix4f);
        this.mul(f);
    }

    public final void mul(Matrix4f matrix4f) {
        this.mul(this, matrix4f);
    }

    public final void mul(Matrix4f matrix4f, Matrix4f matrix4f2) {
        this.set(matrix4f.m00 * matrix4f2.m00 + matrix4f.m01 * matrix4f2.m10 + matrix4f.m02 * matrix4f2.m20 + matrix4f.m03 * matrix4f2.m30, matrix4f.m00 * matrix4f2.m01 + matrix4f.m01 * matrix4f2.m11 + matrix4f.m02 * matrix4f2.m21 + matrix4f.m03 * matrix4f2.m31, matrix4f.m00 * matrix4f2.m02 + matrix4f.m01 * matrix4f2.m12 + matrix4f.m02 * matrix4f2.m22 + matrix4f.m03 * matrix4f2.m32, matrix4f.m00 * matrix4f2.m03 + matrix4f.m01 * matrix4f2.m13 + matrix4f.m02 * matrix4f2.m23 + matrix4f.m03 * matrix4f2.m33, matrix4f.m10 * matrix4f2.m00 + matrix4f.m11 * matrix4f2.m10 + matrix4f.m12 * matrix4f2.m20 + matrix4f.m13 * matrix4f2.m30, matrix4f.m10 * matrix4f2.m01 + matrix4f.m11 * matrix4f2.m11 + matrix4f.m12 * matrix4f2.m21 + matrix4f.m13 * matrix4f2.m31, matrix4f.m10 * matrix4f2.m02 + matrix4f.m11 * matrix4f2.m12 + matrix4f.m12 * matrix4f2.m22 + matrix4f.m13 * matrix4f2.m32, matrix4f.m10 * matrix4f2.m03 + matrix4f.m11 * matrix4f2.m13 + matrix4f.m12 * matrix4f2.m23 + matrix4f.m13 * matrix4f2.m33, matrix4f.m20 * matrix4f2.m00 + matrix4f.m21 * matrix4f2.m10 + matrix4f.m22 * matrix4f2.m20 + matrix4f.m23 * matrix4f2.m30, matrix4f.m20 * matrix4f2.m01 + matrix4f.m21 * matrix4f2.m11 + matrix4f.m22 * matrix4f2.m21 + matrix4f.m23 * matrix4f2.m31, matrix4f.m20 * matrix4f2.m02 + matrix4f.m21 * matrix4f2.m12 + matrix4f.m22 * matrix4f2.m22 + matrix4f.m23 * matrix4f2.m32, matrix4f.m20 * matrix4f2.m03 + matrix4f.m21 * matrix4f2.m13 + matrix4f.m22 * matrix4f2.m23 + matrix4f.m23 * matrix4f2.m33, matrix4f.m30 * matrix4f2.m00 + matrix4f.m31 * matrix4f2.m10 + matrix4f.m32 * matrix4f2.m20 + matrix4f.m33 * matrix4f2.m30, matrix4f.m30 * matrix4f2.m01 + matrix4f.m31 * matrix4f2.m11 + matrix4f.m32 * matrix4f2.m21 + matrix4f.m33 * matrix4f2.m31, matrix4f.m30 * matrix4f2.m02 + matrix4f.m31 * matrix4f2.m12 + matrix4f.m32 * matrix4f2.m22 + matrix4f.m33 * matrix4f2.m32, matrix4f.m30 * matrix4f2.m03 + matrix4f.m31 * matrix4f2.m13 + matrix4f.m32 * matrix4f2.m23 + matrix4f.m33 * matrix4f2.m33);
    }

    public final void mulTransposeBoth(Matrix4f matrix4f, Matrix4f matrix4f2) {
        this.mul(matrix4f2, matrix4f);
        this.transpose();
    }

    public final void mulTransposeRight(Matrix4f matrix4f, Matrix4f matrix4f2) {
        this.set(matrix4f.m00 * matrix4f2.m00 + matrix4f.m01 * matrix4f2.m01 + matrix4f.m02 * matrix4f2.m02 + matrix4f.m03 * matrix4f2.m03, matrix4f.m00 * matrix4f2.m10 + matrix4f.m01 * matrix4f2.m11 + matrix4f.m02 * matrix4f2.m12 + matrix4f.m03 * matrix4f2.m13, matrix4f.m00 * matrix4f2.m20 + matrix4f.m01 * matrix4f2.m21 + matrix4f.m02 * matrix4f2.m22 + matrix4f.m03 * matrix4f2.m23, matrix4f.m00 * matrix4f2.m30 + matrix4f.m01 * matrix4f2.m31 + matrix4f.m02 * matrix4f2.m32 + matrix4f.m03 * matrix4f2.m33, matrix4f.m10 * matrix4f2.m00 + matrix4f.m11 * matrix4f2.m01 + matrix4f.m12 * matrix4f2.m02 + matrix4f.m13 * matrix4f2.m03, matrix4f.m10 * matrix4f2.m10 + matrix4f.m11 * matrix4f2.m11 + matrix4f.m12 * matrix4f2.m12 + matrix4f.m13 * matrix4f2.m13, matrix4f.m10 * matrix4f2.m20 + matrix4f.m11 * matrix4f2.m21 + matrix4f.m12 * matrix4f2.m22 + matrix4f.m13 * matrix4f2.m23, matrix4f.m10 * matrix4f2.m30 + matrix4f.m11 * matrix4f2.m31 + matrix4f.m12 * matrix4f2.m32 + matrix4f.m13 * matrix4f2.m33, matrix4f.m20 * matrix4f2.m00 + matrix4f.m21 * matrix4f2.m01 + matrix4f.m22 * matrix4f2.m02 + matrix4f.m23 * matrix4f2.m03, matrix4f.m20 * matrix4f2.m10 + matrix4f.m21 * matrix4f2.m11 + matrix4f.m22 * matrix4f2.m12 + matrix4f.m23 * matrix4f2.m13, matrix4f.m20 * matrix4f2.m20 + matrix4f.m21 * matrix4f2.m21 + matrix4f.m22 * matrix4f2.m22 + matrix4f.m23 * matrix4f2.m23, matrix4f.m20 * matrix4f2.m30 + matrix4f.m21 * matrix4f2.m31 + matrix4f.m22 * matrix4f2.m32 + matrix4f.m23 * matrix4f2.m33, matrix4f.m30 * matrix4f2.m00 + matrix4f.m31 * matrix4f2.m01 + matrix4f.m32 * matrix4f2.m02 + matrix4f.m33 * matrix4f2.m03, matrix4f.m30 * matrix4f2.m10 + matrix4f.m31 * matrix4f2.m11 + matrix4f.m32 * matrix4f2.m12 + matrix4f.m33 * matrix4f2.m13, matrix4f.m30 * matrix4f2.m20 + matrix4f.m31 * matrix4f2.m21 + matrix4f.m32 * matrix4f2.m22 + matrix4f.m33 * matrix4f2.m23, matrix4f.m30 * matrix4f2.m30 + matrix4f.m31 * matrix4f2.m31 + matrix4f.m32 * matrix4f2.m32 + matrix4f.m33 * matrix4f2.m33);
    }

    public final void mulTransposeLeft(Matrix4f matrix4f, Matrix4f matrix4f2) {
        this.set(matrix4f.m00 * matrix4f2.m00 + matrix4f.m10 * matrix4f2.m10 + matrix4f.m20 * matrix4f2.m20 + matrix4f.m30 * matrix4f2.m30, matrix4f.m00 * matrix4f2.m01 + matrix4f.m10 * matrix4f2.m11 + matrix4f.m20 * matrix4f2.m21 + matrix4f.m30 * matrix4f2.m31, matrix4f.m00 * matrix4f2.m02 + matrix4f.m10 * matrix4f2.m12 + matrix4f.m20 * matrix4f2.m22 + matrix4f.m30 * matrix4f2.m32, matrix4f.m00 * matrix4f2.m03 + matrix4f.m10 * matrix4f2.m13 + matrix4f.m20 * matrix4f2.m23 + matrix4f.m30 * matrix4f2.m33, matrix4f.m01 * matrix4f2.m00 + matrix4f.m11 * matrix4f2.m10 + matrix4f.m21 * matrix4f2.m20 + matrix4f.m31 * matrix4f2.m30, matrix4f.m01 * matrix4f2.m01 + matrix4f.m11 * matrix4f2.m11 + matrix4f.m21 * matrix4f2.m21 + matrix4f.m31 * matrix4f2.m31, matrix4f.m01 * matrix4f2.m02 + matrix4f.m11 * matrix4f2.m12 + matrix4f.m21 * matrix4f2.m22 + matrix4f.m31 * matrix4f2.m32, matrix4f.m01 * matrix4f2.m03 + matrix4f.m11 * matrix4f2.m13 + matrix4f.m21 * matrix4f2.m23 + matrix4f.m31 * matrix4f2.m33, matrix4f.m02 * matrix4f2.m00 + matrix4f.m12 * matrix4f2.m10 + matrix4f.m22 * matrix4f2.m20 + matrix4f.m32 * matrix4f2.m30, matrix4f.m02 * matrix4f2.m01 + matrix4f.m12 * matrix4f2.m11 + matrix4f.m22 * matrix4f2.m21 + matrix4f.m32 * matrix4f2.m31, matrix4f.m02 * matrix4f2.m02 + matrix4f.m12 * matrix4f2.m12 + matrix4f.m22 * matrix4f2.m22 + matrix4f.m32 * matrix4f2.m32, matrix4f.m02 * matrix4f2.m03 + matrix4f.m12 * matrix4f2.m13 + matrix4f.m22 * matrix4f2.m23 + matrix4f.m32 * matrix4f2.m33, matrix4f.m03 * matrix4f2.m00 + matrix4f.m13 * matrix4f2.m10 + matrix4f.m23 * matrix4f2.m20 + matrix4f.m33 * matrix4f2.m30, matrix4f.m03 * matrix4f2.m01 + matrix4f.m13 * matrix4f2.m11 + matrix4f.m23 * matrix4f2.m21 + matrix4f.m33 * matrix4f2.m31, matrix4f.m03 * matrix4f2.m02 + matrix4f.m13 * matrix4f2.m12 + matrix4f.m23 * matrix4f2.m22 + matrix4f.m33 * matrix4f2.m32, matrix4f.m03 * matrix4f2.m03 + matrix4f.m13 * matrix4f2.m13 + matrix4f.m23 * matrix4f2.m23 + matrix4f.m33 * matrix4f2.m33);
    }

    public boolean equals(Matrix4f matrix4f) {
        return matrix4f != null && this.m00 == matrix4f.m00 && this.m01 == matrix4f.m01 && this.m02 == matrix4f.m02 && this.m03 == matrix4f.m03 && this.m10 == matrix4f.m10 && this.m11 == matrix4f.m11 && this.m12 == matrix4f.m12 && this.m13 == matrix4f.m13 && this.m20 == matrix4f.m20 && this.m21 == matrix4f.m21 && this.m22 == matrix4f.m22 && this.m23 == matrix4f.m23 && this.m30 == matrix4f.m30 && this.m31 == matrix4f.m31 && this.m32 == matrix4f.m32 && this.m33 == matrix4f.m33;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Matrix4f && this.equals((Matrix4f)object);
    }

    public boolean epsilonEquals(Matrix4f matrix4f, float f) {
        return Math.abs(this.m00 - matrix4f.m00) <= f && Math.abs(this.m01 - matrix4f.m01) <= f && Math.abs(this.m02 - matrix4f.m02) <= f && Math.abs(this.m03 - matrix4f.m03) <= f && Math.abs(this.m10 - matrix4f.m10) <= f && Math.abs(this.m11 - matrix4f.m11) <= f && Math.abs(this.m12 - matrix4f.m12) <= f && Math.abs(this.m13 - matrix4f.m13) <= f && Math.abs(this.m20 - matrix4f.m20) <= f && Math.abs(this.m21 - matrix4f.m21) <= f && Math.abs(this.m22 - matrix4f.m22) <= f && Math.abs(this.m23 - matrix4f.m23) <= f && Math.abs(this.m30 - matrix4f.m30) <= f && Math.abs(this.m31 - matrix4f.m31) <= f && Math.abs(this.m32 - matrix4f.m32) <= f && Math.abs(this.m33 - matrix4f.m33) <= f;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.m00) ^ Float.floatToIntBits(this.m01) ^ Float.floatToIntBits(this.m02) ^ Float.floatToIntBits(this.m03) ^ Float.floatToIntBits(this.m10) ^ Float.floatToIntBits(this.m11) ^ Float.floatToIntBits(this.m12) ^ Float.floatToIntBits(this.m13) ^ Float.floatToIntBits(this.m20) ^ Float.floatToIntBits(this.m21) ^ Float.floatToIntBits(this.m22) ^ Float.floatToIntBits(this.m23) ^ Float.floatToIntBits(this.m30) ^ Float.floatToIntBits(this.m31) ^ Float.floatToIntBits(this.m32) ^ Float.floatToIntBits(this.m33);
    }

    public final void transform(Tuple4f tuple4f, Tuple4f tuple4f2) {
        tuple4f2.set(this.m00 * tuple4f.x + this.m01 * tuple4f.y + this.m02 * tuple4f.z + this.m03 * tuple4f.w, this.m10 * tuple4f.x + this.m11 * tuple4f.y + this.m12 * tuple4f.z + this.m13 * tuple4f.w, this.m20 * tuple4f.x + this.m21 * tuple4f.y + this.m22 * tuple4f.z + this.m23 * tuple4f.w, this.m30 * tuple4f.x + this.m31 * tuple4f.y + this.m32 * tuple4f.z + this.m33 * tuple4f.w);
    }

    public final void transform(Tuple4f tuple4f) {
        this.transform(tuple4f, tuple4f);
    }

    public final void transform(Point3f point3f, Point3f point3f2) {
        point3f2.set(this.m00 * point3f.x + this.m01 * point3f.y + this.m02 * point3f.z + this.m03, this.m10 * point3f.x + this.m11 * point3f.y + this.m12 * point3f.z + this.m13, this.m20 * point3f.x + this.m21 * point3f.y + this.m22 * point3f.z + this.m23);
    }

    public final void transform(Point3f point3f) {
        this.transform(point3f, point3f);
    }

    public final void transform(Vector3f vector3f, Vector3f vector3f2) {
        vector3f2.set(this.m00 * vector3f.x + this.m01 * vector3f.y + this.m02 * vector3f.z, this.m10 * vector3f.x + this.m11 * vector3f.y + this.m12 * vector3f.z, this.m20 * vector3f.x + this.m21 * vector3f.y + this.m22 * vector3f.z);
    }

    public final void transform(Vector3f vector3f) {
        this.transform(vector3f, vector3f);
    }

    public final void setRotation(Matrix3d matrix3d) {
        float f = this.SVD(null);
        this.setRotationScale(matrix3d);
        this.mulRotationScale(f);
    }

    public final void setRotation(Matrix3f matrix3f) {
        float f = this.SVD(null);
        this.setRotationScale(matrix3f);
        this.mulRotationScale(f);
    }

    public final void setRotation(Quat4f quat4f) {
        float f = this.SVD(null, null);
        float f2 = this.m03;
        float f3 = this.m13;
        float f4 = this.m23;
        float f5 = this.m30;
        float f6 = this.m31;
        float f7 = this.m32;
        float f8 = this.m33;
        this.set(quat4f);
        this.mulRotationScale(f);
        this.m03 = f2;
        this.m13 = f3;
        this.m23 = f4;
        this.m30 = f5;
        this.m31 = f6;
        this.m32 = f7;
        this.m33 = f8;
    }

    public final void setRotation(Quat4d quat4d) {
        float f = this.SVD(null, null);
        float f2 = this.m03;
        float f3 = this.m13;
        float f4 = this.m23;
        float f5 = this.m30;
        float f6 = this.m31;
        float f7 = this.m32;
        float f8 = this.m33;
        this.set(quat4d);
        this.mulRotationScale(f);
        this.m03 = f2;
        this.m13 = f3;
        this.m23 = f4;
        this.m30 = f5;
        this.m31 = f6;
        this.m32 = f7;
        this.m33 = f8;
    }

    public final void setRotation(AxisAngle4f axisAngle4f) {
        float f = this.SVD(null, null);
        float f2 = this.m03;
        float f3 = this.m13;
        float f4 = this.m23;
        float f5 = this.m30;
        float f6 = this.m31;
        float f7 = this.m32;
        float f8 = this.m33;
        this.set(axisAngle4f);
        this.mulRotationScale(f);
        this.m03 = f2;
        this.m13 = f3;
        this.m23 = f4;
        this.m30 = f5;
        this.m31 = f6;
        this.m32 = f7;
        this.m33 = f8;
    }

    public final void setZero() {
        this.m00 = 0.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 0.0f;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 0.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 0.0f;
    }

    public final void negate() {
        this.m00 = -this.m00;
        this.m01 = -this.m01;
        this.m02 = -this.m02;
        this.m03 = -this.m03;
        this.m10 = -this.m10;
        this.m11 = -this.m11;
        this.m12 = -this.m12;
        this.m13 = -this.m13;
        this.m20 = -this.m20;
        this.m21 = -this.m21;
        this.m22 = -this.m22;
        this.m23 = -this.m23;
        this.m30 = -this.m30;
        this.m31 = -this.m31;
        this.m32 = -this.m32;
        this.m33 = -this.m33;
    }

    public final void negate(Matrix4f matrix4f) {
        this.set(matrix4f);
        this.negate();
    }

    private void set(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.m00 = f;
        this.m01 = f2;
        this.m02 = f3;
        this.m03 = f4;
        this.m10 = f5;
        this.m11 = f6;
        this.m12 = f7;
        this.m13 = f8;
        this.m20 = f9;
        this.m21 = f10;
        this.m22 = f11;
        this.m23 = f12;
        this.m30 = f13;
        this.m31 = f14;
        this.m32 = f15;
        this.m33 = f16;
    }

    private float SVD(Matrix3f matrix3f, Matrix4f matrix4f) {
        float f;
        float f2 = (float)Math.sqrt((double)(this.m00 * this.m00 + this.m10 * this.m10 + this.m20 * this.m20 + this.m01 * this.m01 + this.m11 * this.m11 + this.m21 * this.m21 + this.m02 * this.m02 + this.m12 * this.m12 + this.m22 * this.m22) / 3.0);
        float f3 = f = f2 == 0.0f ? 0.0f : 1.0f / f2;
        if (matrix3f != null) {
            this.getRotationScale(matrix3f);
            matrix3f.mul(f);
        }
        if (matrix4f != null) {
            if (matrix4f != this) {
                matrix4f.setRotationScale(this);
            }
            matrix4f.mulRotationScale(f);
        }
        return f2;
    }

    private float SVD(Matrix3d matrix3d) {
        float f;
        float f2 = (float)Math.sqrt((double)(this.m00 * this.m00 + this.m10 * this.m10 + this.m20 * this.m20 + this.m01 * this.m01 + this.m11 * this.m11 + this.m21 * this.m21 + this.m02 * this.m02 + this.m12 * this.m12 + this.m22 * this.m22) / 3.0);
        float f3 = f = f2 == 0.0f ? 0.0f : 1.0f / f2;
        if (matrix3d != null) {
            this.getRotationScale(matrix3d);
            matrix3d.mul(f);
        }
        return f2;
    }

    private void mulRotationScale(float f) {
        this.m00 *= f;
        this.m01 *= f;
        this.m02 *= f;
        this.m10 *= f;
        this.m11 *= f;
        this.m12 *= f;
        this.m20 *= f;
        this.m21 *= f;
        this.m22 *= f;
    }

    private void setRotationScale(Matrix4f matrix4f) {
        this.m00 = matrix4f.m00;
        this.m01 = matrix4f.m01;
        this.m02 = matrix4f.m02;
        this.m10 = matrix4f.m10;
        this.m11 = matrix4f.m11;
        this.m12 = matrix4f.m12;
        this.m20 = matrix4f.m20;
        this.m21 = matrix4f.m21;
        this.m22 = matrix4f.m22;
    }

    private void setRotationScale(Matrix3d matrix3d) {
        this.m00 = (float)matrix3d.m00;
        this.m01 = (float)matrix3d.m01;
        this.m02 = (float)matrix3d.m02;
        this.m10 = (float)matrix3d.m10;
        this.m11 = (float)matrix3d.m11;
        this.m12 = (float)matrix3d.m12;
        this.m20 = (float)matrix3d.m20;
        this.m21 = (float)matrix3d.m21;
        this.m22 = (float)matrix3d.m22;
    }

    private void setTranslation(Vector3d vector3d) {
        this.m03 = (float)vector3d.x;
        this.m13 = (float)vector3d.y;
        this.m23 = (float)vector3d.z;
    }

    private final void getRotationScale(Matrix3d matrix3d) {
        matrix3d.m00 = this.m00;
        matrix3d.m01 = this.m01;
        matrix3d.m02 = this.m02;
        matrix3d.m10 = this.m10;
        matrix3d.m11 = this.m11;
        matrix3d.m12 = this.m12;
        matrix3d.m20 = this.m20;
        matrix3d.m21 = this.m21;
        matrix3d.m22 = this.m22;
    }

    private void setFromQuat(double d, double d2, double d3, double d4) {
        double d5 = d * d + d2 * d2 + d3 * d3 + d4 * d4;
        double d6 = d5 > 0.0 ? 2.0 / d5 : 0.0;
        double d7 = d * d6;
        double d8 = d2 * d6;
        double d9 = d3 * d6;
        double d10 = d4 * d7;
        double d11 = d4 * d8;
        double d12 = d4 * d9;
        double d13 = d * d7;
        double d14 = d * d8;
        double d15 = d * d9;
        double d16 = d2 * d8;
        double d17 = d2 * d9;
        double d18 = d3 * d9;
        this.setIdentity();
        this.m00 = (float)(1.0 - (d16 + d18));
        this.m01 = (float)(d14 - d12);
        this.m02 = (float)(d15 + d11);
        this.m10 = (float)(d14 + d12);
        this.m11 = (float)(1.0 - (d13 + d18));
        this.m12 = (float)(d17 - d10);
        this.m20 = (float)(d15 - d11);
        this.m21 = (float)(d17 + d10);
        this.m22 = (float)(1.0 - (d13 + d16));
    }

    private void setFromAxisAngle(double d, double d2, double d3, double d4) {
        double d5 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        d5 = 1.0 / d5;
        d *= d5;
        d2 *= d5;
        d3 *= d5;
        double d6 = Math.cos(d4);
        double d7 = Math.sin(d4);
        double d8 = 1.0 - d6;
        this.m00 = (float)(d6 + d * d * d8);
        this.m11 = (float)(d6 + d2 * d2 * d8);
        this.m22 = (float)(d6 + d3 * d3 * d8);
        double d9 = d * d2 * d8;
        double d10 = d3 * d7;
        this.m01 = (float)(d9 - d10);
        this.m10 = (float)(d9 + d10);
        d9 = d * d3 * d8;
        d10 = d2 * d7;
        this.m02 = (float)(d9 + d10);
        this.m20 = (float)(d9 - d10);
        d9 = d2 * d3 * d8;
        d10 = d * d7;
        this.m12 = (float)(d9 - d10);
        this.m21 = (float)(d9 + d10);
        this.m32 = 0.0f;
        this.m31 = 0.0f;
        this.m30 = 0.0f;
        this.m23 = 0.0f;
        this.m13 = 0.0f;
        this.m03 = 0.0f;
        this.m33 = 1.0f;
    }

    public Object clone() {
        return new Matrix4f(this);
    }
}

