/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4d;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4d;

public class Vector4f
extends Tuple4f
implements Serializable {
    public Vector4f(float f, float f2, float f3, float f4) {
        super(f, f2, f3, f4);
    }

    public Vector4f(float[] fArray) {
        super(fArray);
    }

    public Vector4f(Vector4f vector4f) {
        super(vector4f);
    }

    public Vector4f(Vector4d vector4d) {
        super(vector4d);
    }

    public Vector4f(Tuple4d tuple4d) {
        super(tuple4d);
    }

    public Vector4f(Tuple4f tuple4f) {
        super(tuple4f);
    }

    public Vector4f() {
    }

    public Vector4f(Tuple3f tuple3f) {
        super(tuple3f.x, tuple3f.y, tuple3f.z, 0.0f);
    }

    public final void set(Tuple3f tuple3f) {
        this.set(tuple3f.x, tuple3f.y, tuple3f.z, 0.0f);
    }

    public final float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public final float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public final float dot(Vector4f vector4f) {
        return this.x * vector4f.x + this.y * vector4f.y + this.z * vector4f.z + this.w * vector4f.w;
    }

    public final void normalize(Vector4d vector4d) {
        this.set(vector4d);
        this.normalize();
    }

    public final void normalize() {
        double d = this.length();
        this.x = (float)((double)this.x / d);
        this.y = (float)((double)this.y / d);
        this.z = (float)((double)this.z / d);
        this.w = (float)((double)this.w / d);
    }

    public final float angle(Vector4f vector4f) {
        double d = this.dot(vector4f);
        double d2 = vector4f.length();
        double d3 = this.length();
        return (float)Math.acos(d / d2 / d3);
    }

    public Object clone() {
        return new Vector4f(this);
    }
}

