/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.data;

import de.grogra.persistence.Shareable;
import de.grogra.persistence.SharedObjectProvider;
import de.grogra.persistence.SharedObjectReference;
import de.grogra.pf.data.Datacell;
import de.grogra.pf.data.Dataseries;
import de.grogra.pf.data.DatasetAdapter;
import de.grogra.pf.data.HistogramAdapter;
import de.grogra.pf.data.StatisticsAdapter;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.ObjectSourceImpl;
import de.grogra.pf.registry.Item;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.Panel;
import de.grogra.pf.ui.Showable;
import de.grogra.pf.ui.UIToolkit;
import de.grogra.pf.ui.registry.PanelFactory;
import de.grogra.util.MimeType;
import de.grogra.xl.util.ObjectList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jfree.data.DomainOrder;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;
import org.jfree.data.statistics.HistogramBin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Dataset
implements Shareable,
Serializable,
Showable {
    public static final MimeType MIME_TYPE = MimeType.valueOf(Dataset.class);
    private static final long serialVersionUID = 4519569933099691755L;
    private transient DatasetGroup group;
    private transient ArrayList<TableModelListener> tmListeners;
    private transient SharedObjectProvider soProvider;
    private transient ObjectList refs = null;
    private String title;
    private String categoryLabel;
    private String valueLabel;
    private final ArrayList<ArrayList<Datacell>> rows = new ArrayList();
    final ArrayList<Comparable> rowKeys = new ArrayList();
    final ArrayList<Comparable> columnKeys = new ArrayList();
    final ArrayList<ArrayList<HistogramBin>> bins = new ArrayList();
    private DomainOrder order;
    boolean seriesInRows = false;
    private static final Datacell NULL_CELL = new Datacell((Dataset)null);
    private transient DatasetAdapter adapter;
    private transient HistogramAdapter histogram;
    private transient StatisticsAdapter statistics;
    private transient TableModel tableAdapter;

    public synchronized DatasetAdapter asDatasetAdapter() {
        if (this.adapter == null) {
            this.adapter = new DatasetAdapter(this);
        }
        return this.adapter;
    }

    public synchronized HistogramAdapter toHistogram() {
        if (this.histogram == null) {
            this.histogram = new HistogramAdapter(this);
        }
        return this.histogram;
    }

    public synchronized StatisticsAdapter toStatistics() {
        if (this.statistics == null) {
            this.statistics = new StatisticsAdapter(this);
        }
        return this.statistics;
    }

    public synchronized TableModel asTableModel() {
        if (this.tableAdapter == null) {
            this.tableAdapter = new Table();
        }
        return this.tableAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireDatasetChanged(Object object) {
        int n;
        int n2;
        ArrayList<TableModelListener> arrayList;
        DatasetAdapter datasetAdapter = this.asDatasetAdapter();
        HistogramAdapter histogramAdapter = this.toHistogram();
        StatisticsAdapter statisticsAdapter = this.toStatistics();
        Serializable serializable = this;
        synchronized (serializable) {
            ArrayList<TableModelListener> arrayList2 = arrayList = datasetAdapter.listeners != null ? new ArrayList<TableModelListener>(datasetAdapter.listeners) : new ArrayList();
            if (histogramAdapter.listeners != null) {
                arrayList.addAll(histogramAdapter.listeners);
            }
            if (statisticsAdapter.listeners != null) {
                arrayList.addAll(statisticsAdapter.listeners);
            }
            n2 = arrayList.size();
            if (this.tmListeners != null) {
                arrayList.addAll(this.tmListeners);
            }
        }
        if (n2 > 0) {
            serializable = new DatasetChangeEvent(object, datasetAdapter);
            for (n = 0; n < n2; ++n) {
                try {
                    ((DatasetChangeListener)arrayList.get(n)).datasetChanged((DatasetChangeEvent)serializable);
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    runtimeException.printStackTrace();
                }
            }
        }
        if (arrayList.size() > n2) {
            serializable = new TableModelEvent(this.asTableModel());
            for (n = n2; n < arrayList.size(); ++n) {
                ((TableModelListener)arrayList.get(n)).tableChanged((TableModelEvent)serializable);
            }
        }
    }

    public void initProvider(SharedObjectProvider sharedObjectProvider) {
        this.soProvider = sharedObjectProvider;
    }

    public SharedObjectProvider getProvider() {
        return this.soProvider;
    }

    public synchronized void addReference(SharedObjectReference sharedObjectReference) {
        if (this.refs == null) {
            this.refs = new ObjectList(4, false);
        }
        this.refs.add((Object)sharedObjectReference);
    }

    public synchronized void removeReference(SharedObjectReference sharedObjectReference) {
        if (this.refs != null) {
            this.refs.remove((Object)sharedObjectReference);
        }
    }

    public synchronized void appendReferencesTo(List list) {
        if (this.refs != null) {
            list.addAll(this.refs);
        }
    }

    public DatasetGroup getGroup() {
        return this.group;
    }

    public void setGroup(DatasetGroup datasetGroup) {
        this.group = datasetGroup;
    }

    public Dataset setSeriesInRows(boolean bl) {
        if (bl != this.seriesInRows) {
            this.seriesInRows = bl;
            this.fireDatasetChanged(this);
        }
        return this;
    }

    public boolean hasSeriesInRows() {
        return this.seriesInRows;
    }

    public Dataset clear() {
        this.rows.clear();
        this.columnKeys.clear();
        this.rowKeys.clear();
        return this;
    }

    private ArrayList<Datacell> getRow0(int n) {
        boolean bl = false;
        while (this.rows.size() <= n) {
            this.rows.add(new ArrayList());
            bl = true;
        }
        while (this.rowKeys.size() <= n) {
            this.rowKeys.add(this.getDefaultRowKey(this.rowKeys.size()));
            bl = true;
        }
        if (bl) {
            this.fireDatasetChanged(this);
        }
        return this.rows.get(n);
    }

    public Datacell getCell(int n, int n2) {
        ArrayList<Datacell> arrayList = this.getRow0(n);
        boolean bl = false;
        while (arrayList.size() <= n2) {
            arrayList.add(new Datacell(this));
            bl = true;
        }
        while (this.columnKeys.size() <= n2) {
            this.columnKeys.add(this.getDefaultColumnKey(this.columnKeys.size()));
            bl = true;
        }
        if (bl) {
            this.fireDatasetChanged(this);
        }
        return arrayList.get(n2);
    }

    Datacell getCellOrDefault(int n, int n2) {
        ArrayList<Datacell> arrayList;
        if (n < this.rows.size() && n2 < (arrayList = this.rows.get(n)).size()) {
            return arrayList.get(n2);
        }
        return NULL_CELL;
    }

    Datacell getCell0(int n, int n2) {
        return this.seriesInRows ? this.getCellOrDefault(n2, n) : this.getCellOrDefault(n, n2);
    }

    public boolean hasCell(int n, int n2) {
        if (n >= this.rows.size()) {
            return false;
        }
        ArrayList<Datacell> arrayList = this.rows.get(n);
        if (n2 >= arrayList.size()) {
            return false;
        }
        return !arrayList.get(n2).isNull();
    }

    boolean hasCell0(int n, int n2) {
        return this.seriesInRows ? this.hasCell(n2, n) : this.hasCell(n, n2);
    }

    public DomainOrder getDomainOrder() {
        return this.order;
    }

    public void setDomainOrder(DomainOrder domainOrder) {
        this.order = domainOrder;
        this.fireDatasetChanged(this);
    }

    public String getTitle() {
        return this.title;
    }

    public Dataset setTitle(String string) {
        this.title = string;
        return this;
    }

    public String getCategoryLabel() {
        return this.categoryLabel;
    }

    public Dataset setCategoryLabel(String string) {
        this.categoryLabel = string;
        return this;
    }

    public String getValueLabel() {
        return this.valueLabel;
    }

    public Dataset setValueLabel(String string) {
        this.valueLabel = string;
        return this;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getRowCount(int n) {
        for (int i = this.rows.size(); i > 0; --i) {
            ArrayList<Datacell> arrayList = this.rows.get(i - 1);
            if (n >= arrayList.size() || arrayList.get(n).isNull()) continue;
            return i;
        }
        return 0;
    }

    public int getColumnCount() {
        return this.rows.isEmpty() ? 0 : this.columnKeys.size();
    }

    public int getColumnCount(int n) {
        return this.getRow0(n).size();
    }

    public Dataseries getRow(int n) {
        return new Dataseries(this, false, n);
    }

    public Dataseries getColumn(int n) {
        return new Dataseries(this, true, n);
    }

    public Dataseries addRow() {
        return this.addRow(this.getDefaultRowKey(this.getRowCount()));
    }

    public Dataseries addColumn() {
        return this.addColumn(this.getDefaultColumnKey(this.getColumnCount()));
    }

    public Dataseries addRow(Comparable comparable) {
        this.setRowKey(this.getRowCount(), comparable);
        return this.getRow(this.getRowCount());
    }

    public Dataseries addColumn(Comparable comparable) {
        this.setColumnKey(this.getColumnCount(), comparable);
        return this.getColumn(this.getColumnCount());
    }

    public Dataseries operator$shl(Number number) {
        return this.addRow().set(0, number);
    }

    public Dataseries operator$shl(double[] dArray) {
        return this.addRow().operator$shl(dArray);
    }

    public Comparable getRowKey(int n) {
        return n >= this.rowKeys.size() ? null : this.rowKeys.get(n);
    }

    public Comparable getColumnKey(int n) {
        return n >= this.columnKeys.size() ? null : this.columnKeys.get(n);
    }

    public Dataset setRowKey(int n, Comparable comparable) {
        while (this.rowKeys.size() <= n) {
            this.rowKeys.add(this.getDefaultRowKey(this.rowKeys.size()));
        }
        this.rowKeys.set(n, comparable);
        this.fireDatasetChanged(this);
        return this;
    }

    public Dataset setColumnKey(int n, Comparable comparable) {
        while (this.columnKeys.size() <= n) {
            this.columnKeys.add(this.getDefaultColumnKey(this.columnKeys.size()));
        }
        this.columnKeys.set(n, comparable);
        this.fireDatasetChanged(this);
        return this;
    }

    ArrayList<HistogramBin> getBins(int n) {
        while (this.bins.size() <= n) {
            this.bins.add(new ArrayList());
        }
        return this.bins.get(n);
    }

    public Dataset setHistogramBins(int n, double d, double d2, int n2) {
        ArrayList<HistogramBin> arrayList = this.getBins(n);
        arrayList.clear();
        double d3 = (d2 - d) / (double)n2;
        for (int i = 0; i < n2; ++i) {
            arrayList.add(new HistogramBin(d + (double)i * d3, d + (double)(i + 1) * d3));
        }
        this.fireDatasetChanged(this);
        return this;
    }

    public Dataset setHistogramBins(int n, List<HistogramBin> list) {
        ArrayList<HistogramBin> arrayList = this.getBins(n);
        arrayList.clear();
        arrayList.addAll(list);
        this.fireDatasetChanged(this);
        return this;
    }

    @Override
    public void show(Context context) {
        this.showInPanel(PanelFactory.getAndShowPanel(context, "/ui/panels/table", null));
    }

    public static void export(Item item, Object object, Context context) {
        Panel panel = context.getPanel();
        if (panel == null) {
            return;
        }
        TableModel tableModel = UIToolkit.get(panel).getTable(panel.getContent());
        if (tableModel instanceof Table) {
            Dataset dataset = ((Table)tableModel).getDataset();
            context.getWorkbench().export((FilterSource)new ObjectSourceImpl((Object)dataset, dataset.getTitle(), MIME_TYPE, context.getWorkbench().getRegistry().getRootRegistry(), null));
        }
    }

    public void showInPanel(Panel panel) {
        panel.setContent(UIToolkit.get(panel).createTable(this.asTableModel(), panel));
    }

    private Comparable getDefaultColumnKey(int n) {
        return new Character((char)(n + 65));
    }

    private Comparable getDefaultRowKey(int n) {
        return Integer.valueOf(n + 1);
    }

    private final class Table
    implements TableModel {
        private Table() {
        }

        Dataset getDataset() {
            return Dataset.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addTableModelListener(TableModelListener tableModelListener) {
            Dataset dataset = Dataset.this;
            synchronized (dataset) {
                if (Dataset.this.tmListeners == null) {
                    Dataset.this.tmListeners = new ArrayList();
                }
                Dataset.this.tmListeners.add(tableModelListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeTableModelListener(TableModelListener tableModelListener) {
            Dataset dataset = Dataset.this;
            synchronized (dataset) {
                if (Dataset.this.tmListeners != null) {
                    Dataset.this.tmListeners.add(tableModelListener);
                }
            }
        }

        public int getColumnCount() {
            return Dataset.this.getColumnCount() + 1;
        }

        public int getRowCount() {
            return Dataset.this.getRowCount();
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 > 0;
        }

        public Class getColumnClass(int n) {
            return n == 0 ? Object.class : Datacell.class;
        }

        public Object getValueAt(int n, int n2) {
            return n2 == 0 ? Dataset.this.getRowKey(n) : Dataset.this.getCellOrDefault(n, n2 - 1);
        }

        public void setValueAt(Object object, int n, int n2) {
            if (object instanceof Datacell) {
                Dataset.this.getCell(n, n2 - 1).set((Datacell)object);
            }
        }

        public String getColumnName(int n) {
            return n == 0 ? "#" : String.valueOf(Dataset.this.getColumnKey(n - 1));
        }
    }
}

