/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.data;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import de.grogra.pf.data.Dataset;
import de.grogra.pf.io.FilterBase;
import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.ObjectSource;
import de.grogra.pf.io.OutputStreamSource;
import de.grogra.util.MimeType;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PDFWriter
extends FilterBase
implements OutputStreamSource {
    public static final IOFlavor FLAVOR = new IOFlavor(MimeType.PDF, 2, null);

    public PDFWriter(FilterItem filterItem, FilterSource filterSource) {
        super(filterItem, filterSource);
        this.setFlavor(FLAVOR);
    }

    public void write(OutputStream outputStream) throws IOException {
        Dataset dataset = (Dataset)((ObjectSource)this.source).getObject();
        Document document = new Document(PageSize.A4.rotate(), 50.0f, 50.0f, 50.0f, 50.0f);
        int n = dataset.getColumnCount();
        int n2 = dataset.getRowCount();
        try {
            Paragraph paragraph;
            int n3;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
            document.addAuthor("GroIMP");
            document.addSubject(dataset.getTitle());
            document.addTitle(dataset.getTitle());
            document.addCreator("GroIMP");
            document.addKeywords(dataset.getTitle());
            HeaderFooter headerFooter = new HeaderFooter(new Phrase("Created by GroIMP                   " + dataset.getTitle() + "                                        Seite "), true);
            headerFooter.setAlignment(1);
            headerFooter.setBorderWidth(0.0f);
            headerFooter.setBorderWidthTop(1.0f);
            document.setFooter(headerFooter);
            document.open();
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = 10;
            }
            PdfPTable pdfPTable = new PdfPTable(n);
            pdfPTable.setWidthPercentage(100.0f);
            pdfPTable.setWidths(nArray);
            pdfPTable.getDefaultCell().setBorderWidth(1.0f);
            pdfPTable.getDefaultCell().setBackgroundColor(Color.LIGHT_GRAY);
            pdfPTable.getDefaultCell().setHorizontalAlignment(1);
            for (n3 = 0; n3 < n; ++n3) {
                paragraph = new Paragraph(dataset.getColumnKey(n3).toString());
                pdfPTable.addCell((Phrase)paragraph);
                paragraph.font().setSize(9.0f);
            }
            pdfPTable.setHeaderRows(1);
            pdfPTable.getDefaultCell().setBackgroundColor(Color.WHITE);
            pdfPTable.getDefaultCell().setHorizontalAlignment(0);
            for (n3 = 0; n3 < n2; ++n3) {
                for (int i = 0; i < n; ++i) {
                    paragraph = new Paragraph(String.valueOf(dataset.getCell(n3, i).getX()));
                    pdfPTable.addCell((Phrase)paragraph);
                    paragraph.font().setSize(9.0f);
                }
            }
            document.add((Element)pdfPTable);
            document.close();
            byteArrayOutputStream.writeTo(outputStream);
            byteArrayOutputStream.close();
        }
        catch (DocumentException documentException) {
            documentException.printStackTrace();
        }
    }
}

