/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui;

import de.grogra.util.Utils;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Executor;

public abstract class Synchronizer
implements Runnable,
Executor {
    private Callback callback;
    private Thread thread;
    private int action;
    private int iarg;
    private Object oarg1;
    private Object oarg2;

    public Synchronizer() {
    }

    public Synchronizer(Callback callback) {
        this.initCallback(callback);
    }

    public void initCallback(Callback callback) {
        if (this.callback != null) {
            throw new IllegalStateException("Callback already initialized");
        }
        this.callback = callback;
    }

    public Object invokeAndWait(int n) {
        return this.invokeAndWait(n, 0, null, null);
    }

    public Object invokeAndWait(int n, Object object) {
        return this.invokeAndWait(n, 0, object, null);
    }

    public Object invokeAndWait(final int n, final int n2, final Object object, final Object object2) {
        if (this.isDispatchThread()) {
            return this.callback.run(n, n2, object, object2);
        }
        if (this.thread == null) {
            this.thread = Thread.currentThread();
        } else if (this.thread != Thread.currentThread()) {
            try {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class Action
                implements Runnable {
                    Object result;

                    Action() {
                    }

                    @Override
                    public void run() {
                        this.result = Synchronizer.this.callback.run(n, n2, object, object2);
                    }
                }
                Action action = new Action();
                this.invokeAndWait(action);
                return action.result;
            }
            catch (InvocationTargetException invocationTargetException) {
                Utils.rethrow((Throwable)invocationTargetException.getCause());
                throw new AssertionError();
            }
        }
        this.action = n;
        this.iarg = n2;
        this.oarg1 = object;
        this.oarg2 = object2;
        try {
            this.invokeAndWait(this);
            Object object3 = this.oarg1;
            return object3;
        }
        catch (InvocationTargetException invocationTargetException) {
            Utils.rethrow((Throwable)invocationTargetException.getCause());
            throw new AssertionError();
        }
        finally {
            this.oarg1 = null;
            this.oarg2 = null;
        }
    }

    public void run() {
        this.oarg1 = this.callback.run(this.action, this.iarg, this.oarg1, this.oarg2);
    }

    protected abstract boolean isDispatchThread();

    protected abstract void invokeAndWait(Runnable var1) throws InvocationTargetException;

    public static interface Callback {
        public Object run(int var1, int var2, Object var3, Object var4);
    }
}

