/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui;

import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.event.UIPropertyEditEvent;
import de.grogra.util.EventListener;
import de.grogra.util.StringMap;
import de.grogra.xl.util.ObjectList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;

public class UIProperty {
    public static final int WORKBENCH = 0;
    public static final int WINDOW = 1;
    public static final int PANEL = 2;
    private static final StringMap PROPERTIES = new StringMap(40);
    public static final UIProperty WORKBENCH_TITLE = new UIProperty("workbenchTitle", 0);
    public static final UIProperty PANEL_TITLE = new UIProperty("panelTitle", 2);
    public static final UIProperty ICON = new UIProperty("icon", 2);
    public static final UIProperty WINDOW_LAYOUT = new UIProperty("windowLayout", 1);
    public static final UIProperty WORKBENCH_SELECTION = new UIProperty("workbenchSelection", 0);
    private final int source;
    private final String name;
    private final boolean postEvent;
    private final Map globalListeners = new HashMap();
    private static final Command FIRE = new Command(){

        public String getCommandName() {
            return null;
        }

        public void run(Object object, Context context) {
            UIProperty.fireImpl(object, (UIPropertyEditEvent)context);
        }
    };

    protected UIProperty(String string, int n) {
        this(string, n, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UIProperty(String string, int n, boolean bl) {
        this.name = string;
        this.source = n;
        this.postEvent = bl;
        StringMap stringMap = PROPERTIES;
        synchronized (stringMap) {
            if (PROPERTIES.put(string, (Object)this) != null) {
                throw new IllegalStateException("UIProperty " + string + " already registered");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UIProperty get(String string, String string2, ClassLoader classLoader) {
        StringMap stringMap = PROPERTIES;
        synchronized (stringMap) {
            UIProperty uIProperty = (UIProperty)PROPERTIES.get(string);
            if (uIProperty == null) {
                try {
                    Class.forName(string2, true, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
                uIProperty = (UIProperty)PROPERTIES.get(string);
            }
            return uIProperty;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UIProperty getOrCreate(String string, int n) {
        StringMap stringMap = PROPERTIES;
        synchronized (stringMap) {
            UIProperty uIProperty = (UIProperty)PROPERTIES.get(string);
            if (uIProperty == null) {
                uIProperty = new UIProperty(string, n);
            }
            return uIProperty;
        }
    }

    public static int getSource(String string) {
        return string.equals("workbench") ? 0 : (string.equals("window") ? 1 : (string.equals("panel") ? 2 : -1));
    }

    public Context getSource(Context context) {
        switch (this.source) {
            case 0: {
                return context.getWorkbench();
            }
            case 1: {
                return context.getWindow();
            }
            case 2: {
                return context.getPanel().resolve();
            }
        }
        throw new IllegalStateException("source == " + this.source);
    }

    private Map getMap(Context context) {
        switch (this.source) {
            case 0: {
                return context.getWorkbench().propertyMap;
            }
            case 1: {
                return context.getWindow().getUIPropertyMap();
            }
            case 2: {
                return context.getPanel().getUIPropertyMap();
            }
        }
        throw new IllegalStateException("source == " + this.source);
    }

    protected Object initialValue(Context context) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getArray(Map map) {
        Object v;
        Map map2 = map;
        synchronized (map2) {
            v = map.get(this);
        }
        return v != null ? (Object[])v : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getOrCreateArray(Map map) {
        Object object;
        Map map2 = map;
        synchronized (map2) {
            object = map.get(this);
            if (object == null) {
                object = new Object[2];
                map.put(this, object);
            }
        }
        return (Object[])object;
    }

    private Object getListener(Map map) {
        Object[] objectArray = this.getArray(map);
        return objectArray != null ? objectArray[0] : null;
    }

    public synchronized void firePropertyChange(Context context, Object object, Object object2, Object object3) {
        Map map = this.getMap(context);
        Object object4 = this.getListener(map);
        UIPropertyEditEvent uIPropertyEditEvent = null;
        if (object4 != null) {
            uIPropertyEditEvent = new UIPropertyEditEvent(context, this, object, object2, object3);
            this.firePropertyChange(object4, uIPropertyEditEvent);
        }
        if ((object4 = this.getListener(this.globalListeners)) != null) {
            if (uIPropertyEditEvent == null) {
                uIPropertyEditEvent = new UIPropertyEditEvent(context, this, object, object2, object3);
            }
            this.firePropertyChange(object4, uIPropertyEditEvent);
        }
    }

    private void firePropertyChange(Object objectArray, UIPropertyEditEvent uIPropertyEditEvent) {
        if (objectArray instanceof ObjectList) {
            objectArray = ((ObjectList)objectArray).toArray();
        }
        if (this.postEvent || !UI.getThreadContext(uIPropertyEditEvent).isCurrent()) {
            UI.getJobManager(uIPropertyEditEvent).runLater(FIRE, objectArray, uIPropertyEditEvent, 70536);
        } else {
            UIProperty.fireImpl(objectArray, uIPropertyEditEvent);
        }
    }

    static void fireImpl(Object object, UIPropertyEditEvent uIPropertyEditEvent) {
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                ((EventListener)objectArray[i]).eventOccured((EventObject)uIPropertyEditEvent);
            }
        } else if (object != null) {
            ((EventListener)object).eventOccured((EventObject)uIPropertyEditEvent);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setValue(Context context, Object object) {
        Map map = this.getMap(context);
        Object[] objectArray = this.getOrCreateArray(map);
        Object object2 = objectArray[1];
        Object object3 = objectArray[1] = object == null ? PROPERTIES : object;
        if (object2 == PROPERTIES) {
            object2 = null;
        }
        if (!(object2 == object || object2 != null && object2.equals(object))) {
            this.firePropertyChange(context, object2, object, null);
        }
    }

    public Object getValue(Context context) {
        Map map = this.getMap(context);
        Object[] objectArray = this.getOrCreateArray(map);
        Object object = objectArray[1];
        if (object == null) {
            object = this.initialValue(context);
            objectArray[1] = object == null ? PROPERTIES : object;
            return object;
        }
        if (object == PROPERTIES) {
            return null;
        }
        return object;
    }

    public synchronized void addPropertyListener(Context context, EventListener eventListener) {
        Map map = context == null ? this.globalListeners : this.getMap(context);
        Object object = this.getListener(map);
        if (object != null && object.getClass() == ObjectList.class) {
            ((ObjectList)object).addIfNotContained((Object)eventListener);
        } else if (object != null && object != eventListener) {
            ObjectList objectList = new ObjectList(5, false);
            objectList.add(object);
            objectList.addIfNotContained((Object)eventListener);
            this.getArray((Map)map)[0] = objectList;
        } else {
            this.getOrCreateArray((Map)map)[0] = eventListener;
        }
    }

    public synchronized void removePropertyListener(Context context, EventListener eventListener) {
        Map map = context == null ? this.globalListeners : this.getMap(context);
        Object object = this.getListener(map);
        if (object == eventListener) {
            this.getArray((Map)map)[0] = null;
        } else if (object != null && object.getClass() == ObjectList.class) {
            ((ObjectList)object).remove((Object)eventListener);
        }
    }
}

