/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.edit;

import de.grogra.icon.IconSource;
import de.grogra.persistence.PersistenceField;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.edit.FieldProperty;
import de.grogra.pf.ui.edit.Property;
import de.grogra.pf.ui.edit.PropertyEditor;
import de.grogra.pf.ui.edit.PropertyEditorTree;
import de.grogra.pf.ui.edit.SelectionBase;
import de.grogra.pf.ui.tree.RegistryAdapter;
import de.grogra.pf.ui.tree.UITree;
import de.grogra.util.Described;
import java.util.ArrayList;
import java.util.List;

public abstract class FieldSelection
extends SelectionBase {
    final Item description;
    final Object object;
    final PropertyEditor[] editors;
    final PersistenceField[] fields;
    final int[][] indices;
    final String[] labels;

    public FieldSelection(Context context, Object object, PersistenceField[] persistenceFieldArray, int[][] object2, PropertyEditor[] propertyEditorArray, String[] stringArray, Item item) {
        super(context);
        this.object = object;
        this.fields = persistenceFieldArray;
        if (object2 == null) {
            object2 = new int[persistenceFieldArray.length][];
        }
        this.indices = object2;
        this.editors = propertyEditorArray;
        this.labels = stringArray;
        this.description = item;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FieldSelection)) {
            return false;
        }
        FieldSelection fieldSelection = (FieldSelection)object;
        if (this.object != fieldSelection.object || this.fields.length != fieldSelection.fields.length) {
            return false;
        }
        for (int i = this.fields.length - 1; i >= 0; --i) {
            if (this.fields[i] != fieldSelection.fields[i]) {
                return false;
            }
            if (this.indices[i] == fieldSelection.indices[i]) continue;
            int[] nArray = this.indices[i];
            int[] nArray2 = fieldSelection.indices[i];
            if (nArray == null || nArray2 == null || nArray.length != nArray2.length) {
                return false;
            }
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] == nArray2[j]) continue;
                return false;
            }
        }
        return true;
    }

    public Object getDescription(String string) {
        if (this.description != null) {
            return this.description.getDescription(string);
        }
        if (this.object instanceof Described) {
            return ((Described)this.object).getDescription(string);
        }
        if ("Icon".equals(string) && this.object instanceof IconSource) {
            return this.object;
        }
        return null;
    }

    protected UITree getHierarchySource() {
        return new RegistryAdapter(this.context);
    }

    protected Object getHierarchySourceRoot(UITree uITree) {
        return Item.resolveItem((RegistryContext)UI.getRegistry(this.context), (String)"/attributes");
    }

    protected PropertyEditorTree.Node createPropertyNodes(PropertyEditorTree propertyEditorTree, Property property, UITree uITree, Object object) {
        return null;
    }

    protected PropertyEditorTree.Node createPropertyNodesInGroup(PropertyEditorTree propertyEditorTree, Property property, UITree uITree, Object object) {
        return ((Item)object).hasName("attributes") ? this.createPropertyNodes(propertyEditorTree, property, null) : null;
    }

    protected String getLabelFor(Property property) {
        int n = ((FieldProperty)property).index;
        return n >= 0 && this.labels != null ? this.labels[n] : null;
    }

    protected PropertyEditor getEditorFor(Property property, Item item) {
        int n = ((FieldProperty)property).index;
        return n >= 0 && this.editors != null ? this.editors[n] : super.getEditorFor(property, item);
    }

    protected List getProperties(PropertyEditorTree propertyEditorTree) {
        ArrayList<FieldProperty> arrayList = new ArrayList<FieldProperty>(this.fields.length);
        for (int i = 0; i < this.fields.length; ++i) {
            arrayList.add(this.createProperty(propertyEditorTree.getContext(), i));
        }
        return arrayList;
    }

    protected abstract FieldProperty createProperty(Context var1, int var2);
}

