/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.registry;

import de.grogra.graph.impl.Node;
import de.grogra.persistence.ManageableType;
import de.grogra.pf.registry.Directory;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.Link;
import de.grogra.pf.registry.PluginDescriptor;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.registry.expr.Exists;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.registry.ExplorerFactory;
import de.grogra.reflect.Type;
import de.grogra.util.Described;

public final class ResourceDirectory
extends Item {
    private static final int CREATE_EXPLORER_MASK = 2048;
    private static final int CREATE_PROJECT_DIRECTORY_MASK = 4096;
    public static final int USED_BITS = 13;
    public static final Node.NType $TYPE = new Node.NType((Node)new ResourceDirectory());
    public static final Node.NType.Field createExplorer$FIELD = new Node.NType.BitField($TYPE, "createExplorer", 0x200000, Type.BOOLEAN, 2048);
    public static final Node.NType.Field createProjectDirectory$FIELD;

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new ResourceDirectory();
    }

    private ResourceDirectory() {
        this(null);
    }

    public ResourceDirectory(String string) {
        super(string);
        this.setDirectory();
        this.bits |= 0x1800;
    }

    public static void installExplorers(Registry registry) {
        ResourceDirectory.installExplorers0(ResourceDirectory.resolveItem((RegistryContext)registry, (String)"/objects"));
    }

    private static Item getDirectory(Item item, Item item2, PluginDescriptor pluginDescriptor) {
        Item item3 = (Item)item2.getAxisParent();
        if (item3 == null) {
            return item;
        }
        if ((item3 = (item = ResourceDirectory.getDirectory(item, item3, pluginDescriptor)).getItem((CharSequence)item2.getName())) != null) {
            return item3;
        }
        item3 = new Directory(item2.getName(), true).initPluginDescriptor(pluginDescriptor);
        item3.setDefaultDescription((Described)item2);
        item.add(item3);
        return item3;
    }

    private static void installExplorers0(Item item) {
        if (item instanceof ResourceDirectory) {
            ResourceDirectory resourceDirectory = (ResourceDirectory)item;
            String string = resourceDirectory.getAbsoluteName();
            PluginDescriptor pluginDescriptor = resourceDirectory.getPluginDescriptor();
            if ((resourceDirectory.bits & 0x800) != 0) {
                ExplorerFactory explorerFactory = new ExplorerFactory(resourceDirectory.getName(), resourceDirectory.getBaseName(), string, "/project" + string);
                explorerFactory.initPluginDescriptor(pluginDescriptor).setDefaultDescription((Described)resourceDirectory);
                ResourceDirectory.getDirectory(resourceDirectory.getRegistry().getDirectory("/ui/panels", pluginDescriptor), (Item)resourceDirectory.getAxisParent(), pluginDescriptor).add(explorerFactory.add(new Exists(".available", "/project").initPluginDescriptor(pluginDescriptor)).add(new Link("menu", "/ui/explorer/menu").initPluginDescriptor(pluginDescriptor)));
            }
            if ((resourceDirectory.bits & 0x1000) != 0) {
                resourceDirectory.insertBranchNode(0, (Node)new Link("project", "/project" + string));
            }
        } else {
            for (item = (Item)item.getBranch(); item != null; item = (Item)item.getSuccessor()) {
                ResourceDirectory.installExplorers0(item);
            }
        }
    }

    public static void configure(Registry registry) {
        ResourceDirectory.configure0(registry, ResourceDirectory.resolveItem((RegistryContext)registry, (String)"/objects"));
    }

    private static void configure0(Registry registry, Item item) {
        if (item instanceof ResourceDirectory) {
            ResourceDirectory resourceDirectory = (ResourceDirectory)item;
            if ((resourceDirectory.bits & 0x1000) != 0) {
                item = registry.getDirectory("/project" + resourceDirectory.getAbsoluteName(), resourceDirectory.getPluginDescriptor());
                if (item.hasName((String)item.getDescription("Name"))) {
                    item.setDescription("Name", (Object)UI.I18N.msg("projectresource", resourceDirectory.getDescription("Name")));
                }
                item.setDefaultDescription((Described)resourceDirectory);
            }
        } else {
            for (item = (Item)item.getBranch(); item != null; item = (Item)item.getSuccessor()) {
                ResourceDirectory.configure0(registry, item);
            }
        }
    }

    public Item getProjectDirectory(RegistryContext registryContext) {
        return ResourceDirectory.resolveItem((RegistryContext)registryContext, (String)("/project" + this.getAbsoluteName()));
    }

    public String getBaseName() {
        String string = (String)this.getDescription("Base");
        if (string == null && (string = this.getName()).endsWith("s")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static ResourceDirectory get(Item item) {
        while (item != null && !(item instanceof ResourceDirectory)) {
            item = (Item)item.getAxisParent();
        }
        return (ResourceDirectory)item;
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)createExplorer$FIELD);
        createProjectDirectory$FIELD = new Node.NType.BitField($TYPE, "createProjectDirectory", 0x200000, Type.BOOLEAN, 4096);
        $TYPE.addManagedField((ManageableType.Field)createProjectDirectory$FIELD);
        $TYPE.validate();
    }
}

