/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.data.KeyedObject;
import org.jfree.util.PublicCloneable;

public class KeyedObjects
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 1321582394193530984L;
    private List data = new ArrayList();

    public int getItemCount() {
        return this.data.size();
    }

    public Object getObject(int n) {
        KeyedObject keyedObject;
        Object object = null;
        if (n >= 0 && n < this.data.size() && (keyedObject = (KeyedObject)this.data.get(n)) != null) {
            object = keyedObject.getObject();
        }
        return object;
    }

    public Comparable getKey(int n) {
        KeyedObject keyedObject;
        Comparable comparable = null;
        if (n >= 0 && n < this.data.size() && (keyedObject = (KeyedObject)this.data.get(n)) != null) {
            comparable = keyedObject.getKey();
        }
        return comparable;
    }

    public int getIndex(Comparable comparable) {
        int n = -1;
        int n2 = 0;
        for (KeyedObject keyedObject : this.data) {
            if (keyedObject.getKey().equals(comparable)) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public List getKeys() {
        ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
        for (KeyedObject keyedObject : this.data) {
            arrayList.add(keyedObject.getKey());
        }
        return arrayList;
    }

    public Object getObject(Comparable comparable) {
        return this.getObject(this.getIndex(comparable));
    }

    public void addObject(Comparable comparable, Object object) {
        this.setObject(comparable, object);
    }

    public void setObject(Comparable comparable, Object object) {
        int n = this.getIndex(comparable);
        if (n >= 0) {
            KeyedObject keyedObject = (KeyedObject)this.data.get(n);
            keyedObject.setObject(object);
        } else {
            KeyedObject keyedObject = new KeyedObject(comparable, object);
            this.data.add(keyedObject);
        }
    }

    public void removeValue(int n) {
        this.data.remove(n);
    }

    public void removeValue(Comparable comparable) {
        this.removeValue(this.getIndex(comparable));
    }

    public Object clone() throws CloneNotSupportedException {
        KeyedObjects keyedObjects = (KeyedObjects)super.clone();
        keyedObjects.data = new ArrayList();
        for (KeyedObject keyedObject : this.data) {
            keyedObjects.data.add(keyedObject.clone());
        }
        return keyedObjects;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof KeyedObjects)) {
            return false;
        }
        KeyedObjects keyedObjects = (KeyedObjects)object;
        int n = this.getItemCount();
        if (n != keyedObjects.getItemCount()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Comparable comparable;
            Comparable comparable2 = this.getKey(i);
            if (!comparable2.equals(comparable = keyedObjects.getKey(i))) {
                return false;
            }
            Object object2 = this.getObject(i);
            Object object3 = keyedObjects.getObject(i);
            if (!(object2 == null ? object3 != null : !object2.equals(object3))) continue;
            return false;
        }
        return true;
    }
}

