/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.Serializable;
import org.jfree.util.Log;

public class WaitingImageObserver
implements ImageObserver,
Serializable,
Cloneable {
    static final long serialVersionUID = -807204410581383550L;
    private boolean lock;
    private Image image;
    private boolean error;

    public WaitingImageObserver(Image image) {
        if (image == null) {
            throw new NullPointerException();
        }
        this.image = image;
        this.lock = true;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x20) == 32) {
            this.lock = false;
            this.error = false;
        } else if ((n & 0x80) == 128 || (n & 0x40) == 64) {
            this.lock = false;
            this.error = true;
        }
        return true;
    }

    public void waitImageLoaded() {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 1);
        Graphics graphics = bufferedImage.getGraphics();
        while (this.lock) {
            if (graphics.drawImage(this.image, 0, 0, bufferedImage.getWidth(this), bufferedImage.getHeight(this), this)) {
                return;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                Log.info("WaitingImageObserver.waitImageLoaded(): InterruptedException thrown", interruptedException);
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        WaitingImageObserver waitingImageObserver = (WaitingImageObserver)super.clone();
        return waitingImageObserver;
    }

    public boolean isError() {
        return this.error;
    }
}

