/*
 * Decompiled with CFR 0.152.
 */
package raskob.geometry;

import java.util.ArrayList;
import java.util.Vector;
import pi6.geom.Delaunay2;
import pi6.geom.Point2;
import pi6.geom.Polygon2;
import raskob.geometry.Density1;
import raskob.geometry.MassCenter;
import raskob.geometry.MathP;
import raskob.geometry.Point;
import raskob.geometry.Polygon;

public final class Voronoi {
    private ArrayList pointset = new ArrayList();
    private Delaunay2 d = new Delaunay2();
    private Polygon cachePolygon = null;
    private Polygon lastPol = null;
    private boolean dirtyPolygon = true;
    private ArrayList vdInsec = new ArrayList();
    private ArrayList vdMc = new ArrayList();
    private ArrayList vdPol = new ArrayList();
    private ArrayList weight = new ArrayList();

    public Voronoi(Polygon pol) {
        this.refresh(pol);
    }

    private void refresh() {
        this.refresh(this.lastPol);
    }

    private void refresh(Polygon pol) {
        this.lastPol = pol;
        if (this.dirtyPolygon) {
            this.vdInsec = new ArrayList();
            this.vdMc = new ArrayList();
            this.vdPol = new ArrayList();
            int i = 0;
            while (i < this.size()) {
                double area;
                Point site = this.get(i);
                Polygon thispol = this.getRegion(site);
                this.vdPol.add(thispol);
                Polygon ipol = null;
                MassCenter mc = null;
                if (thispol != null) {
                    ipol = pol.getIntersection(thispol, false);
                }
                this.vdInsec.add(ipol);
                if (ipol != null && !MathP.equals(0.0, area = ipol.getArea(new Density1()))) {
                    mc = ipol.getMassCenter(new Density1());
                }
                this.vdMc.add(mc);
                ++i;
            }
            this.cachePolygon = null;
            this.dirtyPolygon = false;
        }
    }

    private boolean contains(Point p) {
        int i = 0;
        while (i < this.size()) {
            Point q = (Point)this.pointset.get(i);
            if (p.equals(q)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final void insertSite(Point p) {
        if (this.contains(p)) {
            return;
        }
        this.d.insertSite(Voronoi.pointToPoint2(p));
        this.pointset.add(p);
        this.weight.add(new Long(0L));
        this.dirtyPolygon = true;
    }

    private Polygon getRegion(Point findSite) {
        Vector regions = this.d.getVoronoiRegions();
        if (regions == null) {
            return null;
        }
        int i = 0;
        while (i < regions.size()) {
            Point site = Voronoi.point2ToPoint((Point2)regions.get(i));
            if (site.equals(findSite)) {
                Polygon2 region = (Polygon2)regions.get(i + 1);
                Vector points = region.getPoints();
                Polygon regpol = new Polygon(null);
                Point oldP = null;
                if (points.size() > 1) {
                    oldP = Voronoi.point2ToPoint((Point2)points.get(points.size() - 1));
                    oldP.round();
                }
                int j = 0;
                while (j < points.size()) {
                    Point p = Voronoi.point2ToPoint((Point2)points.get(j));
                    p.round();
                    if (!oldP.equals(p)) {
                        regpol.add(p);
                    }
                    oldP = p;
                    ++j;
                }
                return regpol;
            }
            i += 2;
        }
        return null;
    }

    public final Point get(int i) {
        return (Point)this.pointset.get(i);
    }

    public final int size() {
        return this.pointset.size();
    }

    private static Point point2ToPoint(Point2 p2) {
        return new Point(p2.getX(), p2.getY());
    }

    private static Point2 pointToPoint2(Point p) {
        return new Point2(p.getX(), p.getY());
    }

    public final void lloydIterate(int iterationen) {
        int j = 0;
        while (j < iterationen) {
            if (this.dirtyPolygon) {
                this.refresh();
            }
            if (this.size() <= 4) {
                return;
            }
            Voronoi vdnew = new Voronoi(this.lastPol);
            int i = 0;
            while (i < this.size()) {
                Point site = this.get(i);
                site.round();
                MassCenter mc = (MassCenter)this.vdMc.get(i);
                if (mc != null && !Double.isNaN(mc.getX()) && !Double.isNaN(mc.getY())) {
                    mc.round();
                    vdnew.insertSite(mc);
                    vdnew.weight.set(i, (Long)this.weight.get(i));
                } else {
                    vdnew.insertSite(site);
                    vdnew.weight.set(i, (Long)this.weight.get(i));
                }
                ++i;
            }
            this.copyFrom(vdnew);
            this.cachePolygon = null;
            this.dirtyPolygon = true;
            this.refresh();
            ++j;
        }
    }

    private void copyFrom(Voronoi vd) {
        this.pointset = vd.pointset;
        this.d = vd.d;
        this.cachePolygon = vd.cachePolygon;
        this.lastPol = vd.lastPol;
        this.dirtyPolygon = vd.dirtyPolygon;
        this.vdInsec = vd.vdInsec;
        this.vdMc = vd.vdMc;
        this.vdPol = vd.vdPol;
        this.weight = vd.weight;
    }
}

