/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.property;

import de.grogra.xl.property.RuntimeModel;
import java.util.HashMap;

public class RuntimeModelFactory {
    private static RuntimeModelFactory factory;
    private final HashMap<String, RuntimeModel> models = new HashMap();

    public static synchronized RuntimeModelFactory getInstance() {
        if (factory == null) {
            factory = new RuntimeModelFactory();
        }
        return factory;
    }

    public static synchronized void setInstance(RuntimeModelFactory runtimeModelFactory) {
        factory = runtimeModelFactory;
    }

    public synchronized boolean defineModel(String string, RuntimeModel runtimeModel) {
        this.models.put(string, runtimeModel);
        return true;
    }

    public final synchronized RuntimeModel modelForName(String string, ClassLoader classLoader) {
        RuntimeModel runtimeModel = this.models.get(string);
        if (runtimeModel == null) {
            runtimeModel = this.modelForNameImpl(string, classLoader);
            if (runtimeModel == null) {
                throw new NoClassDefFoundError(string);
            }
            this.models.put(string, runtimeModel);
        }
        return runtimeModel;
    }

    protected RuntimeModel modelForNameImpl(String string, ClassLoader classLoader) {
        try {
            int n = string.indexOf(58);
            RuntimeModel runtimeModel = (RuntimeModel)Class.forName(n < 0 ? string : string.substring(0, n), true, classLoader).newInstance();
            runtimeModel.initialize(n < 0 ? null : string.substring(n + 1));
            return runtimeModel;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

