/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.grogra;

import de.grogra.graph.Graph;
import de.grogra.graph.GraphState;
import de.grogra.graph.impl.Edge;
import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.Node;
import de.grogra.graph.impl.TreeIterator;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.Transaction;
import de.grogra.pf.data.Dataseries;
import de.grogra.pf.data.Dataset;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.registry.CommandItem;
import de.grogra.reflect.Method;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.rgg.Library;
import de.grogra.rgg.RGG;
import de.grogra.rgg.model.RGGGraph;
import de.grogra.rgg.model.RGGProducer;
import de.grogra.rgg.model.Runtime;
import de.grogra.turtle.Attributes;
import de.grogra.turtle.F;
import de.grogra.turtle.K;
import de.grogra.turtle.KAssignment;
import de.grogra.turtle.KL;
import de.grogra.turtle.Shoot;
import de.grogra.turtle.TurtleState;
import de.grogra.vecmath.CutConeParameter;
import de.grogra.vecmath.CutRay2Parameter;
import de.grogra.vecmath.Math2;
import de.grogra.vecmath.Matrix34d;
import de.grogra.xl.lang.VoidConsumer;
import de.grogra.xl.util.Operators;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import java.util.HashMap;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class LSystem
extends RGG {
    public float angle = 90.0f;
    public int generation = 90;
    public float r0;
    public float r1;
    public float r2;
    public float r3;
    public float r4;
    public float r5;
    public float r6;
    public float r7;
    public float r8;
    public float r9;
    private Dataset shootPopulation = new Dataset();
    private int generationCounter;
    private TurtleState interpretationState = new TurtleState();
    private Method derivation = null;
    private Method interpretation = null;
    protected float[] defaultValuesForLocalRegisters;
    private Shoot refShoot;
    public Node currentNode;
    private boolean derivationActive;
    private static final double D2R = Math.PI / 180;
    private static final double R2D = 57.29577951308232;
    private static final int REG_ID = Registry.allocatePropertyId();
    public static final Node.NType $TYPE = new Node.NType((Node)new LSystem());
    public static final Node.NType.Field angle$FIELD = new _Field("angle", 0x200001, Type.FLOAT, null, 0);
    public static final Node.NType.Field generation$FIELD;

    protected void reset() {
        super.reset();
        generation$FIELD.setInt((Object)this, null, 0, this.getGraph().getActiveTransaction());
    }

    public LSystem() {
        this.shootPopulation.setTitle("shoot population");
        this.shootPopulation.setColumnKey(0, (Comparable)((Object)"Generation")).setColumnKey(1, (Comparable)((Object)"Shoots for color 1")).setColumnKey(2, (Comparable)((Object)"Shoots for color 2")).setColumnKey(3, (Comparable)((Object)"Shoots for color 3")).setColumnKey(4, (Comparable)((Object)"Shoots for color 4")).setColumnKey(5, (Comparable)((Object)"Shoots for color 5")).setColumnKey(6, (Comparable)((Object)"Shoots for color 6")).setColumnKey(7, (Comparable)((Object)"Shoots for color 7")).setColumnKey(8, (Comparable)((Object)"Shoots for color 8")).setColumnKey(9, (Comparable)((Object)"Shoots for color 9")).setColumnKey(10, (Comparable)((Object)"Shoots for color 10")).setColumnKey(11, (Comparable)((Object)"Shoots for color 11")).setColumnKey(12, (Comparable)((Object)"Shoots for color 12")).setColumnKey(13, (Comparable)((Object)"Shoots for color 13")).setColumnKey(14, (Comparable)((Object)"Shoots for color 14")).setColumnKey(15, (Comparable)((Object)"Shoots for color 15")).setColumnKey(16, (Comparable)((Object)"Shoots for color 16")).setColumnKey(17, (Comparable)((Object)"Shoots of other colors"));
    }

    public static float uniform(float f, float f2) {
        return Operators.getRandomGenerator().nextFloat() * (f2 - f) + f;
    }

    public static float normal(float f, float f2) {
        return f + f2 * (float)Operators.getRandomGenerator().nextGaussian();
    }

    public static float random() {
        return Operators.getRandomGenerator().nextFloat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sumGenerator(VoidConsumer voidConsumer) {
        Node node = this.currentNode;
        if (node == null) {
            return;
        }
        Shoot shoot = LSystem.getAssociatedShoot(node);
        TreeIterator treeIterator = new TreeIterator((Node)(shoot != null ? shoot : node));
        try {
            while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
                this.currentNode = shoot;
                voidConsumer.consume();
            }
        }
        finally {
            this.currentNode = node;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sumdGenerator(VoidConsumer voidConsumer) {
        Node node = this.currentNode;
        if (node == null) {
            return;
        }
        try {
            this.sumdGenerator((Node)LSystem.getAssociatedShoot(node), voidConsumer);
        }
        finally {
            this.currentNode = node;
        }
    }

    private void sumdGenerator(Node node, VoidConsumer voidConsumer) {
        for (Edge edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
            Node node2 = edge.getTarget();
            if (node == node2 || !edge.testEdgeBits(768)) continue;
            if (node2 instanceof Shoot) {
                this.currentNode = node2;
                voidConsumer.consume();
                continue;
            }
            this.sumdGenerator(node2, voidConsumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sumpGenerator(VoidConsumer voidConsumer) {
        Node node = this.currentNode;
        if (node == null) {
            return;
        }
        Shoot shoot = LSystem.getAssociatedShoot(node);
        try {
            while (shoot != null) {
                this.currentNode = shoot;
                voidConsumer.consume();
                shoot = LSystem.getAssociatedShoot(shoot.findAdjacent(true, false, 768));
            }
        }
        finally {
            this.currentNode = node;
        }
    }

    public void patternMatched(RGGProducer rGGProducer) {
        this.currentNode = rGGProducer.producer$getLeftmostMatch();
    }

    private static Shoot getAssociatedShoot(Node node) {
        while (node != null && !(node instanceof Shoot)) {
            node = node.findAdjacent(true, false, 768);
        }
        return (Shoot)node;
    }

    private static Shoot getAssociatedMotherShoot(Node node) {
        while ((node = node.findAdjacent(true, false, 768)) != null && !(node instanceof Shoot)) {
        }
        return (Shoot)node;
    }

    static Shoot nextShoot(TreeIterator treeIterator) {
        while (treeIterator.hasNext()) {
            Node node = treeIterator.nextNode();
            if (!(node instanceof Shoot)) continue;
            return (Shoot)node;
        }
        return null;
    }

    public float currentXcoordinate() {
        Shoot shoot = LSystem.getAssociatedShoot(this.currentNode);
        if (shoot == null) {
            return 0.0f;
        }
        Matrix34d matrix34d = Library.transformation((Node)shoot);
        return (float)(matrix34d.m02 * (double)shoot.getLength(shoot, shoot.getCurrentGraphState()) + matrix34d.m03);
    }

    public float currentYcoordinate() {
        Shoot shoot = LSystem.getAssociatedShoot(this.currentNode);
        if (shoot == null) {
            return 0.0f;
        }
        Matrix34d matrix34d = Library.transformation((Node)shoot);
        return (float)(matrix34d.m12 * (double)shoot.getLength(shoot, shoot.getCurrentGraphState()) + matrix34d.m13);
    }

    public float currentZcoordinate() {
        Shoot shoot = LSystem.getAssociatedShoot(this.currentNode);
        if (shoot == null) {
            return 0.0f;
        }
        Matrix34d matrix34d = Library.transformation((Node)shoot);
        return (float)(matrix34d.m22 * (double)shoot.getLength(shoot, shoot.getCurrentGraphState()) + matrix34d.m23);
    }

    public float currentLength() {
        if (this.derivationActive) {
            Shoot shoot = LSystem.getAssociatedShoot(this.currentNode);
            return shoot == null ? 0.0f : shoot.getLength(shoot, shoot.getCurrentGraphState());
        }
        return this.interpretationState.length;
    }

    static Matrix4d transformation(Node node) {
        Matrix4d matrix4d = new Matrix4d();
        Library.transformation(node).get(matrix4d);
        return matrix4d;
    }

    public float function1(double d) {
        Shoot shoot;
        float f = 180.0f;
        float f2 = 0.0f;
        Shoot shoot2 = LSystem.getAssociatedShoot(this.currentNode);
        if (shoot2 == null) {
            return f;
        }
        Node node = this.getRoot();
        GraphState graphState = GraphState.current((Graph)node.getGraph());
        TreeIterator treeIterator = new TreeIterator(node);
        Shoot shoot3 = LSystem.getAssociatedMotherShoot(this.currentNode);
        CutRay2Parameter cutRay2Parameter = new CutRay2Parameter();
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Math2.getEndOfShoot((Matrix4d)LSystem.transformation((Node)shoot2), (double)f2, (Vector3d)vector3d3);
        while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
            f2 = (float)graphState.getDouble((Object)shoot, true, Attributes.LENGTH);
            if (shoot == shoot2 || !((double)f2 >= d) || shoot == shoot3) continue;
            Math2.getBeginAndEndOfShoot((Matrix4d)LSystem.transformation((Node)shoot), (double)f2, (Vector3d)vector3d, (Vector3d)vector3d2);
            Math2.cutRay2((float)((float)vector3d3.x), (float)((float)vector3d3.z), (float)0.0f, (float)1.0f, (float)((float)vector3d.x), (float)((float)vector3d.z), (float)((float)vector3d2.x), (float)((float)vector3d2.z), (CutRay2Parameter)cutRay2Parameter);
            if (cutRay2Parameter.isCorrect() && cutRay2Parameter.isExists()) {
                f = 0.0f;
                continue;
            }
            Matrix4d matrix4d = LSystem.transformation((Node)shoot);
            float f3 = (float)(Math.acos(matrix4d.m22 / Math.sqrt(matrix4d.m02 * matrix4d.m02 + matrix4d.m12 * matrix4d.m12 + matrix4d.m22 * matrix4d.m22)) * 57.29577951308232);
            if (!(f3 < f)) continue;
            f = f3;
        }
        return f;
    }

    public float function2(double d, int n) {
        Shoot shoot;
        float f = Float.MAX_VALUE;
        float f2 = 0.0f;
        Shoot shoot2 = LSystem.getAssociatedShoot(this.currentNode);
        if (shoot2 == null) {
            return f;
        }
        Node node = this.getRoot();
        GraphState graphState = GraphState.current((Graph)node.getGraph());
        TreeIterator treeIterator = new TreeIterator(node);
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Math2.getEndOfShoot((Matrix4d)LSystem.transformation((Node)shoot2), (double)f2, (Vector3d)vector3d3);
        Shoot shoot3 = LSystem.getAssociatedMotherShoot(this.currentNode);
        while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
            f2 = (float)graphState.getDouble((Object)shoot, true, Attributes.LENGTH);
            if (shoot == shoot2 || shoot == shoot3 || !((double)f2 >= d) || n >= 0 && graphState.getInt((Object)shoot, true, Attributes.DTG_COLOR) != n) continue;
            Math2.getBeginAndEndOfShoot((Matrix4d)LSystem.transformation((Node)shoot), (double)f2, (Vector3d)vector3d, (Vector3d)vector3d2);
            float f3 = Math2.abstpp((Vector3d)vector3d3, (Vector3d)vector3d2);
            if (f3 < f) {
                f = f3;
            }
            if (!((f3 = Math2.abstpp((Vector3d)vector3d3, (Vector3d)vector3d)) < f)) continue;
            f = f3;
        }
        return f;
    }

    public float function3() {
        Shoot shoot = LSystem.getAssociatedShoot(this.currentNode);
        if (shoot == null) {
            return 0.0f;
        }
        float f = 0.0f;
        GraphState graphState = shoot.getCurrentGraphState();
        TreeIterator treeIterator = new TreeIterator((Node)shoot);
        while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
            f += graphState.getFloat((Object)shoot, true, Attributes.PARAMETER);
        }
        return f;
    }

    public float function4(double d, double d2) {
        Shoot shoot;
        float f = 0.0f;
        float f2 = 0.0f;
        Shoot shoot2 = LSystem.getAssociatedShoot(this.currentNode);
        if (shoot2 == null || d < 0.0 || d > 90.0 || d2 < 0.0) {
            return 0.0f;
        }
        if (d2 < (double)1.0E-5f) {
            d2 = 1.0E-5f;
        }
        Node node = this.getRoot();
        GraphState graphState = GraphState.current((Graph)node.getGraph());
        TreeIterator treeIterator = new TreeIterator(node);
        CutConeParameter cutConeParameter = new CutConeParameter();
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Matrix4d matrix4d = LSystem.transformation((Node)shoot2);
        while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
            f = (float)graphState.getDouble((Object)shoot, true, Attributes.LENGTH);
            if (shoot == shoot2 || !((double)f >= d2)) continue;
            Math2.getBeginAndEndOfShoot((Matrix4d)LSystem.transformation((Node)shoot), (double)f, (Vector3d)vector3d, (Vector3d)vector3d2);
            Math2.getBeginOfShoot((Matrix4d)matrix4d, (Vector3d)vector3d3);
            Math2.cutCone((Vector3d)vector3d3, (float)((float)d), (Vector3d)vector3d, (Vector3d)vector3d2, (CutConeParameter)cutConeParameter);
            if (!cutConeParameter.isCorrect() || !cutConeParameter.isExists()) continue;
            f2 += cutConeParameter.getA() * graphState.getFloat((Object)shoot, true, Attributes.PARAMETER);
        }
        return f2;
    }

    public float function5(double d) {
        Shoot shoot;
        Shoot shoot2 = LSystem.getAssociatedShoot(this.currentNode);
        Node node = this.getRoot();
        GraphState graphState = GraphState.current((Graph)node.getGraph());
        TreeIterator treeIterator = new TreeIterator(node);
        float f = 0.0f;
        GraphState graphState2 = shoot2.getCurrentGraphState();
        float f2 = (float)graphState2.getDouble((Object)shoot2, true, Attributes.LENGTH);
        while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
            float f3 = graphState.getFloat((Object)shoot, true, Attributes.PARAMETER);
            if (!(f3 > 0.0f)) continue;
            float f4 = 0.0f;
            boolean bl = false;
            Shoot shoot3 = LSystem.getAssociatedMotherShoot((Node)shoot);
            while (shoot3 != null) {
                f4 = (float)((double)f4 + graphState.getDouble((Object)shoot, true, Attributes.LENGTH));
                if (shoot3 == shoot2) {
                    bl = true;
                }
                shoot3 = LSystem.getAssociatedMotherShoot((Node)shoot3);
            }
            if (!bl || !(f4 > 0.0f)) continue;
            f += (float)d * f3 * f2 / f4;
        }
        return f;
    }

    public float function6() {
        Shoot shoot = LSystem.getAssociatedShoot(this.currentNode);
        if (shoot == null) {
            return 0.0f;
        }
        float f = 0.0f;
        GraphState graphState = GraphState.current((Graph)shoot.getGraph());
        TreeIterator treeIterator = new TreeIterator((Node)shoot);
        while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
            f += TurtleState.getBefore((Object)shoot, (GraphState)graphState).carbon;
        }
        return f;
    }

    public float function7() {
        Shoot shoot = LSystem.getAssociatedShoot(this.currentNode);
        if (shoot == null) {
            return 0.0f;
        }
        Matrix4d matrix4d = LSystem.transformation((Node)shoot);
        return (float)(Math.acos(matrix4d.m22 / Math.sqrt(matrix4d.m02 * matrix4d.m02 + matrix4d.m12 * matrix4d.m12 + matrix4d.m22 * matrix4d.m22)) * 57.29577951308232);
    }

    public float function8(int n) {
        Shoot shoot;
        short[] sArray = new short[Math2.nbSkySegments];
        Shoot shoot2 = LSystem.getAssociatedShoot(this.currentNode);
        Node node = this.getRoot();
        GraphState graphState = GraphState.current((Graph)node.getGraph());
        TreeIterator treeIterator = new TreeIterator(node);
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Math2.getEndOfShoot((Matrix4d)LSystem.transformation((Node)shoot2), (double)shoot2.getCurrentGraphState().getDouble((Object)shoot2, true, Attributes.LENGTH), (Vector3d)vector3d3);
        float f = (float)vector3d3.z;
        while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
            int n2;
            Math2.getBeginAndEndOfShoot((Matrix4d)LSystem.transformation((Node)shoot), (double)graphState.getDouble((Object)shoot, true, Attributes.LENGTH), (Vector3d)vector3d, (Vector3d)vector3d2);
            int n3 = graphState.getInt((Object)shoot, true, Attributes.DTG_COLOR);
            if (shoot == shoot2 || n <= 0 && n3 != n) continue;
            if (vector3d.z > (double)f) {
                vector3d.sub((Tuple3d)vector3d3);
                n2 = Math2.skySegment((Vector3d)vector3d);
                if (n2 >= 0 && n2 < Math2.nbSkySegments) {
                    sArray[n2] = 1;
                }
            }
            if (!(vector3d2.z > (double)f)) continue;
            vector3d2.sub((Tuple3d)vector3d3);
            n2 = Math2.skySegment((Vector3d)vector3d2);
            if (n2 < 0 || n2 >= Math2.nbSkySegments) continue;
            sArray[n2] = 1;
        }
        int n4 = 0;
        for (int i = 0; i < Math2.nbSkySegments; ++i) {
            n4 += sArray[i];
        }
        float f2 = (float)n4 / (float)Math2.nbSkySegments;
        return f2;
    }

    public float function9(double d, double d2, int n) {
        Shoot shoot;
        float f = Float.MAX_VALUE;
        Shoot shoot2 = LSystem.getAssociatedShoot(this.currentNode);
        Node node = this.getRoot();
        GraphState graphState = GraphState.current((Graph)node.getGraph());
        TreeIterator treeIterator = new TreeIterator(node);
        if (shoot2 == null) {
            return f;
        }
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        Matrix4d matrix4d = LSystem.transformation((Node)shoot2);
        vector3d4.x = matrix4d.m02;
        vector3d4.y = matrix4d.m12;
        vector3d4.z = matrix4d.m22;
        Math2.getEndOfShoot((Matrix4d)matrix4d, (double)shoot2.getCurrentGraphState().getDouble((Object)shoot2, true, Attributes.LENGTH), (Vector3d)vector3d3);
        while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
            float f2;
            float f3 = (float)graphState.getDouble((Object)shoot, true, Attributes.LENGTH);
            Math2.getBeginAndEndOfShoot((Matrix4d)LSystem.transformation((Node)shoot), (double)f3, (Vector3d)vector3d, (Vector3d)vector3d2);
            if (!((double)f3 >= d2) || n >= 0 && graphState.getInt((Object)shoot, true, Attributes.DTG_COLOR) != n) continue;
            Vector3d vector3d5 = (Vector3d)vector3d.clone();
            vector3d5.sub((Tuple3d)vector3d3);
            float f4 = (float)Math.toDegrees(vector3d4.angle(vector3d5));
            if ((double)f4 <= d && (double)f4 >= -d && shoot != this.currentNode && (f2 = Math2.abstps((Vector3d)vector3d3, (Vector3d)vector3d, (Vector3d)vector3d2)) < f) {
                f = f2;
            }
            vector3d5 = (Vector3d)vector3d2.clone();
            vector3d5.sub((Tuple3d)vector3d3);
            f4 = (float)Math.toDegrees(vector3d4.angle(vector3d5));
            if (!((double)f4 <= d) || !((double)f4 >= -d) || shoot == this.currentNode || !((f2 = Math2.abstps((Vector3d)vector3d3, (Vector3d)vector3d, (Vector3d)vector3d2)) < f)) continue;
            f = f2;
        }
        return f;
    }

    public static float function10(float f) {
        return (int)(0.5 * (double)f + 2.3 - Math.exp(0.022 * (double)f + 0.06));
    }

    public static float function11(float f, float f2, float f3, float f4, float f5) {
        return f5 == 0.0f || f5 == 1.0f ? 0.0f : (f < f5 * (f + f2) ? (1.0f + 0.03f * f2) * 1.1f * f3 * f / f5 : (1.0f + 0.03f * f2) * 1.1f * ((f3 + f4 * f5) * f2 / (1.0f - f5) - f4 * f));
    }

    public static float function12(float f, float f2) {
        switch (Math.round(f)) {
            case 1: {
                return f2 <= 20.0f ? 7.0f + 0.1f * f2 : (f2 <= 90.0f ? 3.0f + 0.3f * f2 : 0.7222222f * f2 - 35.0f);
            }
            case 2: {
                return f2 <= 30.0f ? 7.0f + 0.1f * f2 : (f2 <= 90.0f ? 1.5f + 0.28333333f * f2 : 0.6111111f * f2 - 28.0f);
            }
            case 3: {
                return f2 <= 40.0f ? 7.0f + 0.1f * f2 : (f2 <= 90.0f ? 0.28f * f2 - 0.2f : 0.5f * f2 - 20.0f);
            }
        }
        return 0.0f;
    }

    public static float function13(double d, double d2) {
        float f = 8.17E-5f;
        float f2 = d2 < 0.0 ? (float)d * (float)d * f : (float)d * (float)d * (float)d2;
        if ((double)f2 < 0.0) {
            System.out.println("Warning: negative leaf mass in function 13 !");
            return 0.0f;
        }
        if ((double)f2 >= 9.0) {
            return 7.0f;
        }
        if ((double)f2 >= 7.0) {
            return 6.0f;
        }
        if ((double)f2 >= 5.0) {
            return 5.0f;
        }
        if ((double)f2 >= 3.0) {
            return 4.0f;
        }
        if ((double)f2 >= 2.0) {
            return 3.0f;
        }
        if ((double)f2 >= 1.0) {
            return 2.0f;
        }
        if ((double)f2 >= 0.5) {
            return 1.0f;
        }
        return 0.0f;
    }

    public float function15(int n) {
        Shoot shoot;
        short[] sArray = new short[Math2.nbSkySegments];
        Shoot shoot2 = LSystem.getAssociatedShoot(this.currentNode);
        Node node = this.getRoot();
        GraphState graphState = GraphState.current((Graph)node.getGraph());
        TreeIterator treeIterator = new TreeIterator(node);
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Math2.getEndOfShoot((Matrix4d)LSystem.transformation((Node)shoot2), (double)shoot2.getCurrentGraphState().getDouble((Object)shoot2, true, Attributes.LENGTH), (Vector3d)vector3d3);
        float f = (float)vector3d3.z;
        while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
            int n2;
            Math2.getBeginAndEndOfShoot((Matrix4d)LSystem.transformation((Node)shoot), (double)graphState.getDouble((Object)shoot, true, Attributes.LENGTH), (Vector3d)vector3d, (Vector3d)vector3d2);
            int n3 = graphState.getInt((Object)shoot, true, Attributes.DTG_COLOR);
            if (shoot == shoot2 || n <= 0 && n3 != n) continue;
            if (vector3d.z > (double)f) {
                vector3d.sub((Tuple3d)vector3d3);
                n2 = Math2.skySegment((Vector3d)vector3d);
                if (n2 >= 0 && n2 < Math2.nbSkySegments) {
                    sArray[n2] = 1;
                }
            }
            if (!(vector3d2.z > (double)f)) continue;
            vector3d2.sub((Tuple3d)vector3d3);
            n2 = Math2.skySegment((Vector3d)vector3d2);
            if (n2 < 0 || n2 >= Math2.nbSkySegments) continue;
            sArray[n2] = 1;
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i = 0; i < Math2.nbSkySegments; ++i) {
            float f4 = (float)(Math2.turtsky[i].z / Math2.turtsky[i].length());
            f2 += f4;
            if (sArray[i] <= 0) continue;
            f3 += f4;
        }
        float f5 = f3 / f2;
        return f5;
    }

    public float function20(int n) {
        float f = 2.0E-4f;
        float f2 = 0.25f;
        float f3 = 0.1f;
        float f4 = 1.5f;
        float[] fArray = new float[1];
        Shoot shoot = LSystem.getAssociatedShoot(this.currentNode);
        Node node = this.getRoot();
        if (node == null || shoot == null) {
            return 0.0f;
        }
        float f5 = this.taklightcapt(node, shoot, f3, f4, n, false, false, false, fArray);
        return f * f5 - f2 * shoot.getCurrentGraphState().getFloat((Object)shoot, true, Attributes.PARAMETER);
    }

    private float taklightcapt(Node node, Shoot shoot, float f, float f2, int n, boolean bl, boolean bl2, boolean bl3, float[] fArray) {
        float f3 = 10000.0f;
        float f4 = 1.0f;
        fArray[0] = 0.0f;
        GraphState graphState = shoot.getCurrentGraphState();
        if (shoot == null) {
            return 0.0f;
        }
        Shoot shoot2 = bl3 ? LSystem.getAssociatedMotherShoot((Node)shoot) : null;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = (float)(1.0 - (1.0 - (1.0 - (double)f) / (double)(f2 * f2)) * (1.0 - (1.0 - (double)f) / (double)(f2 * f2)));
        float f8 = (float)(0.5 * Math.sqrt(f3 * graphState.getFloat((Object)shoot, true, Attributes.PARAMETER) / Math2.M_PI));
        float f9 = f8 * f2;
        f9 = f9 * f9 * Math2.M_PI * f7;
        float f10 = (float)graphState.getDouble((Object)shoot, true, Attributes.LENGTH);
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Matrix4d matrix4d = LSystem.transformation((Node)shoot);
        vector3d.x = matrix4d.m02;
        vector3d.y = matrix4d.m12;
        vector3d.z = matrix4d.m22;
        Math2.getEndOfShoot((Matrix4d)matrix4d, (double)f10, (Vector3d)vector3d2);
        for (int i = 0; i <= 45; ++i) {
            if (bl2) {
                float f11 = f10 * (float)Math.sin(Math2.turtsky[i].angle(vector3d));
                f9 += 2.0f * f11 * f8 * f2 * f7;
            }
            int n2 = this.nbcuts(node, vector3d2, Math2.turtsky[i], n, shoot, shoot2);
            float f12 = (float)((double)f4 * (1.0 + 2.0 * Math2.turtsky[i].z) / 3.0);
            if (bl) {
                f6 += f12 * f9;
            }
            for (int j = 0; j < n2; ++j) {
                f12 = (float)((double)f12 * (1.0 - (double)f7));
            }
            f5 += f12 * f9;
        }
        if (bl && (double)f6 > 0.0) {
            fArray[0] = f5 / f6;
        }
        return f5;
    }

    private int nbcuts(Node node, Vector3d vector3d, Vector3d vector3d2, int n, Shoot shoot, Shoot shoot2) {
        Shoot shoot3;
        int n2 = 0;
        if (Math2.isNullVector((Vector3d)vector3d2)) {
            return 0;
        }
        GraphState graphState = GraphState.current((Graph)node.getGraph());
        TreeIterator treeIterator = new TreeIterator(node);
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        while ((shoot3 = LSystem.nextShoot(treeIterator)) != null) {
            if (n >= 0 && n != graphState.getInt((Object)shoot3, true, Attributes.DTG_COLOR) || shoot3 == shoot || shoot3 == shoot2) continue;
            Math2.getBeginAndEndOfShoot((Matrix4d)LSystem.transformation((Node)shoot3), (double)graphState.getDouble((Object)shoot3, true, Attributes.LENGTH), (Vector3d)vector3d3, (Vector3d)vector3d4);
            float f = Math2.absthgs((Vector3d)vector3d, (Vector3d)vector3d2, (Vector3d)vector3d3, (Vector3d)vector3d4);
            if (!((double)f <= 0.5 * (double)TurtleState.getBefore((Object)shoot3, (GraphState)graphState).diameter)) continue;
            ++n2;
        }
        return n2;
    }

    public float function21(int n) {
        Shoot shoot;
        float f = 0.0f;
        Shoot shoot2 = LSystem.getAssociatedShoot(this.currentNode);
        Node node = this.getRoot();
        GraphState graphState = GraphState.current((Graph)node.getGraph());
        TreeIterator treeIterator = new TreeIterator(node);
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Math2.getEndOfShoot((Matrix4d)LSystem.transformation((Node)shoot2), (double)shoot2.getCurrentGraphState().getDouble((Object)shoot2, true, Attributes.LENGTH), (Vector3d)vector3d3);
        while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
            if (n >= 0 && graphState.getInt((Object)shoot, true, Attributes.DTG_COLOR) != n) continue;
            float f2 = (float)graphState.getDouble((Object)shoot, true, Attributes.LENGTH);
            Math2.getBeginAndEndOfShoot((Matrix4d)LSystem.transformation((Node)shoot), (double)f2, (Vector3d)vector3d, (Vector3d)vector3d2);
            float f3 = Math2.abstps((Vector3d)vector3d3, (Vector3d)vector3d, (Vector3d)vector3d2);
            if (!(f3 < f2) || !(f2 > f)) continue;
            f = f2;
            this.refShoot = shoot;
        }
        return f;
    }

    public float function30(float f, float f2, float f3) {
        System.out.println(" funct30    " + f + "    " + f2 + "    " + f3);
        return 0.0f;
    }

    public float function31(float f, float f2, float f3) {
        return 0.0f;
    }

    public float function32(float f, float f2, float f3) {
        return 0.0f;
    }

    public float function33(float f, float f2, float f3) {
        return 0.0f;
    }

    public float function34(float f, float f2, float f3) {
        return 0.0f;
    }

    public float function35(float f, float f2, float f3) {
        return 0.0f;
    }

    public float function36(float f, float f2, float f3) {
        return 0.0f;
    }

    public float function37(float f, float f2, float f3) {
        return 0.0f;
    }

    public float function38(float f, float f2, float f3) {
        return 0.0f;
    }

    public float function39(float f, float f2, float f3) {
        return 0.0f;
    }

    public void method1() {
        float f = 300.0f;
        float f2 = 100.0f;
        float f3 = 1.0f;
        float f4 = 5.0f;
        if (this.r4 >= 0.0f) {
            System.out.println("r1: " + this.r1);
            System.out.println("r2: " + this.r2);
            System.out.println("r3: " + this.r3);
            System.out.println("r4: " + this.r4);
            float f5 = this.r3 - f3 * this.r1 + f4 * this.r2;
            if (f5 <= 0.0f) {
                this.r4 = -1.0f;
            } else if (f5 > f) {
                this.r3 = f5 - f;
                this.r4 = f2;
            } else {
                this.r3 = 0.0f;
                this.r4 = f2 * (f5 / f);
            }
        }
        this.r2 = 0.0f;
        this.r1 = 0.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method4() {
        Node node = this.getRoot();
        GraphState graphState = node.getCurrentGraphState();
        TreeIterator treeIterator = new TreeIterator(node);
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        RandomAccessFile randomAccessFile = null;
        try {
            Shoot shoot;
            randomAccessFile = new RandomAccessFile("strutemp.dat", "rw");
            while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
                float f = (float)graphState.getDouble((Object)shoot, true, Attributes.LENGTH);
                Matrix4d matrix4d = LSystem.transformation((Node)shoot);
                Math2.getBeginAndEndOfShoot((Matrix4d)matrix4d, (double)f, (Vector3d)vector3d, (Vector3d)vector3d2);
                randomAccessFile.writeShort(this.generationCounter + 1);
                randomAccessFile.writeInt((int)shoot.getId());
                Shoot shoot2 = LSystem.getAssociatedMotherShoot((Node)shoot);
                randomAccessFile.writeInt((int)(shoot2 != null ? shoot2.getId() : -2L));
                randomAccessFile.writeFloat(f);
                randomAccessFile.writeFloat(TurtleState.getBefore((Object)shoot, (GraphState)graphState).heartwood);
                randomAccessFile.writeFloat(TurtleState.getBefore((Object)shoot, (GraphState)graphState).diameter);
                randomAccessFile.writeFloat(graphState.getFloat((Object)shoot, true, Attributes.PARAMETER));
                randomAccessFile.writeShort(TurtleState.getBefore((Object)shoot, (GraphState)graphState).internodeCount);
                randomAccessFile.writeShort(graphState.getInt((Object)shoot, true, Attributes.DTG_COLOR));
                randomAccessFile.writeShort(graphState.getInt((Object)shoot, true, Attributes.ORDER));
                randomAccessFile.writeShort(0);
                randomAccessFile.writeInt(graphState.getInt((Object)shoot, true, Attributes.GENERATIVE_DISTANCE));
                randomAccessFile.writeFloat(graphState.getFloat((Object)shoot, true, Attributes.REL_POSITION));
                randomAccessFile.writeFloat((float)vector3d.x);
                randomAccessFile.writeFloat((float)vector3d.y);
                randomAccessFile.writeFloat((float)vector3d.z);
                randomAccessFile.writeFloat((float)vector3d2.x);
                randomAccessFile.writeFloat((float)vector3d2.y);
                randomAccessFile.writeFloat((float)vector3d2.z);
                randomAccessFile.writeFloat((float)matrix4d.m02);
                randomAccessFile.writeFloat((float)matrix4d.m12);
                randomAccessFile.writeFloat((float)matrix4d.m22);
                randomAccessFile.writeFloat((float)matrix4d.m00);
                randomAccessFile.writeFloat((float)matrix4d.m10);
                randomAccessFile.writeFloat((float)matrix4d.m20);
                randomAccessFile.writeFloat((float)matrix4d.m01);
                randomAccessFile.writeFloat((float)matrix4d.m11);
                randomAccessFile.writeFloat((float)matrix4d.m21);
                randomAccessFile.writeInt(-2);
                randomAccessFile.writeFloat(TurtleState.getBefore((Object)shoot, (GraphState)graphState).carbon);
                randomAccessFile.writeFloat(0.0f);
                randomAccessFile.writeFloat(0.0f);
                randomAccessFile.writeFloat(0.0f);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method10() {
        Node node = this.getRoot();
        GraphState graphState = node.getCurrentGraphState();
        TreeIterator treeIterator = new TreeIterator(node);
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        PrintWriter printWriter = null;
        try {
            Shoot shoot;
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter("bt" + new Date().getTime() + ".dtt", true)));
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            long l = 0L;
            while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
                ++l;
                float f7 = (float)graphState.getDouble((Object)shoot, true, Attributes.LENGTH);
                int n = graphState.getInt((Object)shoot, true, Attributes.ORDER);
                float f8 = TurtleState.getBefore((Object)shoot, (GraphState)graphState).diameter;
                Math2.getEndOfShoot((Matrix4d)LSystem.transformation((Node)shoot), (double)f7, (Vector3d)vector3d2);
                if (vector3d2.x > (double)f6) {
                    f6 = (float)vector3d2.x;
                }
                if (n == 1) {
                    f5 += f7;
                }
                f4 += graphState.getFloat((Object)shoot, true, Attributes.PARAMETER);
                if (n == 1 && f8 > f3) {
                    f3 = f8;
                }
                if (vector3d2.y < (double)f) {
                    f = (float)vector3d2.y;
                }
                if (!(vector3d2.y > (double)f2)) continue;
                f2 = (float)vector3d2.y;
            }
            f3 = (float)((double)Math2.M_PI * 0.25 * (double)f3 * (double)f3);
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
            decimalFormatSymbols.setDecimalSeparator('.');
            DecimalFormat decimalFormat = new DecimalFormat("############.000", decimalFormatSymbols);
            DecimalFormat decimalFormat2 = new DecimalFormat("############.00000", decimalFormatSymbols);
            DecimalFormat decimalFormat3 = new DecimalFormat("###############.0000000", decimalFormatSymbols);
            DecimalFormat decimalFormat4 = new DecimalFormat("###############.000", decimalFormatSymbols);
            DecimalFormat decimalFormat5 = new DecimalFormat("##########", decimalFormatSymbols);
            DecimalFormat decimalFormat6 = new DecimalFormat("#####", decimalFormatSymbols);
            printWriter.print(decimalFormat.format(f6) + "  " + decimalFormat2.format(f5) + "  " + decimalFormat3.format(f4) + "  " + decimalFormat4.format(f3) + "  " + decimalFormat.format(f2 - f) + "  " + decimalFormat5.format(l) + "\n\n");
            treeIterator = new TreeIterator(node);
            while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
                Math2.getBeginAndEndOfShoot((Matrix4d)LSystem.transformation((Node)shoot), (double)graphState.getDouble((Object)shoot, true, Attributes.LENGTH), (Vector3d)vector3d, (Vector3d)vector3d2);
                int n = 0;
                if (graphState.getFloat((Object)shoot, true, Attributes.PARAMETER) > 1.0E-9f) {
                    n = 1;
                }
                printWriter.print(decimalFormat.format(vector3d.x) + "  " + decimalFormat.format(vector3d.y) + "  " + decimalFormat.format(vector3d.z) + "  " + decimalFormat.format(vector3d2.x) + "  " + decimalFormat.format(vector3d2.y) + "  " + decimalFormat.format(vector3d2.z) + "  " + decimalFormat6.format(n) + "\n");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            printWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method12() {
        PrintWriter printWriter = null;
        try {
            Shoot shoot;
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter("method12.dat", true)));
            Node node = this.getRoot();
            GraphState graphState = node.getCurrentGraphState();
            TreeIterator treeIterator = new TreeIterator(node);
            while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
                if (graphState.getInt((Object)shoot, true, Attributes.DTG_COLOR) != 14) continue;
                printWriter.print(TurtleState.getBefore((Object)shoot, (GraphState)graphState).carbon + " ");
            }
            printWriter.print("\n\n");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            printWriter.close();
        }
    }

    public void method30() {
        Shoot shoot;
        Node node = this.getRoot();
        GraphState graphState = node.getCurrentGraphState();
        TreeIterator treeIterator = new TreeIterator(node);
        while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
            if (graphState.getInt((Object)shoot, true, Attributes.ORDER) != 0) continue;
            int n = graphState.getInt((Object)shoot, true, Attributes.ORDER);
            while (shoot != null && n == 0) {
                System.out.println("A shoot of a stem " + n);
                Shoot shoot2 = shoot;
                shoot = LSystem.nextShoot(treeIterator);
                n = graphState.getInt((Object)shoot, true, Attributes.ORDER);
                while (shoot != null && (n == 1 || n == -20)) {
                    System.out.println("A branch is found " + n);
                    shoot = LSystem.nextShoot(treeIterator);
                    while (shoot != null && LSystem.getAssociatedMotherShoot((Node)shoot) != shoot2) {
                        shoot = LSystem.nextShoot(treeIterator);
                    }
                }
            }
            System.out.println("Whole tree scanned");
            System.out.println();
        }
        System.out.println("Whole structure scanned");
    }

    public void method32() {
        Shoot shoot;
        Node node = this.getRoot();
        GraphState graphState = node.getCurrentGraphState();
        TreeIterator treeIterator = new TreeIterator(node);
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
            if (graphState.getInt((Object)shoot, true, Attributes.ORDER) != 0) continue;
            int n = graphState.getInt((Object)shoot, true, Attributes.ORDER);
            while (shoot != null && n == 0) {
                Shoot shoot2 = shoot;
                shoot = LSystem.nextShoot(treeIterator);
                n = graphState.getInt((Object)shoot, true, Attributes.ORDER);
                while (shoot != null && (n == 1 || n == -20)) {
                    float f = Float.MAX_VALUE;
                    float f2 = -3.4028235E38f;
                    float f3 = Float.MAX_VALUE;
                    float f4 = -3.4028235E38f;
                    float f5 = Float.MAX_VALUE;
                    float f6 = -3.4028235E38f;
                    boolean bl = false;
                    if (n > 0) {
                        bl = true;
                        Math2.getBeginAndEndOfShoot((Matrix4d)LSystem.transformation((Node)shoot), (double)graphState.getDouble((Object)shoot, true, Attributes.LENGTH), (Vector3d)vector3d, (Vector3d)vector3d2);
                        f2 = (float)Math.max(Math.max((double)f2, vector3d.x), vector3d2.x);
                        f6 = (float)Math.max(Math.max((double)f6, vector3d.y), vector3d2.y);
                        f4 = (float)Math.max(Math.max((double)f4, vector3d.z), vector3d2.z);
                        f = (float)Math.min(Math.min((double)f, vector3d.x), vector3d2.x);
                        f5 = (float)Math.min(Math.min((double)f5, vector3d.y), vector3d2.y);
                        f3 = (float)Math.min(Math.min((double)f3, vector3d.z), vector3d2.z);
                    }
                    shoot = LSystem.nextShoot(treeIterator);
                    while (shoot != null && LSystem.getAssociatedMotherShoot((Node)shoot) != shoot2) {
                        if (graphState.getInt((Object)shoot, true, Attributes.ORDER) > 0) {
                            bl = true;
                            Math2.getBeginAndEndOfShoot((Matrix4d)LSystem.transformation((Node)shoot), (double)graphState.getDouble((Object)shoot, true, Attributes.LENGTH), (Vector3d)vector3d, (Vector3d)vector3d2);
                            f2 = (float)Math.max(Math.max((double)f2, vector3d.x), vector3d2.x);
                            f6 = (float)Math.max(Math.max((double)f6, vector3d.y), vector3d2.y);
                            f4 = (float)Math.max(Math.max((double)f4, vector3d.z), vector3d2.z);
                            f = (float)Math.min(Math.min((double)f, vector3d.x), vector3d2.x);
                            f5 = (float)Math.min(Math.min((double)f5, vector3d.y), vector3d2.y);
                            f3 = (float)Math.min(Math.min((double)f3, vector3d.z), vector3d2.z);
                        }
                        shoot = LSystem.nextShoot(treeIterator);
                    }
                    if (bl) {
                        float f7 = Math.max(f2 - f, Math.max(f4 - f3, f6 - f5));
                        if (f7 != 0.0f) {
                            System.out.println("oksakohtainen: dimension=" + f7);
                        } else {
                            System.out.println("oksa karsittu");
                        }
                    }
                    n = graphState.getInt((Object)shoot, true, Attributes.ORDER);
                }
                System.out.println();
            }
        }
        System.out.println("Whole structure scanned");
    }

    public void method31() {
    }

    public void method33() {
    }

    public void method34() {
    }

    public void method35() {
    }

    public void method36() {
    }

    public void method37() {
    }

    public void method38() {
    }

    public void method39() {
    }

    public void method40() {
    }

    public void method41() {
    }

    public void method42() {
    }

    public void method43() {
    }

    public void method44() {
    }

    public Dataset getShootPopulation() {
        return this.shootPopulation;
    }

    public Shoot getRefShoot() {
        return this.refShoot;
    }

    public int getGenerationNo() {
        return this.generationCounter - 1;
    }

    public static float floor(float f) {
        return (float)Math.floor(f);
    }

    public static float exp(float f) {
        return (float)Math.exp(f);
    }

    public static float log(float f) {
        return (float)Math.log(f);
    }

    public static float sqr(float f) {
        return f * f;
    }

    public static float sqrt(float f) {
        return (float)Math.sqrt(f);
    }

    public static float atan(float f) {
        return (float)Math.atan(f);
    }

    public static float atg(float f) {
        return (float)(57.29577951308232 * Math.atan(f));
    }

    public static int round(float f) {
        return Math.round(f);
    }

    public static float min(float f, float f2) {
        return Math.min(f, f2);
    }

    public static float max(float f, float f2) {
        return Math.max(f, f2);
    }

    public static LSystem get(Registry registry) {
        return (LSystem)((Object)registry.getUserProperty(REG_ID));
    }

    public static LSystem current() {
        return LSystem.get(Registry.current());
    }

    protected void startup() {
        this.getRegistry().setUserProperty(REG_ID, (Object)this);
        super.startup();
    }

    protected void shutdown() {
        super.shutdown();
        this.getRegistry().setUserProperty(REG_ID, null);
    }

    public void derivation() {
        if (this.derivation == null) {
            this.derivation = Reflection.getDeclaredMethod((Type)this.getNType(), (String)"derivation");
        }
        try {
            this.derivation.invoke((Object)this, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            Workbench.log((Throwable)illegalAccessException.getCause());
        }
        catch (InvocationTargetException invocationTargetException) {
            Workbench.log((Throwable)invocationTargetException.getCause());
        }
    }

    public void interpretation() {
        if (this.interpretation == null) {
            this.interpretation = Reflection.getDeclaredMethod((Type)this.getNType(), (String)"interpretation");
        }
        try {
            this.interpretation.invoke((Object)this, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            Workbench.log((Throwable)illegalAccessException.getCause());
        }
        catch (InvocationTargetException invocationTargetException) {
            Workbench.log((Throwable)invocationTargetException.getCause());
        }
    }

    protected void initializeApplyMenu(Item item, boolean bl, boolean bl2) {
        item.add((Item)new CommandItem("Rules", (Command)new Apply(false, bl2, 1)));
    }

    protected void initializeRunMenu(Item item, boolean bl, boolean bl2) {
        item.add((Item)new CommandItem("Run Rules", (Command)new Apply(true, bl2, 1)));
    }

    final boolean apply(int n, Transaction transaction) {
        return this.apply(((GraphManager)this.getPersistenceManager()).getRoot(), n, transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean apply(Node node, int n, Transaction transaction) {
        RGGGraph rGGGraph = Runtime.INSTANCE.currentGraph();
        boolean bl = false;
        while (n-- > 0) {
            int n2;
            Shoot shoot;
            float[] fArray;
            long l = rGGGraph.derive();
            this.derivationActive = true;
            this.currentNode = null;
            this.derivation();
            rGGGraph.removeInterpretiveNodesOnDerivation();
            bl = rGGGraph.derive() > l;
            this.derivationActive = false;
            this.currentNode = null;
            int n3 = rGGGraph.getDerivationMode();
            rGGGraph.setDerivationMode(n3 | 4);
            try {
                this.interpretation();
            }
            finally {
                rGGGraph.setDerivationMode(n3);
            }
            rGGGraph.derive();
            int[] nArray = new int[17];
            Node node2 = this.getRoot();
            GraphState graphState = node2.getCurrentGraphState();
            TreeIterator treeIterator = new TreeIterator(node2);
            Node node3 = this.getRoot();
            HashMap<KAssignment, float[]> hashMap = new HashMap<KAssignment, float[]>();
            while ((node3 = node3.findAdjacent(false, true, 768)) != null) {
                if (!(node3 instanceof KAssignment) || (fArray = (shoot = LSystem.getAssociatedShoot(node3)).getLocalRegisters()) == null) continue;
                hashMap.put((KAssignment)node3, fArray);
            }
            while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
                shoot.setLocalRegisters(null);
                int n4 = graphState.getInt((Object)shoot, true, Attributes.DTG_COLOR);
                if (n4 > -1 && n4 < 16) {
                    int n5 = n4;
                    nArray[n5] = nArray[n5] + 1;
                    continue;
                }
                nArray[16] = nArray[16] + 1;
            }
            Dataseries dataseries = this.shootPopulation.addRow();
            dataseries.set(0, (Number)this.generationCounter);
            for (n2 = 1; n2 < 18; ++n2) {
                dataseries.set(n2, (Number)nArray[n2 - 1]);
            }
            ++this.generationCounter;
            node3 = this.getRoot();
            while ((node3 = node3.findAdjacent(false, true, 768)) != null) {
                if (node3 instanceof K) {
                    shoot = LSystem.getAssociatedShoot(node3);
                    fArray = shoot.getLocalRegisters();
                    if (fArray != null) {
                        fArray[((K)node3).getArgument()] = this.defaultValuesForLocalRegisters[((K)node3).getArgument()];
                        continue;
                    }
                    fArray = new float[this.defaultValuesForLocalRegisters.length];
                    for (n2 = 0; n2 < fArray.length; ++n2) {
                        fArray[n2] = Float.NaN;
                    }
                    fArray[((K)node3).getArgument()] = this.defaultValuesForLocalRegisters[((K)node3).getArgument()];
                    continue;
                }
                if (node3 instanceof KL) {
                    shoot = LSystem.getAssociatedShoot(node3);
                    fArray = shoot.getLocalRegisters();
                    GraphState graphState2 = shoot.getCurrentGraphState();
                    if (fArray != null) {
                        fArray[((KL)node3).getArgument()] = (float)graphState2.getDouble((Object)shoot, true, Attributes.LENGTH);
                        continue;
                    }
                    fArray = new float[this.defaultValuesForLocalRegisters.length];
                    for (int i = 0; i < fArray.length; ++i) {
                        fArray[i] = Float.NaN;
                    }
                    fArray[((KL)node3).getArgument()] = (float)graphState2.getDouble((Object)shoot, true, Attributes.LENGTH);
                    continue;
                }
                if (!(node3 instanceof KAssignment)) continue;
                shoot = LSystem.getAssociatedShoot(node3);
                fArray = shoot.getLocalRegisters();
                if (fArray != null) {
                    fArray[((KAssignment)node3).getArgument()] = ((float[])hashMap.get(node3))[((KAssignment)node3).getArgument()];
                    continue;
                }
                fArray = new float[this.defaultValuesForLocalRegisters.length];
                for (n2 = 0; n2 < fArray.length; ++n2) {
                    fArray[n2] = Float.NaN;
                }
                fArray[((KAssignment)node3).getArgument()] = ((float[])hashMap.get(node3))[((KAssignment)node3).getArgument()];
            }
            generation$FIELD.setInt((Object)this, null, this.generation + 1, transaction);
        }
        rGGGraph.derive();
        return bl;
    }

    protected void assignLocalRegister(int n, float f) {
        Shoot shoot = LSystem.getAssociatedShoot(this.currentNode);
        while (shoot != null) {
            float[] fArray;
            if (shoot instanceof F && (fArray = shoot.getLocalRegisters())[n] == fArray[n]) {
                fArray[n] = f;
                break;
            }
            shoot = LSystem.getAssociatedShoot((Node)shoot);
        }
    }

    protected void assignLocalRegisterAdd(int n, float f) {
        Shoot shoot = LSystem.getAssociatedShoot(this.currentNode);
        while (shoot != null) {
            float[] fArray;
            if (shoot instanceof F && (fArray = shoot.getLocalRegisters())[n] == fArray[n]) {
                int n2 = n;
                fArray[n2] = fArray[n2] + f;
                break;
            }
            shoot = LSystem.getAssociatedShoot((Node)shoot);
        }
    }

    protected void assignLocalRegisterMul(int n, float f) {
        Shoot shoot = LSystem.getAssociatedShoot(this.currentNode);
        while (shoot != null) {
            float[] fArray;
            if (shoot instanceof F && (fArray = shoot.getLocalRegisters())[n] == fArray[n]) {
                int n2 = n;
                fArray[n2] = fArray[n2] * f;
                break;
            }
            shoot = LSystem.getAssociatedShoot((Node)shoot);
        }
    }

    protected void assignReferenceShoot(int n, float f) {
        float[] fArray;
        if (this.refShoot != null && (fArray = this.refShoot.getLocalRegisters())[n] == fArray[n]) {
            fArray[n] = f;
        }
    }

    protected void assignReferenceShootAdd(int n, float f) {
        float[] fArray;
        if (this.refShoot != null && (fArray = this.refShoot.getLocalRegisters())[n] == fArray[n]) {
            int n2 = n;
            fArray[n2] = fArray[n2] + f;
        }
    }

    protected void assignReferenceShootMul(int n, float f) {
        float[] fArray;
        if (this.refShoot != null && (fArray = this.refShoot.getLocalRegisters())[n] == fArray[n]) {
            int n2 = n;
            fArray[n2] = fArray[n2] * f;
        }
    }

    protected float getLocalRegisterValue(int n) {
        Shoot shoot = LSystem.getAssociatedShoot(this.currentNode);
        while (shoot != null) {
            float[] fArray = shoot.getLocalRegisters();
            if (fArray != null && fArray[n] == fArray[n]) {
                return fArray[n];
            }
            shoot = LSystem.getAssociatedShoot((Node)shoot);
        }
        return 0.0f;
    }

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new LSystem();
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)angle$FIELD);
        generation$FIELD = new _Field("generation", 0x200001, Type.INT, null, 1);
        $TYPE.addManagedField((ManageableType.Field)generation$FIELD);
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        public void setInt(Object object, int n) {
            switch (this.id) {
                case 1: {
                    ((LSystem)((Object)object)).generation = n;
                    return;
                }
            }
            super.setInt(object, n);
        }

        public int getInt(Object object) {
            switch (this.id) {
                case 1: {
                    return ((LSystem)((Object)object)).generation;
                }
            }
            return super.getInt(object);
        }

        public void setFloat(Object object, float f) {
            switch (this.id) {
                case 0: {
                    ((LSystem)((Object)object)).angle = f;
                    return;
                }
            }
            super.setFloat(object, f);
        }

        public float getFloat(Object object) {
            switch (this.id) {
                case 0: {
                    return ((LSystem)((Object)object)).angle;
                }
            }
            return super.getFloat(object);
        }
    }

    public class Apply
    extends RGG.Apply {
        private final int count;

        public Apply(boolean bl, boolean bl2, int n) {
            super(LSystem.this, null, bl, bl2);
            this.count = n;
        }

        protected boolean applyRules(Transaction transaction) {
            return LSystem.this.apply(this.count, transaction);
        }
    }
}

