/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.mtg;

import de.grogra.mtg.MTGBranchElement;
import java.util.ArrayList;

public class MTGBranch {
    int supportNodeIndex;
    int plant;
    int scale;
    int category;
    double alpha;
    private ArrayList<MTGBranchElement> elements;

    public MTGBranch(int n, int n2, int n3) {
        this.supportNodeIndex = n;
        this.plant = n2;
        this.elements = new ArrayList();
        this.scale = n3;
        this.category = -1;
        this.alpha = -1.0;
    }

    public void setAlpha(double d) {
        this.alpha = d;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setCategory(int n) {
        this.category = n;
    }

    public int getCategory() {
        return this.category;
    }

    public int getScale() {
        return this.scale;
    }

    public int baseOfBranch() {
        if (this.elements.size() == 0) {
            return -1;
        }
        return this.elements.get(0).getNodeIndex();
    }

    public int endOfBranch() {
        if (this.elements.size() == 0) {
            return -1;
        }
        return this.elements.get(this.elements.size() - 1).getNodeIndex();
    }

    public void addElement(MTGBranchElement mTGBranchElement) {
        this.elements.add(mTGBranchElement);
    }

    public MTGBranchElement getElement(int n) {
        if (this.elements.size() - 1 < n) {
            return null;
        }
        return this.elements.get(n);
    }

    public int getElementIndex(MTGBranchElement mTGBranchElement) {
        for (int i = 0; i < this.elements.size(); ++i) {
            if (!this.elements.get(i).equals(mTGBranchElement)) continue;
            return i;
        }
        return -1;
    }

    public int getElementCount() {
        return this.elements.size();
    }

    public int getSupportNodeIndex() {
        return this.supportNodeIndex;
    }

    public int getPlant() {
        return this.plant;
    }

    public static boolean lessThan(MTGBranch mTGBranch, MTGBranch mTGBranch2) {
        boolean bl = false;
        if (mTGBranch.getPlant() == mTGBranch2.getPlant()) {
            if (mTGBranch.getSupportNodeIndex() < mTGBranch2.getSupportNodeIndex()) {
                bl = true;
            }
        } else if (mTGBranch.getPlant() < mTGBranch2.getPlant()) {
            bl = true;
        }
        return bl;
    }

    public static boolean greaterThan(MTGBranch mTGBranch, MTGBranch mTGBranch2) {
        boolean bl = false;
        if (mTGBranch.getPlant() == mTGBranch2.getPlant()) {
            if (mTGBranch.getSupportNodeIndex() > mTGBranch2.getSupportNodeIndex()) {
                bl = true;
            }
        } else if (mTGBranch.getPlant() > mTGBranch2.getPlant()) {
            bl = true;
        }
        return bl;
    }

    public static boolean equal(MTGBranch mTGBranch, MTGBranch mTGBranch2) {
        boolean bl = false;
        bl = mTGBranch.getPlant() == mTGBranch2.getPlant() && mTGBranch.getSupportNodeIndex() == mTGBranch2.getSupportNodeIndex();
        return bl;
    }
}

