/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.mtg;

import de.grogra.graph.impl.Node;
import de.grogra.imp3d.objects.Sphere;
import de.grogra.mtg.MTGError;
import de.grogra.mtg.MTGGraphBuilder;
import de.grogra.mtg.MTGLineReader;
import de.grogra.mtg.MTGNode;
import de.grogra.mtg.MTGTokenizer;
import de.grogra.pf.registry.Registry;
import de.grogra.rgg.RGGRoot;
import java.io.Reader;

public class MTGTranslator {
    private Reader mtgReader;
    private MTGLineReader mtgLineReader;
    private MTGGraphBuilder mtgGraphBuilder;
    private int lineCounter;
    private String errorMessage;
    private String systemId;
    private String mtgLine;

    public MTGTranslator(Reader reader, String string) {
        this.mtgReader = reader;
        this.mtgLineReader = null;
        this.mtgGraphBuilder = null;
        this.errorMessage = new String("");
        this.systemId = string;
    }

    public int translateMTGFileHeader() {
        this.lineCounter = 0;
        this.errorMessage = "";
        try {
            this.mtgLineReader = new MTGLineReader(this.mtgReader);
        }
        catch (Throwable throwable) {
            return 1;
        }
        this.mtgGraphBuilder = new MTGGraphBuilder(this.systemId);
        this.mtgLine = this.mtgLineReader.readLine();
        MTGTokenizer mTGTokenizer = new MTGTokenizer(this.mtgLine);
        boolean bl = false;
        while (this.mtgLine != null) {
            ++this.lineCounter;
            mTGTokenizer.setCommentCharFound(false);
            mTGTokenizer.setLineString(this.mtgLine);
            String[] stringArray = mTGTokenizer.tokenizeLineString();
            if (stringArray != null) {
                try {
                    bl = this.mtgGraphBuilder.processTokens(stringArray);
                    if (bl) {
                        --this.lineCounter;
                        break;
                    }
                }
                catch (MTGError.MTGGraphBuildException mTGGraphBuildException) {
                    this.errorMessage = mTGGraphBuildException.getError();
                    this.mtgLineReader.close();
                    return 4;
                }
                catch (Throwable throwable) {
                    this.errorMessage = throwable.getMessage();
                    this.mtgLineReader.close();
                    return 5;
                }
            }
            this.mtgLine = this.mtgLineReader.readLine();
        }
        if (!bl) {
            return 9;
        }
        return 8;
    }

    public int translateMTGFileBody() {
        MTGTokenizer mTGTokenizer = new MTGTokenizer(this.mtgLine);
        while (this.mtgLine != null) {
            ++this.lineCounter;
            if (this.lineCounter == 101) {
                boolean bl = false;
            }
            mTGTokenizer.setCommentCharFound(false);
            mTGTokenizer.setLineString(this.mtgLine);
            String[] stringArray = mTGTokenizer.tokenizeLineString();
            if (stringArray != null) {
                try {
                    this.mtgGraphBuilder.processTokens(stringArray);
                }
                catch (MTGError.MTGGraphBuildException mTGGraphBuildException) {
                    this.errorMessage = mTGGraphBuildException.getError();
                    this.mtgLineReader.close();
                    return 4;
                }
                catch (Throwable throwable) {
                    this.errorMessage = throwable.getMessage();
                    this.mtgLineReader.close();
                    return 5;
                }
            }
            this.mtgLine = this.mtgLineReader.readLine();
        }
        this.mtgGraphBuilder.removeTypes();
        if (this.mtgLineReader.close() != 0) {
            this.errorMessage = "Error closing file buffer.";
            return 2;
        }
        if (this.mtgGraphBuilder.getStage() != 4L) {
            this.errorMessage = "Incomplete File Syntax.";
            return 3;
        }
        this.mtgGraphBuilder.storeNodeListInRoot();
        try {
            this.mtgGraphBuilder.removeInterScaleTopoRelations();
        }
        catch (MTGError.MTGPlantFrameException mTGPlantFrameException) {
            this.errorMessage = mTGPlantFrameException.getError();
            return 6;
        }
        catch (Throwable throwable) {
            return 7;
        }
        return 0;
    }

    public int translateMTGFile() {
        this.lineCounter = 0;
        this.errorMessage = "";
        try {
            this.mtgLineReader = new MTGLineReader(this.mtgReader);
        }
        catch (Throwable throwable) {
            return 1;
        }
        this.mtgGraphBuilder = new MTGGraphBuilder(this.systemId);
        String string = this.mtgLineReader.readLine();
        MTGTokenizer mTGTokenizer = new MTGTokenizer(string);
        while (string != null) {
            ++this.lineCounter;
            mTGTokenizer.setCommentCharFound(false);
            mTGTokenizer.setLineString(string);
            String[] stringArray = mTGTokenizer.tokenizeLineString();
            if (stringArray != null) {
                try {
                    this.mtgGraphBuilder.processTokens(stringArray);
                }
                catch (MTGError.MTGGraphBuildException mTGGraphBuildException) {
                    this.errorMessage = mTGGraphBuildException.getError();
                    this.mtgLineReader.close();
                    return 4;
                }
                catch (Throwable throwable) {
                    this.errorMessage = throwable.getMessage();
                    this.mtgLineReader.close();
                    return 5;
                }
            }
            string = this.mtgLineReader.readLine();
        }
        this.mtgGraphBuilder.removeTypes();
        if (this.mtgLineReader.close() != 0) {
            this.errorMessage = "Error closing file buffer.";
            return 2;
        }
        if (this.mtgGraphBuilder.getStage() != 4L) {
            this.errorMessage = "Incomplete File Syntax.";
            return 3;
        }
        this.mtgGraphBuilder.storeNodeListInRoot();
        try {
            this.mtgGraphBuilder.removeInterScaleTopoRelations();
        }
        catch (MTGError.MTGPlantFrameException mTGPlantFrameException) {
            this.errorMessage = mTGPlantFrameException.getError();
            return 6;
        }
        catch (Throwable throwable) {
            return 7;
        }
        return 0;
    }

    public MTGNode getMTGRootNode() {
        return this.mtgGraphBuilder.getMTGRootNode();
    }

    public MTGNode getFirstNode() {
        return this.mtgGraphBuilder.getFirstNode();
    }

    public RGGRoot getRootNode() {
        RGGRoot rGGRoot = new RGGRoot();
        rGGRoot.setGraphForDeserialization(Registry.current().getProjectGraph());
        rGGRoot.addEdgeBitsTo((Node)this.mtgGraphBuilder.getMTGRootNode(), 512, null);
        return rGGRoot;
    }

    public Sphere getSphere() {
        Sphere sphere = new Sphere(3.0f);
        return sphere;
    }

    public int getLineCounter() {
        return this.lineCounter;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

