/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.rgg;

import de.grogra.gpuflux.scene.experiment.Experiment;
import de.grogra.gpuflux.scene.experiment.Measurement;
import de.grogra.gpuflux.scene.filter.ObjectFilter;
import de.grogra.gpuflux.tracer.FluxLightModelTracer;
import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.spectral.SpectralCurve;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import de.grogra.pf.ui.Workbench;
import de.grogra.ray.physics.Spectrum;
import de.grogra.reflect.ClassAdapter;
import de.grogra.rgg.LightModelBase;

public class FluxLightModel
extends LightModelBase {
    private FluxLightModelTracer processor;
    public static final Type $TYPE = new Type(FluxLightModel.class);
    public static final SCOType.Field processor$FIELD = Type._addManagedField($TYPE, "processor", 0x200002, (de.grogra.reflect.Type)ClassAdapter.wrap(FluxLightModelTracer.class), null, 0);
    private transient int stamp;

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public FluxLightModel() {
        this(30000, 10);
    }

    public FluxLightModel(int n, int n2) {
        this(n, n2, 0.001);
    }

    public FluxLightModel(int n, int n2, double d) {
        this(n, n2, d, true);
    }

    public FluxLightModel(int n, int n2, double d, boolean bl) {
        this.processor = new FluxLightModelTracer(n, n2, d, bl);
    }

    public boolean isSensorsEnabled() {
        return this.processor.isEnableSensors();
    }

    public int getDepth() {
        return this.processor.getDepth();
    }

    public int getRayCount() {
        return this.processor.getRayCount();
    }

    public int getMinLambda() {
        return this.processor.getMinLambda();
    }

    public int getMaxLambda() {
        return this.processor.getMaxLambda();
    }

    public int getSpectralBuckets() {
        return this.processor.getSpectralBuckets();
    }

    public double getCutoffPower() {
        return this.processor.getSpectralBuckets();
    }

    public FluxLightModelTracer.MeasureMode getMeasureMode() {
        return this.processor.getMeasureMode();
    }

    public SpectralCurve[] getSpectralWeightCurve() {
        return this.processor.getSensitivityCurves();
    }

    public SpectralCurve getSpectralImportanceCurve() {
        return this.processor.getImportanceCurve();
    }

    public void setEnableSensors(boolean bl) {
        this.processor.setEnableSensors(bl);
    }

    public void setCutoffPower(double d) {
        this.processor.setCutoffPower(d);
    }

    public void setDepth(int n) {
        this.processor.setDepth(n);
    }

    public void setRayCount(int n) {
        this.processor.setRayCount(n);
    }

    public void setSpectralWeightCurves(SpectralCurve[] spectralCurveArray) {
        this.processor.setSensitivityCurves(spectralCurveArray);
    }

    public void setSpectralImportanceCurve(SpectralCurve spectralCurve) {
        this.processor.setImportanceCurve(spectralCurve);
    }

    public void setSpectralBuckets(int n) {
        this.processor.setSpectralBuckets(n);
    }

    public void setMeasureMode(FluxLightModelTracer.MeasureMode measureMode) {
        this.processor.setMeasureMode(measureMode);
    }

    public void setSpectralDomain(int n, int n2) {
        this.processor.setSpectralRange(n, n2);
    }

    public void setTargetVariance(double d, double d2) {
        this.processor.setTargetVariance(d, d2);
    }

    public void setDispersion(boolean bl) {
        this.processor.setDispersion(bl);
    }

    public void setFlatness(float f) {
        this.processor.setFlatness(f);
    }

    public void setMeasureObjectFilter(ObjectFilter objectFilter) {
        this.processor.setMeasureObjectFilter(objectFilter);
    }

    public void build() {
        this.processor.build();
    }

    public void compute() {
        this.compute(true, true);
    }

    public void compute(boolean bl) {
        this.compute(bl, true);
    }

    public void compute(boolean bl, boolean bl2) {
        Workbench workbench = Workbench.current();
        if (workbench == null) {
            return;
        }
        GraphManager graphManager = workbench.getRegistry().getProjectGraph();
        if (bl || this.stamp != graphManager.getStamp()) {
            this.processor.compute(bl, bl2);
            this.stamp = graphManager.getStamp();
        }
    }

    public void compute(Spectrum spectrum) {
        this.processor.compute();
    }

    public void compute(Spectrum spectrum, boolean bl) {
        this.processor.compute();
    }

    public Spectrum getAbsorbedPower(Node node) {
        return this.processor.getAbsorbedPower(node);
    }

    public Spectrum getSensedIrradiance(Node node) {
        return this.processor.getSensedIrradiance(node);
    }

    public Experiment getSensedIrradiance() {
        return this.processor.getSensedIrradiance();
    }

    public Experiment getAbsorbedPower() {
        return this.processor.getAbsorbedPower();
    }

    public Measurement getSensedIrradianceMeasurement(Node node) {
        return this.processor.getSensedIrradianceMeasurement(node);
    }

    public Measurement getAbsorbedPowerMeasurement(Node node) {
        return this.processor.getAbsorbedPowerMeasurement(node);
    }

    public void setLayerVisible(int n, boolean bl) {
        this.processor.setLayerVisible(n, bl);
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends SCOType {
        private static final int SUPER_FIELD_COUNT = 0;
        protected static final int FIELD_COUNT = 1;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(FluxLightModel fluxLightModel, SCOType sCOType) {
            super((Object)fluxLightModel, sCOType);
        }

        Type(Class clazz) {
            super(clazz, SCOType.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setObject(Object object, int n, Object object2) {
            switch (n) {
                case 0: {
                    ((FluxLightModel)((Object)object)).processor = (FluxLightModelTracer)object2;
                    return;
                }
            }
            super.setObject(object, n, object2);
        }

        protected Object getObject(Object object, int n) {
            switch (n) {
                case 0: {
                    return ((FluxLightModel)((Object)object)).processor;
                }
            }
            return super.getObject(object, n);
        }

        public Object newInstance() {
            return new FluxLightModel();
        }
    }
}

