/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.rgg;

import de.grogra.graph.Graph;
import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.Node;
import de.grogra.imp.IMPWorkbench;
import de.grogra.imp3d.ray2.SceneVisitor;
import de.grogra.imp3d.ray2.VolumeListener;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import de.grogra.pf.ui.Workbench;
import de.grogra.ray.physics.Collector;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.physics.Spectrum3d;
import de.grogra.ray2.Options;
import de.grogra.ray2.ProgressMonitor;
import de.grogra.ray2.Scene;
import de.grogra.ray2.tracing.ParallelRadiationModel;
import de.grogra.ray2.tracing.RadiationModel;
import de.grogra.reflect.ClassAdapter;
import de.grogra.rgg.Library;
import de.grogra.rgg.LightModelBase;
import de.grogra.vecmath.geom.Volume;
import de.grogra.xl.util.IntList;
import de.grogra.xl.util.LongToIntHashMap;

public class LightModel
extends LightModelBase
implements Options,
VolumeListener {
    private transient int stamp;
    private transient LongToIntHashMap nodeToGroup;
    private transient IntList idToGroup;
    private transient int grouping;
    private transient int nextGroupIndex;
    private transient int currentGroupIndex;
    private transient int msgCount = 20;
    private transient RadiationModel processor;
    private transient long totalSceneTime;
    private transient long totalRadiationTime;
    private int rayCount;
    private int depth;
    private double minPower;
    private long seed;
    private int threadCount;
    private Spectrum spectrumFactory = new Spectrum3d();
    private boolean[] visibleLayers;
    public static final Type $TYPE = new Type(LightModel.class);
    public static final SCOType.Field rayCount$FIELD = Type._addManagedField($TYPE, "rayCount", 0x200002, de.grogra.reflect.Type.INT, null, 0);
    public static final SCOType.Field depth$FIELD = Type._addManagedField($TYPE, "depth", 0x200002, de.grogra.reflect.Type.INT, null, 1);
    public static final SCOType.Field minPower$FIELD = Type._addManagedField($TYPE, "minPower", 0x200002, de.grogra.reflect.Type.DOUBLE, null, 2);
    public static final SCOType.Field seed$FIELD = Type._addManagedField($TYPE, "seed", 0x200002, de.grogra.reflect.Type.LONG, null, 3);
    public static final SCOType.Field threadCount$FIELD = Type._addManagedField($TYPE, "threadCount", 0x200002, de.grogra.reflect.Type.INT, null, 4);
    public static final SCOType.Field spectrumFactory$FIELD = Type._addManagedField($TYPE, "spectrumFactory", 0x200002, (de.grogra.reflect.Type)ClassAdapter.wrap(Spectrum.class), null, 5);
    public static final SCOType.Field visibleLayers$FIELD = Type._addManagedField($TYPE, "visibleLayers", 0x200002, (de.grogra.reflect.Type)ClassAdapter.wrap(boolean[].class), null, 6);

    public LightModel() {
        this(30000, 10);
    }

    public LightModel(int n, int n2) {
        this(n, n2, 0.001);
    }

    public LightModel(int n, int n2, double d) {
        this.setRayCount(n);
        this.setDepth(n2);
        this.setMinPower(d);
        this.visibleLayers = new boolean[16];
        for (int i = 0; i < 16; ++i) {
            this.visibleLayers[i] = true;
        }
    }

    public void compute() {
        this.compute(this.spectrumFactory);
    }

    public void compute(Spectrum spectrum) {
        this.compute(spectrum, false);
    }

    public void compute(boolean bl) {
        this.compute(this.spectrumFactory, bl);
    }

    public void compute(Spectrum spectrum, boolean bl) {
        this.msgCount = 20;
        IMPWorkbench iMPWorkbench = Library.workbench();
        if (iMPWorkbench == null) {
            return;
        }
        GraphManager graphManager = iMPWorkbench.getRegistry().getProjectGraph();
        if (bl || this.processor == null || this.stamp != graphManager.getStamp()) {
            if (this.nodeToGroup == null) {
                this.nodeToGroup = new LongToIntHashMap();
                this.idToGroup = new IntList();
            } else {
                this.nodeToGroup.clear();
                this.idToGroup.clear();
            }
            this.grouping = 0;
            this.nextGroupIndex = 1;
            this.currentGroupIndex = -1;
            long l = System.currentTimeMillis();
            SceneVisitor sceneVisitor = new SceneVisitor((Workbench)iMPWorkbench, (Graph)graphManager, 1.0E-5f, (Options)this, null, this.visibleLayers, (VolumeListener)this, spectrum.clone());
            long l2 = System.currentTimeMillis();
            l = l2 - l;
            this.processor = new ParallelRadiationModel((Scene)sceneVisitor, this.idToGroup.elements, this.threadCount);
            sceneVisitor.setProgress("Shooting rays...", 0.0f);
            this.processor.compute((long)this.rayCount, this.seed, (ProgressMonitor)sceneVisitor, this.depth, this.minPower);
            l2 = System.currentTimeMillis() - l2;
            sceneVisitor.setProgress("Done after " + (l + l2) + " ms", 2.0f);
            this.totalSceneTime += l;
            this.totalRadiationTime += l2;
            iMPWorkbench.logInfo("LightModel: " + l + '/' + l2 + " ms (total " + this.totalSceneTime + '/' + this.totalRadiationTime + " ms), " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L + " kB used, bounds are " + sceneVisitor.getBoundingBox());
            this.stamp = graphManager.getStamp();
            sceneVisitor.dispose();
        }
    }

    public void setDepth(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("depth must be a positive integer but was " + n);
        }
        this.depth = n;
    }

    public void setRayCount(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("rayCount must be a positive integer but was " + n);
        }
        this.rayCount = n;
    }

    public void setMinPower(double d) {
        if (!(d > 0.0)) {
            throw new IllegalArgumentException("minPower must be a positive double but was " + d);
        }
        this.minPower = d;
    }

    public void setLayerVisible(int n, boolean bl) {
        this.visibleLayers[n] = bl;
    }

    private static void print(String string) {
        IMPWorkbench iMPWorkbench = Library.workbench();
        if (iMPWorkbench != null) {
            iMPWorkbench.logGUIInfo(string);
        } else {
            Library.out.println(string);
        }
    }

    private int checkVolumeId(Node node) {
        if (this.nodeToGroup == null || this.processor == null) {
            if (this.msgCount > 0) {
                LightModel.print("LightModel data has not yet been computed.");
                --this.msgCount;
            }
            return -1;
        }
        int n = this.nodeToGroup.get(node.getId(), -1);
        if (n < 0 && this.msgCount > 0) {
            LightModel.print(node + " is invisible, no LightModel data available.");
            --this.msgCount;
        }
        return n;
    }

    public Spectrum getAbsorbedPower(Node node) {
        int n = this.checkVolumeId(node);
        return n >= 0 ? this.processor.getAbsorbedPower(n) : this.spectrumFactory.newInstance();
    }

    public Spectrum getSensedIrradiance(Node node) {
        int n = this.checkVolumeId(node);
        return n >= 0 ? this.processor.getSensedIrradiance(n) : this.spectrumFactory.newInstance();
    }

    public Collector getSensedIrradianceCollector(Node node) {
        int n = this.checkVolumeId(node);
        return n >= 0 ? this.processor.getSensedIrradianceCollector(n) : ((Collector)this.spectrumFactory).newInstance();
    }

    public Collector getAbsorbedPowerCollector(Node node) {
        int n = this.checkVolumeId(node);
        return n >= 0 ? this.processor.getAbsorbedPowerCollector(n) : ((Collector)this.spectrumFactory).newInstance();
    }

    public Object get(String string, Object object) {
        return object;
    }

    public void volumeCreated(Object object, boolean bl, Volume volume) {
        assert (bl);
        if (this.grouping == 0) {
            this.currentGroupIndex = this.nextGroupIndex++;
            this.nodeToGroup.put(((Node)object).getId(), this.currentGroupIndex);
        }
        this.idToGroup.set(volume.getId(), this.currentGroupIndex);
    }

    public void beginGroup(Object object, boolean bl) {
        assert (bl);
        if (this.grouping == 0) {
            this.currentGroupIndex = this.nodeToGroup.get(((Node)object).getId());
            if (this.currentGroupIndex == 0) {
                this.currentGroupIndex = this.nextGroupIndex++;
                this.nodeToGroup.put(((Node)object).getId(), this.currentGroupIndex);
            }
        }
        ++this.grouping;
    }

    public void endGroup() {
        if (--this.grouping < 0) {
            throw new IllegalStateException();
        }
    }

    public void invalidateOctree() {
        this.stamp = 0;
    }

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public int getRayCount() {
        return this.rayCount;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int n) {
        this.threadCount = n;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long l) {
        this.seed = l;
    }

    public double getMinPower() {
        return this.minPower;
    }

    public Spectrum getSpectrumFactory() {
        return this.spectrumFactory;
    }

    public void setSpectrumFactory(Spectrum spectrum) {
        spectrumFactory$FIELD.setObject((Object)this, (Object)spectrum);
    }

    static /* synthetic */ boolean[] access$602(LightModel lightModel, boolean[] blArray) {
        lightModel.visibleLayers = blArray;
        return blArray;
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends SCOType {
        private static final int SUPER_FIELD_COUNT = 0;
        protected static final int FIELD_COUNT = 7;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(LightModel lightModel, SCOType sCOType) {
            super((Object)lightModel, sCOType);
        }

        Type(Class clazz) {
            super(clazz, SCOType.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setInt(Object object, int n, int n2) {
            switch (n) {
                case 0: {
                    ((LightModel)((Object)object)).rayCount = n2;
                    return;
                }
                case 1: {
                    ((LightModel)((Object)object)).depth = n2;
                    return;
                }
                case 4: {
                    ((LightModel)((Object)object)).threadCount = n2;
                    return;
                }
            }
            super.setInt(object, n, n2);
        }

        protected int getInt(Object object, int n) {
            switch (n) {
                case 0: {
                    return ((LightModel)((Object)object)).getRayCount();
                }
                case 1: {
                    return ((LightModel)((Object)object)).getDepth();
                }
                case 4: {
                    return ((LightModel)((Object)object)).getThreadCount();
                }
            }
            return super.getInt(object, n);
        }

        protected void setLong(Object object, int n, long l) {
            switch (n) {
                case 3: {
                    ((LightModel)((Object)object)).seed = l;
                    return;
                }
            }
            super.setLong(object, n, l);
        }

        protected long getLong(Object object, int n) {
            switch (n) {
                case 3: {
                    return ((LightModel)((Object)object)).getSeed();
                }
            }
            return super.getLong(object, n);
        }

        protected void setDouble(Object object, int n, double d) {
            switch (n) {
                case 2: {
                    ((LightModel)((Object)object)).minPower = d;
                    return;
                }
            }
            super.setDouble(object, n, d);
        }

        protected double getDouble(Object object, int n) {
            switch (n) {
                case 2: {
                    return ((LightModel)((Object)object)).getMinPower();
                }
            }
            return super.getDouble(object, n);
        }

        protected void setObject(Object object, int n, Object object2) {
            switch (n) {
                case 5: {
                    ((LightModel)((Object)object)).spectrumFactory = (Spectrum)object2;
                    return;
                }
                case 6: {
                    LightModel.access$602((LightModel)((Object)object), (boolean[])object2);
                    return;
                }
            }
            super.setObject(object, n, object2);
        }

        protected Object getObject(Object object, int n) {
            switch (n) {
                case 5: {
                    return ((LightModel)((Object)object)).getSpectrumFactory();
                }
                case 6: {
                    return ((LightModel)((Object)object)).visibleLayers;
                }
            }
            return super.getObject(object, n);
        }

        public Object newInstance() {
            return new LightModel();
        }
    }
}

