/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.rgg;

import de.grogra.graph.Graph;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.ray2.SceneVisitor;
import de.grogra.imp3d.ray2.VolumeListener;
import de.grogra.math.RGBColor;
import de.grogra.persistence.Transaction;
import de.grogra.pf.ui.Workbench;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.physics.Spectrum3d;
import de.grogra.ray2.Options;
import de.grogra.rgg.Library;
import de.grogra.rgg.RGGRoot;
import de.grogra.vecmath.geom.Intersection;
import de.grogra.vecmath.geom.IntersectionList;
import de.grogra.vecmath.geom.Line;
import de.grogra.vecmath.geom.Volume;
import de.grogra.xl.util.IntList;
import de.grogra.xl.util.LongToIntHashMap;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Random;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scanner
implements Options,
VolumeListener {
    private Vector3d x0;
    private Vector3d y0;
    private Vector3d z0;
    private double thetaRange;
    private double phiRange;
    private double thetaStep;
    private double phiStep;
    private Matrix3d P;
    private double p;
    private boolean allCorrect;
    private boolean raysInit;
    private boolean rayCountInit;
    private double rayLength;
    private int RayCount;
    private ArrayList<Point3d> scannedPoints;
    private Point3d origin;
    private ArrayList<Line> rays;
    private boolean thetaNoise;
    private int thetaNoiseType;
    private boolean thetaNoiseAdapt;
    private double thetaNoiseParam1;
    private double thetaNoiseParam2;
    private boolean phiNoise;
    private int phiNoiseType;
    private boolean phiNoiseAdapt;
    private double phiNoiseParam1;
    private double phiNoiseParam2;
    private boolean distanceNoise;
    private int distanceNoiseType;
    private boolean distanceNoiseAdapt;
    private double distanceNoiseParam1;
    private double distanceNoiseParam2;
    private Random generator;
    private int[] hitList;
    private double[] hitDistance;
    private boolean prepareScene = true;
    public static final int NO_HIT = 0;
    public static final int HIT = 1;
    private transient boolean[] visibleLayers;
    private transient int currentGroupIndex;
    private transient int nextGroupIndex;
    private transient int grouping;
    private transient IntList groupToVolumeId;
    private transient LongToIntHashMap nodeToGroup;
    private IntersectionList ilist;
    private Intersection is;
    private SceneVisitor scene;
    private Spectrum3d spec;

    public Scanner() {
        this(new Vector3d(1.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.0, 0.0, 1.0), -0.1f, -0.1f, -0.1f, -0.1f, 10.0);
    }

    public Scanner(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, double d, double d2, double d3, double d4, double d5) {
        this.setBasis(vector3d, vector3d2, vector3d3);
        this.setRange(d, d2);
        this.setSteps(d, d2);
        this.setRayLength(d5);
        this.computeRayCount();
        this.initializeArrays();
        this.generator = new Random();
        this.setThetaNoise(false);
        this.setThetaNoiseType(0, false, 0.0, 0.0);
        this.setPhiNoise(false);
        this.setPhiNoiseType(0, false, 0.0, 0.0);
        this.setDistanceNoise(false);
        this.setDistanceNoiseType(0, false, 0.0, 0.0);
        if (this.nodeToGroup == null) {
            this.nodeToGroup = new LongToIntHashMap();
            this.groupToVolumeId = new IntList();
        } else {
            this.nodeToGroup.clear();
            this.groupToVolumeId.clear();
        }
        this.visibleLayers = new boolean[16];
        for (int i = 0; i < 16; ++i) {
            this.visibleLayers[i] = true;
        }
        this.grouping = 0;
        this.nextGroupIndex = 1;
        this.currentGroupIndex = -1;
        this.spec = new Spectrum3d();
    }

    public void setLayerVisible(int n, boolean bl) {
        if (n > 0) {
            this.visibleLayers[n] = bl;
        }
    }

    public void setPrepareScene() {
        this.prepareScene = true;
    }

    public void setpDrawRay(double d) {
        this.p = d;
    }

    private void computeRayCount() {
        this.RayCount = 0;
        if (this.thetaStep > 0.0 && this.thetaRange > 0.0) {
            int n = (int)Math.floor(this.thetaRange / this.thetaStep) + 1;
            if (this.phiStep > 0.0 && this.phiRange > 0.0) {
                int n2 = (int)Math.floor(this.phiRange / this.phiStep) + 1;
                this.RayCount = n * n2;
            } else {
                this.RayCount = n;
            }
        } else {
            this.RayCount = this.phiStep > 0.0 && this.phiRange > 0.0 ? (int)Math.floor(this.phiRange / this.phiStep) + 1 : 1;
        }
        this.rayCountInit = true;
        this.raysInit = false;
    }

    private void initializeArrays() {
        this.rays = new ArrayList(this.RayCount);
        this.hitList = new int[this.RayCount];
        this.hitDistance = new double[this.RayCount];
        this.scannedPoints = new ArrayList(this.RayCount);
        for (int i = 1; i <= this.RayCount; ++i) {
            this.rays.add(new Line());
        }
        this.raysInit = true;
    }

    public void setRange(double d, double d2) {
        this.thetaRange = d;
        if (this.thetaRange > Math.PI * 2) {
            this.thetaRange = Math.PI * 2;
        }
        this.phiRange = d2;
        if (this.phiRange > Math.PI) {
            this.thetaRange = Math.PI;
        }
        this.rayCountInit = false;
    }

    public void setSteps(double d, double d2) {
        this.thetaStep = d;
        this.phiStep = d2;
        this.rayCountInit = false;
    }

    public void setRayLength(double d) {
        this.rayLength = d;
        if (this.rayLength < 0.0) {
            this.allCorrect = false;
            System.err.println("rayLength < 0 ! (" + this.rayLength + ")");
        }
    }

    public void writeDataToFile(ArrayList<Point3d> arrayList, String string) throws IOException {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
        for (int i = 0; i < arrayList.size(); ++i) {
            printWriter.println(arrayList.get((int)i).x + "\t" + arrayList.get((int)i).y + "\t" + arrayList.get((int)i).z);
        }
        printWriter.close();
    }

    public ArrayList<Point3d> scanSphere(Point3d point3d, double d, double d2, double d3, Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        ArrayList<Point3d> arrayList = new ArrayList<Point3d>();
        if (d <= 0.0) {
            System.err.println("The radius must be > 0 !");
            return arrayList;
        }
        if (d2 <= 0.0) {
            System.err.println("The phi-angular step must be > 0 !");
            return arrayList;
        }
        if (!this.checkBasis(vector3d, vector3d2, vector3d3)) {
            return arrayList;
        }
        Vector3d vector3d4 = new Vector3d(vector3d);
        Vector3d vector3d5 = new Vector3d(vector3d2);
        Vector3d vector3d6 = new Vector3d(vector3d3);
        vector3d4.normalize();
        vector3d5.normalize();
        vector3d6.normalize();
        int n = (int)Math.floor(Math.PI / d2);
        for (int i = 0; i <= n; ++i) {
            double d4 = (double)i * d2;
            arrayList.addAll(this.scanCircleSphere(point3d, d4, d, vector3d4, vector3d5, vector3d6, d3));
        }
        return arrayList;
    }

    private ArrayList<Point3d> scanCircleSphere(Point3d point3d, double d, double d2, Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, double d3) {
        ArrayList<Point3d> arrayList = new ArrayList<Point3d>();
        double d4 = Math.sin(d);
        double d5 = Math.cos(d);
        int n = Math.sin(d) == 0.0 || d3 <= 0.0 ? 0 : (int)Math.floor(Math.PI * 2 / d3);
        for (int i = 0; i <= n; ++i) {
            double d6 = (double)i * d3;
            double d7 = Math.cos(d6);
            double d8 = Math.sin(d6);
            Vector3d vector3d4 = new Vector3d();
            vector3d4.scale(d7 * d4, (Tuple3d)vector3d);
            vector3d4.scaleAdd(d8 * d4, (Tuple3d)vector3d2, (Tuple3d)vector3d4);
            vector3d4.scaleAdd(d5, (Tuple3d)vector3d3, (Tuple3d)vector3d4);
            Vector3d vector3d5 = new Vector3d();
            vector3d5.scale(-d7 * d5, (Tuple3d)vector3d);
            vector3d5.scaleAdd(-d8 * d5, (Tuple3d)vector3d2, (Tuple3d)vector3d5);
            vector3d5.scaleAdd(d4, (Tuple3d)vector3d3, (Tuple3d)vector3d5);
            Vector3d vector3d6 = new Vector3d();
            vector3d6.scale(-d8, (Tuple3d)vector3d);
            vector3d6.scaleAdd(d7, (Tuple3d)vector3d2, (Tuple3d)vector3d6);
            Point3d point3d2 = new Point3d();
            point3d2.scaleAdd(d2, (Tuple3d)vector3d4, (Tuple3d)point3d);
            vector3d4.negate();
            this.setBasisNoCheck(vector3d4, vector3d5, vector3d6);
            this.scan(point3d2);
            arrayList.addAll(this.scannedPoints);
        }
        return arrayList;
    }

    public ArrayList<Point3d> scanSegment(Point3d point3d, Vector3d vector3d, float f, int n) {
        ArrayList<Point3d> arrayList = new ArrayList<Point3d>();
        if (f <= 0.0f) {
            System.err.println("The lenght of the steps must be > 0 !");
            return arrayList;
        }
        if (n <= 0) {
            System.err.println("The number of steps must be > 0 !");
            return arrayList;
        }
        if (vector3d.length() <= 0.0) {
            System.err.println("The direction vector is incorrect !");
            return arrayList;
        }
        Vector3d vector3d2 = new Vector3d(vector3d);
        vector3d2.normalize();
        for (int i = 0; i < n; ++i) {
            Point3d point3d2 = new Point3d();
            point3d2.scaleAdd((double)((float)i * f), (Tuple3d)vector3d2, (Tuple3d)point3d);
            this.scan(point3d2);
            arrayList.addAll(this.scannedPoints);
        }
        return arrayList;
    }

    public ArrayList<Point3d> scanCircle(Point3d point3d, double d, Vector3d vector3d, double d2) {
        Vector3d vector3d2 = new Vector3d();
        if (Math.abs(vector3d.x) > 1.0E-4) {
            vector3d2.x = vector3d.y;
            vector3d2.y = -vector3d.x;
            vector3d2.z = 0.0;
        } else {
            vector3d2.x = 0.0;
            vector3d2.y = -vector3d.z;
            vector3d2.z = vector3d.y;
        }
        return this.scanCircle(point3d, d, vector3d, vector3d2, d2);
    }

    public ArrayList<Point3d> scanCircle(Point3d point3d, double d, Vector3d vector3d, Vector3d vector3d2, double d2) {
        ArrayList<Point3d> arrayList = new ArrayList<Point3d>();
        if (d <= 0.0) {
            System.err.println("The radius must be > 0 !");
            return arrayList;
        }
        if (d2 <= 0.0) {
            System.err.println("The angular step must be > 0 !");
            return arrayList;
        }
        if (vector3d.length() < 1.0E-4) {
            System.err.println("The normal vector must not be null !");
            return arrayList;
        }
        if (vector3d2.length() < 1.0E-4) {
            System.err.println("The angle reference vector must not be null !");
            return arrayList;
        }
        if (Math.abs(vector3d2.dot(vector3d)) > 1.0E-4) {
            System.err.println("The given vectors are not orthogonal !");
            return arrayList;
        }
        int n = (int)Math.floor(Math.PI * 2 / d2);
        Vector3d vector3d3 = new Vector3d(vector3d);
        Vector3d vector3d4 = new Vector3d(vector3d2);
        vector3d3.normalize();
        vector3d4.normalize();
        Vector3d vector3d5 = new Vector3d();
        vector3d5.cross(vector3d3, vector3d4);
        for (int i = 0; i <= n; ++i) {
            Point3d point3d2 = new Point3d(point3d);
            Vector3d vector3d6 = new Vector3d();
            Vector3d vector3d7 = new Vector3d();
            double d3 = (double)i * d2;
            double d4 = Math.cos(d3);
            double d5 = Math.sin(d3);
            vector3d6.scale(d4, (Tuple3d)vector3d4);
            vector3d6.scaleAdd(d5, (Tuple3d)vector3d5, (Tuple3d)vector3d6);
            vector3d7.scale(-d5, (Tuple3d)vector3d4);
            vector3d7.scaleAdd(d4, (Tuple3d)vector3d5, (Tuple3d)vector3d7);
            point3d2.scaleAdd(d, (Tuple3d)vector3d6, (Tuple3d)point3d);
            vector3d6.negate();
            vector3d7.negate();
            this.setBasisNoCheck(vector3d6, vector3d7, vector3d3);
            this.scan(point3d2);
            arrayList.addAll(this.scannedPoints);
        }
        return arrayList;
    }

    private ArrayList<Point3d> scanCircleNoCheck(Point3d point3d, double d, Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, double d2) {
        ArrayList<Point3d> arrayList = new ArrayList<Point3d>();
        int n = (int)Math.floor(Math.PI * 2 / d2);
        for (int i = 0; i <= n; ++i) {
            Point3d point3d2 = new Point3d(point3d);
            Vector3d vector3d4 = new Vector3d();
            Vector3d vector3d5 = new Vector3d();
            double d3 = (double)i * d2;
            double d4 = Math.cos(d3);
            double d5 = Math.sin(d3);
            vector3d4.scale(d4, (Tuple3d)vector3d);
            vector3d4.scaleAdd(d5, (Tuple3d)vector3d2, (Tuple3d)vector3d4);
            vector3d5.scale(-d5, (Tuple3d)vector3d);
            vector3d5.scaleAdd(d4, (Tuple3d)vector3d2, (Tuple3d)vector3d5);
            point3d2.scaleAdd(d, (Tuple3d)vector3d4, (Tuple3d)point3d);
            vector3d4.negate();
            vector3d5.negate();
            this.setBasisNoCheck(vector3d4, vector3d5, vector3d3);
            this.scan(point3d2);
            arrayList.addAll(this.scannedPoints);
        }
        return arrayList;
    }

    public ArrayList<Point3d> scanCylinder(Point3d point3d, Vector3d vector3d, double d, double d2, double d3, int n, Vector3d vector3d2) {
        ArrayList<Point3d> arrayList = new ArrayList<Point3d>();
        if (d2 <= 0.0) {
            System.err.println("The angular step must be > 0 ! ");
            return arrayList;
        }
        if (d3 <= 0.0) {
            System.err.println("The lenght of the steps along the axis must be > 0 ! ");
            return arrayList;
        }
        if (n <= 0) {
            System.err.println("The number of steps along the axis must be > 0 ! ");
            return arrayList;
        }
        if (vector3d.length() < 1.0E-4) {
            System.err.println("The axis vector must not be null !");
            return arrayList;
        }
        if (vector3d2.length() < 1.0E-4) {
            System.err.println("The angle reference vector must not be null !");
            return arrayList;
        }
        if (Math.abs(vector3d2.dot(vector3d)) > 1.0E-4) {
            System.err.println("The given vectors are not orthogonal !");
            return arrayList;
        }
        Vector3d vector3d3 = new Vector3d(vector3d);
        Vector3d vector3d4 = new Vector3d(vector3d2);
        vector3d3.normalize();
        vector3d4.normalize();
        Vector3d vector3d5 = new Vector3d();
        vector3d5.cross(vector3d3, vector3d4);
        for (int i = 0; i < n; ++i) {
            Point3d point3d2 = new Point3d();
            point3d2.scaleAdd((double)i * d3, (Tuple3d)vector3d3, (Tuple3d)point3d);
            arrayList.addAll(this.scanCircleNoCheck(point3d2, d, vector3d4, vector3d5, vector3d3, d2));
        }
        return arrayList;
    }

    public ArrayList<Point3d> scanCylinder(Point3d point3d, Vector3d vector3d, double d, double d2, double d3, int n) {
        Vector3d vector3d2 = new Vector3d();
        if (Math.abs(vector3d.x) > 1.0E-4) {
            vector3d2.x = vector3d.y;
            vector3d2.y = -vector3d.x;
            vector3d2.z = 0.0;
        } else {
            vector3d2.x = 0.0;
            vector3d2.y = -vector3d.z;
            vector3d2.z = vector3d.y;
        }
        return this.scanCylinder(point3d, vector3d, d, d2, d3, n, vector3d2);
    }

    private boolean checkBasis(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        if (Math.abs(vector3d.dot(vector3d2)) > 1.0E-4) {
            System.err.println("Vectors incorrect : x.y = " + vector3d.dot(vector3d2));
            return false;
        }
        if (Math.abs(vector3d.dot(vector3d3)) > 1.0E-4) {
            System.err.println("Vectors incorrect : x.z = " + vector3d2.dot(vector3d2));
            return false;
        }
        if (Math.abs(vector3d3.dot(vector3d2)) > 1.0E-4) {
            System.err.println("Vectors incorrect : z.y = " + vector3d3.dot(vector3d2));
            return false;
        }
        Vector3d vector3d4 = new Vector3d();
        vector3d4.cross(vector3d, vector3d2);
        if (vector3d4.dot(vector3d3) < 0.0) {
            System.err.println("Vectors incorrect : x (cross) y = " + vector3d4 + " ; and z = " + vector3d3);
            return false;
        }
        return true;
    }

    public void setBasis(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        this.allCorrect = this.checkBasis(vector3d, vector3d2, vector3d3);
        Vector3d vector3d4 = new Vector3d(vector3d);
        Vector3d vector3d5 = new Vector3d(vector3d2);
        Vector3d vector3d6 = new Vector3d(vector3d3);
        if (this.allCorrect) {
            vector3d4.normalize();
            vector3d5.normalize();
            vector3d6.normalize();
        }
        this.x0 = vector3d4;
        this.y0 = vector3d5;
        this.z0 = vector3d6;
        if (this.allCorrect) {
            this.P = new Matrix3d(this.x0.x, this.y0.x, this.z0.x, this.x0.y, this.y0.y, this.z0.y, this.x0.z, this.y0.z, this.z0.z);
        }
    }

    private void setBasisNoCheck(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        this.allCorrect = true;
        this.x0 = vector3d;
        this.y0 = vector3d2;
        this.z0 = vector3d3;
        this.P = new Matrix3d(this.x0.x, this.y0.x, this.z0.x, this.x0.y, this.y0.y, this.z0.y, this.x0.z, this.y0.z, this.z0.z);
    }

    public int getScannedPointsNb() {
        return this.scannedPoints.size();
    }

    public ArrayList<Point3d> getScannedPoints() {
        return this.scannedPoints;
    }

    public void prepareScene() {
        if (this.prepareScene || this.scene == null) {
            if (this.scene != null) {
                this.scene.dispose();
            }
            this.grouping = 0;
            this.nextGroupIndex = 1;
            this.currentGroupIndex = -1;
            this.nodeToGroup.clear();
            this.groupToVolumeId.clear();
            this.scene = new SceneVisitor(Workbench.current(), (Graph)Workbench.current().getRegistry().getProjectGraph(), 1.0E-5f, (Options)this, null, this.visibleLayers, (VolumeListener)this, (Spectrum)this.spec);
            this.prepareScene = false;
        }
        this.setListToZero(this.rays);
        this.ilist = new IntersectionList();
        this.is = new Intersection(new IntersectionList());
    }

    public void scan(Point3d point3d) {
        if (!this.allCorrect) {
            System.err.println("Error in the parameters ! No scan will be performed !");
            return;
        }
        if (!this.rayCountInit) {
            this.computeRayCount();
            this.initializeArrays();
        } else if (!this.raysInit) {
            this.initializeArrays();
        }
        this.prepareScene();
        this.origin = point3d;
        if (this.thetaNoise || this.phiNoise || this.distanceNoise) {
            this.shootRaysNoisy();
        } else {
            this.shootRays();
        }
        this.showLines();
        this.raysInit = false;
    }

    private void traceRay(int n) {
        int n2 = this.ilist.size;
        this.hitList[n] = 0;
        this.hitDistance[n] = 0.0;
        this.ilist.clear();
        Line line = this.rays.get(n);
        this.scene.computeIntersections(line, 1, this.ilist, this.is, null);
        if (this.ilist.size > n2) {
            Intersection intersection = this.ilist.elements[0];
            if (intersection.parameter < Double.POSITIVE_INFINITY) {
                this.hitList[n] = 1;
                this.hitDistance[n] = intersection.parameter;
            }
            this.ilist.setSize(n2);
        }
    }

    private void shootRays() {
        int n = this.thetaRange > 0.0 && this.thetaStep > 0.0 ? (int)Math.floor(this.thetaRange / this.thetaStep) : 0;
        int n2 = this.phiRange > 0.0 && this.phiStep > 0.0 ? (int)Math.floor(this.phiRange / this.phiStep) : 0;
        if (n > 0) {
            if (n2 > 0) {
                int n3 = 0;
                for (int i = 0; i <= n; ++i) {
                    double d = -this.thetaRange / 2.0 + this.thetaStep * (double)i;
                    for (int j = 0; j <= n2; ++j) {
                        double d2 = 1.5707963267948966 - this.phiRange / 2.0 + this.phiStep * (double)j;
                        this.shootRay(d, d2, n3);
                        ++n3;
                    }
                }
            } else {
                int n4 = 0;
                for (int i = 0; i <= n; ++i) {
                    double d = -this.thetaRange / 2.0 + this.thetaStep * (double)i;
                    this.shootRayTheta(d, n4);
                    ++n4;
                }
            }
        } else if (n2 > 0) {
            int n5 = 0;
            for (int i = 0; i <= n2; ++i) {
                double d = 1.5707963267948966 - this.phiRange / 2.0 + this.phiStep * (double)i;
                this.shootRayPhi(d, n5);
                ++n5;
            }
        } else {
            Vector3d vector3d = this.x0;
            Line line = this.rays.get(0);
            line.origin.set((Tuple3d)this.origin);
            line.direction.set((Tuple3d)vector3d);
            line.start = 1.0E-4;
            line.end = this.rayLength;
            this.traceRay(0);
            if (this.hitList[0] == 1) {
                Point3d point3d = new Point3d();
                vector3d.scale(this.hitDistance[0]);
                point3d.add((Tuple3d)this.origin, (Tuple3d)vector3d);
                this.scannedPoints.add(point3d);
            }
        }
    }

    private void shootRaysNoisy() {
        int n = this.thetaRange > 0.0 && this.thetaStep > 0.0 ? (int)Math.floor(this.thetaRange / this.thetaStep) : 0;
        int n2 = this.phiRange > 0.0 && this.phiStep > 0.0 ? (int)Math.floor(this.phiRange / this.phiStep) : 0;
        if (n > 0) {
            if (n2 > 0) {
                int n3 = 0;
                for (int i = 0; i <= n; ++i) {
                    double d = -this.thetaRange / 2.0 + this.thetaStep * (double)i;
                    for (int j = 0; j <= n2; ++j) {
                        double d2 = 1.5707963267948966 - this.phiRange / 2.0 + this.phiStep * (double)j;
                        this.shootRayNoisy(d, d2, n3);
                        ++n3;
                    }
                }
            } else {
                int n4 = 0;
                for (int i = 0; i <= n; ++i) {
                    double d = -this.thetaRange / 2.0 + this.thetaStep * (double)i;
                    this.shootRayThetaNoisy(d, n4);
                    ++n4;
                }
            }
        } else if (n2 > 0) {
            int n5 = 0;
            for (int i = 0; i <= n2; ++i) {
                double d = 1.5707963267948966 - this.phiRange / 2.0 + this.phiStep * (double)i;
                this.shootRayPhiNoisy(d, n5);
                ++n5;
            }
        } else {
            Vector3d vector3d = this.x0;
            Line line = this.rays.get(0);
            line.origin.set((Tuple3d)this.origin);
            line.direction.set((Tuple3d)vector3d);
            line.start = 1.0E-4;
            line.end = this.rayLength;
            this.traceRay(0);
            if (this.hitList[0] == 1) {
                double d;
                if (this.thetaNoise || this.phiNoise) {
                    d = this.thetaNoise ? this.makeNoisyValue(0.0, this.thetaNoiseType, this.thetaNoiseParam1, this.thetaNoiseParam2, this.thetaNoiseAdapt) : 0.0;
                    double d3 = this.phiNoise ? this.makeNoisyValue(1.5707963267948966, this.phiNoiseType, this.phiNoiseParam1, this.phiNoiseParam2, this.phiNoiseAdapt) : 1.5707963267948966;
                    Vector3d vector3d2 = new Vector3d();
                    vector3d2.x = Math.cos(d) * Math.sin(d3);
                    vector3d2.y = Math.sin(d) * Math.sin(d3);
                    vector3d2.z = Math.cos(d3);
                    double[] dArray = new double[3];
                    for (int i = 0; i < 3; ++i) {
                        Vector3d vector3d3 = new Vector3d();
                        this.P.getRow(i, vector3d3);
                        dArray[i] = vector3d3.dot(vector3d2);
                    }
                    vector3d = new Vector3d(dArray);
                }
                d = this.distanceNoise ? this.makeNoisyValue(this.hitDistance[0], this.distanceNoiseType, this.distanceNoiseParam1, this.distanceNoiseParam2, this.distanceNoiseAdapt) : this.hitDistance[0];
                Point3d point3d = new Point3d();
                vector3d.scale(d);
                point3d.add((Tuple3d)this.origin, (Tuple3d)vector3d);
                this.scannedPoints.add(point3d);
            }
        }
    }

    public void setThetaNoise(boolean bl) {
        this.thetaNoise = bl;
    }

    public void setThetaNoiseType(int n, boolean bl, double d, double d2) {
        this.thetaNoiseType = n;
        this.thetaNoiseAdapt = bl;
        this.thetaNoiseParam1 = d;
        this.thetaNoiseParam2 = d2;
    }

    public void setPhiNoise(boolean bl) {
        this.phiNoise = bl;
    }

    public void setPhiNoiseType(int n, boolean bl, double d, double d2) {
        this.phiNoiseType = n;
        this.phiNoiseAdapt = bl;
        this.phiNoiseParam1 = d;
        this.phiNoiseParam2 = d2;
    }

    public void setDistanceNoise(boolean bl) {
        this.distanceNoise = bl;
    }

    public void setDistanceNoiseType(int n, boolean bl, double d, double d2) {
        this.distanceNoiseType = n;
        this.distanceNoiseAdapt = bl;
        this.distanceNoiseParam1 = d;
        this.distanceNoiseParam2 = d2;
    }

    private double makeNoisyValue(double d, int n, double d2, double d3, boolean bl) {
        if (n == 0) {
            double d4 = this.generator.nextDouble();
            if (bl) {
                return d * (1.0 + (d3 - d2) * d4 + d2);
            }
            return d + (d3 - d2) * d4 + d2;
        }
        if (n == 1) {
            double d5 = this.generator.nextGaussian();
            if (bl) {
                return d * (1.0 + d2 + d3 * d5);
            }
            return d + d2 + d3 * d5;
        }
        return d;
    }

    private void shootRayNoisy(double d, double d2, int n) {
        Vector3d vector3d;
        Vector3d vector3d2 = new Vector3d();
        vector3d2.x = Math.cos(d) * Math.sin(d2);
        vector3d2.y = Math.sin(d) * Math.sin(d2);
        vector3d2.z = Math.cos(d2);
        double[] dArray = new double[3];
        for (int i = 0; i < 3; ++i) {
            vector3d = new Vector3d();
            this.P.getRow(i, vector3d);
            dArray[i] = vector3d.dot(vector3d2);
        }
        Vector3d vector3d3 = new Vector3d(dArray);
        vector3d = this.rays.get(n);
        vector3d.origin.set((Tuple3d)this.origin);
        vector3d.direction.set((Tuple3d)vector3d3);
        vector3d.start = 1.0E-4;
        vector3d.end = this.rayLength;
        this.traceRay(n);
        if (this.hitList[n] == 1) {
            double d3;
            Vector3d vector3d4 = new Vector3d(vector3d2);
            if (this.thetaNoise || this.phiNoise) {
                d3 = this.thetaNoise ? this.makeNoisyValue(0.0, this.thetaNoiseType, this.thetaNoiseParam1, this.thetaNoiseParam2, this.thetaNoiseAdapt) : d;
                double d4 = this.phiNoise ? this.makeNoisyValue(1.5707963267948966, this.phiNoiseType, this.phiNoiseParam1, this.phiNoiseParam2, this.phiNoiseAdapt) : d2;
                vector3d4.x = Math.cos(d3) * Math.sin(d4);
                vector3d4.y = Math.sin(d3) * Math.sin(d4);
                vector3d4.z = Math.cos(d4);
                double[] dArray2 = new double[3];
                for (int i = 0; i < 3; ++i) {
                    Vector3d vector3d5 = new Vector3d();
                    this.P.getRow(i, vector3d5);
                    dArray2[i] = vector3d5.dot(vector3d4);
                }
                vector3d3 = new Vector3d(dArray2);
            }
            d3 = this.distanceNoise ? this.makeNoisyValue(this.hitDistance[n], this.distanceNoiseType, this.distanceNoiseParam1, this.distanceNoiseParam2, this.distanceNoiseAdapt) : this.hitDistance[n];
            Point3d point3d = new Point3d();
            vector3d3.scale(d3);
            point3d.add((Tuple3d)this.origin, (Tuple3d)vector3d3);
            this.scannedPoints.add(point3d);
        }
    }

    private void shootRayThetaNoisy(double d, int n) {
        Vector3d vector3d;
        Vector3d vector3d2 = new Vector3d();
        vector3d2.x = Math.cos(d);
        vector3d2.y = Math.sin(d);
        vector3d2.z = 0.0;
        double[] dArray = new double[3];
        for (int i = 0; i < 3; ++i) {
            vector3d = new Vector3d();
            this.P.getRow(i, vector3d);
            dArray[i] = vector3d.dot(vector3d2);
        }
        Vector3d vector3d3 = new Vector3d(dArray);
        vector3d = this.rays.get(n);
        vector3d.origin.set((Tuple3d)this.origin);
        vector3d.direction.set((Tuple3d)vector3d3);
        vector3d.start = 1.0E-4;
        vector3d.end = this.rayLength;
        this.traceRay(n);
        if (this.hitList[n] == 1) {
            double d2;
            Vector3d vector3d4 = new Vector3d(vector3d2);
            if (this.thetaNoise || this.phiNoise) {
                d2 = this.thetaNoise ? this.makeNoisyValue(0.0, this.thetaNoiseType, this.thetaNoiseParam1, this.thetaNoiseParam2, this.thetaNoiseAdapt) : d;
                double d3 = this.phiNoise ? this.makeNoisyValue(1.5707963267948966, this.phiNoiseType, this.phiNoiseParam1, this.phiNoiseParam2, this.phiNoiseAdapt) : 1.5707963267948966;
                vector3d4.x = Math.cos(d2) * Math.sin(d3);
                vector3d4.y = Math.sin(d2) * Math.sin(d3);
                vector3d4.z = Math.cos(d3);
                double[] dArray2 = new double[3];
                for (int i = 0; i < 3; ++i) {
                    Vector3d vector3d5 = new Vector3d();
                    this.P.getRow(i, vector3d5);
                    dArray2[i] = vector3d5.dot(vector3d4);
                }
                vector3d3 = new Vector3d(dArray2);
            }
            d2 = this.distanceNoise ? this.makeNoisyValue(this.hitDistance[n], this.distanceNoiseType, this.distanceNoiseParam1, this.distanceNoiseParam2, this.distanceNoiseAdapt) : this.hitDistance[n];
            Point3d point3d = new Point3d();
            vector3d3.scale(d2);
            point3d.add((Tuple3d)this.origin, (Tuple3d)vector3d3);
            this.scannedPoints.add(point3d);
        }
    }

    private void shootRayPhiNoisy(double d, int n) {
        Vector3d vector3d;
        Vector3d vector3d2 = new Vector3d();
        vector3d2.x = Math.sin(d);
        vector3d2.y = 0.0;
        vector3d2.z = Math.cos(d);
        double[] dArray = new double[3];
        for (int i = 0; i < 3; ++i) {
            vector3d = new Vector3d();
            this.P.getRow(i, vector3d);
            dArray[i] = vector3d.dot(vector3d2);
        }
        Vector3d vector3d3 = new Vector3d(dArray);
        vector3d = this.rays.get(n);
        vector3d.origin.set((Tuple3d)this.origin);
        vector3d.direction.set((Tuple3d)vector3d3);
        vector3d.start = 1.0E-4;
        vector3d.end = this.rayLength;
        this.traceRay(n);
        if (this.hitList[n] == 1) {
            double d2;
            Vector3d vector3d4 = new Vector3d(vector3d2);
            if (this.thetaNoise || this.phiNoise) {
                d2 = this.thetaNoise ? this.makeNoisyValue(0.0, this.thetaNoiseType, this.thetaNoiseParam1, this.thetaNoiseParam2, this.thetaNoiseAdapt) : 0.0;
                double d3 = this.phiNoise ? this.makeNoisyValue(1.5707963267948966, this.phiNoiseType, this.phiNoiseParam1, this.phiNoiseParam2, this.phiNoiseAdapt) : d;
                vector3d4.x = Math.cos(d2) * Math.sin(d3);
                vector3d4.y = Math.sin(d2) * Math.sin(d3);
                vector3d4.z = Math.cos(d3);
                double[] dArray2 = new double[3];
                for (int i = 0; i < 3; ++i) {
                    Vector3d vector3d5 = new Vector3d();
                    this.P.getRow(i, vector3d5);
                    dArray2[i] = vector3d5.dot(vector3d4);
                }
                vector3d3 = new Vector3d(dArray2);
            }
            d2 = this.distanceNoise ? this.makeNoisyValue(this.hitDistance[n], this.distanceNoiseType, this.distanceNoiseParam1, this.distanceNoiseParam2, this.distanceNoiseAdapt) : this.hitDistance[n];
            Point3d point3d = new Point3d();
            vector3d3.scale(d2);
            point3d.add((Tuple3d)this.origin, (Tuple3d)vector3d3);
            this.scannedPoints.add(point3d);
        }
    }

    private void shootRay(double d, double d2, int n) {
        Vector3d vector3d;
        Vector3d vector3d2 = new Vector3d();
        vector3d2.x = Math.cos(d) * Math.sin(d2);
        vector3d2.y = Math.sin(d) * Math.sin(d2);
        vector3d2.z = Math.cos(d2);
        double[] dArray = new double[3];
        for (int i = 0; i < 3; ++i) {
            vector3d = new Vector3d();
            this.P.getRow(i, vector3d);
            dArray[i] = vector3d.dot(vector3d2);
        }
        Vector3d vector3d3 = new Vector3d(dArray);
        vector3d = this.rays.get(n);
        vector3d.origin.set((Tuple3d)this.origin);
        vector3d.direction.set((Tuple3d)vector3d3);
        vector3d.start = 1.0E-4;
        vector3d.end = this.rayLength;
        this.traceRay(n);
        if (this.hitList[n] == 1) {
            Point3d point3d = new Point3d();
            vector3d3.scale(this.hitDistance[n]);
            point3d.add((Tuple3d)this.origin, (Tuple3d)vector3d3);
            this.scannedPoints.add(point3d);
        }
    }

    private void shootRayPhi(double d, int n) {
        Vector3d vector3d;
        Vector3d vector3d2 = new Vector3d();
        vector3d2.x = Math.sin(d);
        vector3d2.y = 0.0;
        vector3d2.z = Math.cos(d);
        double[] dArray = new double[3];
        for (int i = 0; i < 3; ++i) {
            vector3d = new Vector3d();
            this.P.getRow(i, vector3d);
            dArray[i] = vector3d.dot(vector3d2);
        }
        Vector3d vector3d3 = new Vector3d(dArray);
        vector3d = this.rays.get(n);
        vector3d.origin.set((Tuple3d)this.origin);
        vector3d.direction.set((Tuple3d)vector3d3);
        vector3d.start = 1.0E-4;
        vector3d.end = this.rayLength;
        this.traceRay(n);
        if (this.hitList[n] == 1) {
            Point3d point3d = new Point3d();
            vector3d3.scale(this.hitDistance[n]);
            point3d.add((Tuple3d)this.origin, (Tuple3d)vector3d3);
            this.scannedPoints.add(point3d);
        }
    }

    private void shootRayTheta(double d, int n) {
        Vector3d vector3d;
        Vector3d vector3d2 = new Vector3d();
        vector3d2.x = Math.cos(d);
        vector3d2.y = Math.sin(d);
        vector3d2.z = 0.0;
        double[] dArray = new double[3];
        for (int i = 0; i < 3; ++i) {
            vector3d = new Vector3d();
            this.P.getRow(i, vector3d);
            dArray[i] = vector3d.dot(vector3d2);
        }
        Vector3d vector3d3 = new Vector3d(dArray);
        vector3d = this.rays.get(n);
        vector3d.origin.set((Tuple3d)this.origin);
        vector3d.direction.set((Tuple3d)vector3d3);
        vector3d.start = 1.0E-4;
        vector3d.end = this.rayLength;
        this.traceRay(n);
        if (this.hitList[n] == 1) {
            Point3d point3d = new Point3d();
            vector3d3.scale(this.hitDistance[n]);
            point3d.add((Tuple3d)this.origin, (Tuple3d)vector3d3);
            this.scannedPoints.add(point3d);
        }
    }

    private void setListToZero(ArrayList<Line> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            Line line = arrayList.get(i);
            line.origin.set(0.0, 0.0, 0.0);
            line.direction.set(0.0, 0.0, 0.0);
            line.start = 0.0;
            line.end = 0.0;
        }
    }

    private de.grogra.imp3d.objects.Line drawLine(int n) {
        if (n >= 0 && n <= this.RayCount) {
            RGBColor rGBColor;
            Line line = this.rays.get(n);
            double d = this.hitDistance[n] > 0.0 && this.hitDistance[n] < Double.POSITIVE_INFINITY && this.hitDistance[n] > 0.001 ? this.hitDistance[n] : line.end;
            line.direction.normalize();
            de.grogra.imp3d.objects.Line line2 = new de.grogra.imp3d.objects.Line((float)line.origin.x, (float)line.origin.y, (float)line.origin.z, (float)(line.direction.x * d), (float)(line.direction.y * d), (float)(line.direction.z * d));
            switch (this.hitList[n]) {
                case 1: {
                    rGBColor = new RGBColor(1.0f, 0.4f, 0.0f);
                    rGBColor.scale((float)this.hitDistance[n] / (float)line.end);
                    break;
                }
                default: {
                    rGBColor = RGBColor.YELLOW;
                }
            }
            line2.setColor((Color3f)rGBColor);
            return line2;
        }
        return null;
    }

    private void showLines() {
        block3: {
            Transaction transaction;
            block2: {
                transaction = Library.graph().getActiveTransaction();
                if (!(this.p < 1.0) || !(this.p > 0.0)) break block2;
                for (int i = 0; i < this.RayCount; ++i) {
                    if (!(Math.random() < this.p)) continue;
                    RGGRoot.getRoot(Library.graph()).addEdgeBitsTo((Node)this.drawLine(i), 512, transaction);
                }
                break block3;
            }
            if (!(this.p > 1.0)) break block3;
            for (int i = 0; i < this.RayCount; ++i) {
                RGGRoot.getRoot(Library.graph()).addEdgeBitsTo((Node)this.drawLine(i), 512, transaction);
            }
        }
    }

    public Object get(String string, Object object) {
        return object;
    }

    public void volumeCreated(Object object, boolean bl, Volume volume) {
        assert (bl);
        long l = ((Node)object).getId();
        if (this.grouping == 0) {
            this.currentGroupIndex = this.nextGroupIndex++;
            this.nodeToGroup.put(l, this.currentGroupIndex);
        }
        this.groupToVolumeId.set(this.currentGroupIndex, volume.getId());
    }

    public void beginGroup(Object object, boolean bl) {
        assert (bl);
        if (this.grouping == 0) {
            this.currentGroupIndex = this.nodeToGroup.get(((Node)object).getId());
            if (this.currentGroupIndex == 0) {
                this.currentGroupIndex = this.nextGroupIndex++;
                this.nodeToGroup.put(((Node)object).getId(), this.currentGroupIndex);
            }
        }
        ++this.grouping;
    }

    public void endGroup() {
        if (--this.grouping < 0) {
            throw new IllegalStateException();
        }
    }
}

