/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.math;

import de.grogra.math.Channel;
import de.grogra.math.ChannelMap;
import de.grogra.math.Pool;
import de.grogra.util.Utils;
import de.grogra.xl.util.BooleanList;
import de.grogra.xl.util.EHashMap;
import de.grogra.xl.util.IntList;
import de.grogra.xl.util.ObjectList;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3f;

public final class ChannelData
extends Pool {
    private ChannelMap map;
    private final EHashMap dataForMap;
    private final EHashMap.IdentityEntry<ChannelMap, ChannelData> dfmKey;
    private final ChannelData source;
    private ChannelData sink;
    private final ObjectList inMaps;
    private final ObjectList inMapData;
    private ChannelData defaultData;
    private EHashMap properties = null;
    private final EHashMap.ObjectEntry<String, Object> propKey;
    private boolean[] valid = new boolean[Channel.getCurrentChannelCount()];
    private float[] floatData = new float[Channel.getCurrentChannelCount()];
    private Object[] objectData = Utils.OBJECT_0;
    private final ObjectList dependencies = new ObjectList();
    private final IntList usedDepChannels = new IntList();
    private final Entry[] entryPool;
    private final EHashMap.ObjectEntry<String, Object>[] propertiesEntryPool;
    private final ObjectList depMapPool;
    private final ObjectList dataPool;
    private final ObjectList propertiesPool;
    private int usedDataCount = 0;
    private ChannelData requesting;
    private int requestedChannel;

    public ChannelData() {
        this.map = null;
        this.source = null;
        this.defaultData = this;
        this.dataForMap = new EHashMap();
        this.dfmKey = new EHashMap.IdentityEntry();
        this.propKey = new EHashMap.ObjectEntry();
        this.inMaps = null;
        this.inMapData = null;
        this.entryPool = new Entry[1];
        this.propertiesEntryPool = new EHashMap.ObjectEntry[1];
        this.depMapPool = new ObjectList();
        this.dataPool = new ObjectList();
        this.propertiesPool = new ObjectList();
    }

    public void clear() {
        assert (this.source == null);
        this.dataForMap.clear();
        this.clearImpl();
        for (int i = this.usedDataCount - 1; i >= 0; --i) {
            ((ChannelData)this.dataPool.get(i)).clearImpl();
        }
        this.usedDataCount = 0;
        this.defaultData = this;
        this.sink = null;
    }

    private void clearImpl() {
        this.map = null;
        this.defaultData = null;
        if (this.properties != null) {
            this.properties.clear();
            this.propertiesPool.add((Object)this.properties);
            this.properties = null;
        }
        while (!this.usedDepChannels.isEmpty()) {
            EHashMap eHashMap = (EHashMap)this.dependencies.set(this.usedDepChannels.pop(), null);
            this.depMapPool.add((Object)eHashMap);
            eHashMap.clear();
        }
        BooleanList.clear((boolean[])this.valid, (int)0, (int)this.valid.length);
        ObjectList.clear((Object[])this.objectData, (int)0, (int)this.objectData.length);
        if (this.inMaps != null) {
            this.inMaps.clear();
            this.inMapData.clear();
        }
        this.requesting = null;
    }

    public void invalidate() {
        assert (this.source == null);
        BooleanList.clear((boolean[])this.valid, (int)0, (int)this.valid.length);
        for (int i = this.usedDataCount - 1; i >= 0; --i) {
            boolean[] blArray = ((ChannelData)this.dataPool.get((int)i)).valid;
            BooleanList.clear((boolean[])blArray, (int)0, (int)blArray.length);
        }
    }

    public ChannelData initDefault(ChannelMap channelMap) {
        if (this.defaultData.map != channelMap) {
            if (this.defaultData != this) {
                throw new IllegalStateException();
            }
            this.defaultData = this.createChannelData(channelMap);
        }
        return this.defaultData;
    }

    private ChannelData(ChannelData channelData, ChannelMap channelMap) {
        this.map = channelMap;
        this.source = channelData;
        this.defaultData = null;
        this.dataForMap = channelData.dataForMap;
        this.dfmKey = channelData.dfmKey;
        this.entryPool = channelData.entryPool;
        this.propertiesEntryPool = channelData.propertiesEntryPool;
        this.propKey = channelData.propKey;
        this.depMapPool = channelData.depMapPool;
        this.propertiesPool = channelData.propertiesPool;
        this.dataPool = null;
        this.inMaps = new ObjectList(4, false);
        this.inMapData = new ObjectList(4);
    }

    private ChannelData createChannelData(ChannelMap channelMap) {
        ChannelData channelData;
        assert (this.source == null);
        if (this.usedDataCount < this.dataPool.size) {
            channelData = (ChannelData)this.dataPool.get(this.usedDataCount);
            channelData.map = channelMap;
        } else {
            channelData = new ChannelData(this, channelMap);
            this.dataPool.add((Object)channelData);
        }
        ++this.usedDataCount;
        EHashMap.IdentityEntry identityEntry = (EHashMap.IdentityEntry)this.dataForMap.popEntryFromPool();
        if (identityEntry == null) {
            identityEntry = new EHashMap.IdentityEntry();
        }
        identityEntry.setKey((Object)channelMap);
        identityEntry.value = channelData;
        this.dataForMap.put((EHashMap.Entry)identityEntry);
        return channelData;
    }

    public ChannelMap getMap() {
        return this.map;
    }

    public void setProperty(String string, Object object) {
        EHashMap.ObjectEntry objectEntry;
        if (this.properties == null) {
            this.properties = this.propertiesPool.isEmpty() ? new EHashMap(this.propertiesEntryPool, 10, 0.75f) : (EHashMap)this.propertiesPool.pop();
        }
        if ((objectEntry = (EHashMap.ObjectEntry)this.properties.popEntryFromPool()) == null) {
            objectEntry = new EHashMap.ObjectEntry();
        }
        objectEntry.setKey((Object)string);
        objectEntry.value = object;
        this.properties.put((EHashMap.Entry)objectEntry);
    }

    public Object getProperty(String string) {
        if (this.properties == null) {
            return null;
        }
        this.propKey.setKey((Object)string);
        EHashMap.ObjectEntry objectEntry = (EHashMap.ObjectEntry)this.properties.get(this.propKey);
        return objectEntry != null ? objectEntry.value : null;
    }

    public boolean isValid(int n) {
        return n < this.valid.length && this.valid[n];
    }

    public float getFloatValue(ChannelData channelData, int n) {
        if (n < this.valid.length && this.valid[n]) {
            if (channelData != null) {
                this.setDependency(n, channelData, channelData.requestedChannel);
            }
            return this.floatData[n];
        }
        if (this.map != null) {
            ChannelData channelData2 = this.requesting;
            int n2 = this.requestedChannel;
            this.requesting = channelData;
            this.requestedChannel = n;
            float f = this.map.getFloatValue(this, n);
            if (this.requestedChannel >= 0) {
                this.setFloat(n, f);
            }
            this.requesting = channelData2;
            this.requestedChannel = n2;
            return f;
        }
        return 0.0f;
    }

    public float forwardGetFloatValue(ChannelData channelData) {
        int n = this.requestedChannel;
        this.requestedChannel = -1;
        return channelData.getFloatValue(this.requesting, n);
    }

    public float getValidFloatValue(int n) {
        return this.floatData[n];
    }

    public Object getObjectValue(ChannelData channelData, int n) {
        if (n < this.valid.length && this.valid[n]) {
            if (channelData != null) {
                this.setDependency(n, channelData, channelData.requestedChannel);
            }
            return this.objectData[n];
        }
        if (this.map != null) {
            ChannelData channelData2 = this.requesting;
            int n2 = this.requestedChannel;
            this.requesting = channelData;
            this.requestedChannel = n;
            Object object = this.map.getObjectValue(this, n);
            if (this.requestedChannel >= 0) {
                this.setObject(n, object);
            }
            this.requesting = channelData2;
            this.requestedChannel = n2;
            return object;
        }
        return null;
    }

    public Object forwardGetObjectValue(ChannelData channelData) {
        int n = this.requestedChannel;
        this.requestedChannel = -1;
        return channelData.getObjectValue(this.requesting, n);
    }

    public Object getValidObjectValue(int n) {
        return this.objectData[n];
    }

    private void setDependency(int n, ChannelData channelData, int n2) {
        Entry entry;
        EHashMap eHashMap = (EHashMap)this.dependencies.get(n);
        if (eHashMap == null) {
            eHashMap = this.depMapPool.isEmpty() ? new EHashMap((EHashMap.Entry[])this.entryPool, 40, 0.5f) : (EHashMap)this.depMapPool.pop();
            this.dependencies.set(n, (Object)eHashMap);
            this.usedDepChannels.add(n);
        }
        if ((entry = (Entry)eHashMap.popEntryFromPool()) == null) {
            entry = new Entry();
        }
        entry.set(channelData, n2);
        eHashMap.getOrPut((EHashMap.Entry)entry);
    }

    private void invalidateDep(int n, boolean bl) {
        EHashMap eHashMap = (EHashMap)this.dependencies.get(n);
        if (eHashMap == null) {
            return;
        }
        Entry entry = (Entry)eHashMap.getFirstEntry();
        while (entry != null) {
            ChannelData channelData = entry.dependent;
            if ((bl || channelData != this) && channelData.setValid(entry.dependentChannel, false)) {
                channelData.invalidateDep(entry.dependentChannel, true);
            }
            entry = (Entry)entry.listNext;
        }
    }

    public void getTuple3f(Tuple3f tuple3f, ChannelData channelData, int n) {
        tuple3f.x = this.getFloatValue(channelData, n);
        tuple3f.y = this.getFloatValue(channelData, n + 1);
        tuple3f.z = this.getFloatValue(channelData, n + 2);
    }

    private boolean setValid(int n, boolean bl) {
        boolean bl2;
        boolean[] blArray = this.valid;
        if (bl) {
            if (n >= blArray.length) {
                this.valid = new boolean[n + 1];
                System.arraycopy(blArray, 0, this.valid, 0, blArray.length);
                blArray = this.valid;
                bl2 = false;
            } else {
                bl2 = blArray[n];
            }
            blArray[n] = true;
        } else if (n < blArray.length) {
            bl2 = blArray[n];
            blArray[n] = false;
            if (n < this.objectData.length) {
                this.objectData[n] = null;
            }
        } else {
            bl2 = false;
        }
        return bl2;
    }

    public void setFloat(int n, float f) {
        float[] fArray = this.floatData;
        if (n >= this.floatData.length) {
            this.floatData = new float[n + 1];
            System.arraycopy(fArray, 0, this.floatData, 0, fArray.length);
            fArray = this.floatData;
        }
        float f2 = fArray[n];
        fArray[n] = f;
        if (this.setValid(n, true) && f2 != f) {
            this.invalidateDep(n, false);
        }
        if (this.source != null) {
            if (this.requesting != null) {
                this.setDependency(n, this.requesting, this.requesting.requestedChannel);
            }
            if (n != this.requestedChannel) {
                this.setDependency(this.requestedChannel, this, n);
            }
        }
    }

    public void setObject(int n, Object object) {
        Object[] objectArray = this.objectData;
        if (n >= this.objectData.length) {
            this.objectData = new Object[n + 1];
            System.arraycopy(objectArray, 0, this.objectData, 0, objectArray.length);
            objectArray = this.objectData;
        }
        Object object2 = objectArray[n];
        objectArray[n] = object;
        if (this.setValid(n, true) && object2 != object) {
            this.invalidateDep(n, false);
        }
        if (this.source != null) {
            if (this.requesting != null) {
                this.setDependency(n, this.requesting, this.requesting.requestedChannel);
            }
            if (n != this.requestedChannel) {
                this.setDependency(this.requestedChannel, this, n);
            }
        }
    }

    public void setTuple3f(int n, Tuple3f tuple3f) {
        this.setFloat(n, tuple3f.x);
        this.setFloat(n + 1, tuple3f.y);
        this.setFloat(n + 2, tuple3f.z);
    }

    public void setTuple3f(int n, float f, float f2, float f3) {
        this.setFloat(n, f);
        this.setFloat(n + 1, f2);
        this.setFloat(n + 2, f3);
    }

    public void setTuple2f(int n, Tuple2f tuple2f) {
        this.setFloat(n, tuple2f.x);
        this.setFloat(n + 1, tuple2f.y);
    }

    public void setTuple2f(int n, float f, float f2) {
        this.setFloat(n, f);
        this.setFloat(n + 1, f2);
    }

    public ChannelData createSink(ChannelMap channelMap) {
        this.sink = this.getData(channelMap, false);
        return this.sink;
    }

    public ChannelData getSink() {
        return this.sink;
    }

    public ChannelData getData(ChannelMap channelMap) {
        return this.getData(channelMap, true);
    }

    private ChannelData getData(ChannelMap channelMap, boolean bl) {
        int n;
        if (channelMap == null) {
            return this == this.source.defaultData ? this.source : this.source.defaultData;
        }
        if (bl && (n = this.inMaps.indexOf((Object)channelMap)) >= 0) {
            return (ChannelData)this.inMapData.get(n);
        }
        this.dfmKey.setKey((Object)channelMap);
        EHashMap.Entry entry = this.dataForMap.get(this.dfmKey);
        ChannelData channelData = entry != null ? (ChannelData)((EHashMap.IdentityEntry)entry).value : (bl ? this.source : this).createChannelData(channelMap);
        if (bl) {
            this.inMaps.add((Object)channelMap);
            this.inMapData.add((Object)channelData);
        }
        return channelData;
    }

    public String toString() {
        return "ChannelData@" + Integer.toHexString(this.hashCode()) + '[' + this.map + ']';
    }

    private static final class Entry
    extends EHashMap.Entry {
        ChannelData dependent;
        int dependentChannel;

        private Entry() {
        }

        void set(ChannelData channelData, int n) {
            this.dependent = channelData;
            this.dependentChannel = n;
            this.hashCode = channelData.hashCode() * 31 + n;
        }

        public void clear() {
            this.dependent = null;
        }

        public boolean keyEquals(EHashMap.Entry entry) {
            Entry entry2 = (Entry)entry;
            return entry2.dependent == this.dependent && entry2.dependentChannel == this.dependentChannel;
        }

        public void copyValue(EHashMap.Entry entry) {
            throw new AssertionError();
        }

        public String toString() {
            return '[' + this.dependent.toString() + '.' + this.dependentChannel + ']';
        }
    }
}

