/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.math;

import de.grogra.graph.GraphState;
import de.grogra.graph.impl.ContextDependentBase;
import de.grogra.math.BSpline;
import de.grogra.math.VertexGrid;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import de.grogra.reflect.ClassAdapter;

public class SubGrid
extends ContextDependentBase
implements VertexGrid {
    VertexGrid grid;
    int offsetU;
    int offsetV;
    int widthU = -1;
    int widthV = -1;
    int step = 1;
    public static final Type $TYPE = new Type(SubGrid.class);
    public static final SCOType.Field grid$FIELD = Type._addManagedField($TYPE, "grid", 0x200000, (de.grogra.reflect.Type)ClassAdapter.wrap(VertexGrid.class), null, 0);
    public static final SCOType.Field offsetU$FIELD = Type._addManagedField($TYPE, "offsetU", 0x200000, de.grogra.reflect.Type.INT, null, 1);
    public static final SCOType.Field offsetV$FIELD = Type._addManagedField($TYPE, "offsetV", 0x200000, de.grogra.reflect.Type.INT, null, 2);
    public static final SCOType.Field widthU$FIELD = Type._addManagedField($TYPE, "widthU", 0x200000, de.grogra.reflect.Type.INT, null, 3);
    public static final SCOType.Field widthV$FIELD = Type._addManagedField($TYPE, "widthV", 0x200000, de.grogra.reflect.Type.INT, null, 4);
    public static final SCOType.Field step$FIELD = Type._addManagedField($TYPE, "step", 0x200000, de.grogra.reflect.Type.INT, null, 5);

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public int getOffsetU() {
        return this.offsetU;
    }

    public void setOffsetU(int n) {
        this.offsetU = n;
    }

    public int getOffsetV() {
        return this.offsetV;
    }

    public void setOffsetV(int n) {
        this.offsetV = n;
    }

    public int getWidthU() {
        return this.widthU;
    }

    public void setWidthU(int n) {
        this.widthU = n;
    }

    public int getWidthV() {
        return this.widthV;
    }

    public void setWidthV(int n) {
        this.widthV = n;
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int n) {
        this.step = n;
    }

    public VertexGrid getGrid() {
        return this.grid;
    }

    public void setGrid(VertexGrid vertexGrid) {
        grid$FIELD.setObject((Object)this, (Object)vertexGrid);
    }

    public int getUSize(GraphState graphState) {
        if (this.grid == null) {
            return 1;
        }
        int n = this.grid.getUSize(graphState) - this.offsetU;
        if (this.widthU >= 1) {
            n = Math.min(n, this.widthU);
        }
        return n / this.step;
    }

    public int getVSize(GraphState graphState) {
        if (this.grid == null) {
            return 1;
        }
        int n = this.grid.getVSize(graphState) - this.offsetV;
        if (this.widthV >= 1) {
            n = Math.min(n, this.widthV);
        }
        return n / this.step;
    }

    public int getVertexIndex(int n, int n2, GraphState graphState) {
        return this.grid == null ? 0 : this.grid.getVertexIndex(n * this.step + this.offsetU, n2 * this.step + this.offsetV, graphState);
    }

    public int getDimension(GraphState graphState) {
        return this.grid == null ? 2 : this.grid.getDimension(graphState);
    }

    public boolean isRational(GraphState graphState) {
        return this.grid != null && this.grid.isRational(graphState);
    }

    public int getVertex(float[] fArray, int n, GraphState graphState) {
        return this.grid == null ? BSpline.set(fArray, 0.0f, 0.0f) : this.grid.getVertex(fArray, n, graphState);
    }

    public boolean dependsOnContext() {
        return this.grid != null && this.grid.dependsOnContext();
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends SCOType {
        private static final int SUPER_FIELD_COUNT = 0;
        protected static final int FIELD_COUNT = 6;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(SubGrid subGrid, SCOType sCOType) {
            super((Object)subGrid, sCOType);
        }

        Type(Class clazz) {
            super(clazz, SCOType.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setInt(Object object, int n, int n2) {
            switch (n) {
                case 1: {
                    ((SubGrid)object).offsetU = n2;
                    return;
                }
                case 2: {
                    ((SubGrid)object).offsetV = n2;
                    return;
                }
                case 3: {
                    ((SubGrid)object).widthU = n2;
                    return;
                }
                case 4: {
                    ((SubGrid)object).widthV = n2;
                    return;
                }
                case 5: {
                    ((SubGrid)object).step = n2;
                    return;
                }
            }
            super.setInt(object, n, n2);
        }

        protected int getInt(Object object, int n) {
            switch (n) {
                case 1: {
                    return ((SubGrid)object).getOffsetU();
                }
                case 2: {
                    return ((SubGrid)object).getOffsetV();
                }
                case 3: {
                    return ((SubGrid)object).getWidthU();
                }
                case 4: {
                    return ((SubGrid)object).getWidthV();
                }
                case 5: {
                    return ((SubGrid)object).getStep();
                }
            }
            return super.getInt(object, n);
        }

        protected void setObject(Object object, int n, Object object2) {
            switch (n) {
                case 0: {
                    ((SubGrid)object).grid = (VertexGrid)object2;
                    return;
                }
            }
            super.setObject(object, n, object2);
        }

        protected Object getObject(Object object, int n) {
            switch (n) {
                case 0: {
                    return ((SubGrid)object).getGrid();
                }
            }
            return super.getObject(object, n);
        }

        public Object newInstance() {
            return new SubGrid();
        }
    }
}

