/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.math;

import de.grogra.xl.util.FloatList;

public abstract class SubdivisionHelper {
    protected final boolean rational;
    protected int dimension;
    protected int degree;
    protected float flatness = 0.001f;
    int maxDepth = 8;

    public SubdivisionHelper(boolean bl) {
        this.rational = bl;
    }

    protected boolean isFlat(float f, float f2, int n) {
        if (n >= this.maxDepth) {
            return true;
        }
        int n2 = this.degree + 1;
        if ((n = 1 << n) > n2) {
            return f * (float)n2 <= this.flatness * f2 * (float)n;
        }
        return f <= this.flatness * f2;
    }

    protected static void subdivide(FloatList floatList, int n, int n2, int n3, int n4, int n5, float[] fArray) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11 = (n4 - 1) * n5 + n2 * n3 + n;
        int n12 = floatList.size - n11;
        floatList.setSize(n12 + 2 * n11);
        float[] fArray2 = floatList.elements;
        for (n10 = n4 - 1; n10 >= 0; --n10) {
            n9 = n10 * n5;
            FloatList.arraycopy((float[])fArray2, (int)(n12 + n9), (float[])fArray2, (int)(n12 + n11 + n9), (int)n);
        }
        for (n10 = n2 - 1; n10 >= 0; --n10) {
            for (n9 = n4 - 1; n9 >= 0; --n9) {
                n8 = n9 * n5 + n10 * n3;
                n7 = (n10 * n4 + n9) * n;
                for (n6 = n - 1; n6 >= 0; --n6) {
                    fArray[n7 + n6] = 0.5f * (fArray2[n12 + n8 + n6] + fArray2[n12 + n8 + n3 + n6]);
                }
            }
        }
        for (n10 = n4 - 1; n10 >= 0; --n10) {
            n9 = n10 * n5;
            FloatList.arraycopy((float[])fArray, (int)(n10 * n), (float[])fArray2, (int)(n12 + n11 + n9 + n3), (int)n);
            FloatList.arraycopy((float[])fArray, (int)(((n2 - 1) * n4 + n10) * n), (float[])fArray2, (int)(n12 + (n9 += (n2 - 1) * n3)), (int)n);
        }
        n10 = n4 * n;
        for (n9 = n2 - 2; n9 >= 0; --n9) {
            for (n8 = 0; n8 <= n9; ++n8) {
                n7 = n8 * n10;
                for (n6 = n10 - 1; n6 >= 0; --n6) {
                    fArray[n7 + n6] = 0.5f * (fArray[n7 + n6] + fArray[n7 + n10 + n6]);
                }
            }
            for (n8 = n4 - 1; n8 >= 0; --n8) {
                n7 = n8 * n5;
                FloatList.arraycopy((float[])fArray, (int)(n8 * n), (float[])fArray2, (int)(n12 + n11 + n7 + n3 * (n2 - n9)), (int)n);
                FloatList.arraycopy((float[])fArray, (int)((n9 * n4 + n8) * n), (float[])fArray2, (int)(n12 + (n7 += n9 * n3)), (int)n);
            }
        }
    }

    protected void subdivideCurve(FloatList floatList, float[] fArray, int n, int n2) {
        int n3 = this.dimension;
        int n4 = n3 * (this.degree + 1);
        int n5 = floatList.size - n4;
        if (this.degree > 1) {
            float[] fArray2 = floatList.elements;
            float f = 0.0f;
            float f2 = 0.0f;
            boolean bl = true;
            boolean bl2 = this.rational;
            float f3 = bl2 ? 1.0f / fArray2[n5 + n3 - 1] : 0.0f;
            for (int i = n4 - n3; i > 0; i -= n3) {
                float f4 = 0.0f;
                float f5 = 0.0f;
                float f6 = bl2 ? 1.0f / fArray2[n5 + i + n3 - 1] : 0.0f;
                for (int j = n3 - (this.rational ? 2 : 1); j >= 0; --j) {
                    float f7;
                    float f8;
                    if (this.rational) {
                        f8 = f6 * fArray2[n5 + i + j] - f3 * fArray2[n5 + j];
                        f7 = f8 * f8;
                    } else {
                        f8 = fArray2[n5 + i + j] - fArray2[n5 + j];
                        f7 = f8 * f8;
                    }
                    f4 += f7;
                    if (bl) {
                        fArray[j] = f8;
                        continue;
                    }
                    f5 += fArray[j] * f8;
                }
                if (bl) {
                    bl = false;
                    f = f4 * 1.1f;
                    f2 = -1.0f / f4;
                    continue;
                }
                if (!(f4 > f || f > 0.0f && !this.isFlat(f4 + f5 * f5 * f2, f, n2))) {
                    continue;
                }
                break;
            }
        } else {
            this.visitFlat(floatList.elements, n5);
            return;
        }
        SubdivisionHelper.subdivide(floatList, n3, this.degree, n3, 1, 0, fArray);
        this.subdivideCurve(floatList, fArray, 1, n2 + 1);
        floatList.setSize(n5 + n4);
        this.subdivideCurve(floatList, fArray, -1, n2 + 1);
    }

    protected abstract void visitFlat(float[] var1, int var2);
}

