/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.math;

import de.grogra.graph.GraphState;
import de.grogra.graph.impl.ContextDependentBase;
import de.grogra.math.BSpline;
import de.grogra.math.BSplineCurve;
import de.grogra.math.BSplineCurveList;
import de.grogra.math.Pool;
import de.grogra.persistence.SCOType;
import de.grogra.vecmath.Math2;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;

public abstract class Sweep
extends ContextDependentBase
implements BSplineCurveList {
    boolean useRail = false;
    public static final Type $TYPE = new Type(Sweep.class);
    public static final SCOType.Field useRail$FIELD = Type._addManagedField($TYPE, "useRail", 0x200000, de.grogra.reflect.Type.BOOLEAN, null, 0);

    protected abstract BSplineCurve getTrajectory(GraphState var1);

    protected abstract Object[] initCache(GraphState var1);

    protected Object[] getCache(GraphState graphState) {
        Object[] objectArray = this.getCacheImpl(graphState);
        objectArray[0] = this.computeTrajectory(objectArray, graphState);
        return objectArray;
    }

    protected Object[] getCacheImpl(GraphState graphState) {
        Object[] objectArray = (Object[])graphState.getObjectContext().getValue((Object)this);
        if (objectArray != null) {
            return objectArray;
        }
        objectArray = this.initCache(graphState);
        graphState.getObjectContext().setValue((Object)this, (Object)objectArray);
        return objectArray;
    }

    protected float[] computeTrajectory(Object[] objectArray, GraphState graphState) {
        BSplineCurve bSplineCurve = this.getTrajectory(graphState);
        int n = bSplineCurve.getSize(graphState) - 1;
        int n2 = bSplineCurve.getDegree(graphState);
        if (n2 <= 0 || n < n2) {
            n = -1;
        }
        float[] fArray = new float[16 * (n + 1)];
        if (n >= 0) {
            Pool pool = Pool.push(graphState);
            int n3 = bSplineCurve.getDimension(graphState);
            float f = (float)n2 * bSplineCurve.getKnot(0, n2, graphState);
            float f2 = 1.0f / (float)n2;
            float[] fArray2 = pool.getFloatArray(0, (n2 + 1) * (n2 + 1));
            float[] fArray3 = pool.getFloatArray(1, Math.max(n2 + 1, n3));
            float[] fArray4 = pool.getFloatArray(2, n2 + 1);
            float[] fArray5 = pool.getFloatArray(3, 2 * (n2 + 1));
            Point4f point4f = pool.p4f0;
            Point4f point4f2 = pool.p4f1;
            Vector4f vector4f = pool.v4f0;
            Vector3f vector3f = pool.v3f0;
            Vector3f vector3f2 = pool.v3f1;
            Vector3f vector3f3 = pool.v3f2;
            boolean bl = bSplineCurve.isRational(graphState);
            for (int i = 0; i <= n; ++i) {
                float f3 = (f += bSplineCurve.getKnot(0, Math.min(i + n2, n + 1), graphState) - bSplineCurve.getKnot(0, Math.max(i, n2), graphState)) * f2;
                int n4 = BSpline.findSpan(n, n2, f3, bSplineCurve, 0, graphState);
                BSpline.calculateDerivatives(fArray5, n2, bSplineCurve, 0, n4, f3, 1, graphState, fArray3, fArray4, fArray2);
                n4 -= n2;
                vector3f3.z = 0.0f;
                vector3f3.y = 0.0f;
                vector3f3.x = 0.0f;
                vector4f.w = 0.0f;
                vector4f.z = 0.0f;
                vector4f.y = 0.0f;
                vector4f.x = 0.0f;
                point4f2.w = 0.0f;
                point4f2.z = 0.0f;
                point4f2.y = 0.0f;
                point4f2.x = 0.0f;
                float f4 = 0.0f;
                boolean bl2 = false;
                for (int j = 0; j <= n2; ++j) {
                    f3 = fArray5[j];
                    int n5 = bSplineCurve.getVertex(fArray3, n4 + j, graphState);
                    BSpline.set((Tuple4f)point4f, fArray3, n5, bl);
                    point4f2.scaleAdd(f3, (Tuple4f)point4f, (Tuple4f)point4f2);
                    vector4f.scaleAdd(fArray5[n2 + 1 + j], (Tuple4f)point4f, (Tuple4f)vector4f);
                    if (bl) {
                        --n5;
                    }
                    if (n5 <= 6) continue;
                    vector3f3.x += f3 * fArray3[3];
                    vector3f3.y += f3 * fArray3[4];
                    vector3f3.z += f3 * fArray3[5];
                    f4 += f3 * fArray3[6];
                    bl2 = true;
                }
                f3 = 1.0f / point4f2.w;
                point4f.scale(-vector4f.w * f3 * f3, (Tuple4f)point4f2);
                vector3f2.x = vector4f.x * f3 + point4f.x;
                vector3f2.y = vector4f.y * f3 + point4f.y;
                vector3f2.z = vector4f.z * f3 + point4f.z;
                vector3f2.normalize();
                if (i == 0) {
                    if (!bl2) {
                        Math2.getOrthogonal((Tuple3f)vector3f2, (Tuple3f)vector3f);
                        f4 = 1.0f;
                    }
                    f3 = point4f2.w * this.initLocalX(vector3f, vector3f2, vector3f3, f4, objectArray, graphState);
                } else {
                    if (!bl2) {
                        vector3f3.set((Tuple3f)vector3f);
                        f4 = 1.0f;
                    }
                    f3 = point4f2.w * this.calculateLocalX(vector3f, vector3f2, vector3f3, f4, objectArray, graphState);
                }
                vector3f.normalize();
                n4 = i << 4;
                fArray[n4] = vector3f.x * f3;
                fArray[n4 + 4] = vector3f.y * f3;
                fArray[n4 + 8] = vector3f.z * f3;
                fArray[n4 + 2] = vector3f2.x * f3;
                fArray[n4 + 6] = vector3f2.y * f3;
                fArray[n4 + 10] = vector3f2.z * f3;
                vector3f2.cross(vector3f2, vector3f);
                fArray[n4 + 1] = vector3f2.x * f3;
                fArray[n4 + 5] = vector3f2.y * f3;
                fArray[n4 + 9] = vector3f2.z * f3;
                fArray[n4 + 3] = point4f2.x;
                fArray[n4 + 7] = point4f2.y;
                fArray[n4 + 11] = point4f2.z;
                fArray[n4 + 15] = point4f2.w;
            }
            pool.pop(graphState);
        }
        return fArray;
    }

    protected float initLocalX(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, float f, Object[] objectArray, GraphState graphState) {
        if (this.useRail) {
            vector3f.scaleAdd(-vector3f3.dot(vector3f2), (Tuple3f)vector3f2, (Tuple3f)vector3f3);
        } else {
            Math2.getOrthogonal((Tuple3f)vector3f2, (Tuple3f)vector3f);
        }
        return f;
    }

    protected float calculateLocalX(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, float f, Object[] objectArray, GraphState graphState) {
        if (this.useRail) {
            vector3f.scaleAdd(-vector3f3.dot(vector3f2), (Tuple3f)vector3f2, (Tuple3f)vector3f3);
        } else {
            vector3f.scaleAdd(-vector3f.dot(vector3f2), (Tuple3f)vector3f2, (Tuple3f)vector3f);
        }
        return f;
    }

    public int getSize(GraphState graphState) {
        return ((float[])this.getCache(graphState)[0]).length >> 4;
    }

    public int getDimension(int n, GraphState graphState) {
        return 4;
    }

    public boolean isRational(int n, GraphState graphState) {
        return true;
    }

    public boolean areCurvesCompatible(GraphState graphState) {
        return true;
    }

    protected abstract int getVertexImpl(float[] var1, int var2, int var3, Object[] var4, GraphState var5);

    public int getVertex(float[] fArray, int n, int n2, GraphState graphState) {
        float f;
        Object[] objectArray = this.getCache(graphState);
        float[] fArray2 = (float[])objectArray[0];
        int n3 = this.getVertexImpl(fArray, n, n2, objectArray, graphState);
        if (n3 < 0) {
            n3 = -n3;
            f = fArray[n3];
        } else {
            f = 1.0f;
        }
        float f2 = f;
        float f3 = fArray[0];
        float f4 = n3 > 1 ? fArray[1] : 0.0f;
        float f5 = n3 > 2 ? fArray[2] : 0.0f;
        return BSpline.set(fArray, fArray2[n <<= 4] * f3 + fArray2[n + 1] * f4 + fArray2[n + 2] * f5 + fArray2[n + 3] * f2, fArray2[n + 4] * f3 + fArray2[n + 5] * f4 + fArray2[n + 6] * f5 + fArray2[n + 7] * f2, fArray2[n + 8] * f3 + fArray2[n + 9] * f4 + fArray2[n + 10] * f5 + fArray2[n + 11] * f2, fArray2[n + 15] * f2);
    }

    public void setUseRail(boolean bl) {
        this.useRail = bl;
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends SCOType {
        private static final int SUPER_FIELD_COUNT = 0;
        protected static final int FIELD_COUNT = 1;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(Sweep sweep, SCOType sCOType) {
            super((Object)sweep, sCOType);
        }

        Type(Class clazz) {
            super(clazz, SCOType.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setBoolean(Object object, int n, boolean bl) {
            switch (n) {
                case 0: {
                    ((Sweep)object).useRail = bl;
                    return;
                }
            }
            super.setBoolean(object, n, bl);
        }

        protected boolean getBoolean(Object object, int n) {
            switch (n) {
                case 0: {
                    return ((Sweep)object).useRail;
                }
            }
            return super.getBoolean(object, n);
        }
    }
}

